/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs.states;

import be.iminds.ilabt.jfed.espec.model.AnsibleSpec;
import be.iminds.ilabt.jfed.espec.model.ExecuteSpec;
import be.iminds.ilabt.jfed.espec.model.ExperimentInfoOutputSpec;
import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.highlevel.DesiredStatus;
import be.iminds.ilabt.jfed.highlevel.jobs.AbstractJob;
import be.iminds.ilabt.jfed.highlevel.jobs.ExperimentPartStateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.ExperimentPartsSlicedState;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.SetupSoftwareExperimentJob;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartController;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartControllerManager;
import be.iminds.ilabt.jfed.highlevel.jobs.states.AllocateSliversOnAuthorityState;
import be.iminds.ilabt.jfed.highlevel.jobs.states.AnsibleKeyState;
import be.iminds.ilabt.jfed.highlevel.jobs.states.AssureAllSshClosedStateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.states.CreateUserSpecListState;
import be.iminds.ilabt.jfed.highlevel.jobs.states.DistributeSshKeysState;
import be.iminds.ilabt.jfed.highlevel.jobs.states.ExecuteAnsibleServicesState;
import be.iminds.ilabt.jfed.highlevel.jobs.states.ExperimentSpecificationOutputState;
import be.iminds.ilabt.jfed.highlevel.jobs.states.ExperimentSpecificationServicesAnsibleState;
import be.iminds.ilabt.jfed.highlevel.jobs.states.ExperimentSpecificationServicesDirsAndUploadsState;
import be.iminds.ilabt.jfed.highlevel.jobs.states.ExperimentSpecificationServicesSingleExecuteState;
import be.iminds.ilabt.jfed.highlevel.jobs.states.ProvisionSliversOnAuthorityState;
import be.iminds.ilabt.jfed.highlevel.jobs.states.RemotePathResolver;
import be.iminds.ilabt.jfed.highlevel.jobs.states.ShareLanAtAuthorityPartState;
import be.iminds.ilabt.jfed.highlevel.jobs.states.StopExperimentAtAuthorityPartState;
import be.iminds.ilabt.jfed.highlevel.jobs.states.UpdateUntilFinalOpStateTaskState;
import be.iminds.ilabt.jfed.highlevel.jobs.states.WaitForExecuteFinishedState;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.highlevel.util.ProxySocketFactoryProvider;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;

@Singleton
public class JobStateFactory {
    @Nonnull
    private final Provider<HighLevelTaskFactory> hltfProvider;
    @Nonnull
    private final Provider<AggregateManagerWrapperFactory> aggregateManagerWrapperFactoryProvider;
    @Nonnull
    private final GeniUserProvider geniUserProvider;
    @Nonnull
    private final Provider<SfaModel> sfaModelProvider;
    @Nonnull
    private final Provider<ExperimentPartControllerManager> epcManagerProvider;
    @Nonnull
    private final ProxySocketFactoryProvider proxySocketFactoryProvider;

    @Inject
    public JobStateFactory(@Nonnull Provider<HighLevelTaskFactory> hltfProvider, @Nonnull Provider<AggregateManagerWrapperFactory> aggregateManagerWrapperFactoryProvider, @Nonnull GeniUserProvider geniUserProvider, @Nonnull Provider<SfaModel> sfaModelProvider, @Nonnull Provider<ExperimentPartControllerManager> epcManagerProvider, @Nonnull ProxySocketFactoryProvider proxySocketFactoryProvider) {
        this.hltfProvider = hltfProvider;
        this.aggregateManagerWrapperFactoryProvider = aggregateManagerWrapperFactoryProvider;
        this.geniUserProvider = geniUserProvider;
        this.sfaModelProvider = sfaModelProvider;
        this.epcManagerProvider = epcManagerProvider;
        this.proxySocketFactoryProvider = proxySocketFactoryProvider;
    }

    public UpdateUntilFinalOpStateTaskState createGetStatusUntilReadyOrFailTaskState(@Nonnull Job<?> job, @Nonnull Logger LOG, @Nullable Duration checkReadyInterval, @Nullable Duration waitForReadyDelay, @Nonnull SfaExperimentPart experimentPart, @Nonnull DesiredStatus desiredStatus) {
        return new UpdateUntilFinalOpStateTaskState(job, experimentPart, checkReadyInterval, waitForReadyDelay, (HighLevelTaskFactory)this.hltfProvider.get(), desiredStatus);
    }

    public CreateUserSpecListState createCreateUserSpecListState(Experiment experiment) {
        return new CreateUserSpecListState(experiment, this.geniUserProvider, (SfaModel)this.sfaModelProvider.get());
    }

    public AllocateSliversOnAuthorityState createAllocateSliversOnAuthorityState(AbstractJob<?> job, SfaExperimentPart experimentPart, List<UserSpec> userSpecs, @Nullable RequestRspecSource overridingRequestRspecSource) {
        return new AllocateSliversOnAuthorityState(job, experimentPart, userSpecs, overridingRequestRspecSource, (HighLevelTaskFactory)this.hltfProvider.get(), (AggregateManagerWrapperFactory)this.aggregateManagerWrapperFactoryProvider.get());
    }

    public AllocateSliversOnAuthorityState createAllocateSliversOnAuthorityState(AbstractJob<?> job, SfaExperimentPart experimentPart, List<UserSpec> userSpecs) {
        return this.createAllocateSliversOnAuthorityState(job, experimentPart, userSpecs, null);
    }

    public ProvisionSliversOnAuthorityState createProvisionSliversOnAuthorityState(AbstractJob<?> job, SfaExperimentPart experimentPart, List<UserSpec> userSpecs) {
        return new ProvisionSliversOnAuthorityState(experimentPart, userSpecs, (HighLevelTaskFactory)this.hltfProvider.get());
    }

    public StopExperimentAtAuthorityPartState createStopExperimentAtAuthorityPartState(Job<?> job, SfaExperimentPart experimentPart) {
        return new StopExperimentAtAuthorityPartState(job, experimentPart, (HighLevelTaskFactory)this.hltfProvider.get());
    }

    public ShareLanAtAuthorityPartState createShareLanState(Job<?> job, SfaExperimentPart experimentPart, String linkClientId, String sharedLanName) {
        return new ShareLanAtAuthorityPartState(job, experimentPart, (HighLevelTaskFactory)this.hltfProvider.get(), linkClientId, sharedLanName);
    }

    public DistributeSshKeysState createDistributeSshKeysState(SetupSoftwareExperimentJob job) {
        return new DistributeSshKeysState(job);
    }

    public WaitForExecuteFinishedState createWaitForExecuteFinishedState(@Nonnull SetupSoftwareExperimentJob job) {
        return new WaitForExecuteFinishedState(job);
    }

    public ExecuteAnsibleServicesState createExecuteAnsibleServicesState(@Nonnull SetupSoftwareExperimentJob job) {
        return new ExecuteAnsibleServicesState(job, this.geniUserProvider);
    }

    public List<State> createOrderedExperimentServicesStates(@Nonnull SetupSoftwareExperimentJob job) {
        ExperimentSpecificationServicesSingleExecuteState singleExecuteState;
        assert (job.getExperiment().getExperimentSpecification() != null);
        assert (job.getExperiment().getExperimentSpecificationBundle() != null);
        if (job.getExperiment().getExperimentSpecification() == null) {
            throw new IllegalStateException("Internal error, createOrderedExperimentServicesStates called for experiment without ExperimentSpecification");
        }
        if (job.getExperiment().getExperimentSpecificationBundle() == null) {
            throw new IllegalStateException("Internal error, createOrderedExperimentServicesStates called for experiment without ExperimentSpecification (bundle)");
        }
        ArrayList<State> res = new ArrayList<State>();
        RemotePathResolver remotePathResolver = new RemotePathResolver(job);
        if (job.getExperiment().getExperimentSpecification().getOutputs().stream().anyMatch(ExperimentInfoOutputSpec::isRequiringAnsibleKey) || job.getExperiment().getExperimentSpecification().getAnsible() != null) {
            res.add(new AnsibleKeyState(job, this.geniUserProvider, this.sfaModelProvider, this.epcManagerProvider));
        }
        for (Object outputSpec : job.getExperiment().getExperimentSpecification().getOutputs()) {
            ExperimentSpecificationOutputState outputState = new ExperimentSpecificationOutputState(job, this.geniUserProvider, (SfaModel)this.sfaModelProvider.get(), (ExperimentInfoOutputSpec)outputSpec);
            res.add(outputState);
        }
        if (job.isRunAll()) {
            ExperimentSpecificationServicesDirsAndUploadsState dirAndUpload = new ExperimentSpecificationServicesDirsAndUploadsState(job, remotePathResolver, this.geniUserProvider.getLoggedInGeniUser());
            res.add(dirAndUpload);
        }
        boolean mustRun = job.getStartPosition() == null;
        for (ExecuteSpec executeSpec : job.getExperiment().getExperimentSpecification().getExecutes()) {
            if (job.getStartPosition() != null && executeSpec == job.getStartPosition()) {
                mustRun = true;
            }
            if (mustRun) {
                singleExecuteState = new ExperimentSpecificationServicesSingleExecuteState(job, remotePathResolver, executeSpec, false);
                res.add(singleExecuteState);
            }
            if (job.getStopPosition() == null || executeSpec != job.getStopPosition()) continue;
            mustRun = false;
        }
        if (job.getExperiment().getExperimentSpecification().getAnsible() != null) {
            for (ExecuteSpec executeSpec : job.getExperiment().getExperimentSpecification().getAnsible().getAnsibleHostSpec().getExecuteLists()) {
                if (job.getStartPosition() != null && executeSpec == job.getStartPosition()) {
                    mustRun = true;
                }
                if (mustRun) {
                    singleExecuteState = new ExperimentSpecificationServicesSingleExecuteState(job, remotePathResolver, executeSpec, true);
                    res.add(singleExecuteState);
                }
                if (job.getStopPosition() == null || executeSpec != job.getStopPosition()) continue;
                mustRun = false;
            }
            AnsibleSpec ansibleSpec = job.getExperiment().getExperimentSpecification().getAnsible();
            if (job.getStartPosition() != null && ansibleSpec == job.getStartPosition()) {
                mustRun = true;
            }
            if (mustRun) {
                ExperimentSpecificationServicesAnsibleState ansibleState = new ExperimentSpecificationServicesAnsibleState(job, this.geniUserProvider, remotePathResolver, ansibleSpec, this.sfaModelProvider, this.epcManagerProvider);
                res.add(ansibleState);
            }
            if (job.getStopPosition() != null && ansibleSpec == job.getStopPosition()) {
                mustRun = false;
            }
        }
        res.add(new AssureAllSshClosedStateSlice(job));
        return res;
    }

    public ExperimentPartsSlicedState<ExperimentPartStateSlice> createUpdateSshKeysState(final Job<?> job, final Collection<UserSpec> userSpecs) {
        return new ExperimentPartsSlicedState<ExperimentPartStateSlice>("Update SSH keys on authorities", job.getExperiment(), (ExperimentPartControllerManager)this.epcManagerProvider.get()){

            @Override
            public <EP extends ExperimentPart> ExperimentPartStateSlice createJobSlice(ExperimentPartController<EP> controller, EP experimentPart) {
                return controller.editSshKeys(job, experimentPart, userSpecs);
            }
        };
    }

    public class StopExperimentState
    extends ExperimentPartsSlicedState<ExperimentPartStateSlice> {
        private final Job<?> job;

        private StopExperimentState(Job<?> job) {
            super("Delete all resources", job.getExperiment(), (ExperimentPartControllerManager)JobStateFactory.this.epcManagerProvider.get());
            this.job = job;
        }

        @Override
        public <EP extends ExperimentPart> ExperimentPartStateSlice createJobSlice(ExperimentPartController<EP> controller, EP experimentPart) {
            return controller.stop(this.job, experimentPart);
        }
    }
}

