/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs.states;

import be.iminds.ilabt.jfed.espec.ESpecLogic;
import be.iminds.ilabt.jfed.espec.model.AnsiblePlaybookSpec;
import be.iminds.ilabt.jfed.espec.model.DirSpec;
import be.iminds.ilabt.jfed.espec.model.ExecuteSpec;
import be.iminds.ilabt.jfed.espec.model.ExperimentSpecification;
import be.iminds.ilabt.jfed.espec.model.UploadLikeSpec;
import be.iminds.ilabt.jfed.espec.model.UploadLikeWithLogSpec;
import be.iminds.ilabt.jfed.espec.model.UploadSpec;
import be.iminds.ilabt.jfed.espec.parser.ESpecConstants;
import be.iminds.ilabt.jfed.espec.parser.ESpecDefaults;
import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.highlevel.jobs.JobWithSshConnectionManager;
import be.iminds.ilabt.jfed.highlevel.jobs.SetupSoftwareExperimentJob;
import be.iminds.ilabt.jfed.highlevel.util.ExternalFileUtil;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableModelRspec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javafx.util.Pair;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.schmizz.sshj.SSHClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotePathResolver {
    private static final Logger LOG = LoggerFactory.getLogger(RemotePathResolver.class);
    @Nonnull
    private final SetupSoftwareExperimentJob setupSoftwareExperimentJob;
    @Nonnull
    private final Experiment experiment;
    @Nonnull
    private final ExperimentSpecification experimentSpecification;
    @Nonnull
    private final Map<String, ExternalFileUtil> externalFileUtilByClientId;
    @Nullable
    private boolean resolvedPaths = false;
    private final ConcurrentHashMap<Pair<String, ESpecConstants.DirContent>, String> remotePathByDirClientIdAndDirContent = new ConcurrentHashMap();
    private final ConcurrentHashMap<Pair<String, UploadLikeSpec>, String> remotePathByClientIdAndUploadLikeSpec = new ConcurrentHashMap();
    private final ConcurrentHashMap<Pair<String, UploadLikeWithLogSpec>, String> remoteLogPathByClientIdAndUploadLikeWithLogSpec = new ConcurrentHashMap();

    public RemotePathResolver(@Nonnull SetupSoftwareExperimentJob job) {
        this(job, job.getExperiment(), job.getExperiment().getExperimentSpecification());
    }

    public RemotePathResolver(@Nonnull SetupSoftwareExperimentJob setupSoftwareExperimentJob, @Nonnull Experiment experiment, @Nonnull ExperimentSpecification experimentSpecification) {
        this.externalFileUtilByClientId = new HashMap<String, ExternalFileUtil>();
        this.setupSoftwareExperimentJob = setupSoftwareExperimentJob;
        this.experiment = experiment;
        this.experimentSpecification = experimentSpecification;
    }

    private ExternalFileUtil getExternalFileUtil(@Nonnull RspecNode node) throws JFedException, InterruptedException {
        SSHClient ssh;
        String clientId = node.getClientId();
        ExternalFileUtil res = this.externalFileUtilByClientId.get(clientId);
        if (res != null) {
            return res;
        }
        try {
            ssh = this.setupSoftwareExperimentJob.getSSHClient(node, null);
        }
        catch (JobWithSshConnectionManager.SshException e) {
            LOG.warn("Aborting in RemotePathResolver due to SSH connection problem", (Throwable)e);
            throw new RuntimeException("Aborting in RemotePathResolver due to SSH connection problem");
        }
        assert (ssh != null);
        res = new ExternalFileUtil(ssh);
        return res;
    }

    @Nullable
    public String getRemotePath(@Nonnull ESpecConstants.DirContent dirContent, @Nonnull String clientId) throws JFedException, InterruptedException {
        this.resolvePathsIfNeeded(clientId);
        return this.remotePathByDirClientIdAndDirContent.get(new Pair((Object)clientId, (Object)dirContent));
    }

    @Nullable
    public String getRemotePath(@Nonnull DirSpec dirSpec, @Nonnull String clientId) throws JFedException, InterruptedException {
        if (dirSpec.getDirContent() == null) {
            return null;
        }
        return this.getRemotePath(dirSpec.getDirContent(), clientId);
    }

    @Nullable
    public String getRemotePath(@Nonnull UploadLikeSpec uploadLikeSpec, @Nonnull String clientId) throws JFedException, InterruptedException {
        this.resolvePathsIfNeeded(clientId);
        return this.remotePathByClientIdAndUploadLikeSpec.get(new Pair((Object)clientId, (Object)uploadLikeSpec));
    }

    @Nullable
    public String getRemoteLogPath(@Nonnull UploadLikeWithLogSpec spec, @Nonnull String clientId) throws JFedException, InterruptedException {
        this.resolvePathsIfNeeded(clientId);
        return this.remoteLogPathByClientIdAndUploadLikeWithLogSpec.get(new Pair((Object)clientId, (Object)spec));
    }

    private String dirPathToAbsolutePath(ExternalFileUtil externalFileUtil, String dirPath) {
        if (externalFileUtil == null) {
            throw new IllegalStateException("externalFileUtil == null");
        }
        boolean absolutePath = dirPath.startsWith("/");
        assert (absolutePath || dirPath.startsWith("~"));
        if (absolutePath) {
            return RemotePathResolver.assureEndWithSlash(dirPath);
        }
        String homeDir = RemotePathResolver.assureEndWithSlash(externalFileUtil.getHomeDir());
        return RemotePathResolver.assureEndWithSlash(homeDir + (dirPath.length() > 1 ? dirPath.substring(1) : ""));
    }

    @Nonnull
    private String makeRelativePathAbsolute(@Nonnull UploadLikeSpec uploadSpec, @Nonnull ExternalFileUtil externalFileUtil, @Nullable String uploadDirSpecPath, @Nullable String scriptDirSpecPath, @Nullable String ansibleDirSpecPath, @Nonnull String path) {
        if (ESpecLogic.isAnsibleSubPart((UploadLikeSpec)uploadSpec, (ExperimentSpecification)this.experimentSpecification)) {
            if (ansibleDirSpecPath != null) {
                return RemotePathResolver.assureEndWithSlash(RemotePathResolver.convertHomeDir(ansibleDirSpecPath, externalFileUtil.getHomeDir())) + path;
            }
            return RemotePathResolver.assureEndWithSlash(externalFileUtil.getHomeDir()) + "ansible/" + path;
        }
        if (uploadSpec instanceof UploadSpec) {
            if (uploadDirSpecPath != null) {
                return RemotePathResolver.assureEndWithSlash(RemotePathResolver.convertHomeDir(uploadDirSpecPath, externalFileUtil.getHomeDir())) + path;
            }
            return RemotePathResolver.assureEndWithSlash(externalFileUtil.getHomeDir()) + path;
        }
        if (uploadSpec instanceof ExecuteSpec) {
            if (scriptDirSpecPath != null) {
                return RemotePathResolver.assureEndWithSlash(RemotePathResolver.convertHomeDir(scriptDirSpecPath, externalFileUtil.getHomeDir())) + path;
            }
            return RemotePathResolver.assureEndWithSlash(externalFileUtil.getHomeDir()) + path;
        }
        throw new RuntimeException("BUG: uploadSpec of unknown class " + uploadSpec.getClass().getName());
    }

    @Nonnull
    private String makeAnyPathAbsolute(@Nonnull UploadLikeSpec uploadSpec, @Nonnull ExternalFileUtil externalFileUtil, @Nullable String uploadDirSpecPath, @Nullable String scriptDirSpecPath, @Nullable String ansibleDirSpecPath, @Nonnull String path) {
        boolean relativePath;
        boolean absolutePath = path.startsWith("/");
        boolean homePath = path.startsWith("~");
        boolean bl = relativePath = !absolutePath && !homePath;
        if (absolutePath) {
            return path;
        }
        if (homePath) {
            return RemotePathResolver.convertHomeDir(path, externalFileUtil.getHomeDir());
        }
        assert (relativePath);
        return this.makeRelativePathAbsolute(uploadSpec, externalFileUtil, uploadDirSpecPath, scriptDirSpecPath, ansibleDirSpecPath, path);
    }

    @Nonnull
    private String getRemotePath(@Nonnull ExternalFileUtil externalFileUtil, @Nullable String uploadDirSpecPath, @Nullable String scriptDirSpecPath, @Nullable String ansibleDirSpecPath, @Nonnull UploadLikeSpec uploadSpec) {
        if (uploadSpec.getPath() == null) {
            if (uploadSpec.getSource() == null) {
                throw new IllegalStateException("source and path should never both be null");
            }
            String sourceBasename = RemotePathResolver.removeParentDirs(uploadSpec.getSource().getBasename());
            return this.makeRelativePathAbsolute(uploadSpec, externalFileUtil, uploadDirSpecPath, scriptDirSpecPath, ansibleDirSpecPath, sourceBasename);
        }
        return this.makeAnyPathAbsolute(uploadSpec, externalFileUtil, uploadDirSpecPath, scriptDirSpecPath, ansibleDirSpecPath, uploadSpec.getPath());
    }

    public void resolvePathsIfNeeded(@Nonnull String clientId) throws JFedException, InterruptedException {
        assert (this.experiment.getSliceOrNull() != null);
        assert (this.experiment.getSlice().getManifestRspec() != null);
        ImmutableModelRspec manifestModel = this.experiment.getSlice().getManifestRspec().getImmutableModelRspec();
        assert (manifestModel != null);
        RspecNode node = manifestModel.getNodeByClientId(clientId);
        this.resolvePathsIfNeeded(node);
    }

    public void resolvePathsIfNeeded(@Nonnull RspecNode node) throws JFedException, InterruptedException {
        if (this.resolvedPaths) {
            return;
        }
        assert (this.experiment.getExperimentSpecificationFileManager() != null);
        String clientId = node.getClientId();
        assert (clientId != null);
        ExternalFileUtil externalFileUtil = this.getExternalFileUtil(node);
        assert (externalFileUtil != null);
        ArrayList dirs = new ArrayList(this.experimentSpecification.getDirs());
        for (DirSpec dirSpec : dirs) {
            if (!ESpecLogic.mustRunOn((String)clientId, (Collection)node.getAnsibleGroups(), (ExperimentSpecification)this.experimentSpecification, (DirSpec)dirSpec)) continue;
            String remotePath = this.dirPathToAbsolutePath(externalFileUtil, dirSpec.getPath());
            if (dirSpec.getDirContent() == null) continue;
            this.remotePathByDirClientIdAndDirContent.put((Pair<String, ESpecConstants.DirContent>)new Pair((Object)clientId, (Object)dirSpec.getDirContent()), remotePath);
        }
        ArrayList allUploads = new ArrayList(this.experimentSpecification.getUploads());
        allUploads.addAll(this.experimentSpecification.getExecutes());
        ArrayList<AnsiblePlaybookSpec.ExtraVarsJsonFileSpec> ansibleUploads = new ArrayList<AnsiblePlaybookSpec.ExtraVarsJsonFileSpec>();
        if (this.experimentSpecification.getAnsible() != null) {
            ansibleUploads.addAll(this.experimentSpecification.getAnsible().getAnsibleHostSpec().getUploadLists());
            ansibleUploads.addAll(this.experimentSpecification.getAnsible().getAnsibleHostSpec().getExecuteLists());
            ansibleUploads.addAll(this.experimentSpecification.getAnsible().getAnsibleGalaxySpecs());
            ansibleUploads.addAll(this.experimentSpecification.getAnsible().getAnsiblePlaybookSpecs());
            for (AnsiblePlaybookSpec ansiblePlaybookSpec : this.experimentSpecification.getAnsible().getAnsiblePlaybookSpecs()) {
                if (!ansiblePlaybookSpec.hasExtraVarsJsonFileSpec() || ansiblePlaybookSpec.getExtraVarsJsonFileSpec() == null) continue;
                ansibleUploads.add(ansiblePlaybookSpec.getExtraVarsJsonFileSpec());
            }
            allUploads.addAll(ansibleUploads);
        }
        String uploadDirSpecPath = null;
        String scriptDirSpecPath = null;
        String ansibleDirSpecPath = null;
        for (DirSpec dirSpec : this.experimentSpecification.getDirs()) {
            if (dirSpec.getNodes() != null && !dirSpec.getNodes().contains(clientId)) continue;
            if (dirSpec.isScriptContent()) {
                scriptDirSpecPath = this.dirPathToAbsolutePath(externalFileUtil, dirSpec.getPath());
            }
            if (dirSpec.isUploadContent()) {
                uploadDirSpecPath = this.dirPathToAbsolutePath(externalFileUtil, dirSpec.getPath());
            }
            if (!dirSpec.isAnsibleContent()) continue;
            ansibleDirSpecPath = this.dirPathToAbsolutePath(externalFileUtil, dirSpec.getPath());
        }
        assert (scriptDirSpecPath != null);
        assert (uploadDirSpecPath != null);
        for (UploadLikeSpec uploadSpec : allUploads) {
            Object remoteLogPath;
            UploadLikeWithLogSpec es;
            String baseLogPath;
            boolean isDir;
            boolean remoteOnlyFile;
            boolean bl = remoteOnlyFile = uploadSpec.getSource() == null;
            if (Objects.equals(node.getSliverTypeName(), "fake") || !ESpecLogic.mustRunOn((String)clientId, (Collection)node.getAnsibleGroups(), (ExperimentSpecification)this.experimentSpecification, (UploadLikeSpec)uploadSpec)) continue;
            Object remotePath = this.getRemotePath(externalFileUtil, uploadDirSpecPath, scriptDirSpecPath, ansibleDirSpecPath, uploadSpec);
            String name = ExternalFileUtil.getBasename((String)remotePath);
            boolean bl2 = isDir = uploadSpec.getSource() != null && this.experiment.getExperimentSpecificationFileManager().isDir(uploadSpec.getSource());
            if (isDir && !((String)remotePath).endsWith("/")) {
                remotePath = (String)remotePath + "/";
            }
            this.remotePathByClientIdAndUploadLikeSpec.put((Pair<String, UploadLikeSpec>)new Pair((Object)clientId, (Object)uploadSpec), (String)remotePath);
            if (!(uploadSpec instanceof UploadLikeWithLogSpec) || (baseLogPath = (es = (UploadLikeWithLogSpec)uploadSpec).getLog() != null ? es.getLog() : (this.experimentSpecification.getConfig().isStoreRemoteLogsByDefault() ? ESpecDefaults.deriveAutomaticLogFile((String)remotePath) : null)) == null) continue;
            if (!baseLogPath.contains("/")) {
                String dir = ExternalFileUtil.getPathOnly((String)remotePath);
                remoteLogPath = RemotePathResolver.assureEndWithSlash(dir) + baseLogPath;
            } else {
                remoteLogPath = RemotePathResolver.convertHomeDir(baseLogPath, externalFileUtil.getHomeDir());
            }
            assert (remoteLogPath != null);
            this.remoteLogPathByClientIdAndUploadLikeWithLogSpec.put((Pair<String, UploadLikeWithLogSpec>)new Pair((Object)clientId, (Object)es), (String)remoteLogPath);
        }
    }

    @Nonnull
    private static String convertHomeDir(@Nonnull String path, @Nonnull String homeDirPath) {
        if (path.startsWith("~/") && path.length() > 2) {
            return RemotePathResolver.assureEndWithSlash(homeDirPath) + path.substring(2);
        }
        if (path.startsWith("~") && path.length() > 1) {
            return RemotePathResolver.assureEndWithSlash(homeDirPath) + path.substring(1);
        }
        if (path.equals("~")) {
            return RemotePathResolver.assureEndWithSlash(homeDirPath);
        }
        return path;
    }

    @Nonnull
    private static String assureEndWithSlash(@Nonnull String p) {
        if (p.endsWith("/")) {
            return p;
        }
        return p + "/";
    }

    @Nonnull
    private static String assureStartWithSlash(@Nonnull String p) {
        if (p.startsWith("/")) {
            return p;
        }
        return "/" + p;
    }

    @Nonnull
    private static String removeLastChildDir(@Nonnull String childDir, @Nonnull String path) {
        String childDirS = RemotePathResolver.assureEndWithSlash(childDir);
        if (childDir.equals("/")) {
            return path;
        }
        assert (path.endsWith(childDirS)) : "\"" + path + "\" does not end with \"" + childDirS + "\"";
        return path.substring(0, path.length() - childDirS.length());
    }

    @Nonnull
    private static String removeParentDir(@Nonnull String parentPath, @Nonnull String path) {
        if (parentPath.isEmpty()) {
            return path;
        }
        assert (path.startsWith(parentPath)) : "\"" + path + "\" does not start with \"" + parentPath + "\"";
        return path.substring(parentPath.length());
    }

    @Nonnull
    private static String removeParentDirs(@Nonnull String path) {
        if (path.isEmpty() || path.indexOf(47) == -1 || path.length() <= 2) {
            return path;
        }
        int slash = path.lastIndexOf(47, path.length() - 2);
        if (slash == -1) {
            return path;
        }
        return path.substring(slash + 1, path.length());
    }
}

