/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs.states;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.DesiredStatus;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import be.iminds.ilabt.jfed.highlevel.model.InternalState;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.ListSliceResourcesTask;
import be.iminds.ilabt.jfed.highlevel.tasks.StartTask;
import be.iminds.ilabt.jfed.highlevel.tasks.StatusTask;
import be.iminds.ilabt.jfed.highlevel.util.LogEntryGeneratorWrappingLogger;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateUntilFinalOpStateTaskState
extends State {
    private static final Logger ACTUAL_LOG = LoggerFactory.getLogger(UpdateUntilFinalOpStateTaskState.class);
    private final Logger LOG;
    private static final Duration DEFAULT_CHECK_READY_INTERVAL = Duration.ofSeconds(10L);
    private static final int MAX_SOFT_FAIL_COUNT = 5;
    private static final int MAX_RESOURCES_FAILED_RETRY_COUNT = 5;
    private static final int MAX_BUSY_COUNT = 180;
    @Nonnull
    private final Job<?> job;
    @Nonnull
    private final SfaExperimentPart experimentPart;
    @Nullable
    private final Duration maxWaitUntilReady;
    @Nonnull
    private final Experiment experiment;
    @Nonnull
    private final HighLevelTaskFactory hltf;
    @Nonnull
    private Duration checkReadyInterval;
    private Instant timeoutTime;
    private int softFailCount = 0;
    private int resourcesFailedRetryCount = 0;
    private int busyCount = 0;
    private int triesCount = 0;
    private final StatusTask statusTask;
    private boolean waitForFirstCheck;
    @Nonnull
    private DesiredStatus desiredStatus;
    private boolean hadTimeout;

    protected UpdateUntilFinalOpStateTaskState(@Nonnull Job<?> job, @Nonnull SfaExperimentPart experimentPart, @Nullable Duration checkReadyInterval, @Nullable Duration maxWaitUntilReady, @Nonnull HighLevelTaskFactory hltf, @Nonnull DesiredStatus desiredStatus) {
        super(String.format("Waiting for resources on %s to become ready", experimentPart.getName()));
        this.job = job;
        this.LOG = new LogEntryGeneratorWrappingLogger(ACTUAL_LOG, job.getJobReport());
        this.experimentPart = experimentPart;
        this.checkReadyInterval = checkReadyInterval == null ? DEFAULT_CHECK_READY_INTERVAL : checkReadyInterval;
        this.maxWaitUntilReady = maxWaitUntilReady;
        this.hltf = hltf;
        this.experiment = experimentPart.getExperiment();
        this.desiredStatus = desiredStatus;
        this.hadTimeout = false;
        this.statusTask = hltf.status(this.experiment.getSlice(), experimentPart.getConnectSfaAuthority());
    }

    private void registerStart() {
        if (this.maxWaitUntilReady != null) {
            this.timeoutTime = Instant.now().plus(this.maxWaitUntilReady);
        }
    }

    private void registerStop() {
        this.timeoutTime = null;
    }

    @Override
    @Nonnull
    protected ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException, JFedException {
        this.registerStart();
        if (this.waitForFirstCheck) {
            this.waitForCheck();
        }
        boolean IGNORE_NOTREADY = true;
        boolean RETRY_POA_ON_NOTREADY_IGNORE_DEADLINE = true;
        Duration IGNORE_NOTREADY_DURATION = Duration.ofMinutes(5L);
        Duration IGNORE_NOTREADY_DURATION_AFTER_POA = Duration.ofMinutes(2L);
        Instant ignoreNotReadyDeadline = null;
        boolean retriedPoaStart = false;
        boolean finalState = false;
        boolean fatalStop = false;
        while (!(finalState || fatalStop || this.isTimeout())) {
            this.experimentPart.setState(InternalState.WAIT_FOR_READY);
            boolean statusIsFinished = false;
            while (!(statusIsFinished || fatalStop || this.isTimeout())) {
                CountDownLatch statusTaskExecutionReadyLatch = new CountDownLatch(1);
                this.job.submitTask(this.statusTask, (task, taskExecution, state) -> statusTaskExecutionReadyLatch.countDown());
                ++this.triesCount;
                int punctuationCount = -1;
                do {
                    this.updateMessage(String.format("Checked status %d times. Checking%s", this.triesCount, Strings.repeat((String)".", (int)(1 + ++punctuationCount % 3))));
                } while (!statusTaskExecutionReadyLatch.await(1L, TimeUnit.SECONDS));
                if (this.statusTask.isBusy()) {
                    ++this.busyCount;
                    if (this.busyCount > 180) {
                        this.LOG.warn("Got BUSY too many times for resources on {} of {}", (Object)this.experimentPart.getName(), (Object)this.experiment.getName());
                        this.updateMessage("Waited too long for resources on '" + this.experimentPart.getName() + "' to become ready. (Waited " + this.busyCount + " times 10 seconds.)");
                        fatalStop = true;
                    }
                }
                if (this.statusTask.isHardFailure()) {
                    fatalStop = true;
                } else if (this.statusTask.isSoftFailure()) {
                    ++this.softFailCount;
                    if (this.softFailCount > 5) {
                        this.LOG.warn("Something went wrong while waiting for resources on '\"+experimentPart.getName()+\"' to become ready. Will stop checking status...");
                        this.updateMessage("Fetching status failed. Aborting checks!");
                        fatalStop = true;
                    }
                } else {
                    assert (this.statusTask.getStatusDetails() != null);
                    if (this.statusTask.getStatusDetails() != null && UpdateUntilFinalOpStateTaskState.hasAtLeastOneFailure(this.statusTask.getStatusDetails())) {
                        ++this.resourcesFailedRetryCount;
                        if (this.resourcesFailedRetryCount > 5) {
                            this.LOG.warn("At least one resource has FAILED  on '{}'. Retried {} times, but there's no point to keep retrying. Will stop checking status...", (Object)this.experimentPart.getName(), (Object)5);
                            fatalStop = true;
                            this.updateMessage("One or more resources have permanently failed");
                        }
                    } else {
                        this.resourcesFailedRetryCount = 0;
                    }
                }
                statusIsFinished = finalState = this.areAllResourcesInFinalState();
                if (this.hasAtLeastOneNotReadyState()) {
                    if (ignoreNotReadyDeadline == null) {
                        ignoreNotReadyDeadline = Instant.now().plus(IGNORE_NOTREADY_DURATION);
                        this.LOG.info("Workaround: a status is geni_notready. We will ignore this for the next {}", (Object)IGNORE_NOTREADY_DURATION);
                    }
                    assert (ignoreNotReadyDeadline != null);
                    if (Instant.now().isAfter(ignoreNotReadyDeadline) && !retriedPoaStart) {
                        retriedPoaStart = true;
                        StartTask poaTask = this.hltf.poaStart(this.experiment.getSlice(), this.experiment.getSlice().getUrn(), this.experimentPart.getConnectSfaAuthority());
                        this.job.submitTask(poaTask);
                        this.LOG.warn("Workaround: a status is geni_notready. This has been ignored for a while, but nothing has changed. PerformOperationalAction geni_start has been called again.");
                        ignoreNotReadyDeadline = Instant.now().plus(IGNORE_NOTREADY_DURATION_AFTER_POA);
                        this.LOG.info("Workaround: a status is geni_notready. After calling POA, we will again ignore geni_notready for the next {}", (Object)IGNORE_NOTREADY_DURATION_AFTER_POA);
                    }
                    if (Instant.now().isBefore(ignoreNotReadyDeadline)) {
                        this.LOG.info("Workaround: a status is geni_notready. Ignore deadline not reached: treating it as geni_configuring");
                        statusIsFinished = false;
                    } else {
                        this.LOG.warn("Workaround: a status is geni_notready. Ignore deadline reached: will treat it as final state from now");
                    }
                }
                if (statusIsFinished) continue;
                this.waitForCheck();
            }
            finalState = this.areAllResourcesInFinalState();
            this.hadTimeout = this.isTimeout();
            this.LOG.info("Stopped checking until status {} for {} because {}.", new Object[]{this.desiredStatus, this.experimentPart.getName(), finalState ? "finalState" : (fatalStop ? "fatalStop" : (this.hadTimeout ? "timeout" : "UNKNOWN"))});
            if (!finalState || this.desiredStatus != DesiredStatus.GENI_READY) continue;
            this.LOG.debug("Stopped listening for results of status calls after receiving status {} ", this.statusTask.getStatusDetails() != null ? this.statusTask.getStatusDetails().getGlobalStatus() : "null");
            ListSliceResourcesTask sliceResourcesTask = this.hltf.listSliceResources(this.experiment.getSlice(), this.experimentPart.getConnectSfaAuthority());
            CountDownLatch listResourcesTaskReadyLatch = new CountDownLatch(1);
            int punctuationCount = -1;
            this.job.submitTask(sliceResourcesTask, (task, taskExecution, state) -> listResourcesTaskReadyLatch.countDown());
            do {
                this.updateMessage(String.format("Verifying final state%s", Strings.repeat((String)".", (int)(1 + ++punctuationCount % 3))));
            } while (!listResourcesTaskReadyLatch.await(1L, TimeUnit.SECONDS));
            this.updateMessage("");
            finalState = this.areAllResourcesInFinalState();
            if (sliceResourcesTask.isHardFailure()) {
                this.updateMessage("Something went wrong with the ListResource call. Aborting periodic check.");
                fatalStop = true;
            }
            if (!finalState) {
                this.LOG.warn("ListResources reported that not all resources from {} are in a final state. Will start checking again.", (Object)this.experimentPart.getName());
            }
            if (!finalState || this.areAllResourcesInDesiredState(DesiredStatus.GENI_READY, this.statusTask.getStatusDetails())) continue;
            this.LOG.warn("ListResources reported that not all resources from {} are in the desired state (GENI_READY), but status is final. Will have to give up checking.", (Object)this.experimentPart.getName());
        }
        if (this.isTimeout()) {
            this.hadTimeout = true;
        }
        this.registerStop();
        this.LOG.debug("Finished waiting for {} status {} finalState={} hadTimeout={} allDesired={} fatalStop={}", new Object[]{this.experimentPart.getName(), this.desiredStatus, finalState, this.hadTimeout, this.areAllResourcesInDesiredState(DesiredStatus.GENI_READY, this.statusTask.getStatusDetails()), fatalStop});
        if (finalState) {
            if (this.statusTask.getStatusDetails() == null) {
                this.LOG.error("{}: statusTask.getStatusDetails() == null is unexpected. Considering this a FAILURE.", (Object)this.experimentPart.getName());
                return ExperimentTaskStatus.FAILED;
            }
            if (UpdateUntilFinalOpStateTaskState.hasAtLeastOneFailure(this.statusTask.getStatusDetails()) || this.statusTask.getStatusDetails().getGlobalStatus() == StatusDetails.SliverStatus.FAIL) {
                this.LOG.error("{}: hasAtLeastOneFailure={} globalStatus=={}. Considering this a FAILURE.", new Object[]{this.experimentPart.getName(), UpdateUntilFinalOpStateTaskState.hasAtLeastOneFailure(this.statusTask.getStatusDetails()), this.statusTask.getStatusDetails().getGlobalStatus()});
                this.LOG.debug("{}: statusDetails={}", (Object)this.experimentPart.getName(), (Object)this.statusTask.getStatusDetails());
                return ExperimentTaskStatus.FAILED;
            }
            if (this.areAllResourcesInDesiredState(this.desiredStatus, this.statusTask.getStatusDetails())) {
                this.LOG.info("{}: areAllResourcesInDesiredState=true. Considering this a SUCCESS.", (Object)this.experimentPart.getName());
                this.LOG.debug("{}: statusDetails={}", (Object)this.experimentPart.getName(), (Object)this.statusTask.getStatusDetails());
                return ExperimentTaskStatus.SUCCESS;
            }
            this.LOG.error("{}: areAllResourcesInDesiredState=false. Considering this a FAILURE.", (Object)this.experimentPart.getName());
            this.LOG.debug("{}: statusDetails={}", (Object)this.experimentPart.getName(), (Object)this.statusTask.getStatusDetails());
            return ExperimentTaskStatus.FAILED;
        }
        this.LOG.error("{}: not finalState. Considering this a FAILURE.", (Object)this.experimentPart.getName());
        this.LOG.debug("{}: statusDetails={}", (Object)this.experimentPart.getName(), (Object)this.statusTask.getStatusDetails());
        return ExperimentTaskStatus.FAILED;
    }

    public boolean isWaitForFirstCheck() {
        return this.waitForFirstCheck;
    }

    public void setWaitForFirstCheck(boolean waitForFirstCheck) {
        this.waitForFirstCheck = waitForFirstCheck;
    }

    private void waitForCheck() throws InterruptedException {
        long checkReadyIntervalMs = this.checkReadyInterval.toMillis();
        int waitedMs = 0;
        while ((long)waitedMs < checkReadyIntervalMs) {
            this.updateMessage(String.format("Checked status %d times. Next check in %d seconds", this.triesCount, UpdateUntilFinalOpStateTaskState.roundUp(checkReadyIntervalMs - (long)waitedMs, 1000L)));
            Thread.sleep(1000L);
            waitedMs += 1000;
        }
    }

    private boolean areAllResourcesInFinalState() {
        if (this.statusTask.isBusy()) {
            return false;
        }
        if (this.statusTask.getStatusDetails() == null) {
            return false;
        }
        for (StatusDetails.SliverStatus sliverStatus : Iterables.concat(this.statusTask.getStatusDetails().getStatusBySliverUrn().values(), this.statusTask.getStatusDetails().getStatusByComponentUrn().values())) {
            if (sliverStatus != StatusDetails.SliverStatus.UNKNOWN && sliverStatus != StatusDetails.SliverStatus.CHANGING) continue;
            return false;
        }
        if (this.statusTask.getStatusDetails().getGlobalStatus() == StatusDetails.SliverStatus.UNKNOWN) {
            return false;
        }
        return this.statusTask.getStatusDetails().getGlobalStatus() != StatusDetails.SliverStatus.CHANGING;
    }

    private static boolean hasAtLeastOneFailure(@Nonnull StatusDetails statusDetails) {
        for (StatusDetails.SliverStatus sliverStatus : statusDetails.getStatusBySliverUrn().values()) {
            if (sliverStatus != StatusDetails.SliverStatus.FAIL) continue;
            return true;
        }
        for (StatusDetails.SliverStatus sliverStatus : statusDetails.getStatusByComponentUrn().values()) {
            if (sliverStatus != StatusDetails.SliverStatus.FAIL) continue;
            return true;
        }
        return false;
    }

    private boolean hasAtLeastOneNotReadyState() {
        if (this.statusTask.getStatusDetails() == null) {
            return false;
        }
        for (StatusDetails.SliverStatus sliverStatus : Iterables.concat(this.statusTask.getStatusDetails().getStatusBySliverUrn().values(), this.statusTask.getStatusDetails().getStatusByComponentUrn().values())) {
            if (sliverStatus != StatusDetails.SliverStatus.NOTREADY) continue;
            return true;
        }
        return false;
    }

    private boolean areAllResourcesInDesiredState(@Nonnull DesiredStatus desiredStatus, @Nullable StatusDetails amStatusDetails) {
        assert (this.experiment.getSlice() != null);
        List<Sliver> sliversOfAuthority = this.experiment.getSlice().findSlivers(this.experimentPart.getConnectSfaAuthority());
        for (Sliver sliver : sliversOfAuthority) {
            if (!sliver.isFake() && sliver.getNodes() == null) {
                this.LOG.debug("No nodes available in sliver {}", (Object)sliver.getUrn());
                continue;
            }
            StatusDetails statusDetails = this.experiment.getSlice().getStatus();
            if (statusDetails == null) {
                this.LOG.error("statuscheckfail: No status info available! Fallback: assuming resources are NOT in the required state.");
                return false;
            }
            if (sliver.isFake()) {
                if (this.experiment.getSlice().getStatus().getGlobalStatus() == null) {
                    this.LOG.error("statuscheckfail: No global status info available! Fallback: assuming fake resource(s) are NOT in the required state.");
                    return false;
                }
                switch (this.experiment.getSlice().getStatus().getGlobalStatus()) {
                    case UNINITIALISED: 
                    case UNALLOCATED: 
                    case UNKNOWN: 
                    case CHANGING: 
                    case FAIL: {
                        this.LOG.debug("statuscheckfail: fake sliver {} not in state {} but in global state {}", new Object[]{sliver.getUrn(), desiredStatus, this.experiment.getSlice().getStatus().getGlobalStatus()});
                        return false;
                    }
                    case READY: {
                        if (desiredStatus == DesiredStatus.GENI_READY) break;
                        this.LOG.debug("statuscheckfail: fake sliver {} not in state {} but in global state {}", new Object[]{sliver.getUrn(), desiredStatus, this.experiment.getSlice().getStatus().getGlobalStatus()});
                        return false;
                    }
                    case NOTREADY: {
                        if (desiredStatus == DesiredStatus.GENI_NOTREADY) break;
                        this.LOG.debug("statuscheckfail: fake sliver {} not in state {} but in global state {}", new Object[]{sliver.getUrn(), desiredStatus, this.experiment.getSlice().getStatus().getGlobalStatus()});
                        return false;
                    }
                }
                continue;
            }
            StatusDetails.SliverStatus statusBySliverUrn = statusDetails.getStatusBySliverUrn(sliver.getUrn());
            if (statusBySliverUrn == null) {
                StatusDetails.SliverStatus amGlobalStatus;
                this.LOG.warn("statuscheckfail: statusBySliverUrn for {} not found. Will fall back on status of slice at this AM.", (Object)sliver.getUrn());
                StatusDetails.SliverStatus sliverStatus = amGlobalStatus = amStatusDetails != null ? amStatusDetails.getGlobalStatus() : null;
                if (desiredStatus == DesiredStatus.GENI_READY && amGlobalStatus != StatusDetails.SliverStatus.READY) {
                    this.LOG.debug("statuscheckfail: (fallback check) for {} not in state {} but AM global status is {}.", new Object[]{sliver.getUrn(), desiredStatus, amGlobalStatus});
                    return false;
                }
                if (desiredStatus == DesiredStatus.GENI_NOTREADY && amGlobalStatus != StatusDetails.SliverStatus.NOTREADY) {
                    this.LOG.debug("statuscheckfail: (fallback check) for {} not in state {} but AM global status is {}.", new Object[]{sliver.getUrn(), desiredStatus, amGlobalStatus});
                    return false;
                }
            } else {
                if (statusBySliverUrn == StatusDetails.SliverStatus.CHANGING || statusBySliverUrn == StatusDetails.SliverStatus.UNKNOWN) {
                    this.LOG.debug("statuscheckfail: statusBySliverUrn for {} not in state {} but in {}", new Object[]{sliver.getUrn(), desiredStatus, statusBySliverUrn});
                    return false;
                }
                if (desiredStatus == DesiredStatus.GENI_NOTREADY && statusBySliverUrn != StatusDetails.SliverStatus.NOTREADY) {
                    this.LOG.debug("statuscheckfail: statusBySliverUrn for {} not in state {} but in {}", new Object[]{sliver.getUrn(), desiredStatus, statusBySliverUrn});
                    return false;
                }
                if (desiredStatus == DesiredStatus.GENI_READY && statusBySliverUrn != StatusDetails.SliverStatus.READY) {
                    this.LOG.debug("statuscheckfail: statusBySliverUrn for {} not in state {} but in {}", new Object[]{sliver.getUrn(), desiredStatus, statusBySliverUrn});
                    return false;
                }
            }
            if (sliver.getNodes() == null) continue;
            for (RspecNode rspecNode : sliver.getNodes()) {
                if (this.experiment.getSlice().getStatus().getStatusByComponentUrn().containsKey(rspecNode.getComponentId())) {
                    StatusDetails.SliverStatus nodeStatus = (StatusDetails.SliverStatus)this.experiment.getSlice().getStatus().getStatusByComponentUrn().get(rspecNode.getComponentId());
                    if (nodeStatus == StatusDetails.SliverStatus.CHANGING || nodeStatus == StatusDetails.SliverStatus.UNKNOWN) {
                        this.LOG.debug("statuscheckfail: rspecNode {} not in state {} but in {}", new Object[]{rspecNode.getClientId(), desiredStatus, nodeStatus});
                        return false;
                    }
                    if (desiredStatus == DesiredStatus.GENI_NOTREADY && nodeStatus != StatusDetails.SliverStatus.NOTREADY) {
                        this.LOG.debug("statuscheckfail: rspecNode {} not in state {} but in {}", new Object[]{rspecNode.getClientId(), desiredStatus, nodeStatus});
                        return false;
                    }
                    if (desiredStatus != DesiredStatus.GENI_READY || nodeStatus == StatusDetails.SliverStatus.READY) continue;
                    this.LOG.debug("statuscheckfail: rspecNode {} not in state {} but in {}", new Object[]{rspecNode.getClientId(), desiredStatus, nodeStatus});
                    return false;
                }
                this.LOG.debug("No status by componentId for {}", (Object)rspecNode.getComponentId());
            }
        }
        return true;
    }

    private boolean isTimeout() {
        return this.timeoutTime != null && this.timeoutTime.isBefore(Instant.now());
    }

    public boolean isFailedDueToTimeout() {
        return this.hadTimeout;
    }

    private static long roundUp(long num, long divisor) {
        return (num + divisor - 1L) / divisor;
    }

    public void setCheckReadyIntervalMs(long checkReadyIntervalMs) {
        this.checkReadyInterval = Duration.ofMillis(checkReadyIntervalMs);
    }

    public void setCheckReadyInterval(@Nullable Duration checkReadyInterval) {
        this.checkReadyInterval = checkReadyInterval == null ? DEFAULT_CHECK_READY_INTERVAL : checkReadyInterval;
    }
}

