/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.model;

import be.iminds.ilabt.jfed.highlevel.util.JFedJavaFXBindings;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.SfaCredential;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ParameterHistoryModel {
    private final ObservableList<AnyCredential> userCredentialInfos = FXCollections.synchronizedObservableList((ObservableList)FXCollections.observableArrayList());
    private final ObservableList<AnyCredential> sliceCredentialInfos = FXCollections.synchronizedObservableList((ObservableList)FXCollections.observableArrayList());
    private final ObservableList<AnyCredential> uncategorizedCredentiaInfos = FXCollections.synchronizedObservableList((ObservableList)FXCollections.observableArrayList());
    private final ObservableList<String> sliceUrns = FXCollections.synchronizedObservableList((ObservableList)FXCollections.observableArrayList());
    private final ObservableList<String> sliverUrns = FXCollections.synchronizedObservableList((ObservableList)FXCollections.observableArrayList());
    private final ObservableList<String> userUrns = FXCollections.synchronizedObservableList((ObservableList)FXCollections.observableArrayList());

    @Inject
    public ParameterHistoryModel() {
    }

    public void seeUrn(String urn) {
        if (urn.startsWith("urn:publicid:IDN+")) {
            if (urn.contains("+user+")) {
                this.addUserUrn(urn);
            }
            if (urn.contains("+slice+")) {
                this.addSliceUrn(urn);
            }
            if (urn.contains("+sliver+")) {
                this.addSliverUrn(urn);
            }
        }
    }

    public void seeUrnsInCredential(AnyCredential credentialInfo) {
        try {
            if (credentialInfo instanceof SfaCredential) {
                this.seeUrn(((SfaCredential)credentialInfo).getTargetUrn());
                this.seeUrn(((SfaCredential)credentialInfo).getOwnerUrn());
            }
        }
        catch (AssertionError | Exception object) {
            // empty catch block
        }
    }

    public ObservableList<AnyCredential> getUserCredentialsList() {
        return this.userCredentialInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserCredential(AnyCredential userCredentialInfo) {
        this.seeUrnsInCredential(userCredentialInfo);
        ObservableList<AnyCredential> observableList = this.userCredentialInfos;
        synchronized (observableList) {
            if (!this.userCredentialInfos.contains((Object)userCredentialInfo)) {
                this.userCredentialInfos.add((Object)userCredentialInfo);
            }
        }
    }

    public ObservableList<AnyCredential> getSliceCredentialsList() {
        return this.sliceCredentialInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSliceCredential(AnyCredential sliceCredentialInfo) {
        this.seeUrnsInCredential(sliceCredentialInfo);
        ObservableList<AnyCredential> observableList = this.sliceCredentialInfos;
        synchronized (observableList) {
            if (!this.sliceCredentialInfos.contains((Object)sliceCredentialInfo)) {
                this.sliceCredentialInfos.add((Object)sliceCredentialInfo);
            }
        }
    }

    public ObservableList<AnyCredential> getUncategorizedCredentialsList() {
        return this.uncategorizedCredentiaInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUncategorizedCredential(AnyCredential uncategorizedCredentiaInfo) {
        this.seeUrnsInCredential(uncategorizedCredentiaInfo);
        ObservableList<AnyCredential> observableList = this.uncategorizedCredentiaInfos;
        synchronized (observableList) {
            if (!this.uncategorizedCredentiaInfos.contains((Object)uncategorizedCredentiaInfo)) {
                this.uncategorizedCredentiaInfos.add((Object)uncategorizedCredentiaInfo);
            }
        }
    }

    public ObservableList<AnyCredential> getAnyCredentialsList() {
        return JFedJavaFXBindings.union(this.userCredentialInfos, this.sliceCredentialInfos, this.uncategorizedCredentiaInfos);
    }

    public ObservableList<String> getAllUrnList() {
        return JFedJavaFXBindings.union(this.sliceUrns, this.sliverUrns, this.userUrns);
    }

    public ObservableList<String> getSliceUrnsList() {
        return this.sliceUrns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSliceUrn(String urn) {
        ObservableList<String> observableList = this.sliceUrns;
        synchronized (observableList) {
            if (urn != null && !this.sliceUrns.contains((Object)urn)) {
                this.sliceUrns.add((Object)urn);
            }
        }
    }

    public ObservableList<String> getSliverUrns() {
        return this.sliverUrns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSliverUrn(String urn) {
        ObservableList<String> observableList = this.sliverUrns;
        synchronized (observableList) {
            if (urn != null && !this.sliverUrns.contains((Object)urn)) {
                this.sliverUrns.add((Object)urn);
            }
        }
    }

    public ObservableList<String> getUserUrns() {
        return this.userUrns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserUrn(String urn) {
        ObservableList<String> observableList = this.userUrns;
        synchronized (observableList) {
            if (urn != null && !this.userUrns.contains((Object)urn)) {
                this.userUrns.add((Object)urn);
            }
        }
    }
}

