/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.model;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.model.InternalState;
import be.iminds.ilabt.jfed.highlevel.model.ParameterHistoryModel;
import be.iminds.ilabt.jfed.highlevel.model.PlanetlabSfaRegistryInterfaceListener;
import be.iminds.ilabt.jfed.highlevel.model.SfaModelAggregateManager2Listener;
import be.iminds.ilabt.jfed.highlevel.model.SfaModelAggregateManager3Listener;
import be.iminds.ilabt.jfed.highlevel.model.SfaModelSliceAuthorityListener;
import be.iminds.ilabt.jfed.highlevel.model.SfaUniformFederationMemberAuthorityApiListener;
import be.iminds.ilabt.jfed.highlevel.model.SfaUniformFederationSliceAuthorityApiListener;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.highlevel.util.SliceRegistryUtil;
import be.iminds.ilabt.jfed.log.ResultListener;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.SfaCredential;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.rspec_source.AdvertisementRspecSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SfaModel {
    private static final Logger LOG = LoggerFactory.getLogger(SfaModel.class);
    private static final Comparator<Slice> SLICE_COMPARATOR = Comparator.comparing(Slice::getUrnString, String::compareToIgnoreCase);
    private final ObservableList<Slice> slices = FXCollections.observableArrayList();
    private final JavaFXLogger logger;
    UserAndSliceApiWrapper.SubAuthoritySupport subAuthoritySupport = null;
    private final ObservableMap<GeniUrn, Slice> slicesByUrn;
    private List<AnyCredential> userCredentials;
    private final HashMultimap<String, AnyCredential> userCredentialsBySubAuthority = HashMultimap.create();
    private final Multimap<GeniUrn, String> userKeys = HashMultimap.create();
    private final ObservableSet<String> allSubAuthorityNames = FXCollections.observableSet(new HashSet());
    private final ObservableSet<String> userSubAuthorityNames = FXCollections.observableSet(new HashSet());
    private final Map<String, ListProperty<GeniUrn>> usersBySubAuthorityName = new ConcurrentHashMap<String, ListProperty<GeniUrn>>();
    private final ObservableMap<GeniUrn, Instant> projectExpirations = FXCollections.observableMap(new TreeMap((o1, o2) -> o1.toString().compareToIgnoreCase(o2.toString())));
    private final TestbedInfoSource testbedInfoSource;
    private final AuthorityFinder authorityFinder;
    private final ParameterHistoryModel parameterHistoryModel;
    private final GeniUserProvider geniUserProvider;
    private final SliceRegistryUtil sliceRegistryUtil;
    private final Map<Integer, ObjectProperty<AdvertisementRspecSource>> availableAdvertisementPropertyByServerId = new HashMap<Integer, ObjectProperty<AdvertisementRspecSource>>();
    private final Map<Integer, ObjectProperty<AdvertisementRspecSource>> allAdvertisementPropertyByServerId = new HashMap<Integer, ObjectProperty<AdvertisementRspecSource>>();

    @Inject
    public SfaModel(JavaFXLogger logger, TestbedInfoSource testbedInfoSource, AuthorityFinder authorityFinder, ParameterHistoryModel parameterHistoryModel, GeniUserProvider geniUserProvider, @Nullable SliceRegistryUtil sliceRegistryUtil) {
        this.logger = logger;
        this.testbedInfoSource = testbedInfoSource;
        this.authorityFinder = authorityFinder;
        this.parameterHistoryModel = parameterHistoryModel;
        this.geniUserProvider = geniUserProvider;
        this.sliceRegistryUtil = sliceRegistryUtil;
        PlanetlabSfaRegistryInterfaceListener planetlabSfaRegistryInterfaceListener = new PlanetlabSfaRegistryInterfaceListener(this, parameterHistoryModel);
        logger.addResultListener(planetlabSfaRegistryInterfaceListener);
        SfaModelSliceAuthorityListener sliceAuthorityListener = new SfaModelSliceAuthorityListener(this, testbedInfoSource);
        logger.addResultListener(sliceAuthorityListener);
        SfaModelAggregateManager3Listener am3Listener = new SfaModelAggregateManager3Listener(this, testbedInfoSource);
        logger.addResultListener(am3Listener);
        SfaModelAggregateManager2Listener am2Listener = new SfaModelAggregateManager2Listener(this, testbedInfoSource);
        logger.addResultListener(am2Listener);
        SfaUniformFederationSliceAuthorityApiListener ufSaListener = new SfaUniformFederationSliceAuthorityApiListener(this, testbedInfoSource);
        logger.addResultListener(ufSaListener);
        SfaUniformFederationMemberAuthorityApiListener ufMaListener = new SfaUniformFederationMemberAuthorityApiListener(this, geniUserProvider);
        logger.addResultListener(ufMaListener);
        this.userCredentials = null;
        this.slicesByUrn = FXCollections.observableMap(new TreeMap((o1, o2) -> o1.toString().compareToIgnoreCase(o2.toString())));
    }

    public TestbedInfoSource getTestbedInfoSource() {
        return this.testbedInfoSource;
    }

    public AuthorityFinder getAuthorityFinder() {
        return this.authorityFinder;
    }

    private GeniUrn getLoggedInUserUrn() {
        if (!this.geniUserProvider.isUserLoggedIn()) {
            return null;
        }
        return this.geniUserProvider.getLoggedInGeniUser().getUserUrn();
    }

    private static CredForSubAuthInfo areUserCredentialsForSubAuth(List<AnyCredential> userCredentials) {
        if (userCredentials == null) {
            return null;
        }
        CredForSubAuthInfo res = new CredForSubAuthInfo();
        res.isAnyCredForASubAuthority = false;
        res.isAnyCredNotForASubAuthority = false;
        userCredentials.stream().filter(c -> c.isTargetSubAuthority() != null).forEach(c -> {
            if (!res.isAnyCredForASubAuthority && c.isTargetSubAuthority().booleanValue()) {
                res.isAnyCredForASubAuthority = true;
            }
            if (!res.isAnyCredNotForASubAuthority && !c.isTargetSubAuthority().booleanValue()) {
                res.isAnyCredNotForASubAuthority = true;
            }
            if (c.isTargetSubAuthority().booleanValue()) {
                SfaCredential userSfaCredential = (SfaCredential)c;
                String targetUrnStr = userSfaCredential.getTargetUrn();
                assert (targetUrnStr != null);
                GeniUrn targetUrn = GeniUrn.parse((String)targetUrnStr);
                assert (targetUrn != null);
                String subAuthName = targetUrn.getEncodedSubAuthName();
                assert (subAuthName != null);
                if (res.targetSubAuth != null && !Objects.equals(res.targetSubAuth, subAuthName)) {
                    LOG.error("CRITICAL WARNING: in credential list returned, I found a credential for subauthority=" + res.targetSubAuth + " AND for subauthority=" + subAuthName);
                }
                res.targetSubAuth = subAuthName;
            }
        });
        return res;
    }

    private static Collection<String> getTargetUrns(@Nonnull Collection<AnyCredential> creds) {
        return creds.stream().filter(c -> c instanceof SfaCredential).map(c -> ((SfaCredential)c).getTargetUrn()).collect(Collectors.toSet());
    }

    private static Boolean moreRecent(@Nullable Collection<AnyCredential> oldCreds, @Nullable Collection<AnyCredential> newCreds) {
        Date d;
        Date newestOldDate = null;
        Date newestNewDate = null;
        if (oldCreds == null || oldCreds.isEmpty()) {
            return true;
        }
        if (newCreds == null || newCreds.isEmpty()) {
            return false;
        }
        for (AnyCredential oldCred : oldCreds) {
            d = oldCred.getExpiresDate();
            if (d == null || newestOldDate != null && !newestOldDate.after(d)) continue;
            newestOldDate = d;
        }
        for (AnyCredential newCred : newCreds) {
            d = newCred.getExpiresDate();
            if (d == null || newestNewDate != null && !newestNewDate.after(d)) continue;
            newestNewDate = d;
        }
        if (newestOldDate == null) {
            return null;
        }
        if (newestNewDate == null) {
            return null;
        }
        return newestNewDate.after(newestOldDate);
    }

    public synchronized void clear() {
        this.slices.clear();
        this.slicesByUrn.clear();
        this.userCredentials.clear();
        this.userKeys.clear();
        this.allSubAuthorityNames.clear();
        this.userSubAuthorityNames.clear();
        this.clearUsersBySubAuthority();
    }

    public synchronized void clearUsersBySubAuthority() {
        for (ListProperty<GeniUrn> observableList : this.usersBySubAuthorityName.values()) {
            observableList.clear();
        }
    }

    public JavaFXLogger getLogger() {
        return this.logger;
    }

    void logNotExistSlice(@Nonnull GeniUrn sliceUrn) {
        Slice existingSlice = (Slice)this.slicesByUrn.get((Object)sliceUrn);
        if (existingSlice != null) {
            this.slices.remove((Object)existingSlice);
            this.slicesByUrn.remove((Object)existingSlice.getUrn());
        }
    }

    public Slice logExistSlice(@Nonnull String sliceUrn) throws GeniUrn.GeniUrnParseException {
        return this.logExistSlice(new GeniUrn(sliceUrn));
    }

    @Nonnull
    public synchronized Slice logExistSlice(@Nonnull GeniUrn sliceUrn) {
        Slice existingSlice = (Slice)this.slicesByUrn.get((Object)sliceUrn);
        if (existingSlice == null) {
            Slice newSlice = new Slice(sliceUrn, this.testbedInfoSource, this.authorityFinder);
            this.parameterHistoryModel.addSliceUrn(sliceUrn.toString());
            newSlice.credentialsProperty().addListener((observableValue, oldGeniCredentials, newGeniCredentials) -> newGeniCredentials.forEach(this.parameterHistoryModel::addSliceCredential));
            int location = Collections.binarySearch(this.slices, newSlice, SLICE_COMPARATOR);
            assert (location < 0) : "Slice was not found in slicesByUrn (keys=" + this.slicesByUrn.keySet() + ") but was found by binary search. urn=" + sliceUrn;
            location = -location - 1;
            this.slices.add(location, (Object)newSlice);
            this.slicesByUrn.put((Object)sliceUrn, (Object)newSlice);
            return newSlice;
        }
        return existingSlice;
    }

    @Nonnull
    public Slice logExistSliceUrn(@Nonnull String serverUrnString, @Nonnull String sliceUrn) throws GeniUrn.GeniUrnParseException {
        assert (sliceUrn.startsWith("urn:publicid:IDN")) : "sliceUrn is not urn \"" + sliceUrn + "\"";
        assert (sliceUrn.startsWith("urn:publicid:IDN+" + GeniUrn.parse((String)serverUrnString).getEncodedTopLevelAuthority_withoutSubAuth())) : "sliceUrn is not for the correct authority: urn \"" + sliceUrn + "\" auth: \"" + serverUrnString + "\"";
        return this.logExistSlice(sliceUrn);
    }

    @Nonnull
    public Slice logExistSliceUrn(@Nonnull String serverUrnString, @Nonnull GeniUrn sliceUrn) {
        assert (sliceUrn.getTopLevelAuthority().startsWith(GeniUrn.parse((String)serverUrnString).getEncodedTopLevelAuthority_withoutSubAuth())) : "sliceUrn is not for the correct authority: urn \"" + sliceUrn + "\" auth: \"" + serverUrnString + "\"";
        return this.logExistSlice(sliceUrn);
    }

    public void logNotExistSliver(@Nonnull String sliceUrn, @Nonnull String sliverUrn, Sliver.Source source) throws GeniUrn.GeniUrnParseException {
        this.logNotExistSliver(new GeniUrn(sliceUrn), new GeniUrn(sliverUrn), source);
    }

    public void logNotExistSliver(@Nonnull GeniUrn sliceUrn, @Nonnull GeniUrn sliverUrn, Sliver.Source source) {
        Slice slice;
        Sliver sliver;
        if (Objects.equals(sliverUrn.getTopLevelAuthority(), "ple")) {
            LOG.warn("HACK: correcting sliver-urn from +ple+ to +ple:ibbtple+");
            sliverUrn = sliverUrn.replaceTopLevelAuthority("ple:ibbtple");
        }
        if ((sliver = (slice = this.logExistSlice(sliceUrn)).findSliver(sliverUrn)) == null) {
            LOG.info("Sliver {} is not present in model, so we cannot mark it as non-existing", (Object)sliverUrn);
            return;
        }
        if (sliver.getSource() == Sliver.Source.SLICE_AUTHORITY) {
            if (Sliver.Source.SLICE_AUTHORITY.compareTo(source) < 0) {
                if (this.sliceRegistryUtil != null) {
                    LOG.debug("Sliver {} is only known by the slice authority, but not mentioned by {}. We will remove it from the slice authority now.", (Object)sliver.getUrn(), (Object)source.name());
                    this.sliceRegistryUtil.unregisterSliversAtSATaskExecution(slice, sliver.getServer(), Collections.singletonList(sliver.getUrn()), null, new ResultListener[0]);
                }
            } else {
                LOG.debug("Sliver {} was only registered in SLICE_AUTHORITY, and was deleted there. We can safely delete it from our model", (Object)sliver.getUrn());
                slice.removeSliver(sliver);
            }
        } else {
            LOG.debug("Setting sliver {} to 'not existing'", (Object)sliver);
            sliver.setStatus(new StatusDetails(StatusDetails.SliverStatus.UNALLOCATED, sliver.getUrn()));
            sliver.setStatusString("non existing");
            sliver.setManifestRspec(null);
        }
    }

    @Nullable
    public Sliver logExistSliver(@Nonnull String sliceUrnStr, @Nonnull String sliverUrnStr, @Nonnull Server auth, @Nonnull Sliver.Source source) throws GeniUrn.GeniUrnParseException {
        return this.logExistSliver(new GeniUrn(sliceUrnStr), new GeniUrn(sliverUrnStr), auth, source);
    }

    @Nullable
    public Sliver logExistSliver(@Nonnull GeniUrn sliceUrn, @Nonnull GeniUrn sliverUrn, @Nonnull Server auth, @Nonnull Sliver.Source source) {
        if (Objects.equals(sliverUrn.getEncodedTopLevelAuthority_withoutSubAuth(), auth.getDefaultComponentManagerAsGeniUrn().getEncodedTopLevelAuthority_withoutSubAuth())) {
            return this.logExistSliver(sliceUrn, sliverUrn, source);
        }
        LOG.warn("SfaModel.logExistSliver() -> Sliver does not match authority, will ignore it: sliverUrn=" + sliverUrn + " (" + sliverUrn.getEncodedTopLevelAuthority_withoutSubAuth() + ") authUrn=" + auth.getDefaultComponentManagerUrn() + " (" + auth.getDefaultComponentManagerAsGeniUrn().getEncodedTopLevelAuthority_withoutSubAuth() + ")");
        this.logExistAtLeastOneSliver(sliceUrn, auth, source);
        return null;
    }

    @Nonnull
    public Sliver logExistSliver(@Nonnull String sliceUrn, @Nonnull String sliverUrn, @Nonnull Sliver.Source source) throws GeniUrn.GeniUrnParseException {
        assert (sliverUrn.contains("+sliver+")) : "sliverUrn=\"" + sliverUrn + "\" is not a sliver urn (sliceUrn=" + sliceUrn + ")";
        assert (sliceUrn.contains("+slice+")) : "sliceUrn=\"" + sliceUrn + "\" is not a slice urn (sliverUrn=" + sliverUrn + ")";
        return this.logExistSliver(new GeniUrn(sliceUrn), new GeniUrn(sliverUrn), source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Sliver logExistSliver(@Nonnull GeniUrn sliceUrn, @Nonnull GeniUrn sliverUrn, Sliver.Source source) {
        Slice slice;
        if (Objects.equals(sliverUrn.getTopLevelAuthority(), "ple")) {
            LOG.warn("HACK: correcting sliver-urn from +ple+ to +ple:ibbtple+");
            sliverUrn = sliverUrn.replaceTopLevelAuthority("ple:ibbtple");
        }
        Slice slice2 = slice = this.logExistSlice(sliceUrn);
        synchronized (slice2) {
            Sliver sliver = slice.findSliver(sliverUrn);
            if (sliver == null) {
                LOG.debug("logExistSliver did not find sliver by urn " + sliverUrn + " so it will create a sliver");
                Server auth = this.testbedInfoSource.getFromAnyUrn(sliverUrn, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_TOPLEVEL, TestbedInfoSource.SubAuthMatchPreference.PREFER_EXACT_SUBAUTHORITY);
                if (auth == null) {
                    throw new NullPointerException("auth==null because sliverUrn could not be used to find authority: sliverUrn=\"" + sliverUrn + "\"");
                }
                LOG.debug("Sliver '{}' is from authority {} according to {}", new Object[]{sliverUrn, auth.getDefaultComponentManagerUrn(), source.name()});
                sliver = new Sliver(sliverUrn, source, slice, null, null, auth);
                this.parameterHistoryModel.addSliverUrn(sliverUrn.toString());
                slice.addSliver(sliver);
            } else {
                LOG.debug("logExistSliver found sliver " + sliver + " by urn " + sliverUrn);
                if (sliver.getSource().compareTo(source) < 0) {
                    sliver.setSource(source);
                    LOG.debug("logExistSliver found a more trusted source for sliver {}: {}", (Object)sliver.getUrn(), (Object)source);
                }
            }
            return sliver;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Sliver getSliver(@Nonnull GeniUrn sliverUrn) {
        if (Objects.equals(sliverUrn.getTopLevelAuthority(), "ple")) {
            LOG.warn("HACK: correcting sliver-urn from +ple+ to +ple:ibbtple+");
            sliverUrn = sliverUrn.replaceTopLevelAuthority("ple:ibbtple");
        }
        Iterator iterator = this.slicesByUrn.values().iterator();
        while (iterator.hasNext()) {
            Slice slice;
            Slice slice2 = slice = (Slice)iterator.next();
            synchronized (slice2) {
                Sliver sliver = slice.findSliver(sliverUrn);
                if (sliver != null) {
                    return sliver;
                }
            }
        }
        return null;
    }

    public void logExistAtLeastOneSliver(@Nonnull String sliceUrn, @Nonnull Integer serverId, Sliver.Source source) throws GeniUrn.GeniUrnParseException {
        this.logExistAtLeastOneSliver(new GeniUrn(sliceUrn), this.testbedInfoSource.getServerById(serverId), source);
    }

    public void logExistAtLeastOneSliver(@Nonnull GeniUrn sliceUrn, @Nonnull Integer serverId, Sliver.Source source) throws GeniUrn.GeniUrnParseException {
        this.logExistAtLeastOneSliver(sliceUrn, this.testbedInfoSource.getServerById(serverId), source);
    }

    public void logExistAtLeastOneSliver(@Nonnull String sliceUrn, @Nonnull Server auth, Sliver.Source source) throws GeniUrn.GeniUrnParseException {
        this.logExistAtLeastOneSliver(new GeniUrn(sliceUrn), auth, source);
    }

    public void logExistAtLeastOneSliver(@Nonnull GeniUrn sliceUrn, @Nonnull Server auth, Sliver.Source source) {
        Slice slice = this.logExistSlice(sliceUrn);
        List<Sliver> slivers = slice.findSlivers(auth);
        if (slivers == null || slivers.isEmpty()) {
            slice.setAuthorityInternalState(auth, InternalState.UNKNOWN);
            LOG.debug("logExistAtLeastOneSliver -> set internal state for authority {} on slice {} to UNKNOWN", (Object)auth.getName(), (Object)sliceUrn);
        }
    }

    public void logNotExistSliverInSliceOnAuth(@Nonnull GeniUrn sliceUrn, @Nonnull Integer serverId) {
        this.logNotExistSliverInSliceOnAuth(sliceUrn, this.testbedInfoSource.getServerById(serverId));
    }

    public void logNotExistSliverInSliceOnAuth(@Nonnull String sliceUrn, @Nonnull Integer serverId) {
        this.logNotExistSliverInSliceOnAuth(sliceUrn, this.testbedInfoSource.getServerById(serverId));
    }

    public void logNotExistSliverInSliceOnAuth(@Nonnull String sliceUrn, @Nonnull Server auth) {
        try {
            this.logNotExistSliverInSliceOnAuth(new GeniUrn(sliceUrn), auth);
        }
        catch (GeniUrn.GeniUrnParseException e) {
            LOG.warn("Could not register non-existence of sliver on {} in slice {}: invalid sliceUrn", new Object[]{auth.getName(), sliceUrn, e});
        }
    }

    public void logNotExistSliverInSliceOnAuth(@Nonnull GeniUrn sliceUrn, @Nonnull Server auth) {
        Slice slice = (Slice)this.slicesByUrn.get((Object)sliceUrn);
        if (slice == null) {
            return;
        }
        List<Sliver> slivers = slice.findSlivers(auth);
        for (Sliver sliver : slivers) {
            sliver.setStatus(new StatusDetails(StatusDetails.SliverStatus.UNALLOCATED, sliver.getUrn()));
            sliver.setStatusString("non existing");
            sliver.setManifestRspec(null);
        }
    }

    public Slice getSlice(@Nonnull String sliceUrn) throws GeniUrn.GeniUrnParseException {
        return this.getSlice(new GeniUrn(sliceUrn));
    }

    public Slice getSlice(@Nonnull GeniUrn sliceUrn) {
        return (Slice)this.slicesByUrn.get((Object)sliceUrn);
    }

    public ObservableList<Slice> getSlices() {
        return this.slices;
    }

    public void addUserKey(@Nonnull String key) {
        if (this.getLoggedInUserUrn() == null) {
            LOG.warn("No logged in user, so SfaModel cannot register key " + key);
        } else {
            this.addUserKey(this.getLoggedInUserUrn(), key);
        }
    }

    public void addUserKey(@Nonnull GeniUrn user, String key) {
        if (key == null) {
            LOG.warn("addUserKey(" + user + ", null) called -> no key to register. Will ignore.");
            return;
        }
        this.addUserKeys(user, Collections.singletonList(key));
    }

    public void addUserKeys(@Nonnull GeniUrn user, @Nonnull Collection<String> newKeys) {
        newKeys.stream().map(key -> key.replaceAll("\\r\\n|\\r|\\n", "")).forEach(key -> this.userKeys.put((Object)user, key));
    }

    public Collection<String> getUserKeys() {
        if (this.getLoggedInUserUrn() == null) {
            LOG.warn("No logged in user, so SfaModel cannot answer getUserKeys()");
            return Collections.emptyList();
        }
        return this.getUserKeys(this.getLoggedInUserUrn());
    }

    public Collection<String> getUserKeys(GeniUrn userUrn) {
        if (this.userKeys.containsKey((Object)userUrn)) {
            return this.userKeys.get((Object)userUrn);
        }
        return Collections.emptyList();
    }

    public synchronized List<AnyCredential> getAllUserCredentials() {
        ArrayList<AnyCredential> res = new ArrayList<AnyCredential>();
        if (this.userCredentials != null) {
            res.addAll(this.userCredentials);
        }
        this.userCredentialsBySubAuthority.values().forEach(res::add);
        return res;
    }

    public synchronized List<AnyCredential> getUserCredentials() {
        if (LOG.isDebugEnabled()) {
            Collection<String> targetUrn = SfaModel.getTargetUrns(this.userCredentials);
            LOG.debug("SfaModel: retrieving user credential with target: " + targetUrn);
        }
        return this.userCredentials;
    }

    public synchronized void setUserCredentials(@Nonnull List<AnyCredential> userCredentials) {
        LOG.trace("SfaModel: setUserCredentials userCredentials.size()=" + userCredentials.size());
        CredForSubAuthInfo subAuthInfo = SfaModel.areUserCredentialsForSubAuth(userCredentials);
        if (subAuthInfo != null && subAuthInfo.isAnyCredForASubAuthority) {
            this.setUserCredentials(userCredentials, subAuthInfo.targetSubAuth);
        } else {
            this.setUserCredentials(userCredentials, null);
        }
    }

    public synchronized Collection<AnyCredential> getUserCredentials(@Nullable String subAuthority) {
        if (subAuthority == null) {
            return this.getUserCredentials();
        }
        if (LOG.isDebugEnabled()) {
            Collection<String> targetUrn = SfaModel.getTargetUrns(this.userCredentialsBySubAuthority.get((Object)subAuthority));
            LOG.debug("SfaModel: retrieving user credential for SUB AUTHORITY \"" + subAuthority + "\" with target: " + targetUrn);
        }
        return this.userCredentialsBySubAuthority.get((Object)subAuthority);
    }

    public synchronized void setUserCredentials(@Nonnull List<AnyCredential> userCredentials, @Nullable String subAuthority) {
        LOG.trace("SfaModel: setUserCredentials (subAuthority=" + subAuthority + ") userCredentials.size()=" + userCredentials.size());
        if (subAuthority == null) {
            if (SfaModel.moreRecent(this.userCredentials, userCredentials) != Boolean.TRUE) {
                LOG.info("Ignoring received credentials, as current ones are more recent");
                return;
            }
            CredForSubAuthInfo subAuthInfo = SfaModel.areUserCredentialsForSubAuth(userCredentials);
            assert (!subAuthInfo.isAnyCredForASubAuthority) : "subAuthInfo.isAnyCredForASubAuthority=" + subAuthInfo.isAnyCredForASubAuthority + " isAnyCredNotForASubAuthority=" + subAuthInfo.isAnyCredNotForASubAuthority + " for userCredentials=" + userCredentials;
            if (LOG.isDebugEnabled()) {
                Collection<String> targetUrns = SfaModel.getTargetUrns(userCredentials);
                LOG.debug("SfaModel: saving user credential with targets: " + targetUrns);
                if (targetUrns != null && !targetUrns.isEmpty()) {
                    for (String targetUrn : targetUrns) {
                        GeniUrn tu = GeniUrn.parse((String)targetUrn);
                        if (tu != null) assert (tu.getEncodedSubAuthName() == null);
                    }
                }
            }
            LOG.trace("SfaModel: storing userCredentials (no subauth): userCredentials.size()=" + userCredentials.size());
            userCredentials.forEach(this.parameterHistoryModel::addUserCredential);
            this.userCredentials = userCredentials;
        } else {
            CredForSubAuthInfo subAuthInfo = SfaModel.areUserCredentialsForSubAuth(userCredentials);
            assert (subAuthInfo.isAnyCredForASubAuthority) : "subAuthInfo.isAnyCredForASubAuthority=" + subAuthInfo.isAnyCredForASubAuthority + " isAnyCredNotForASubAuthority=" + subAuthInfo.isAnyCredNotForASubAuthority + " for userCredentials=" + userCredentials;
            assert (!subAuthInfo.isAnyCredNotForASubAuthority) : "subAuthInfo.isAnyCredForASubAuthority=" + subAuthInfo.isAnyCredForASubAuthority + " isAnyCredNotForASubAuthority=" + subAuthInfo.isAnyCredNotForASubAuthority + " for userCredentials=" + userCredentials;
            Set oldUserCredentials = this.userCredentialsBySubAuthority.get((Object)subAuthority);
            if (SfaModel.moreRecent(oldUserCredentials, userCredentials) != Boolean.TRUE) {
                LOG.info("Ignoring received credentials for subAuth {}, as current ones are more recent", (Object)subAuthority);
                return;
            }
            if (LOG.isDebugEnabled()) {
                Collection<String> targetUrns = SfaModel.getTargetUrns(this.userCredentialsBySubAuthority.get((Object)subAuthority));
                LOG.debug("SfaModel: saving SUB AUTHORITY user credential for \"" + subAuthority + "\" with target: " + targetUrns);
                if (targetUrns != null && !targetUrns.isEmpty()) {
                    for (String targetUrn : targetUrns) {
                        GeniUrn tu = GeniUrn.parse((String)targetUrn);
                        if (tu != null) assert (tu.getEncodedSubAuthName() != null);
                    }
                }
            }
            LOG.trace("SfaModel: storing userCredentials (subauth=" + subAuthority + "): userCredentials.size()=" + userCredentials.size());
            userCredentials.forEach(this.parameterHistoryModel::addUserCredential);
            this.userCredentialsBySubAuthority.replaceValues((Object)subAuthority, userCredentials);
        }
    }

    public UserAndSliceApiWrapper.SubAuthoritySupport getSubAuthoritySupport() {
        return this.subAuthoritySupport;
    }

    public void setSubAuthoritySupport(UserAndSliceApiWrapper.SubAuthoritySupport subAuthoritySupport) {
        this.subAuthoritySupport = subAuthoritySupport;
    }

    public void addLoggedInUserSubAuthorityName(@Nonnull String subAuthorityName) {
        this.allSubAuthorityNames.add((Object)subAuthorityName);
        this.userSubAuthorityNames.add((Object)subAuthorityName);
    }

    public void addAnySubAuthorityName(@Nonnull String subAuthorityName) {
        this.allSubAuthorityNames.add((Object)subAuthorityName);
    }

    @Nonnull
    public ObservableSet<String> getAllSubAuthorityNames() {
        return this.allSubAuthorityNames;
    }

    @Nonnull
    public ObservableSet<String> getLoggedInUserSubAuthorityNames() {
        return this.userSubAuthorityNames;
    }

    @Nonnull
    public ReadOnlyListProperty<GeniUrn> getUsersBySubAuthority(@Nullable String subAuthorityName) {
        return new ReadOnlyListWrapper((ObservableList)this.usersBySubAuthorityName.computeIfAbsent(subAuthorityName, k -> new SimpleListProperty(FXCollections.observableArrayList())));
    }

    public ParameterHistoryModel getParameterHistoryModel() {
        return this.parameterHistoryModel;
    }

    public void setUsersOfSubAuthority(@Nullable String subAuthorityName, @Nonnull Collection<GeniUrn> userUrns) {
        this.usersBySubAuthorityName.computeIfAbsent(subAuthorityName, k -> new SimpleListProperty(FXCollections.observableArrayList())).setAll(userUrns);
    }

    public void setAdvertisementRspec(Server server, boolean available, String rspec) {
        assert (server != null);
        assert (rspec != null);
        ObjectProperty prop = available ? this.availableAdvertisementPropertyByServerId.computeIfAbsent((Integer)server.getId(), id -> new SimpleObjectProperty()) : this.allAdvertisementPropertyByServerId.computeIfAbsent((Integer)server.getId(), id -> new SimpleObjectProperty());
        prop.setValue((Object)new AdvertisementRspecSource(rspec, ModelRspecType.FX));
    }

    public AdvertisementRspecSource getAvailableAdvertisementRspec(Server server) {
        assert (server != null);
        ObjectProperty prop = this.availableAdvertisementPropertyByServerId.computeIfAbsent((Integer)server.getId(), id -> new SimpleObjectProperty());
        return (AdvertisementRspecSource)prop.get();
    }

    public ObjectProperty<AdvertisementRspecSource> availableAdvertisementRspecProperty(Server server) {
        assert (server != null);
        ObjectProperty prop = this.availableAdvertisementPropertyByServerId.computeIfAbsent((Integer)server.getId(), id -> new SimpleObjectProperty());
        return prop;
    }

    public AdvertisementRspecSource getAllAdvertisementRspec(Server server) {
        assert (server != null);
        ObjectProperty prop = this.allAdvertisementPropertyByServerId.computeIfAbsent((Integer)server.getId(), id -> new SimpleObjectProperty());
        return (AdvertisementRspecSource)prop.get();
    }

    public ObjectProperty<AdvertisementRspecSource> allAdvertisementRspecProperty(Server server) {
        assert (server != null);
        ObjectProperty prop = this.allAdvertisementPropertyByServerId.computeIfAbsent((Integer)server.getId(), id -> new SimpleObjectProperty());
        return prop;
    }

    public ObservableMap<GeniUrn, Instant> getProjectExpirations() {
        return this.projectExpirations;
    }

    @Nullable
    public Instant getProjectExpiration(@Nonnull GeniUrn projectUrn) {
        return (Instant)this.projectExpirations.get((Object)projectUrn);
    }

    public Slice resetSlice(@Nonnull GeniUrn sliceUrn) {
        Slice slice = this.logExistSlice(sliceUrn);
        slice.removeInactiveSlivers();
        return slice;
    }

    private static class CredForSubAuthInfo {
        public boolean isAnyCredForASubAuthority = false;
        public boolean isAnyCredNotForASubAuthority = false;
        public String targetSubAuth = null;

        private CredForSubAuthInfo() {
        }
    }
}

