/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.model;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.SfaModelAbstractListener;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.log.ApiCallDetails;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager3;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.ErrorDetails;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AMv3Wrapper;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SfaModelAggregateManager3Listener
extends SfaModelAbstractListener {
    private static final Logger LOG = LoggerFactory.getLogger(SfaModelAggregateManager3Listener.class);
    private final TestbedInfoSource testbedInfoSource;

    public SfaModelAggregateManager3Listener(SfaModel sfaModel, TestbedInfoSource testbedInfoSource) {
        super(sfaModel);
        this.testbedInfoSource = testbedInfoSource;
    }

    private List<String> getSliceUrns(List<String> urns) {
        ArrayList<String> res = new ArrayList<String>();
        for (String u : urns) {
            GeniUrn geniUrn = GeniUrn.parse((String)u);
            if (geniUrn == null || !Objects.equals(geniUrn.getEncodedResourceType(), "slice")) continue;
            res.add(u);
        }
        return res;
    }

    private List<String> getSliverUrns(List<String> urn) {
        ArrayList<String> res = new ArrayList<String>();
        for (String u : urn) {
            GeniUrn geniUrn = GeniUrn.parse((String)u);
            if (geniUrn == null || !Objects.equals(geniUrn.getEncodedResourceType(), "sliver")) continue;
            res.add(u);
        }
        return res;
    }

    private List<String> getSliverUrnsFromSliverInfo(List<AggregateManager3.SliverInfo> sliverinfos) {
        ArrayList<String> res = new ArrayList<String>();
        for (AggregateManager3.SliverInfo si : sliverinfos) {
            res.add(si.getSliverUrn());
        }
        return res;
    }

    private void onGetVersionResult(ApiCallDetails result) {
        if (result.getReply().getGeniResponseCode().isSuccess()) {
            // empty if block
        }
    }

    public void onStatusResult(Integer serverId, AggregateManager3.StatusInfo statusInfo) {
        try {
            this.getModel().logExistSlice(statusInfo.getSliceUrn());
        }
        catch (GeniUrn.GeniUrnParseException e) {
            LOG.error("Could not register slice with urn {} from StatusResult", (Object)statusInfo.getSliceUrn(), (Object)e);
        }
        this.onListOfSliverInfoResult(serverId, statusInfo.getSliceUrn(), statusInfo.getSliverInfo(), false);
    }

    public void onListOfSliverInfoResult(Integer serverId, String sliceUrn, List<AggregateManager3.SliverInfo> sliverinfos, boolean ignoreOperationStatus) {
        Server auth = this.sfaModel.getTestbedInfoSource().getServerById(serverId);
        assert (sliceUrn != null);
        if (sliverinfos == null) {
            return;
        }
        StatusDetails.SliverStatus aggregatedStatusInCall = StatusDetails.SliverStatus.READY;
        HashSet<GeniUrn> mentionedSliverUrns = new HashSet<GeniUrn>();
        for (AggregateManager3.SliverInfo sliverInfo : sliverinfos) {
            LOG.debug("");
            if (Objects.equals(sliverInfo.getAllocationStatus(), "geni_unallocated")) {
                try {
                    this.getModel().logNotExistSliver(sliceUrn, sliverInfo.getSliverUrn(), Sliver.Source.AGGREGATE_MANAGER_STATUS);
                }
                catch (GeniUrn.GeniUrnParseException e) {
                    LOG.error("Could not register sliver non-existence because of invalid urn {}", (Object)sliverInfo.getSliverUrn(), (Object)e);
                }
                continue;
            }
            try {
                mentionedSliverUrns.add(GeniUrn.parse((String)sliverInfo.getSliverUrn()));
                Sliver sliver2 = this.getModel().logExistSliver(sliceUrn, sliverInfo.getSliverUrn(), Sliver.Source.AGGREGATE_MANAGER_STATUS);
                StatusDetails statusDetails = SfaModelAggregateManager3Listener.sliverInfoToSliverStatus(sliverInfo);
                aggregatedStatusInCall = StatusDetails.SliverStatus.merge((StatusDetails.SliverStatus)aggregatedStatusInCall, (StatusDetails.SliverStatus)statusDetails.getGlobalStatus());
                if (!ignoreOperationStatus) {
                    sliver2.setAllocationAndOperationalStatus(sliverInfo.getAllocationStatus(), sliverInfo.getOperationalStatus(), SfaModelAggregateManager3Listener.sliverInfoToSliverStatus(sliverInfo));
                }
                sliver2.setExpirationDate(sliverInfo.getExpiresDate().toInstant());
            }
            catch (GeniUrn.GeniUrnParseException e) {
                LOG.error("Could not register sliver existence because of invalid urn {}", (Object)sliverInfo.getSliverUrn(), (Object)e);
            }
            catch (ParseException e) {
                LOG.warn("in SfaModelAggregateManager3Listener in onListOfSliverInfoResult(): Invalid RFC3339 date in sliver expires: " + sliverInfo.getExpires(), (Throwable)e);
            }
        }
        try {
            Slice slice = this.getModel().logExistSlice(sliceUrn);
            for (Sliver sliver2 : slice.findSlivers(auth)) {
                if (!sliver2.getUrn().getEncodedResourceName().startsWith("ip-pool-")) continue;
                LOG.debug("Explicitly setting status of fake ip-pool sliver {} to {}", (Object)sliver2.getUrn(), (Object)aggregatedStatusInCall);
                sliver2.setStatus(new StatusDetails(aggregatedStatusInCall));
                mentionedSliverUrns.add(sliver2.getUrn());
            }
            List list = slice.findSlivers(auth).stream().filter(sliver -> !mentionedSliverUrns.contains(sliver.getUrn())).filter(sliver -> sliver.getSource() == Sliver.Source.SLICE_AUTHORITY).collect(Collectors.toList());
            if (!list.isEmpty()) {
                LOG.trace("The following slivers were not mentioned in the SliverInfo of {}: {}", (Object)auth.getName(), (Object)list.stream().map(Sliver::getUrnString).collect(Collectors.joining(", ")));
            } else {
                LOG.trace("No unmentioned slivers in SliverInfo for authority {}", (Object)auth);
            }
            for (Sliver notMentionedSliver : list) {
                this.getModel().logNotExistSliver(sliceUrn, notMentionedSliver.getUrnString(), Sliver.Source.AGGREGATE_MANAGER_STATUS);
            }
        }
        catch (GeniUrn.GeniUrnParseException ex) {
            LOG.error("Failed to remove unnecessary slivers from model", (Throwable)ex);
        }
    }

    public static StatusDetails sliverInfoToSliverStatus(AggregateManager3.SliverInfo si) {
        StatusDetails.SliverStatus s = AMv3Wrapper.getGlobalSliverStatus((AggregateManager3.SliverInfo)si);
        StatusDetails statusDetails = new StatusDetails(s);
        statusDetails.addSliverStatus(si.getSliverUrn(), s);
        if (si.getError() != null && !si.getError().isEmpty()) {
            statusDetails.addError(new ErrorDetails(si.getError(), si.getSliverUrn()));
        }
        if (si.getExpires() != null) {
            try {
                statusDetails.addKnownExpires(si.getExpiresDate());
            }
            catch (ParseException e) {
                LOG.debug("Failed to parse sliver info expires date: " + si.getExpires());
            }
        }
        return statusDetails;
    }

    public void onAllocateAndProvisionInfoResult(Integer serverId, String sliceUrn, AggregateManager3.AllocateAndProvisionInfo info, boolean ignoreOperationalStatus) {
        this.onListOfSliverInfoResult(serverId, sliceUrn, info.getSliverInfo(), ignoreOperationalStatus);
    }

    public void onManifestInfo(Integer serverId, AggregateManager3.ManifestInfo manifestInfo) {
        Server auth = this.sfaModel.getTestbedInfoSource().getServerById(serverId);
        assert (manifestInfo != null);
        assert (manifestInfo.getSliceUrn() != null);
        assert (manifestInfo.getSliverInfos() != null);
        assert (manifestInfo.getManifestRspec() != null);
        if (manifestInfo.getSliverInfos().isEmpty()) {
            LOG.warn("Got a ManifestInfo with empty SliverInfos!");
        }
        List<String> sliverUrns = this.getSliverUrnsFromSliverInfo(manifestInfo.getSliverInfos());
        this.seeManifestRspec(serverId, manifestInfo.getSliceUrn(), sliverUrns, manifestInfo.getManifestRspec());
        this.onListOfSliverInfoResult(serverId, manifestInfo.getSliceUrn(), manifestInfo.getSliverInfos(), false);
    }

    public void seeAdvertisementRspec(Integer serverId, boolean available, String rspec) {
        Server server = this.sfaModel.getTestbedInfoSource().getServerById(serverId);
        this.getModel().setAdvertisementRspec(server, available, rspec);
    }

    public void seeManifestRspec(@Nonnull Integer serverId, @Nonnull String sliceUrnStr, @Nonnull List<String> sliverUrns, @Nonnull String manifestRspecString) {
        Server auth = this.sfaModel.getTestbedInfoSource().getServerById(serverId);
        Slice slice = null;
        try {
            slice = this.getModel().getSlice(sliceUrnStr);
        }
        catch (GeniUrn.GeniUrnParseException e) {
            LOG.error("Could not get slice because of an invalid urn {}", (Object)sliceUrnStr);
        }
        if (slice == null) {
            LOG.warn("Could not find slice with URN {}, while seeing a Manifest from authority {}", (Object)sliceUrnStr, (Object)auth.getDefaultComponentManagerUrn());
            return;
        }
        GeniUrn sliceUrn = GeniUrn.parse((String)sliceUrnStr);
        assert (sliceUrn != null);
        List<Sliver> manifestSlivers = this.findSliversInManifest(auth, sliceUrn, new ManifestRspecSource(manifestRspecString, ModelRspecType.FX));
        ArrayList<Sliver> sliverList = new ArrayList<Sliver>();
        for (String sliverUrn : sliverUrns) {
            try {
                Sliver sliver = this.getModel().logExistSliver(sliceUrnStr, sliverUrn, auth, Sliver.Source.AGGREGATE_MANAGER_STATUS);
                sliverList.add(sliver);
            }
            catch (GeniUrn.GeniUrnParseException e) {
                LOG.error("Could not process the invalid sliver-urn {}", (Object)sliverUrn, (Object)e);
            }
        }
        for (Sliver manifestSliver : manifestSlivers) {
            boolean isKnown = false;
            for (String sliverUrn : sliverUrns) {
                if (!sliverUrn.equals(manifestSliver.getUrnString())) continue;
                isKnown = true;
            }
            if (isKnown) continue;
            sliverList.add(manifestSliver);
        }
        if (manifestRspecString.contains("component_manager_id=\"urn:publicid:IDN+ple+authority+cm\"")) {
            LOG.warn("Using PLE hack in SfaModelAggregateManager2Listener#seeManifestRspec. successfully applied: " + !(manifestRspecString = manifestRspecString.replaceAll(Pattern.quote("urn:publicid:IDN+ple+authority+cm"), Matcher.quoteReplacement("urn:publicid:IDN+ple:ibbtple+authority+cm"))).contains("component_manager_id=\"urn:publicid:IDN+ple+authority+cm\""));
            assert (!manifestRspecString.contains("component_manager_id=\"urn:publicid:IDN+ple+authority+cm\"")) : "HACK applied unsuccessfully to:\n" + manifestRspecString;
        }
        ManifestRspecSource manifestRspec = new ManifestRspecSource(manifestRspecString, ModelRspecType.FX);
        for (Sliver sliver : sliverList) {
            LOG.debug("SfaModelAggregateManager2Listener seeManifestRspec is setting manifest for " + slice + " -> " + sliceUrnStr + "  " + sliver + " -> " + sliver.getUrn());
            sliver.setManifestRspec(manifestRspec);
        }
    }

    public void onResult(ApiCallDetails details) {
        assert (Platform.isFxApplicationThread());
        this.onResultInJavaFXThread(details);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onResultInJavaFXThread(ApiCallDetails details) {
        if (details.getReply() == null || details.getJavaMethodName() == null) {
            return;
        }
        if (!Objects.equals(details.getApiName(), AggregateManager3.getApiName())) {
            return;
        }
        LOG.debug("SfaModelAggregateManager3Listener onResultInJavaFXThread API=" + details.getApiName() + " SfaCommand=\"" + details.getGeniMethodName() + "\" javaCommand=\"" + details.getJavaMethodName() + "\"");
        try {
            String sliceUrn;
            List<String> sliceUrns;
            AggregateManager3.AllocateAndProvisionInfo info;
            if (Objects.equals(details.getJavaMethodName(), "getVersion")) {
                this.onGetVersionResult(details);
            }
            if (Objects.equals(details.getJavaMethodName(), "listResources") && details.getReply().getGeniResponseCode().isSuccess()) {
                String rspec = (String)details.getReply().getValue();
                boolean available = false;
                if (details.getMethodParameters().get("available") != null) {
                    available = (Boolean)details.getMethodParameters().get("available");
                }
                this.seeAdvertisementRspec(details.getServerId(), available, rspec);
            }
            if (Objects.equals(details.getJavaMethodName(), "describe") && details.getReply().getGeniResponseCode().isSuccess()) {
                this.onManifestInfo(details.getServerId(), (AggregateManager3.ManifestInfo)details.getReply().getValue());
            }
            if (Objects.equals(details.getJavaMethodName(), "allocate") && details.getReply().getGeniResponseCode().isSuccess()) {
                info = (AggregateManager3.AllocateAndProvisionInfo)details.getReply().getValue();
                String sliceUrn2 = (String)details.getMethodParameters().get("sliceUrn");
                this.getModel().logExistSlice(sliceUrn2);
                List<String> sliverUrns = this.getSliverUrnsFromSliverInfo(info.getSliverInfo());
                this.onAllocateAndProvisionInfoResult(details.getServerId(), sliceUrn2, info, false);
            }
            if (Objects.equals(details.getJavaMethodName(), "provision") && details.getReply().getGeniResponseCode().isSuccess()) {
                info = (AggregateManager3.AllocateAndProvisionInfo)details.getReply().getValue();
                List urns = (List)details.getMethodParameters().get("urns");
                sliceUrns = this.getSliceUrns(urns);
                String string = sliceUrn = sliceUrns.size() != 1 ? null : sliceUrns.get(0);
                if (sliceUrn != null) {
                    this.getModel().logExistSlice(sliceUrn);
                }
                List<String> sliverUrns = this.getSliverUrnsFromSliverInfo(info.getSliverInfo());
                this.seeManifestRspec(details.getServerId(), sliceUrn, sliverUrns, info.getRspec());
                Server server = this.sfaModel.getTestbedInfoSource().getServerById(details.getServerId());
                boolean ignoreOperationalStatus = server.hasFlag(Server.Flag.workaroundIgnoreProvisionOperationalStatus);
                this.onAllocateAndProvisionInfoResult(details.getServerId(), sliceUrn, info, ignoreOperationalStatus);
            }
            if (Objects.equals(details.getJavaMethodName(), "status") && details.getReply().getGeniResponseCode().isSuccess()) {
                this.onStatusResult(details.getServerId(), (AggregateManager3.StatusInfo)details.getReply().getValue());
            }
            if ((Objects.equals(details.getJavaMethodName(), "performOperationalAction") || Objects.equals(details.getJavaMethodName(), "delete") || Objects.equals(details.getJavaMethodName(), "renew")) && details.getReply().getGeniResponseCode().isSuccess()) {
                List si = (List)details.getReply().getValue();
                List urns = (List)details.getMethodParameters().get("urns");
                sliceUrns = this.getSliceUrns(urns);
                sliceUrn = sliceUrns.size() != 1 ? null : sliceUrns.get(0);
                this.onListOfSliverInfoResult(details.getServerId(), sliceUrn, si, false);
            }
            if (!Objects.equals(details.getJavaMethodName(), "shutdown")) return;
        }
        catch (Exception e) {
            LOG.warn("WARNING: Exception when processing AggregateManager3 reply for SfaModel. This will be ignored, but it is most likely a bug. " + e.getMessage(), (Throwable)e);
        }
    }
}

