/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.model;

import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserWithSpeaksFor;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.RspecFactory;
import be.iminds.ilabt.jfed.rspec.parser.RspecParseException;
import be.iminds.ilabt.jfed.rspec.parser.StaxRspecParser;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecFactory;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyListProperty;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSpecHelper {
    private static final Logger LOG = LoggerFactory.getLogger(UserSpecHelper.class);

    public static List<UserSpec> getUserUserSpecList(GeniUser geniUser) {
        ArrayList<UserSpec> userSpecs = new ArrayList<UserSpec>();
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(KeyUtil.publicKeyToOpenSshAuthorizedKeysFormat((PublicKey)geniUser.getPublicKey()));
        UserSpec user = new UserSpec(geniUser.getUserUrnString(), keys);
        userSpecs.add(user);
        return userSpecs;
    }

    public static List<UserSpec> getUserUserSpecList(GeniUserProvider geniUserProvider, SfaModel sfaModel) {
        ArrayList<UserSpec> userSpecs = new ArrayList<UserSpec>();
        UserSpec user = UserSpecHelper.getUserUserSpec(geniUserProvider, sfaModel);
        if (user.getSshKey().isEmpty()) {
            GeniUserWithSpeaksFor geniUserWithSpeaksFor;
            GeniUser geniUser = geniUserProvider.getLoggedInGeniUser();
            GeniUserWithSpeaksFor geniUserWithSpeaksFor2 = geniUserWithSpeaksFor = geniUser instanceof GeniUserWithSpeaksFor ? (GeniUserWithSpeaksFor)geniUser : null;
            if (geniUserWithSpeaksFor != null) {
                user.getSshKey().add(KeyUtil.publicKeyToOpenSshAuthorizedKeysFormat((PublicKey)geniUserWithSpeaksFor.getSpeaksForUserPublicKey()));
            } else {
                user.getSshKey().add(KeyUtil.publicKeyToOpenSshAuthorizedKeysFormat((PublicKey)geniUserProvider.getLoggedInGeniUser().getPublicKey()));
            }
        }
        userSpecs.add(user);
        return userSpecs;
    }

    public static UserSpec getUserUserSpec(GeniUserProvider geniUserProvider, SfaModel sfaModel) {
        GeniUserWithSpeaksFor geniUserWithSpeaksFor;
        GeniUser geniUser = geniUserProvider.getLoggedInGeniUser();
        GeniUserWithSpeaksFor geniUserWithSpeaksFor2 = geniUserWithSpeaksFor = geniUser instanceof GeniUserWithSpeaksFor ? (GeniUserWithSpeaksFor)geniUser : null;
        if (geniUserWithSpeaksFor != null) {
            return new UserSpec(geniUserWithSpeaksFor.getSpeaksForUrn().toString(), sfaModel.getUserKeys(geniUserWithSpeaksFor.getSpeaksForUrn()));
        }
        return new UserSpec(geniUser.getUserUrnString(), sfaModel.getUserKeys(geniUser.getUserUrn()));
    }

    public static List<UserSpec> getUserSpecFromRspecExt(String rspec) {
        try {
            ModelRspec modelRspec = new StaxRspecParser(rspec, (RspecFactory)FXRspecFactory.getInstance()).call();
            LOG.debug("getUserSpecFromRspecExt model with reconstructed modelRspec.getSshKeys().size()=" + modelRspec.getSshKeys().size());
            return new ArrayList<UserSpec>(modelRspec.getSshKeys());
        }
        catch (RspecParseException e) {
            LOG.debug("getUserSpecFromRspecExt error parsing", (Throwable)e);
            return new ArrayList<UserSpec>();
        }
    }

    public static List<UserSpec> getUserSpecFromRspecExt(ModelRspec modelRspec) {
        LOG.debug("getUserSpecFromRspecExt model with modelRspec.getSshKeys().size()=" + modelRspec.getSshKeys().size());
        return new ArrayList<UserSpec>(modelRspec.getSshKeys());
    }

    public static List<UserSpec> getMergedUserSpecs(GeniUserProvider geniUserProvider, SfaModel sfaModel, String rspec) {
        return UserSpecHelper.getMergedUserSpecs(geniUserProvider, sfaModel, UserSpecHelper.getUserSpecFromRspecExt(rspec));
    }

    public static List<UserSpec> getMergedUserSpecs(GeniUserProvider geniUserProvider, SfaModel sfaModel, ModelRspec modelRspec) {
        return UserSpecHelper.getMergedUserSpecs(geniUserProvider, sfaModel, UserSpecHelper.getUserSpecFromRspecExt(modelRspec));
    }

    private static List<UserSpec> getMergedUserSpecs(GeniUserProvider geniUserProvider, SfaModel sfaModel, List<UserSpec> rspecUserSpecs) {
        List<UserSpec> userUserSpecs = UserSpecHelper.getUserUserSpecList(geniUserProvider, sfaModel);
        HashMap<String, UserSpec> userToSpec = new HashMap<String, UserSpec>();
        for (UserSpec u : userUserSpecs) {
            userToSpec.put(u.getUrn(), u);
        }
        Set userSpecUsers = userToSpec.keySet();
        LOG.debug("userUserSpecs=" + userUserSpecs);
        LOG.debug("rspecUserSpecs=" + rspecUserSpecs);
        HashSet<String> rspecUsers = new HashSet<String>();
        ArrayList<UserSpec> res = new ArrayList<UserSpec>();
        for (UserSpec rspecUserSpec : rspecUserSpecs) {
            boolean defaultUser;
            boolean bl = defaultUser = rspecUserSpec.getUrn() == null || rspecUserSpec.getUrn().trim().isEmpty();
            if (defaultUser || userSpecUsers.contains(rspecUserSpec.getUrn())) {
                String rspecUserSpecUrn;
                assert (!userSpecUsers.isEmpty());
                String string = rspecUserSpecUrn = defaultUser ? (String)userSpecUsers.iterator().next() : rspecUserSpec.getUrn();
                assert (rspecUserSpecUrn != null);
                UserSpec userSpecFromUser = (UserSpec)userToSpec.get(rspecUserSpecUrn);
                HashSet allKeys = new HashSet(userSpecFromUser.getSshKey());
                allKeys.addAll(rspecUserSpec.getSshKey());
                res.add(new UserSpec(rspecUserSpecUrn, allKeys));
                rspecUsers.add(rspecUserSpecUrn);
                continue;
            }
            res.add(rspecUserSpec);
            rspecUsers.add(rspecUserSpec.getUrn());
        }
        userSpecUsers.removeAll(rspecUsers);
        res.addAll(userSpecUsers.stream().map(userToSpec::get).collect(Collectors.toList()));
        return res;
    }

    public static List<UserSpec> getProjectMemberUserSpecs(String projectName, SfaModel sfaModel) {
        ArrayList<UserSpec> res = new ArrayList<UserSpec>();
        ReadOnlyListProperty<GeniUrn> userUrns = sfaModel.getUsersBySubAuthority(projectName);
        for (GeniUrn userUrn : userUrns) {
            Collection<String> keys = sfaModel.getUserKeys(userUrn);
            res.add(new UserSpec(userUrn.toString(), keys));
        }
        return res;
    }

    public static List<UserSpec> getSliceMemberUserSpecs(@Nonnull GeniUrn sliceUrn, @Nonnull SfaModel sfaModel) {
        ArrayList<UserSpec> res = new ArrayList<UserSpec>();
        Slice slice = sfaModel.getSlice(sliceUrn);
        if (slice == null) {
            return Collections.emptyList();
        }
        Collection<GeniUrn> userUrns = slice.getUsers();
        for (GeniUrn userUrn : userUrns) {
            Collection<String> keys = sfaModel.getUserKeys(userUrn);
            res.add(new UserSpec(userUrn.toString(), keys));
        }
        return res;
    }

    public static List<UserSpec> mergeUserSpecs(@Nullable Collection<UserSpec> a, @Nullable Collection<UserSpec> b) {
        HashMultimap userSpecMap = HashMultimap.create();
        if (a != null) {
            UserSpecHelper.addAndMergeUserSpecMap((Multimap<String, String>)userSpecMap, a);
        }
        if (b != null) {
            UserSpecHelper.addAndMergeUserSpecMap((Multimap<String, String>)userSpecMap, b);
        }
        return new ArrayList<UserSpec>(userSpecMap.asMap().entrySet().stream().map(userSpec -> new UserSpec((String)userSpec.getKey(), (Collection)userSpec.getValue())).collect(Collectors.toList()));
    }

    public static List<UserSpec> addUserSpec(Collection<UserSpec> userSpecs, UserSpec userSpec) {
        return UserSpecHelper.mergeUserSpecs(userSpecs, Collections.singleton(userSpec));
    }

    private static void addAndMergeUserSpecMap(Multimap<String, String> target, Collection<UserSpec> input) {
        for (UserSpec userSpec : input) {
            for (String key : userSpec.getSshKey()) {
                target.put((Object)userSpec.getUrn(), (Object)UserSpecHelper.trimSshKey(key));
            }
        }
    }

    public static String trimSshKey(String input) {
        return input.replace("\n", "").replace("\r", "").trim();
    }
}

