/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.stitcher;

import be.iminds.ilabt.jfed.lowlevel.stitching.StitchingCallData;
import be.iminds.ilabt.jfed.lowlevel.stitching.VlanRange;
import be.iminds.ilabt.jfed.lowlevel.stitching.info.Hop;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;

public class HopInfo {
    private final String linkName;
    private final String authUrn;
    private final String hopUrn;
    private final boolean importsVlans;
    final List<HopInfo> dependsOn = new ArrayList<HopInfo>();
    final List<HopInfo> dependingOnThis = new ArrayList<HopInfo>();
    private final ObjectProperty<StitchingCallData.State> authState = new SimpleObjectProperty();
    private final ObjectProperty<VlanRange> availableVlans = new SimpleObjectProperty();
    private final ObjectProperty<VlanRange> unavailableVlans = new SimpleObjectProperty();
    private final IntegerProperty suggestedVlan = new SimpleIntegerProperty();
    private final IntegerProperty confirmedVlan = new SimpleIntegerProperty();

    public HopInfo(Hop hop) {
        this.linkName = hop.getLinkName();
        this.authUrn = hop.getAuthUrn();
        this.hopUrn = hop.getHopUrn();
        this.importsVlans = hop.isImportsVlans();
        this.update(hop);
    }

    public void update(Hop hop) {
        this.authState.set((Object)hop.getAuthState());
        this.availableVlans.set((Object)hop.getAvailableVlans());
        this.unavailableVlans.set((Object)hop.getUnavailableVlans());
        this.suggestedVlan.set(hop.getSuggestedVlan() == null ? -1 : hop.getSuggestedVlan());
        this.confirmedVlan.set(hop.getConfirmedVlan() == null ? -1 : hop.getConfirmedVlan());
    }

    public String getLinkName() {
        return this.linkName;
    }

    public String getAuthUrn() {
        return this.authUrn;
    }

    public String getHopUrn() {
        return this.hopUrn;
    }

    public boolean isImportsVlans() {
        return this.importsVlans;
    }

    public List<HopInfo> getDependsOn() {
        return this.dependsOn;
    }

    public List<HopInfo> getDependingOnThis() {
        return this.dependingOnThis;
    }

    public StitchingCallData.State getAuthState() {
        return (StitchingCallData.State)this.authState.get();
    }

    public ObjectProperty<StitchingCallData.State> authStateProperty() {
        return this.authState;
    }

    public VlanRange getAvailableVlans() {
        return (VlanRange)this.availableVlans.get();
    }

    public ObjectProperty<VlanRange> availableVlansProperty() {
        return this.availableVlans;
    }

    public VlanRange getUnavailableVlans() {
        return (VlanRange)this.unavailableVlans.get();
    }

    public ObjectProperty<VlanRange> unavailableVlansProperty() {
        return this.unavailableVlans;
    }

    public int getSuggestedVlan() {
        return this.suggestedVlan.get();
    }

    public IntegerProperty suggestedVlanProperty() {
        return this.suggestedVlan;
    }

    public int getConfirmedVlan() {
        return this.confirmedVlan.get();
    }

    public IntegerProperty confirmedVlanProperty() {
        return this.confirmedVlan;
    }
}

