/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.client.LastResultFilter;
import be.iminds.ilabt.jfed.fedmon.webapi.client.TestInstanceFilter;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedmonResultsTask
extends Task {
    private static final Logger LOG = LoggerFactory.getLogger(FedmonResultsTask.class);
    private static final String FEDMON_URN = "urn:publicid:IDN+flsmonitor.fed4fire.eu+authority+cm";
    @Nullable
    public final String testbedFilter;
    @Nullable
    public final String testbedUrnFilter;
    @Nullable
    public final String testDefinitionFilter;
    public List<Result> results = null;
    @Nonnull
    private final JavaFXLogger logger;
    @Nonnull
    private final GeniUserProvider geniUserProvider;
    @Nonnull
    private final JFedPreferences jFedPreferences;
    @Nonnull
    private final TestbedInfoSource testbedInfoSource;
    @Nonnull
    private final JFedConnectionProvider connectionProvider;
    @Nonnull
    private final FedmonWebApiClient fedmonWebApiClient;

    public FedmonResultsTask(@Nullable String testbedFilter, @Nullable String testbedUrnFilter, @Nullable String testDefinitionFilter, @Nonnull JavaFXLogger logger, @Nonnull GeniUserProvider geniUserProvider, @Nonnull JFedPreferences jFedPreferences, @Nonnull TestbedInfoSource testbedInfoSource, @Nonnull JFedConnectionProvider connectionProvider, @Nonnull FedmonWebApiClient fedmonWebApiClient) {
        super("Get Fedmon Results");
        this.testbedFilter = testbedFilter;
        this.testbedUrnFilter = testbedUrnFilter;
        this.testDefinitionFilter = testDefinitionFilter;
        this.logger = logger;
        this.geniUserProvider = geniUserProvider;
        this.jFedPreferences = jFedPreferences;
        this.testbedInfoSource = testbedInfoSource;
        this.connectionProvider = connectionProvider;
        this.fedmonWebApiClient = fedmonWebApiClient;
    }

    @Override
    protected void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        Server fedmonAuth = this.testbedInfoSource.getByUrnExact(FEDMON_URN);
        TestInstanceFilter testInstanceFilter = new TestInstanceFilter(null, null, this.testDefinitionFilter, null, null, null, this.testbedFilter, this.testbedUrnFilter, Optional.of(false));
        LastResultFilter filter = new LastResultFilter(testInstanceFilter, true, Optional.empty(), null);
        try {
            this.results = this.fedmonWebApiClient.search((FedmonWebApiClient.FedmonFilter)filter);
            LOG.debug("Found {} fedmon results", (Object)this.results.size());
        }
        catch (FedmonWebApiClient.FedmonWebApiClientException e) {
            this.results = Collections.emptyList();
            throw new JFedException("Failed to fetch fedmon results", (Throwable)e);
        }
    }

    public List<Result> getResults() {
        return this.results;
    }

    public List<Result> getSuccessResults() {
        if (this.results != null) {
            return this.results.stream().filter(r -> r.getSummaryStatus() == Result.ResultStatus.SUCCESS).collect(Collectors.toList());
        }
        return null;
    }
}

