/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public final class GetAdvertisementTask
extends Task {
    private final Server auth;
    private final boolean available;
    private String advertisementRspecString;
    private final UserAndSliceApiWrapper userAndSliceApiWrapper;
    private final AggregateManagerWrapperFactory aggregateManagerWrapperFactory;
    private final HighLevelTaskFactory highLevelTaskFactory;

    private GetAdvertisementTask(Server auth, boolean available, UserAndSliceApiWrapper userAndSliceApiWrapper, AggregateManagerWrapperFactory aggregateManagerWrapperFactory, HighLevelTaskFactory highLevelTaskFactory) {
        super("Fetch Advertisement RSpec on " + auth.getName() + " (" + (available ? "available)" : "all)"));
        this.auth = auth;
        this.available = available;
        this.userAndSliceApiWrapper = userAndSliceApiWrapper;
        this.aggregateManagerWrapperFactory = aggregateManagerWrapperFactory;
        this.highLevelTaskFactory = highLevelTaskFactory;
    }

    public static GetAdvertisementTask createFetchAllAdvertisementTask(Server auth, UserAndSliceApiWrapper userAndSliceApiWrapper, AggregateManagerWrapperFactory aggregateManagerWrapperFactory, HighLevelTaskFactory highLevelTaskFactory) {
        return new GetAdvertisementTask(auth, false, userAndSliceApiWrapper, aggregateManagerWrapperFactory, highLevelTaskFactory);
    }

    public static GetAdvertisementTask createFetchAvailableAdvertisementTask(Server auth, UserAndSliceApiWrapper userAndSliceApiWrapper, AggregateManagerWrapperFactory aggregateManagerWrapperFactory, HighLevelTaskFactory highLevelTaskFactory) {
        return new GetAdvertisementTask(auth, true, userAndSliceApiWrapper, aggregateManagerWrapperFactory, highLevelTaskFactory);
    }

    @Override
    public void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        AggregateManagerWrapper amWrapper = this.aggregateManagerWrapperFactory.getAggregateManagerWrapper(taskExecution, this.auth);
        if (!this.userAndSliceApiWrapper.hasUserCredentials()) {
            throw new JFedException("UserAndSliceApiWrapper did not have user Credentials.");
        }
        this.advertisementRspecString = amWrapper.listResources(this.userAndSliceApiWrapper.getCachedUserCredentialsForAM(), this.available);
        if (this.advertisementRspecString == null) {
            throw new JFedHighLevelException("Got null when asked " + this.auth.getDefaultComponentManagerUrn() + " for advertisement.");
        }
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        return Collections.singletonList(this.highLevelTaskFactory.getUserCredential());
    }

    public String getAdvertisementRspecString() {
        return this.advertisementRspecString;
    }
}

