/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.highlevel.tasks.AggregatesForSliceTask;
import be.iminds.ilabt.jfed.highlevel.tasks.AllocateSliverTask;
import be.iminds.ilabt.jfed.highlevel.tasks.CacheablePairTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.CacheableTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.CreateImageTask;
import be.iminds.ilabt.jfed.highlevel.tasks.CreateSliceTask;
import be.iminds.ilabt.jfed.highlevel.tasks.CreateSliverTask;
import be.iminds.ilabt.jfed.highlevel.tasks.DeleteImageTask;
import be.iminds.ilabt.jfed.highlevel.tasks.DeleteSliversAtAuthorityTask;
import be.iminds.ilabt.jfed.highlevel.tasks.EditSSHKeysTask;
import be.iminds.ilabt.jfed.highlevel.tasks.EmulabRegistryTask;
import be.iminds.ilabt.jfed.highlevel.tasks.FedmonResultsTask;
import be.iminds.ilabt.jfed.highlevel.tasks.GetAdvertisementTask;
import be.iminds.ilabt.jfed.highlevel.tasks.GetSubAuthorityDetailsTask;
import be.iminds.ilabt.jfed.highlevel.tasks.GetVersionTask;
import be.iminds.ilabt.jfed.highlevel.tasks.ListDiskImagesTask;
import be.iminds.ilabt.jfed.highlevel.tasks.ListPendingReputationQuestionnairesTask;
import be.iminds.ilabt.jfed.highlevel.tasks.ListSliceMembersTask;
import be.iminds.ilabt.jfed.highlevel.tasks.ListSliceResourcesTask;
import be.iminds.ilabt.jfed.highlevel.tasks.ListSlicesTask;
import be.iminds.ilabt.jfed.highlevel.tasks.ListSubAuthoritiesTask;
import be.iminds.ilabt.jfed.highlevel.tasks.ListSubAuthorityMembersTask;
import be.iminds.ilabt.jfed.highlevel.tasks.OpenConsoleTask;
import be.iminds.ilabt.jfed.highlevel.tasks.OtherUserSshKeysTask;
import be.iminds.ilabt.jfed.highlevel.tasks.ProjectMemberSshKeysTask;
import be.iminds.ilabt.jfed.highlevel.tasks.ProvisionSliverTask;
import be.iminds.ilabt.jfed.highlevel.tasks.RecoverSliceTask;
import be.iminds.ilabt.jfed.highlevel.tasks.RecoverSliceTaskInteraction;
import be.iminds.ilabt.jfed.highlevel.tasks.RegisterOrUpdateSliversTask;
import be.iminds.ilabt.jfed.highlevel.tasks.RegisterReputationTask;
import be.iminds.ilabt.jfed.highlevel.tasks.RegisterSliceRspecTask;
import be.iminds.ilabt.jfed.highlevel.tasks.RegisterSliversToSLACollectorTask;
import be.iminds.ilabt.jfed.highlevel.tasks.RegisterStopToSLACollectorTask;
import be.iminds.ilabt.jfed.highlevel.tasks.ReloadOSTask;
import be.iminds.ilabt.jfed.highlevel.tasks.RenewSliceTask;
import be.iminds.ilabt.jfed.highlevel.tasks.RenewSliversTask;
import be.iminds.ilabt.jfed.highlevel.tasks.RequestSlaUuidTask;
import be.iminds.ilabt.jfed.highlevel.tasks.ResolveUserAndSlicesTask;
import be.iminds.ilabt.jfed.highlevel.tasks.RestartTask;
import be.iminds.ilabt.jfed.highlevel.tasks.SCSRequestTask;
import be.iminds.ilabt.jfed.highlevel.tasks.ShareLanTask;
import be.iminds.ilabt.jfed.highlevel.tasks.ShareSliceTask;
import be.iminds.ilabt.jfed.highlevel.tasks.SliceAuthorityTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.SliceCredentialTask;
import be.iminds.ilabt.jfed.highlevel.tasks.SliceManifestForAuthorityTask;
import be.iminds.ilabt.jfed.highlevel.tasks.SliceMembersSshKeysTask;
import be.iminds.ilabt.jfed.highlevel.tasks.SliverManifestTask;
import be.iminds.ilabt.jfed.highlevel.tasks.SliverStatusTask;
import be.iminds.ilabt.jfed.highlevel.tasks.StartTask;
import be.iminds.ilabt.jfed.highlevel.tasks.StatusTask;
import be.iminds.ilabt.jfed.highlevel.tasks.UnregisterSliversTask;
import be.iminds.ilabt.jfed.highlevel.tasks.UnshareLanTask;
import be.iminds.ilabt.jfed.highlevel.tasks.UnshareSliceTask;
import be.iminds.ilabt.jfed.highlevel.tasks.UserAuthorityGetVersionTask;
import be.iminds.ilabt.jfed.highlevel.tasks.UserCredentialTask;
import be.iminds.ilabt.jfed.highlevel.tasks.UserSshKeysTask;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.highlevel.util.SliceRegistryUtil;
import be.iminds.ilabt.jfed.log.ResultListener;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HighLevelTaskFactory
implements SliceAuthorityTaskFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HighLevelTaskFactory.class);
    protected final UserAndSliceApiWrapper userAndSliceApiWrapper;
    protected final AggregateManagerWrapperFactory aggregateManagerWrapperFactory;
    protected final JavaFXLogger logger;
    protected final GeniUserProvider geniUserProvider;
    protected final SfaModel sfaModel;
    protected final TaskThread tt;
    protected final JFedPreferences jFedPreferences;
    protected final TestbedInfoSource testbedInfoSource;
    protected final JFedConnectionProvider connectionProvider;
    protected final FedmonWebApiClient fedmonWebApiClient;
    protected final AuthorityFinder authorityFinder;
    private final SliceRegistryUtil sliceRegistryUtil;
    private UserCredentialTask userCredentialTask = null;
    private ListSlicesTask listSlicesTask = null;
    private ListSubAuthoritiesTask listSubAuthoritiesTask = null;
    private ResolveUserAndSlicesTask resolveUserAndSlicesTask = null;
    private UserAuthorityGetVersionTask userAuthorityGetVersionTask = null;
    private final CacheableTaskFactory<Server, GetVersionTask> getVersionTaskFactory = new CacheableTaskFactory<Server, GetVersionTask>(){

        @Override
        @Nonnull
        protected GetVersionTask createNewTask(@Nonnull Server auth) {
            return new GetVersionTask(auth, HighLevelTaskFactory.this.aggregateManagerWrapperFactory);
        }
    };
    private final CacheableTaskFactory<Server, GetAdvertisementTask> getAllAdvertisementTaskFactory = new CacheableTaskFactory<Server, GetAdvertisementTask>(){

        @Override
        @Nonnull
        protected GetAdvertisementTask createNewTask(@Nonnull Server auth) {
            return GetAdvertisementTask.createFetchAllAdvertisementTask(auth, HighLevelTaskFactory.this.userAndSliceApiWrapper, HighLevelTaskFactory.this.aggregateManagerWrapperFactory, HighLevelTaskFactory.this);
        }
    };
    private final CacheableTaskFactory<Server, GetAdvertisementTask> getAvailableAdvertisementTaskFactory = new CacheableTaskFactory<Server, GetAdvertisementTask>(){

        @Override
        @Nonnull
        protected GetAdvertisementTask createNewTask(@Nonnull Server auth) {
            return GetAdvertisementTask.createFetchAvailableAdvertisementTask(auth, HighLevelTaskFactory.this.userAndSliceApiWrapper, HighLevelTaskFactory.this.aggregateManagerWrapperFactory, HighLevelTaskFactory.this);
        }
    };
    private final CacheablePairTaskFactory<String, String, FedmonResultsTask> fedmonResultsTaskFactory = new CacheablePairTaskFactory<String, String, FedmonResultsTask>(){

        @Override
        protected FedmonResultsTask createNewTask(@Nonnull String testbedUrnFilter, @Nonnull String testDefinitionFilter) {
            return new FedmonResultsTask(null, testbedUrnFilter, testDefinitionFilter, HighLevelTaskFactory.this.logger, HighLevelTaskFactory.this.geniUserProvider, HighLevelTaskFactory.this.jFedPreferences, HighLevelTaskFactory.this.testbedInfoSource, HighLevelTaskFactory.this.connectionProvider, HighLevelTaskFactory.this.fedmonWebApiClient);
        }
    };
    private final CacheableTaskFactory<Slice, SliceCredentialTask> sliceCredentialTaskFactory = new CacheableTaskFactory<Slice, SliceCredentialTask>(){

        @Override
        @Nonnull
        protected SliceCredentialTask createNewTask(@Nonnull Slice slice) {
            return new SliceCredentialTask(slice, HighLevelTaskFactory.this.userAndSliceApiWrapper, HighLevelTaskFactory.this.logger, HighLevelTaskFactory.this);
        }
    };
    private final CacheablePairTaskFactory<Slice, Server, SliceManifestForAuthorityTask> sliceManifestForAuthorityFactory = new CacheablePairTaskFactory<Slice, Server, SliceManifestForAuthorityTask>(){

        @Override
        protected SliceManifestForAuthorityTask createNewTask(@Nonnull Slice slice, @Nonnull Server authority) {
            return new SliceManifestForAuthorityTask(slice, authority, HighLevelTaskFactory.this.aggregateManagerWrapperFactory, HighLevelTaskFactory.this);
        }
    };
    private final CacheableTaskFactory<Slice, AggregatesForSliceTask> aggregatesForSliceTaskFactory = new CacheableTaskFactory<Slice, AggregatesForSliceTask>(){

        @Override
        @Nonnull
        protected AggregatesForSliceTask createNewTask(@Nonnull Slice slice) {
            return new AggregatesForSliceTask(slice, HighLevelTaskFactory.this.userAndSliceApiWrapper, HighLevelTaskFactory.this.logger, HighLevelTaskFactory.this);
        }
    };
    private final CacheableTaskFactory<Sliver, SliverManifestTask> sliverManifestTaskFactory = new CacheableTaskFactory<Sliver, SliverManifestTask>(){

        @Override
        @Nonnull
        protected SliverManifestTask createNewTask(@Nonnull Sliver sliver) {
            return new SliverManifestTask(sliver, HighLevelTaskFactory.this.aggregateManagerWrapperFactory, HighLevelTaskFactory.this);
        }
    };
    private final CacheableTaskFactory<Sliver, SliverStatusTask> sliverStatusTaskFactory = new CacheableTaskFactory<Sliver, SliverStatusTask>(){

        @Override
        @Nonnull
        protected SliverStatusTask createNewTask(@Nonnull Sliver sliver) {
            return new SliverStatusTask(sliver, HighLevelTaskFactory.this.aggregateManagerWrapperFactory, HighLevelTaskFactory.this);
        }
    };
    private final CacheablePairTaskFactory<Slice, Server, StatusTask> statusFactory = new CacheablePairTaskFactory<Slice, Server, StatusTask>(){

        @Override
        protected StatusTask createNewTask(@Nonnull Slice slice, @Nonnull Server authority) {
            return new StatusTask(authority, slice, HighLevelTaskFactory.this.aggregateManagerWrapperFactory, HighLevelTaskFactory.this);
        }
    };
    private UserSshKeysTask userSshKeysTask = null;
    private final CacheableTaskFactory<String, ProjectMemberSshKeysTask> projectMemberSshKeysTaskFactory = new CacheableTaskFactory<String, ProjectMemberSshKeysTask>(){

        @Override
        @Nonnull
        protected ProjectMemberSshKeysTask createNewTask(@Nonnull String projectName) {
            return new ProjectMemberSshKeysTask(projectName, HighLevelTaskFactory.this.userAndSliceApiWrapper, HighLevelTaskFactory.this.logger, HighLevelTaskFactory.this);
        }
    };
    private final CacheableTaskFactory<Slice, SliceMembersSshKeysTask> sliceMembersSshKeysTaskFactory = new CacheableTaskFactory<Slice, SliceMembersSshKeysTask>(){

        @Override
        @Nonnull
        protected SliceMembersSshKeysTask createNewTask(@Nonnull Slice slice) {
            return new SliceMembersSshKeysTask(slice, HighLevelTaskFactory.this.userAndSliceApiWrapper, HighLevelTaskFactory.this.logger, HighLevelTaskFactory.this);
        }
    };
    private final HashMap<GeniUrn, OtherUserSshKeysTask> otherUserSshKeysTasks = new HashMap();

    @Inject
    public HighLevelTaskFactory(UserAndSliceApiWrapper userAndSliceApiWrapper, AggregateManagerWrapperFactory aggregateManagerWrapperFactory, JavaFXLogger logger, GeniUserProvider geniUserProvider, SfaModel sfaModel, TaskThread tt, JFedPreferences jFedPreferences, TestbedInfoSource testbedInfoSource, JFedConnectionProvider connectionProvider, SliceRegistryUtil sliceRegistryUtil, FedmonWebApiClient fedmonWebApiClient, AuthorityFinder authorityFinder) {
        this.userAndSliceApiWrapper = userAndSliceApiWrapper;
        this.aggregateManagerWrapperFactory = aggregateManagerWrapperFactory;
        this.logger = logger;
        this.geniUserProvider = geniUserProvider;
        this.sfaModel = sfaModel;
        this.tt = tt;
        this.jFedPreferences = jFedPreferences;
        this.testbedInfoSource = testbedInfoSource;
        this.connectionProvider = connectionProvider;
        this.sliceRegistryUtil = sliceRegistryUtil;
        this.fedmonWebApiClient = fedmonWebApiClient;
        this.authorityFinder = authorityFinder;
    }

    public synchronized UserCredentialTask getUserCredential() {
        if (this.userCredentialTask == null) {
            this.userCredentialTask = new UserCredentialTask(this.userAndSliceApiWrapper, this.logger);
        }
        return this.userCredentialTask;
    }

    public synchronized ListSlicesTask listSlices() {
        if (this.listSlicesTask == null) {
            this.listSlicesTask = new ListSlicesTask(this.userAndSliceApiWrapper, this.logger, this.geniUserProvider, this);
        }
        return this.listSlicesTask;
    }

    public synchronized ListSubAuthoritiesTask listSubAuthorities() {
        if (this.listSubAuthoritiesTask == null) {
            this.listSubAuthoritiesTask = new ListSubAuthoritiesTask(this.userAndSliceApiWrapper, this.logger, this.geniUserProvider, this.sfaModel, this);
        }
        return this.listSubAuthoritiesTask;
    }

    public synchronized ResolveUserAndSlicesTask resolveUserAndSlices() {
        if (this.resolveUserAndSlicesTask == null) {
            this.resolveUserAndSlicesTask = new ResolveUserAndSlicesTask(this.userAndSliceApiWrapper, this.logger, this.geniUserProvider, this.sfaModel, this.tt, this);
        }
        return this.resolveUserAndSlicesTask;
    }

    public synchronized UserAuthorityGetVersionTask getUserAuthorityGetVersionTask() {
        if (this.userAuthorityGetVersionTask == null) {
            this.userAuthorityGetVersionTask = new UserAuthorityGetVersionTask(this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer(), this.logger, this.geniUserProvider, this.connectionProvider, this.jFedPreferences);
        }
        return this.userAuthorityGetVersionTask;
    }

    public GetVersionTask getVersion(Server auth) {
        return this.getVersionTaskFactory.getTask(auth);
    }

    public EmulabRegistryTask emulabRegistry(Server auth) {
        return new EmulabRegistryTask(auth, this.logger, this.geniUserProvider, this.jFedPreferences, this.connectionProvider);
    }

    public GetAdvertisementTask getAllAdvertisement(@Nonnull Server auth) {
        return this.getAllAdvertisementTaskFactory.getTask(auth);
    }

    public GetAdvertisementTask getAvailableAdvertisement(@Nonnull Server auth) {
        return this.getAvailableAdvertisementTaskFactory.getTask(auth);
    }

    public FedmonResultsTask getFedmonResults(String testbedUrnFilter, String testDefinitionFilter) {
        return this.fedmonResultsTaskFactory.getTask(testbedUrnFilter, testDefinitionFilter);
    }

    public SliceCredentialTask getSliceCredential(@Nonnull Slice slice) {
        return this.sliceCredentialTaskFactory.getTask(slice);
    }

    public SliceManifestForAuthorityTask getSliceManifest(@Nonnull Slice slice, @Nonnull Server auth) {
        return this.sliceManifestForAuthorityFactory.getTask(slice, auth);
    }

    public AggregatesForSliceTask getAggregatesForSlice(@Nonnull Slice slice) {
        return this.aggregatesForSliceTaskFactory.getTask(slice);
    }

    public SliverManifestTask getManifest(@Nonnull Sliver sliver) {
        return this.sliverManifestTaskFactory.getTask(sliver);
    }

    public SliverStatusTask getStatus(@Nonnull Sliver sliver) {
        return this.sliverStatusTaskFactory.getTask(sliver);
    }

    public StatusTask status(@Nonnull Slice slice, @Nonnull Server auth) {
        return this.statusFactory.getTask(slice, auth);
    }

    @Nonnull
    public RenewSliceTask renewSlice(@Nonnull Slice slice, @Nonnull Instant newExpirationDate) {
        return new RenewSliceTask(slice, newExpirationDate, this.userAndSliceApiWrapper, this.logger, this);
    }

    @Nonnull
    public RenewSliversTask renewSliversAtAuthority(@Nonnull Slice slice, @Nonnull Instant newExpirationDate, @Nonnull Server authority) {
        return new RenewSliversTask(slice, newExpirationDate, authority, null, false, this.userAndSliceApiWrapper, this.aggregateManagerWrapperFactory, this.logger, this, this.sfaModel);
    }

    @Nonnull
    public RenewSliversTask renewSliversAtAuthority(@Nonnull Slice slice, @Nonnull Instant newExpirationDate, @Nonnull Server authority, @Nonnull Collection<Sliver> slivers, boolean onlyIfNeeded) {
        return new RenewSliversTask(slice, newExpirationDate, authority, slivers, onlyIfNeeded, this.userAndSliceApiWrapper, this.aggregateManagerWrapperFactory, this.logger, this, this.sfaModel);
    }

    @Nonnull
    public CreateSliceTask createSlice(@Nonnull String sliceName, @Nullable String subAuthName, @Nonnull List<GeniUrn> shareWith, @Nullable Instant expirationDate) {
        assert (sliceName != null);
        return new CreateSliceTask(sliceName, subAuthName, shareWith, expirationDate, this.userAndSliceApiWrapper, this.logger, this.sfaModel, this);
    }

    @Override
    @Nonnull
    public RegisterOrUpdateSliversTask registerSlivers(@Nonnull Slice slice, @Nonnull Server auth, @Nonnull Collection<GeniUrn> sliverUrns, @Nonnull Instant sliverExpirationDate, @Nullable Task extraTaskToDependOn, ResultListener ... extraResultListeners) {
        return new RegisterOrUpdateSliversTask(RegisterOrUpdateSliversTask.Action.CREATE_SLIVER_INFO, slice, auth, sliverUrns, sliverExpirationDate, extraTaskToDependOn, this.userAndSliceApiWrapper, this.logger, this, extraResultListeners);
    }

    @Override
    @Nonnull
    public RegisterOrUpdateSliversTask updateSlivers(@Nonnull Slice slice, @Nonnull Server auth, @Nonnull Collection<GeniUrn> sliverUrns, @Nonnull Instant sliverExpirationDate, @Nullable Task extraTaskToDependOn, ResultListener ... extraResultListeners) {
        return new RegisterOrUpdateSliversTask(RegisterOrUpdateSliversTask.Action.UPDATE_SLIVER_INFO, slice, auth, sliverUrns, sliverExpirationDate, extraTaskToDependOn, this.userAndSliceApiWrapper, this.logger, this, extraResultListeners);
    }

    @Nonnull
    public CreateSliverTask createSliver(@Nonnull Slice slice, @Nullable Instant startTime, @Nonnull Instant expirationTime, @Nonnull Server auth, @Nonnull List<UserSpec> userSpecs, @Nullable RequestRspecSource overridingRequestRspecSource) {
        return new CreateSliverTask(slice, startTime, expirationTime, auth, userSpecs, overridingRequestRspecSource, this.aggregateManagerWrapperFactory, this.sliceRegistryUtil, this.sfaModel, this);
    }

    @Nonnull
    public AllocateSliverTask allocateSliver(@Nonnull Slice slice, @Nullable Instant startTime, @Nonnull Instant expirationTime, @Nonnull List<UserSpec> userSpecs, @Nonnull Server auth, @Nullable RequestRspecSource overridingRequestRspecSource) {
        return new AllocateSliverTask(slice, startTime, expirationTime, userSpecs, auth, overridingRequestRspecSource, this.aggregateManagerWrapperFactory, this.sliceRegistryUtil, this.sfaModel, this);
    }

    @Nonnull
    public ProvisionSliverTask provisionSliver(@Nonnull Slice slice, @Nonnull Instant expirationTime, @Nonnull Server auth, @Nonnull List<UserSpec> userSpecs) {
        return new ProvisionSliverTask(slice, expirationTime, auth, userSpecs, this.aggregateManagerWrapperFactory, this.sfaModel, this, this.sliceRegistryUtil, this.geniUserProvider);
    }

    @Nonnull
    public ListSliceResourcesTask listSliceResources(@Nonnull Slice slice, @Nonnull Server auth) {
        return new ListSliceResourcesTask(auth, slice, this.aggregateManagerWrapperFactory, this);
    }

    @Nonnull
    public DeleteSliversAtAuthorityTask deleteSliversAtAuthority(@Nonnull Slice slice, @Nonnull Server auth) {
        return new DeleteSliversAtAuthorityTask(slice, auth, this.aggregateManagerWrapperFactory, this.sliceRegistryUtil);
    }

    @Override
    @Nonnull
    public UnregisterSliversTask unregisterSlivers(@Nonnull Slice slice, @Nonnull Server auth, @Nonnull Collection<GeniUrn> sliversToUnregister, @Nullable Task extraDependsOnTask, ResultListener ... resultListeners) {
        return new UnregisterSliversTask(slice, auth, sliversToUnregister, extraDependsOnTask, this.userAndSliceApiWrapper, this.logger, this, resultListeners);
    }

    @Override
    public RegisterSliceRspecTask registerSliceRspec(@Nonnull AbstractFederationApi.SliceRspecType type, @Nonnull Slice slice, @Nullable Server auth, @Nonnull String rspec, @Nonnull Instant sliceProvisionDate, @Nullable Task extraTaskToDependOn, ResultListener ... extraResultListeners) {
        return new RegisterSliceRspecTask(type, slice, auth, rspec, sliceProvisionDate, extraTaskToDependOn, this.userAndSliceApiWrapper, this.logger, this, extraResultListeners);
    }

    @Nonnull
    public synchronized UserSshKeysTask getUserSSHKeys() {
        if (this.userSshKeysTask == null) {
            this.userSshKeysTask = new UserSshKeysTask(this.userAndSliceApiWrapper, this.logger, this.geniUserProvider, this);
        }
        return this.userSshKeysTask;
    }

    @Nonnull
    public ProjectMemberSshKeysTask getProjectMembersSSHKeys(@Nonnull String projectName) {
        return this.projectMemberSshKeysTaskFactory.getTask(projectName);
    }

    @Nonnull
    public SliceMembersSshKeysTask getSliceMembersSSHKeys(@Nonnull Slice slice) {
        return this.sliceMembersSshKeysTaskFactory.getTask(slice);
    }

    @Nonnull
    public OtherUserSshKeysTask getOtherUserSshKeys(@Nonnull GeniUrn userUrn) {
        return this.getOtherUserSSHKey(userUrn, Collections.emptyList());
    }

    @Nonnull
    public OtherUserSshKeysTask getOtherUserSSHKey(@Nonnull GeniUrn userUrn, Task ... extraTaskDeps) {
        return this.getOtherUserSSHKey(userUrn, Arrays.asList(extraTaskDeps));
    }

    @Nonnull
    public synchronized OtherUserSshKeysTask getOtherUserSSHKey(@Nonnull GeniUrn userUrn, @Nonnull List<Task> extraTaskDeps) {
        return this.otherUserSshKeysTasks.computeIfAbsent(userUrn, urn -> new OtherUserSshKeysTask(userUrn, extraTaskDeps, this.userAndSliceApiWrapper, this.logger, this));
    }

    @Nonnull
    public ShareLanTask getShareLanTask(@Nonnull Slice slice, @Nonnull Server auth, @Nonnull String lanClientId, @Nonnull String newSharedLanName) {
        return new ShareLanTask(slice, auth, lanClientId, newSharedLanName, this.aggregateManagerWrapperFactory, this);
    }

    @Nonnull
    public UnshareLanTask getUnshareLanTask(@Nonnull Slice slice, @Nonnull Server auth, @Nonnull String lanClientId, @Nonnull String sharedLanName) {
        return new UnshareLanTask(slice, auth, lanClientId, sharedLanName, this.aggregateManagerWrapperFactory, this);
    }

    @Nonnull
    public StartTask poaStart(@Nonnull Slice slice, @Nonnull GeniUrn startTarget, @Nonnull Server auth) {
        return new StartTask(slice, auth, startTarget, this.aggregateManagerWrapperFactory, this);
    }

    @Nonnull
    public RestartTask restart(@Nonnull Slice slice, @Nonnull GeniUrn restartTarget, @Nonnull Server auth) {
        return new RestartTask(slice, auth, restartTarget, this.aggregateManagerWrapperFactory, this);
    }

    @Nonnull
    public RestartTask restartSlice(@Nonnull Slice slice, @Nonnull Server auth) {
        assert (slice.getUrn() != null);
        return this.restart(slice, slice.getUrn(), auth);
    }

    @Nonnull
    public RestartTask restartSliver(@Nonnull Sliver sliver) {
        assert (sliver.getUrn() != null);
        return this.restart(sliver.getSlice(), sliver.getUrn(), sliver.getServer());
    }

    @Nonnull
    public ReloadOSTask reloadOS(@Nonnull Slice slice, @Nonnull GeniUrn reloadOSTarget, @Nonnull Server auth) {
        return new ReloadOSTask(slice, auth, reloadOSTarget, this.aggregateManagerWrapperFactory, this);
    }

    @Nonnull
    public ReloadOSTask reloadOS(@Nonnull Sliver sliver) {
        assert (sliver.getUrn() != null);
        return this.reloadOS(sliver.getSlice(), sliver.getUrn(), sliver.getServer());
    }

    @Nonnull
    public CreateImageTask createImage(@Nonnull Slice slice, @Nonnull GeniUrn sliverUrn, @Nonnull String imageName, boolean global, boolean updatePrepare) {
        return new CreateImageTask(slice, sliverUrn, imageName, global, updatePrepare, this.aggregateManagerWrapperFactory, this);
    }

    @Nonnull
    public DeleteImageTask deleteImage(@Nonnull Server auth, @Nonnull GeniUrn imageUrn) {
        return new DeleteImageTask(auth, imageUrn, this.userAndSliceApiWrapper, this.aggregateManagerWrapperFactory, this);
    }

    @Nonnull
    public ListDiskImagesTask listDiskImages(@Nonnull Server auth) {
        return new ListDiskImagesTask(auth, this.userAndSliceApiWrapper, this.aggregateManagerWrapperFactory, this);
    }

    @Nonnull
    public OpenConsoleTask openConsole(@Nonnull Sliver sliver) {
        return new OpenConsoleTask(sliver, this.aggregateManagerWrapperFactory, this);
    }

    @Nonnull
    public ShareSliceTask getShareSliceTask(@Nonnull Slice slice, @Nonnull GeniUrn userUrn) {
        return new ShareSliceTask(slice, userUrn, this.userAndSliceApiWrapper, this.logger, this);
    }

    @Nonnull
    public UnshareSliceTask getUnshareSliceTask(@Nonnull Slice slice, @Nonnull GeniUrn userUrn) {
        return new UnshareSliceTask(slice, userUrn, this.userAndSliceApiWrapper, this.logger, this);
    }

    @Nonnull
    public EditSSHKeysTask getEditSshKeysTask(@Nonnull Slice slice, @Nonnull Server auth, @Nonnull Collection<UserSpec> userSpecs) {
        return new EditSSHKeysTask(slice, auth, userSpecs, this.aggregateManagerWrapperFactory, this);
    }

    @Nonnull
    public TaskExecution submitTask(@Nonnull Task task) {
        return this.tt.addTask(task);
    }

    @Nonnull
    public ListSubAuthorityMembersTask listSubAuthorityMembers(@Nonnull String subAuth) {
        return new ListSubAuthorityMembersTask(subAuth, this.userAndSliceApiWrapper, this.logger);
    }

    @Nonnull
    public GetSubAuthorityDetailsTask getSubAuthorityDetails(@Nonnull String subAuth) {
        return new GetSubAuthorityDetailsTask(subAuth, this.userAndSliceApiWrapper, this.logger);
    }

    @Nonnull
    public ListSliceMembersTask listSliceMembers(@Nonnull Slice slice) {
        return new ListSliceMembersTask(slice, this.userAndSliceApiWrapper, this.logger, this);
    }

    @Nonnull
    public RequestSlaUuidTask requestSlaUuid() {
        return new RequestSlaUuidTask(this.logger, this.jFedPreferences, this.testbedInfoSource, this.connectionProvider, this.geniUserProvider);
    }

    @Nonnull
    public RegisterSliversToSLACollectorTask registerSliversToSLACollector(@Nonnull Slice slice, @Nonnull Server auth, @Nonnull Collection<GeniUrn> createdSliverUrns) {
        return new RegisterSliversToSLACollectorTask(slice, auth, createdSliverUrns, this.logger, this.jFedPreferences, this.testbedInfoSource, this.connectionProvider, this.geniUserProvider);
    }

    @Nonnull
    public RegisterStopToSLACollectorTask registerStopToSLACollector(@Nonnull Slice slice, @Nonnull Server auth) {
        return new RegisterStopToSLACollectorTask(slice, auth, this.logger, this.jFedPreferences, this.testbedInfoSource, this.connectionProvider, this.geniUserProvider);
    }

    @Nonnull
    public SCSRequestTask createSCSRequestTask(@Nonnull Slice slice, @Nonnull RequestRspecSource requestRspecSource, @Nonnull Instant requestedEndTime, @Nonnull Server scsAuthority) {
        return new SCSRequestTask(slice, requestRspecSource, requestedEndTime, scsAuthority, this.geniUserProvider, this.logger, this.connectionProvider, this.jFedPreferences);
    }

    @Nonnull
    public ListPendingReputationQuestionnairesTask listPendingReputationQuestionnaires(@Nonnull Slice slice) {
        return new ListPendingReputationQuestionnairesTask(slice, this.logger, this.jFedPreferences, this.testbedInfoSource, this.connectionProvider, this.geniUserProvider);
    }

    @Nonnull
    public RegisterReputationTask registerReputation(@Nonnull Slice slice, @Nonnull List<GeniUrn> resources, int overallScore, int qualityScore, int availabilityScore) {
        return new RegisterReputationTask(slice, resources, overallScore, qualityScore, availabilityScore, this.logger, this.jFedPreferences, this.testbedInfoSource, this.connectionProvider, this.geniUserProvider);
    }

    @Nonnull
    public RecoverSliceTask createRecoverSliceTask(@Nonnull GeniUrn sliceUrn, @Nonnull RecoverSliceTaskInteraction guiInteraction) {
        return new RecoverSliceTask(sliceUrn, this.sfaModel, this, this.testbedInfoSource, this.authorityFinder, this.jFedPreferences, this.tt, guiInteraction);
    }

    @Nonnull
    public RecoverSliceTask createRecoverSliceTask(@Nonnull Slice slice, @Nonnull RecoverSliceTaskInteraction guiInteraction) {
        return new RecoverSliceTask(slice, this.sfaModel, this, this.testbedInfoSource, this.authorityFinder, this.jFedPreferences, this.tt, guiInteraction);
    }

    public TestbedInfoSource getTestbedInfoSource() {
        return this.testbedInfoSource;
    }

    public AuthorityFinder getAuthorityFinder() {
        return this.authorityFinder;
    }

    public UserAndSliceApiWrapper getUserAndSliceApiWrapper() {
        return this.userAndSliceApiWrapper;
    }
}

