/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ListDiskImagesTask
extends Task {
    @Nonnull
    private final Server auth;
    private List<AggregateManagerWrapper.ImageInfo> diskImageInfos = null;
    @Nonnull
    private final UserAndSliceApiWrapper userAndSliceApiWrapper;
    @Nonnull
    private final AggregateManagerWrapperFactory aggregateManagerWrapperFactory;
    @Nonnull
    private final HighLevelTaskFactory highLevelTaskFactory;

    public ListDiskImagesTask(@Nonnull Server auth, @Nonnull UserAndSliceApiWrapper userAndSliceApiWrapper, @Nonnull AggregateManagerWrapperFactory aggregateManagerWrapperFactory, @Nonnull HighLevelTaskFactory highLevelTaskFactory) {
        super("List User Images on " + auth.getName());
        this.auth = auth;
        this.userAndSliceApiWrapper = userAndSliceApiWrapper;
        this.aggregateManagerWrapperFactory = aggregateManagerWrapperFactory;
        this.highLevelTaskFactory = highLevelTaskFactory;
    }

    @Override
    protected void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        AggregateManagerWrapper amWrapper = this.aggregateManagerWrapperFactory.getAggregateManagerWrapper(taskExecution, this.auth);
        if (!amWrapper.areUserDiskImageFunctionsSupported()) {
            throw new JFedHighLevelException("Authority " + this.auth.getDefaultComponentManagerUrn() + " does not support list image.");
        }
        if (!this.userAndSliceApiWrapper.hasUserCredentials()) {
            throw new JFedException("UserAndSliceApiWrapper did not have user Credentials.");
        }
        List imageInfos = amWrapper.listImages(this.userAndSliceApiWrapper.getCachedUserCredentialsForAM());
        this.diskImageInfos = Collections.unmodifiableList(imageInfos);
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        return Collections.singletonList(this.highLevelTaskFactory.getUserCredential());
    }

    @Nullable
    public List<AggregateManagerWrapper.ImageInfo> getDiskImageInfos() {
        return this.diskImageInfos;
    }
}

