/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.ReputationTask;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.lowlevel.api.ReputationService;
import be.iminds.ilabt.jfed.lowlevel.api.RestApi;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ListPendingReputationQuestionnairesTask
extends ReputationTask {
    @Nonnull
    private final Slice slice;
    private List<ReputationService.SliceReputation> pendingQuestionnaires;

    public ListPendingReputationQuestionnairesTask(@Nonnull Slice slice, @Nonnull JavaFXLogger logger, @Nonnull JFedPreferences jFedPreferences, @Nonnull TestbedInfoSource testbedInfoSource, @Nonnull JFedConnectionProvider connectionProvider, @Nonnull GeniUserProvider geniUserProvider) {
        super("Requesting pending reputation questionnaires", logger, jFedPreferences, testbedInfoSource, connectionProvider, geniUserProvider);
        this.slice = slice;
    }

    @Override
    protected void doReputationTask(TaskExecution taskExecution, ReputationService reputationService) throws JFedException {
        if (this.slice.getCreationDate() == null || this.slice.getExpirationDate() == null) {
            throw new RuntimeException("Cannot register Reputation questionaire: some slice info is missing. (this is an internal jFed error)urn=" + this.slice.getUrn() + (this.slice.getCreationDate() == null ? " cd" : "") + (this.slice.getExpirationDate() == null ? " ed" : ""));
        }
        RestApi.RestReply reply = reputationService.registerExperiment(this.createConnection(), this.geniUserProvider.getLoggedInGeniUser().getUserUrn(), this.slice.getUrn(), Date.from(this.slice.getCreationDate()), Date.from(this.slice.getExpirationDate()));
        if (reply.getHttpCallDetails().getResultHttpStatusCode() != 200) {
            throw new JFedHighLevelException("Error while registering experiment to reputation service");
        }
        this.pendingQuestionnaires = (List)reply.getValue();
    }

    @Nullable
    public List<ReputationService.SliceReputation> getPendingQuestionnaires() {
        return this.pendingQuestionnaires;
    }
}

