/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class ListSubAuthorityMembersTask
extends Task {
    @Nonnull
    private final String projectName;
    @Nonnull
    private final UserAndSliceApiWrapper userAndSliceApiWrapper;
    @Nonnull
    private final JavaFXLogger logger;
    private List<GeniUrn> memberUrns;

    public ListSubAuthorityMembersTask(@Nonnull String projectName, @Nonnull UserAndSliceApiWrapper userAndSliceApiWrapper, @Nonnull JavaFXLogger logger) {
        super("List members of " + projectName);
        this.projectName = projectName;
        this.userAndSliceApiWrapper = userAndSliceApiWrapper;
        this.logger = logger;
    }

    @Override
    protected void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        this.memberUrns = this.userAndSliceApiWrapper.getUsersForSubAuthority((Logger)JavaFXLogger.wrap(this.logger, taskExecution), this.projectName);
    }

    @Nonnull
    public List<GeniUrn> getMemberUrns() {
        return this.memberUrns == null ? Collections.emptyList() : Collections.unmodifiableList(this.memberUrns);
    }
}

