/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.LoggerFactory;

public class ProjectMemberSshKeysTask
extends Task {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(ProjectMemberSshKeysTask.class);
    @Nonnull
    private final String projectName;
    @Nonnull
    private final UserAndSliceApiWrapper userAndSliceApiWrapper;
    @Nonnull
    private final JavaFXLogger logger;
    @Nonnull
    private final HighLevelTaskFactory highLevelTaskFactory;
    private int totalMembersCount = -1;
    private int totalKeyCount = -1;
    private int memberInfoRequested = 0;

    public ProjectMemberSshKeysTask(@Nonnull String projectName, @Nonnull UserAndSliceApiWrapper userAndSliceApiWrapper, @Nonnull JavaFXLogger logger, @Nonnull HighLevelTaskFactory highLevelTaskFactory) {
        super("Get User SSH Keys For users in project " + projectName);
        this.projectName = projectName;
        this.userAndSliceApiWrapper = userAndSliceApiWrapper;
        this.logger = logger;
        this.highLevelTaskFactory = highLevelTaskFactory;
    }

    @Override
    public void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        List<GeniUrn> userUrns = this.userAndSliceApiWrapper.getUsersForSubAuthority((Logger)JavaFXLogger.wrap(this.logger, taskExecution), this.projectName);
        if (userUrns == null) {
            LOG.warn("Could not retrieve SSH-keys of other users");
            userUrns = Collections.emptyList();
        }
        this.totalMembersCount = userUrns.size();
        this.totalKeyCount = 0;
        for (GeniUrn userUrn : userUrns) {
            try {
                ++this.memberInfoRequested;
                List keys = this.userAndSliceApiWrapper.getSshKeysForUser((Logger)JavaFXLogger.wrap(this.logger, taskExecution), userUrn);
                this.totalKeyCount += keys != null ? keys.size() : 0;
            }
            catch (JFedException e) {
                LOG.warn("Could not get user key for {}", (Object)userUrn, (Object)e);
            }
        }
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        return Collections.singletonList(this.highLevelTaskFactory.getUserCredential());
    }

    public int getTotalMembersCount() {
        return this.totalMembersCount;
    }

    public int getTotalKeyCount() {
        return this.totalKeyCount;
    }

    public int getMemberInfoRequested() {
        return this.memberInfoRequested;
    }
}

