/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.log.ResultListener;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegisterOrUpdateSliversTask
extends Task {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterOrUpdateSliversTask.class);
    @Nonnull
    private final Action action;
    @Nonnull
    private final Slice slice;
    @Nonnull
    private final Collection<GeniUrn> createdSliverUrns;
    @Nullable
    private final Task extraTaskToDependOn;
    @Nonnull
    private final Instant sliverExpirationDate;
    @Nonnull
    private final Instant sliverCreationDate;
    @Nonnull
    private final Server auth;
    @Nonnull
    private final ResultListener[] extraResultListeners;
    private final UserAndSliceApiWrapper userAndSliceApiWrapper;
    private final JavaFXLogger logger;
    private final HighLevelTaskFactory highLevelTaskFactory;

    public RegisterOrUpdateSliversTask(@Nonnull Action action, @Nonnull Slice slice, @Nonnull Server auth, @Nonnull Collection<GeniUrn> createdSliverUrns, @Nonnull Instant sliverExpirationDate, @Nullable Task extraTaskToDependOn, @Nonnull UserAndSliceApiWrapper userAndSliceApiWrapper, @Nonnull JavaFXLogger logger, @Nonnull HighLevelTaskFactory highLevelTaskFactory, ResultListener ... extraResultListeners) {
        super((action == Action.CREATE_SLIVER_INFO ? "Registering" : "Updating") + " slivers created @ " + auth.getDefaultComponentManagerUrn());
        this.action = action;
        this.slice = slice;
        this.createdSliverUrns = createdSliverUrns;
        this.sliverExpirationDate = sliverExpirationDate;
        this.sliverCreationDate = Instant.now();
        this.auth = auth;
        this.extraTaskToDependOn = extraTaskToDependOn;
        this.userAndSliceApiWrapper = userAndSliceApiWrapper;
        this.logger = logger;
        this.highLevelTaskFactory = highLevelTaskFactory;
        this.extraResultListeners = extraResultListeners;
    }

    @Override
    protected void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        ResultListener[] resultListeners = Arrays.copyOf(this.extraResultListeners, this.extraResultListeners.length + 1);
        resultListeners[this.extraResultListeners.length] = taskExecution;
        JavaFXLogger logger = JavaFXLogger.wrap(this.logger, resultListeners);
        Collection<GeniUrn> sliverUrns = this.createdSliverUrns;
        LOG.debug("RegisterSliversTask has " + sliverUrns.size() + " sliver Urns to register.");
        if (!sliverUrns.isEmpty()) {
            if (this.action == Action.CREATE_SLIVER_INFO) {
                this.userAndSliceApiWrapper.registerAggregatesForSlice((be.iminds.ilabt.jfed.log.Logger)logger, this.slice.getCredentials(), this.slice.getUrn(), this.auth.getDefaultComponentManagerAsGeniUrn(), sliverUrns, Date.from(this.sliverExpirationDate), Date.from(this.sliverCreationDate));
            }
            if (this.action == Action.UPDATE_SLIVER_INFO) {
                this.userAndSliceApiWrapper.updateSliverExpirationDateInfoForSlice((be.iminds.ilabt.jfed.log.Logger)logger, this.slice.getCredentials(), this.slice.getUrn(), this.auth.getDefaultComponentManagerAsGeniUrn(), sliverUrns, Date.from(this.sliverExpirationDate));
            }
        }
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        ArrayList<Task> res = new ArrayList<Task>();
        if (this.extraTaskToDependOn != null) {
            res.add(this.extraTaskToDependOn);
        }
        res.add(this.highLevelTaskFactory.getSliceCredential(this.slice));
        return res;
    }

    public static enum Action {
        UPDATE_SLIVER_INFO,
        CREATE_SLIVER_INFO;

    }
}

