/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.log.ResultListener;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegisterSliceRspecTask
extends Task {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterSliceRspecTask.class);
    @Nonnull
    private final AbstractFederationApi.SliceRspecType type;
    @Nonnull
    private final Slice slice;
    @Nullable
    private final Server auth;
    @Nonnull
    private final String rspec;
    @Nullable
    private final Task extraTaskToDependOn;
    @Nonnull
    private final Instant sliceProvisionDate;
    @Nonnull
    private final ResultListener[] extraResultListeners;
    private final UserAndSliceApiWrapper userAndSliceApiWrapper;
    private final JavaFXLogger logger;
    private final HighLevelTaskFactory highLevelTaskFactory;

    public RegisterSliceRspecTask(@Nonnull AbstractFederationApi.SliceRspecType type, @Nonnull Slice slice, @Nullable Server auth, @Nonnull String rspec, @Nonnull Instant sliceProvisionDate, @Nullable Task extraTaskToDependOn, @Nonnull UserAndSliceApiWrapper userAndSliceApiWrapper, @Nonnull JavaFXLogger logger, @Nonnull HighLevelTaskFactory highLevelTaskFactory, ResultListener ... extraResultListeners) {
        super("Registering slice RSpec for " + (auth == null ? "(NO AUTH)" : auth.getDefaultComponentManagerUrn()));
        assert (auth == null == (type != AbstractFederationApi.SliceRspecType.MANIFEST)) : "auth is required for MANIFEST, but not allowed for REQUEST and COMBINED MANIFEST";
        this.type = type;
        this.slice = slice;
        this.rspec = rspec;
        this.sliceProvisionDate = sliceProvisionDate;
        this.auth = auth;
        this.extraTaskToDependOn = extraTaskToDependOn;
        this.userAndSliceApiWrapper = userAndSliceApiWrapper;
        this.logger = logger;
        this.highLevelTaskFactory = highLevelTaskFactory;
        this.extraResultListeners = extraResultListeners;
    }

    @Override
    protected void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        ResultListener[] resultListeners = Arrays.copyOf(this.extraResultListeners, this.extraResultListeners.length + 1);
        resultListeners[this.extraResultListeners.length] = taskExecution;
        JavaFXLogger logger = JavaFXLogger.wrap(this.logger, resultListeners);
        this.userAndSliceApiWrapper.registerRspec((be.iminds.ilabt.jfed.log.Logger)logger, this.slice.getCredentials(), this.type, this.slice.getUrn(), this.auth == null ? null : this.auth.getDefaultComponentManagerAsGeniUrn(), this.rspec, Date.from(this.sliceProvisionDate));
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        ArrayList<Task> res = new ArrayList<Task>();
        if (this.extraTaskToDependOn != null) {
            res.add(this.extraTaskToDependOn);
        }
        res.add(this.highLevelTaskFactory.getSliceCredential(this.slice));
        return res;
    }
}

