/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.tasks.RegisterOrUpdateSliversTask;
import be.iminds.ilabt.jfed.highlevel.tasks.SlaTask;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.lowlevel.api.RestApi;
import be.iminds.ilabt.jfed.lowlevel.api.SlaCollector;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestSlaUuidTask
extends SlaTask {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterOrUpdateSliversTask.class);
    private static final String AGREEMENT_ID = "agreement_id";
    private String slaUuid = null;

    public RequestSlaUuidTask(@Nonnull JavaFXLogger logger, @Nonnull JFedPreferences jFedPreferences, @Nonnull TestbedInfoSource testbedInfoSource, @Nonnull JFedConnectionProvider connectionProvider, @Nonnull GeniUserProvider geniUserProvider) {
        super("Request SLA UUID", logger, jFedPreferences, testbedInfoSource, connectionProvider, geniUserProvider);
    }

    @Override
    protected void doSlaTask(@Nonnull TaskExecution taskExecution, @Nonnull SlaCollector slaCollector) throws JFedException {
        RestApi.RestReply reply = slaCollector.generateUUID(this.createConnection());
        if (reply.getValue() != null) {
            try {
                JSONObject result = new JSONObject((String)reply.getValue());
                this.slaUuid = result.getString(AGREEMENT_ID);
            }
            catch (JSONException ex) {
                throw new JFedHighLevelException("Could not process response: " + ex.getMessage(), ex);
            }
        }
        if (this.slaUuid == null) {
            LOG.error("Didn't get a UUID from the server!");
        }
    }

    @Nullable
    public String getSlaUuid() {
        return this.slaUuid;
    }
}

