/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.lowlevel.api.StitchingComputationService;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import java.time.Instant;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCSRequestTask
extends Task {
    private static final Logger log = LoggerFactory.getLogger(SCSRequestTask.class);
    @Nonnull
    private final Server scsAuthority;
    @Nonnull
    private final Slice slice;
    @Nonnull
    private final RequestRspecSource originalRspecRequest;
    @Nonnull
    private final Instant requestedEndTime;
    @Nonnull
    private final GeniUserProvider geniUserProvider;
    @Nonnull
    private final JavaFXLogger logger;
    @Nonnull
    private final JFedConnectionProvider connectionProvider;
    @Nonnull
    private final JFedPreferences jFedPreferences;
    private StitchingComputationService.ComputePathResult result;

    public SCSRequestTask(@Nonnull Slice slice, @Nonnull RequestRspecSource requestRspecSource, @Nonnull Instant requestedEndTime, @Nonnull Server scsAuthority, @Nonnull GeniUserProvider geniUserProvider, @Nonnull JavaFXLogger logger, @Nonnull JFedConnectionProvider connectionProvider, @Nonnull JFedPreferences jFedPreferences) {
        super("ParallelStitcher StitchingComputationService call");
        this.slice = slice;
        this.originalRspecRequest = requestRspecSource;
        this.requestedEndTime = requestedEndTime;
        this.geniUserProvider = geniUserProvider;
        this.logger = logger;
        this.connectionProvider = connectionProvider;
        this.jFedPreferences = jFedPreferences;
        this.scsAuthority = scsAuthority;
    }

    @Override
    protected void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        String requestRspec;
        log.debug("Sending StitchingComputationService request");
        StitchingComputationService scs = new StitchingComputationService((be.iminds.ilabt.jfed.log.Logger)JavaFXLogger.wrap(this.logger, taskExecution), this.jFedPreferences);
        assert (this.geniUserProvider.isUserLoggedIn());
        String modifiedRequestRspec = null;
        if (this.scsAuthority.hasFlag(Server.Flag.workaroundAddExpiresAttributeToRequestRspec)) {
            ModelRspec modelRspec = this.originalRspecRequest.getMutableModelRspec();
            if (modelRspec == null) {
                throw new JFedHighLevelException("Invalid Request: cannot parse request");
            }
            modelRspec = modelRspec.copy();
            modelRspec.setExpires(Date.from(this.requestedEndTime));
            modifiedRequestRspec = modelRspec.toGeni3Rspec();
        }
        String string = requestRspec = modifiedRequestRspec == null ? this.originalRspecRequest.getRspecXmlString() : modifiedRequestRspec;
        if (requestRspec == null) {
            throw new JFedHighLevelException("There is a problem with the RSpec, so it makes no sense to send it to the SCS.");
        }
        try {
            SfaConnection con = (SfaConnection)this.connectionProvider.getConnectionByAuthority(this.geniUserProvider.getLoggedInGeniUser(), this.scsAuthority, StitchingComputationService.class);
            StitchingComputationService.SCSReply res = scs.computePath(con, this.slice.getUrnString(), requestRspec, null);
            if (res != null) {
                if (res.getValue() == null) {
                    if (res.getOutput() != null) {
                        throw new JFedHighLevelException(String.format("SCS returned a failure: %s", res.getOutput()));
                    }
                    throw new JFedHighLevelException("Could not process SCS response: response without value or output");
                }
            } else {
                throw new JFedHighLevelException("Could not process SCS response: is NULL");
            }
            log.info("SCS call success");
            this.result = (StitchingComputationService.ComputePathResult)res.getValue();
        }
        catch (JFedException e) {
            log.error("SCS call failed", (Throwable)e);
            throw e;
        }
    }

    @Nullable
    public StitchingComputationService.ComputePathResult getResult() {
        return this.result;
    }
}

