/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.rspec.model.StringRspec;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceManifestForAuthorityTask
extends Task {
    private static final Logger LOG = LoggerFactory.getLogger(SliceManifestForAuthorityTask.class);
    private final Server auth;
    private final Slice slice;
    private String manifestRspec = null;
    private final AggregateManagerWrapperFactory aggregateManagerWrapperFactory;
    private final HighLevelTaskFactory highLevelTaskFactory;

    public SliceManifestForAuthorityTask(@Nonnull Slice slice, @Nonnull Server auth, AggregateManagerWrapperFactory aggregateManagerWrapperFactory, HighLevelTaskFactory highLevelTaskFactory) {
        super("get Manifest of Slice @ " + auth.getName());
        this.auth = auth;
        this.slice = slice;
        this.aggregateManagerWrapperFactory = aggregateManagerWrapperFactory;
        this.highLevelTaskFactory = highLevelTaskFactory;
    }

    @Override
    public void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        AggregateManagerWrapper amWrapper = this.aggregateManagerWrapperFactory.getAggregateManagerWrapper(taskExecution, this.auth);
        if (!ApiInfo.hasService((Server)this.auth, (ApiInfo.ApiName)ApiInfo.ApiName.GENI_AM)) {
            LOG.error("Tried to get manifest for slice '{}', at authority '{}', but that authority has no AM URL: cannot continue.", (Object)this.slice.getUrnString(), (Object)this.auth.getName());
            throw new JFedHighLevelException("Tried to get manifest for slice \"" + this.slice.getUrnString() + "\", at authority \"" + this.auth.getDefaultComponentManagerUrn() + "\", but that authority has no AM URL: cannot continue.");
        }
        this.manifestRspec = amWrapper.describe(this.slice.getUrn(), this.slice.getCredentials());
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        return Collections.singletonList(this.highLevelTaskFactory.getSliceCredential(this.slice));
    }

    public String getManifestRspec() {
        return this.manifestRspec;
    }

    public StringRspec getManifestStringRspec() {
        if (this.manifestRspec != null) {
            return new StringRspec(this.manifestRspec);
        }
        return null;
    }
}

