/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class SliverManifestTask
extends Task {
    private final Sliver sliver;
    private final AggregateManagerWrapperFactory aggregateManagerWrapperFactory;
    private final HighLevelTaskFactory highLevelTaskFactory;

    public SliverManifestTask(Sliver sliver, AggregateManagerWrapperFactory aggregateManagerWrapperFactory, HighLevelTaskFactory highLevelTaskFactory) {
        super("Get Sliver Manifest");
        this.sliver = sliver;
        this.aggregateManagerWrapperFactory = aggregateManagerWrapperFactory;
        this.highLevelTaskFactory = highLevelTaskFactory;
    }

    @Override
    public void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        Server auth = this.sliver.getServer();
        if (!ApiInfo.hasService((Server)auth, (ApiInfo.ApiName)ApiInfo.ApiName.GENI_AM)) {
            throw new JFedHighLevelException("Tried to get manifest for sliver \"" + this.sliver.getUrnString() + "\", at authority \"" + auth.getDefaultComponentManagerUrn() + "\", but that authority has no AM URL: cannot continue.");
        }
        AggregateManagerWrapper amWrapper = this.aggregateManagerWrapperFactory.getAggregateManagerWrapper(taskExecution, auth);
        amWrapper.describe(this.sliver.getSlice().getUrn(), this.sliver.getSlice().getCredentials());
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        return Collections.singletonList(this.highLevelTaskFactory.getSliceCredential(this.sliver.getSlice()));
    }
}

