/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class UnshareSliceTask
extends Task {
    @Nonnull
    private final Slice slice;
    @Nonnull
    private final GeniUrn userUrn;
    @Nonnull
    private final UserAndSliceApiWrapper userAndSliceApiWrapper;
    @Nonnull
    private final JavaFXLogger logger;
    @Nonnull
    private final HighLevelTaskFactory highLevelTaskFactory;

    public UnshareSliceTask(@Nonnull Slice slice, @Nonnull GeniUrn userUrn, @Nonnull UserAndSliceApiWrapper userAndSliceApiWrapper, @Nonnull JavaFXLogger logger, @Nonnull HighLevelTaskFactory highLevelTaskFactory) {
        super("Unshare slice \"" + slice.getUrn().getEncodedResourceName() + "\" with " + userUrn.getEncodedResourceName());
        this.slice = slice;
        this.userUrn = userUrn;
        this.userAndSliceApiWrapper = userAndSliceApiWrapper;
        this.logger = logger;
        this.highLevelTaskFactory = highLevelTaskFactory;
    }

    @Override
    public void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        this.userAndSliceApiWrapper.unshareSlice((Logger)JavaFXLogger.wrap(this.logger, taskExecution), this.slice.getUrn(), this.slice.getCredentials(), this.userUrn);
        this.slice.addUser(this.userUrn);
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        return Collections.singletonList(this.highLevelTaskFactory.getSliceCredential(this.slice));
    }
}

