/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class UserSshKeysTask
extends Task {
    @Nonnull
    private final UserAndSliceApiWrapper userAndSliceApiWrapper;
    @Nonnull
    private final JavaFXLogger logger;
    @Nonnull
    private final GeniUserProvider geniUserProvider;
    @Nonnull
    private final HighLevelTaskFactory highLevelTaskFactory;

    public UserSshKeysTask(@Nonnull UserAndSliceApiWrapper userAndSliceApiWrapper, @Nonnull JavaFXLogger logger, @Nonnull GeniUserProvider geniUserProvider, @Nonnull HighLevelTaskFactory highLevelTaskFactory) {
        super("Get User SSH Keys");
        this.userAndSliceApiWrapper = userAndSliceApiWrapper;
        this.logger = logger;
        this.geniUserProvider = geniUserProvider;
        this.highLevelTaskFactory = highLevelTaskFactory;
    }

    @Override
    public void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        this.userAndSliceApiWrapper.getSshKeysForUser((Logger)JavaFXLogger.wrap(this.logger, taskExecution), this.geniUserProvider.getLoggedInGeniUser().getUserUrn());
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        return Collections.singletonList(this.highLevelTaskFactory.getUserCredential());
    }
}

