/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.util;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticAggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AggregateManagerWrapperFactory {
    private final AutomaticAggregateManagerWrapper.AutomaticAggregateManagerWrapperFactory automaticAggregateManagerWrapperFactory;
    private final JavaFXLogger logger;

    @Inject
    public AggregateManagerWrapperFactory(AutomaticAggregateManagerWrapper.AutomaticAggregateManagerWrapperFactory automaticAggregateManagerWrapperFactory, JavaFXLogger logger) {
        this.automaticAggregateManagerWrapperFactory = automaticAggregateManagerWrapperFactory;
        this.logger = logger;
    }

    public void setSpeaksFor(List<AnyCredential> speaksForCredentials, @Nullable GeniUrn speakingForUrn) {
        this.automaticAggregateManagerWrapperFactory.setSpeaksFor(speaksForCredentials, speakingForUrn);
    }

    public boolean isSpeaksFor() {
        return this.automaticAggregateManagerWrapperFactory.isSpeaksFor();
    }

    public List<AnyCredential> getSpeaksForCredentials() {
        return this.automaticAggregateManagerWrapperFactory.getSpeaksForCredentials();
    }

    public GeniUrn getSpeaksForUserUrn() {
        return this.automaticAggregateManagerWrapperFactory.getSpeaksForUserUrn();
    }

    public AggregateManagerWrapper getAggregateManagerWrapper(Server amServer) {
        return this.automaticAggregateManagerWrapperFactory.create(amServer);
    }

    public AggregateManagerWrapper getAggregateManagerWrapper(TaskExecution taskExecution, Server amServer) {
        JavaFXLogger wrappedLogger = taskExecution != null ? JavaFXLogger.wrap(this.logger, taskExecution) : this.logger;
        return this.automaticAggregateManagerWrapperFactory.create((Logger)wrappedLogger, amServer);
    }
}

