/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.util;

import be.iminds.ilabt.jfed.highlevel.util.FXPlatformUtil;
import be.iminds.ilabt.jfed.log.ApiCallDetails;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.log.ResultListener;
import javafx.application.Platform;
import javax.annotation.Nonnull;
import javax.inject.Singleton;
import org.slf4j.LoggerFactory;

@Singleton
public class JavaFXLogger
extends Logger {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(JavaFXLogger.class);
    private final boolean synchronous;

    public JavaFXLogger() {
        this(true);
    }

    protected JavaFXLogger(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public synchronized void fireResult(ApiCallDetails reply) {
        Runnable fireListeners = () -> {
            for (ResultListener l : this.resultListeners) {
                try {
                    l.onResult(reply);
                }
                catch (AssertionError | Exception t) {
                    LOG.error("Error while processing Logger ApiCallDetails reply on JavaFX thread. (will be ignored)", (Throwable)t);
                }
            }
        };
        if (!this.synchronous) {
            Platform.runLater((Runnable)fireListeners);
        } else {
            FXPlatformUtil.runAndWait(fireListeners);
        }
    }

    public JavaFXLogger getWrappingLogger() {
        return new MyWrappingJavaFXLogger(this.synchronous, this);
    }

    public JavaFXLogger getWrappingLogger(boolean synchronous) {
        return new MyWrappingJavaFXLogger(synchronous, this);
    }

    public static JavaFXLogger wrap(@Nonnull JavaFXLogger logger, ResultListener ... resultListeners) {
        MyWrappingJavaFXLogger res = new MyWrappingJavaFXLogger(logger.synchronous, logger);
        for (ResultListener resultListener : resultListeners) {
            res.addResultListener(resultListener);
        }
        return res;
    }

    public static JavaFXLogger wrap(boolean synchronous, @Nonnull JavaFXLogger logger, ResultListener ... resultListeners) {
        MyWrappingJavaFXLogger res = new MyWrappingJavaFXLogger(synchronous, logger);
        for (ResultListener resultListener : resultListeners) {
            res.addResultListener(resultListener);
        }
        return res;
    }

    private static class MyWrappingJavaFXLogger
    extends JavaFXLogger {
        private final JavaFXLogger parentLogger;

        public MyWrappingJavaFXLogger(boolean synchronous, JavaFXLogger parentLogger) {
            super(synchronous);
            this.parentLogger = parentLogger;
        }

        @Override
        public synchronized void fireResult(ApiCallDetails reply) {
            this.parentLogger.fireResult(reply);
            super.fireResult(reply);
        }
    }
}

