/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.util;

import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public final class LoggerOutputStream
extends OutputStream {
    private final Logger log;
    private final Level level;
    private final LoggingFunction loggingFunction;
    private final String pretext;
    private String mem = "";

    public LoggerOutputStream(Logger log, Level level, String pretext) {
        this.log = log;
        this.level = level;
        switch (this.level) {
            case TRACE: {
                this.loggingFunction = arg_0 -> ((Logger)log).trace(arg_0);
                break;
            }
            case DEBUG: {
                this.loggingFunction = arg_0 -> ((Logger)log).debug(arg_0);
                break;
            }
            case INFO: {
                this.loggingFunction = arg_0 -> ((Logger)log).info(arg_0);
                break;
            }
            case WARN: {
                this.loggingFunction = arg_0 -> ((Logger)log).warn(arg_0);
                break;
            }
            case ERROR: {
                this.loggingFunction = arg_0 -> ((Logger)log).error(arg_0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected error level");
            }
        }
        this.pretext = pretext;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] bytes = new byte[]{(byte)(b & 0xFF)};
        this.mem = this.mem + new String(bytes);
        if (this.mem.endsWith("\n")) {
            this.mem = this.mem.substring(0, this.mem.length() - 1);
            this.writeLine();
        }
    }

    public void writeLine() {
        this.loggingFunction.log(this.pretext + this.mem);
        this.mem = "";
    }

    @Override
    public void close() throws IOException {
        if (!this.mem.isEmpty()) {
            this.writeLine();
        }
    }

    @FunctionalInterface
    private static interface LoggingFunction {
        public void log(String var1);
    }
}

