/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.TransformationList;

public class MappedList<E, F>
extends TransformationList<E, F> {
    private final Function<F, E> mapper;

    public MappedList(ObservableList<? extends F> source, Function<F, E> mapper) {
        super(source);
        this.mapper = mapper;
    }

    public int getSourceIndex(int index) {
        return index;
    }

    public int getViewIndex(int index) {
        return index;
    }

    public E get(int index) {
        return this.mapper.apply(this.getSource().get(index));
    }

    public int size() {
        return this.getSource().size();
    }

    protected void sourceChanged(final ListChangeListener.Change<? extends F> c) {
        this.fireChange(new ListChangeListener.Change<E>((ObservableList)this){

            public boolean wasAdded() {
                return c.wasAdded();
            }

            public boolean wasRemoved() {
                return c.wasRemoved();
            }

            public boolean wasReplaced() {
                return c.wasReplaced();
            }

            public boolean wasUpdated() {
                return c.wasUpdated();
            }

            public boolean wasPermutated() {
                return c.wasPermutated();
            }

            public int getPermutation(int i) {
                return c.getPermutation(i);
            }

            protected int[] getPermutation() {
                throw new AssertionError((Object)"Unreachable code");
            }

            public List<E> getRemoved() {
                ArrayList res = new ArrayList(c.getRemovedSize());
                for (Object e : c.getRemoved()) {
                    res.add(MappedList.this.mapper.apply(e));
                }
                return res;
            }

            public int getFrom() {
                return c.getFrom();
            }

            public int getTo() {
                return c.getTo();
            }

            public boolean next() {
                return c.next();
            }

            public void reset() {
                c.reset();
            }
        });
    }
}

