/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.util;

import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class SentryUtil {
    public static List<Map<String, ?>> createSentrySlices(SfaModel sfaModel) {
        return sfaModel.getSlices().stream().map(SentryUtil::createSentrySlice).collect(Collectors.toList());
    }

    public static Map<String, ?> createSentrySlice(Slice slice) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("urn", slice.getUrnString());
        res.put("expiration_date", slice.getExpirationDate() == null ? null : RFC3339Util.instantToRFC3339String((Instant)slice.getExpirationDate()));
        if (slice.getStatus() != null) {
            res.put("status", slice.getStatus().detailedToString());
        }
        ArrayList sliversRes = new ArrayList();
        for (Sliver sliver : slice.getSliversCopy()) {
            HashMap<String, Object> sliverMap = new HashMap<String, Object>();
            List components = sliver.getComponentInfo().stream().filter(Objects::nonNull).map(c -> c.getClientId() == null ? c.getComponentId() : c.getClientId()).filter(Objects::nonNull).collect(Collectors.toList());
            List errorDetails = sliver.getStatus().getAllErrors().stream().filter(Objects::nonNull).map(e -> {
                HashMap<String, String> r = new HashMap<String, String>();
                r.put("error", e.getError());
                r.put("sliver_urn", e.getSliverUrn() == null ? null : e.getSliverUrn().toString());
                r.put("component_urn", e.getComponentUrn() == null ? null : e.getComponentUrn().toString());
                r.put("timestamp", RFC3339Util.instantToRFC3339String((Instant)Instant.ofEpochMilli(e.getTimestamp())));
                return r;
            }).collect(Collectors.toList());
            Object sliverUrn = sliver.getUrn() != null ? sliver.getUrn().toString() : "SLIVER-ON: " + sliver.getServer().getDefaultComponentManagerUrn();
            sliverMap.put("urn", sliverUrn);
            sliverMap.put("status_str", sliver.getStatusString());
            sliverMap.put("status", sliver.getStatus() == null ? null : Objects.toString(sliver.getStatus().getGlobalStatus(), null));
            sliverMap.put("expiration_date", sliver.getExpirationDate() == null ? null : RFC3339Util.instantToRFC3339String((Instant)sliver.getExpirationDate()));
            sliverMap.put("manifest_rspec", sliver.getManifestRspec() != null);
            sliverMap.put("components", components);
            sliverMap.put("error_details", errorDetails);
            sliversRes.add(sliverMap);
        }
        res.put("slivers", sliversRes);
        return res;
    }
}

