/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.util;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Contract;

public class SliceRunDuration {
    public static final Duration LONG_SLICE_DURATION_CUTOFF = Duration.of(2L, ChronoUnit.DAYS);
    public static final Duration SHORT_SLICE_DURATION_CUTOFF = Duration.of(6L, ChronoUnit.HOURS);
    @Nullable
    private final Instant sliceCreation;

    public SliceRunDuration(@Nullable Experiment experiment) {
        this(experiment == null ? null : experiment.getSliceOrNull());
    }

    public SliceRunDuration(@Nullable Slice slice) {
        this(slice == null ? null : slice.getCreationDate());
    }

    public SliceRunDuration(@Nullable Instant sliceCreation) {
        this.sliceCreation = sliceCreation;
    }

    public boolean isLongRunning(boolean nullFallback) {
        if (this.sliceCreation == null) {
            return nullFallback;
        }
        Duration sliceRunDuration = Duration.between(this.sliceCreation, Instant.now());
        return sliceRunDuration.compareTo(LONG_SLICE_DURATION_CUTOFF) > 0;
    }

    public boolean isShortRunning(boolean nullFallback) {
        if (this.sliceCreation == null) {
            return nullFallback;
        }
        Duration sliceRunDuration = Duration.between(this.sliceCreation, Instant.now());
        return sliceRunDuration.compareTo(SHORT_SLICE_DURATION_CUTOFF) < 0;
    }

    private static boolean isDurationLessThan(@Nonnull Duration a, @Nonnull Duration b) {
        return a.compareTo(b) < 0;
    }

    private static boolean isDurationMoreThan(@Nonnull Duration a, @Nonnull Duration b) {
        return a.compareTo(b) > 0;
    }

    public boolean willExpireSoon(@Nullable Instant earliestExpirationDate, boolean nullFallback) {
        if (this.sliceCreation == null || earliestExpirationDate == null) {
            return nullFallback;
        }
        Instant now = Instant.now();
        if (earliestExpirationDate.isBefore(now)) {
            return true;
        }
        Duration sliceRunDuration = Duration.between(this.sliceCreation, now);
        Duration sliceExpiresIn = Duration.between(now, earliestExpirationDate);
        if (SliceRunDuration.isDurationLessThan(sliceRunDuration, Duration.of(10L, ChronoUnit.HOURS))) {
            return SliceRunDuration.isDurationLessThan(sliceExpiresIn, Duration.of(1L, ChronoUnit.HOURS));
        }
        if (SliceRunDuration.isDurationLessThan(sliceRunDuration, Duration.of(3L, ChronoUnit.DAYS))) {
            return SliceRunDuration.isDurationLessThan(sliceExpiresIn, Duration.of(8L, ChronoUnit.HOURS));
        }
        if (SliceRunDuration.isDurationLessThan(sliceRunDuration, Duration.of(7L, ChronoUnit.DAYS))) {
            return SliceRunDuration.isDurationLessThan(sliceExpiresIn, Duration.of(1L, ChronoUnit.DAYS));
        }
        if (SliceRunDuration.isDurationLessThan(sliceRunDuration, Duration.of(14L, ChronoUnit.DAYS))) {
            return SliceRunDuration.isDurationLessThan(sliceExpiresIn, Duration.of(2L, ChronoUnit.DAYS));
        }
        if (SliceRunDuration.isDurationLessThan(sliceRunDuration, Duration.of(30L, ChronoUnit.DAYS))) {
            return SliceRunDuration.isDurationLessThan(sliceExpiresIn, Duration.of(4L, ChronoUnit.DAYS));
        }
        return SliceRunDuration.isDurationLessThan(sliceExpiresIn, Duration.of(10L, ChronoUnit.DAYS));
    }

    @Nonnull
    public Duration getDuration() {
        return this.getDuration(Duration.ZERO);
    }

    @Nullable
    @Contract(value="!null -> !null")
    public Duration getDuration(@Nullable Duration nullFallback) {
        if (this.sliceCreation == null) {
            return nullFallback;
        }
        return Duration.between(this.sliceCreation, Instant.now());
    }
}

