/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.util;

import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.PuTTYFilesKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshFilesKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ssh_terminal_tool.known_hosts.OpenSshKnownHostsFile;
import be.iminds.ilabt.jfed.ssh_terminal_tool.unix.SshAgentHelper;
import be.iminds.ilabt.jfed.util.common.Pair;
import be.iminds.ilabt.jfed.util.tmp_file_helpers.PermanentFile;
import be.iminds.ilabt.jfed.util.tmp_file_helpers.TmpFile;
import com.google.common.net.InetAddresses;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshCommandBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SshCommandBuilder.class);
    @Nonnull
    private final JFedHLPreferences jFedPreferences;
    @Nonnull
    private final OpenSshKnownHostsFile openSshKnownHostsFile;
    @Nullable
    private final KeyPasswordRequester keyPasswordRequester;
    private String targetServerUserName;
    private String hostName;
    private int port = -1;
    private List<PuTTYFilesKeyInfo> sshKeyInfos;
    private JFedConnection.ProxyInfo proxyInfo;
    private boolean useSshAgent;
    private boolean forcePseudoTerminal = false;

    SshCommandBuilder(@Nonnull GeniUserProvider geniUserProvider, @Nonnull JFedHLPreferences jFedPreferences, @Nonnull OpenSshKnownHostsFile openSshKnownHostsFile, @Nullable KeyPasswordRequester keyPasswordRequester) {
        this.jFedPreferences = jFedPreferences;
        this.openSshKnownHostsFile = openSshKnownHostsFile;
        this.keyPasswordRequester = keyPasswordRequester;
        ArrayList<PuTTYFilesKeyInfo> sshKeyInfos = new ArrayList<PuTTYFilesKeyInfo>();
        PuTTYFilesKeyInfo customSshKeyInfo = jFedPreferences.getCustomSshKeyInfo();
        if (customSshKeyInfo != null) {
            LOG.info("ExternalSshTerminal: The preferences are overriding the SSH key used (" + customSshKeyInfo.getClass().getName() + ").");
            sshKeyInfos.add(customSshKeyInfo);
        }
        if (jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_USE_LOGIN_KEY, false) || sshKeyInfos.isEmpty()) {
            LOG.info("ExternalSshTerminal: The user's SSH key will be used.");
            sshKeyInfos.add((PuTTYFilesKeyInfo)SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)geniUserProvider.getLoggedInGeniUser()));
        }
        this.sshKeyInfos = sshKeyInfos;
    }

    public Pair<String, List<TmpFile>> build(boolean useDummyValuesForKeysIfNeeded) {
        String resSshCommand;
        if (!this.hasNeededData()) {
            throw new IllegalStateException("Cannot build: not all needed setters were called");
        }
        ArrayList<TmpFile> tmpFiles = new ArrayList<TmpFile>();
        if (this.useSshAgent) {
            for (SshFilesKeyInfo sshFilesKeyInfo : this.sshKeyInfos) {
                try {
                    if (!this.unlockIfNeeded(sshFilesKeyInfo)) {
                        LOG.warn("Skipping ssh agent key because user did not unlock it.");
                        continue;
                    }
                    SshAgentHelper.registerKey((SshFilesKeyInfo)sshFilesKeyInfo);
                }
                catch (Exception e) {
                    LOG.warn("ssh-add failed: sshKeyInfo.hasUnencryptedPrivateKey=" + sshFilesKeyInfo.hasUnencryptedPrivateKey(), (Throwable)e);
                }
            }
        }
        if (this.proxyInfo == null) {
            resSshCommand = this.jFedPreferences.getString(HLPreferenceKey.PREF_COMMAND_SSH);
            if (resSshCommand == null) {
                resSshCommand = "ssh -A -X -oServerAliveInterval=120 -i '$i' $u@$h -oPort=$p";
            }
        } else {
            boolean bl;
            assert (this.proxyInfo instanceof JFedConnection.SshProxyInfo);
            JFedConnection.SshProxyInfo sshProxyInfo = (JFedConnection.SshProxyInfo)this.proxyInfo;
            if (sshProxyInfo.getHostKey() != null) {
                this.openSshKnownHostsFile.addKnownHost(sshProxyInfo.getHostname(), sshProxyInfo.getHostKey());
            }
            if ((resSshCommand = this.jFedPreferences.getString(HLPreferenceKey.PREF_COMMAND_SSH_PROXY)) == null) {
                resSshCommand = "ssh -A -X -oServerAliveInterval=120 -i '$i' $u@$h -oPort=$p -oProxyCommand=\"ssh -i '$I' -oPort=$P $U@$H -W %h:%p\"";
            }
            resSshCommand = resSshCommand.replace("$P", "" + sshProxyInfo.getPort());
            resSshCommand = resSshCommand.replace("$H", sshProxyInfo.getHostname());
            resSshCommand = resSshCommand.replace("$U", sshProxyInfo.getUsername());
            if (sshProxyInfo.getSshKeyInfo() != null) {
                assert (sshProxyInfo.getSshKeyInfo() instanceof SshFilesKeyInfo) : "sshProxyInfo.getSshKeyInfo() -> " + sshProxyInfo.getSshKeyInfo().getClass().getName();
                SshFilesKeyInfo sshFilesKeyInfo = (SshFilesKeyInfo)sshProxyInfo.getSshKeyInfo();
                if (useDummyValuesForKeysIfNeeded) {
                    Object object = tmpFile = sshFilesKeyInfo.isLocked() && !sshFilesKeyInfo.canReturnLockedPrivateKeyFile() ? null : sshFilesKeyInfo.getPrivateKeyFile();
                    resSshCommand = tmpFile instanceof PermanentFile ? resSshCommand.replace("$I", tmpFile.getFilename()) : resSshCommand.replace("$I", "<PEM file>");
                } else if (this.useSshAgent) {
                    if (!this.unlockIfNeeded(sshFilesKeyInfo)) {
                        LOG.warn("Skipping ssh agent key because user did not unlock it.");
                    } else {
                        tmpFile = sshFilesKeyInfo.getPrivateKeyFile();
                        tmpFiles.add(tmpFile);
                        resSshCommand = resSshCommand.replace("$I", tmpFile.getFilename());
                        try {
                            SshAgentHelper.registerKey((SshFilesKeyInfo)sshFilesKeyInfo);
                        }
                        catch (SshAgentHelper.SshAgentHelperException e) {
                            LOG.error("Problem registering user SSH keys when starting terminal. Login might fail.", (Throwable)e);
                        }
                    }
                } else {
                    tmpFile = sshFilesKeyInfo.getUnencryptedPrivateKeyFile();
                    tmpFiles.add(tmpFile);
                    resSshCommand = resSshCommand.replace("$I", tmpFile.getFilename());
                }
            }
            boolean bl2 = bl = this.hostName.contains(":") && InetAddresses.isInetAddress((String)this.hostName);
            if (bl && resSshCommand.contains(" -W %h:%p")) {
                resSshCommand = resSshCommand.replace(" -W %h:%p", " -W [%h]:%p");
            }
        }
        if (this.forcePseudoTerminal) {
            resSshCommand = resSshCommand.replaceFirst("^ssh ", "ssh -tt ");
        }
        resSshCommand = resSshCommand.replace("$p", "" + this.port);
        resSshCommand = resSshCommand.replace("$h", this.hostName);
        resSshCommand = resSshCommand.replace("$u", this.targetServerUserName);
        Object iReplacement = null;
        boolean bl = resSshCommand.contains("-i $i");
        boolean isQuotedDefaultIOption = resSshCommand.contains("-i '$i'");
        boolean isDoubleQuotedDefaultIOption = resSshCommand.contains("-i \"$i\"");
        if (!(bl || isQuotedDefaultIOption || isDoubleQuotedDefaultIOption)) {
            LOG.warn("isDefaultIOption=false for sshCommand=\"" + resSshCommand + "\"");
        }
        for (SshFilesKeyInfo sshFilesKeyInfo : this.sshKeyInfos) {
            String privKeyFilename;
            LOG.debug("launchTerminal sshKeyInfo class: " + sshFilesKeyInfo.getClass().getName() + " isDefaultIOption=" + bl + " iReplacement=\"" + iReplacement + "\"");
            if (!this.unlockIfNeeded(sshFilesKeyInfo)) {
                LOG.warn("Skipping command key because user did not unlock it.");
                continue;
            }
            TmpFile privKeyFile = sshFilesKeyInfo.getPrivateKeyFile();
            if (useDummyValuesForKeysIfNeeded) {
                privKeyFilename = privKeyFile instanceof PermanentFile ? privKeyFile.getFilename() : "<PEM file>";
            } else {
                privKeyFilename = privKeyFile.getFilename();
                tmpFiles.add(privKeyFile);
            }
            if (privKeyFilename != null) {
                if (iReplacement == null) {
                    iReplacement = privKeyFilename;
                    continue;
                }
                if (bl || isQuotedDefaultIOption || isDoubleQuotedDefaultIOption) {
                    if (bl) {
                        iReplacement = (String)iReplacement + " -i " + privKeyFilename;
                    }
                    if (isQuotedDefaultIOption) {
                        iReplacement = (String)iReplacement + "' -i '" + privKeyFilename;
                    }
                    if (!isDoubleQuotedDefaultIOption) continue;
                    iReplacement = (String)iReplacement + "\" -i \"" + privKeyFilename;
                    continue;
                }
                LOG.warn("sshCommand used is not using default openSSH -i option -> Will only use first private key to login!");
                continue;
            }
            throw new RuntimeException("No private key file specified, cannot use SSH login. sshKeyInfo class: " + sshFilesKeyInfo.getClass().getName());
        }
        if (iReplacement == null) {
            throw new RuntimeException("Could not replace $i in sshCommand");
        }
        LOG.debug("Using final iReplacement=\"" + iReplacement + "\"");
        resSshCommand = resSshCommand.replace("$i", (CharSequence)iReplacement);
        return new Pair((Object)resSshCommand, tmpFiles);
    }

    private boolean unlockIfNeeded(@Nonnull SshFilesKeyInfo sshKeyInfo) {
        if (sshKeyInfo.isLocked() && !sshKeyInfo.canReturnLockedPrivateKeyFile()) {
            char[] pass = this.keyPasswordRequester.requestPassword("PEM Key requires a password to unlock (key will be ignored if no password given)");
            if (pass != null) {
                sshKeyInfo.unlock(pass);
                return true;
            }
            return false;
        }
        return true;
    }

    public void setTargetServerUserName(@Nonnull String targetServerUserName) {
        this.targetServerUserName = targetServerUserName;
    }

    public void setHostName(@Nonnull String hostName) {
        this.hostName = hostName;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void overrideSshKeyInfos(@Nonnull List<PuTTYFilesKeyInfo> sshKeyInfos) {
        this.sshKeyInfos = sshKeyInfos;
    }

    public void setProxyInfo(@Nullable JFedConnection.ProxyInfo proxyInfo) {
        this.proxyInfo = proxyInfo;
    }

    public void setUseSshAgent(boolean useSshAgent) {
        this.useSshAgent = useSshAgent;
    }

    public boolean hasNeededData() {
        return this.targetServerUserName != null && this.hostName != null && this.port > 0;
    }

    public void setForcePseudoTerminal(boolean forcePseudoTerminal) {
        this.forcePseudoTerminal = forcePseudoTerminal;
    }

    public String getTargetServerUserName() {
        return this.targetServerUserName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public List<PuTTYFilesKeyInfo> getSshKeyInfos() {
        return this.sshKeyInfos;
    }

    public JFedConnection.ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public boolean isUseSshAgent() {
        return this.useSshAgent;
    }

    public boolean isForcePseudoTerminal() {
        return this.forcePseudoTerminal;
    }

    public static interface KeyPasswordRequester {
        @Nullable
        public char[] requestPassword(String var1);
    }
}

