/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.log_cache;

import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetails;
import be.iminds.ilabt.jfed.log.ApiCallDetails;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.log.ResultListener;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsCache;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsRef;
import be.iminds.ilabt.jfed.log_cache.DiskApiCallDetailsCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.TransformationList;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.LoggerFactory;

@Singleton
public class AllApiCallsList
implements ResultListener {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(AllApiCallsList.class);
    private final ListProperty<ApiCallDetailsRef> allCalls;
    private final Logger logger;
    private final ApiCallDetailsCache cache;

    @Inject
    public AllApiCallsList(Logger logger, ApiCallDetailsCache cache) {
        this.logger = logger;
        this.cache = cache;
        this.allCalls = new SimpleListProperty(FXCollections.observableArrayList());
        if (cache instanceof DiskApiCallDetailsCache) {
            DiskApiCallDetailsCache diskCache = (DiskApiCallDetailsCache)cache;
            diskCache.flushOld();
            diskCache.reduceOld();
            this.allCalls.addAll(diskCache.loadExisting());
        }
        this.logger.addResultListener((ResultListener)this);
    }

    public void onResult(ApiCallDetails result) {
        try {
            ApiCallDetailsRef ref = this.cache.registerApiCallDetails(result);
            Platform.runLater(() -> {
                ListProperty<ApiCallDetailsRef> listProperty = this.allCalls;
                synchronized (listProperty) {
                    this.allCalls.add((Object)ref);
                }
            });
        }
        catch (Exception e) {
            LOG.error("AllApiCallsList failed to log a call", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ApiCallDetailsRef> getCalls() {
        ListProperty<ApiCallDetailsRef> listProperty = this.allCalls;
        synchronized (listProperty) {
            return new ArrayList<ApiCallDetailsRef>((Collection<ApiCallDetailsRef>)this.allCalls);
        }
    }

    public ObservableList<ApiCallDetailsRef> getObservableCalls() {
        return FXCollections.unmodifiableObservableList(this.allCalls);
    }

    public ReadOnlyIntegerProperty getObservableCallsSize() {
        return this.allCalls.sizeProperty();
    }

    public ObservableList<SerializableApiCallDetails> getObservablSerializableCalls() {
        return FXCollections.unmodifiableObservableList((ObservableList)new TransformationList<SerializableApiCallDetails, ApiCallDetailsRef>(this.allCalls){

            public int size() {
                return this.getSource().size();
            }

            public SerializableApiCallDetails get(int index) {
                return AllApiCallsList.this.cache.getFullApiDetails((ApiCallDetailsRef)this.getSource().get(index));
            }

            protected void sourceChanged(final ListChangeListener.Change<? extends ApiCallDetailsRef> c) {
                ListChangeListener.Change<SerializableApiCallDetails> newChange = new ListChangeListener.Change<SerializableApiCallDetails>((ObservableList)this){

                    public boolean next() {
                        return c.next();
                    }

                    public void reset() {
                        c.reset();
                    }

                    public int getFrom() {
                        return c.getFrom();
                    }

                    public int getTo() {
                        return c.getTo();
                    }

                    public List<SerializableApiCallDetails> getRemoved() {
                        return Collections.emptyList();
                    }

                    protected int[] getPermutation() {
                        return new int[0];
                    }
                };
                this.fireChange((ListChangeListener.Change)newChange);
            }

            public int getSourceIndex(int index) {
                return index;
            }

            public int getViewIndex(int index) {
                return index;
            }
        });
    }

    public ApiCallDetailsCache getCache() {
        return this.cache;
    }
}

