#!/bin/sh

# First a serious hack: This first part runs differently in sh and in python:
#     - In python, it's just ignored (2 string that are concatted)
#     - In sh, '''\' is seen as literal \. That is the argument to "true", and "true" just does nothing, ignoring its argument

# This hack allows sh to find a specific version of python and then exec that python with the script and its arguments
"true" '''\'

if which python2 >/dev/null 2>&1; then
    PYTHON_EXE=$(which python2)
     echo "Using ${PYTHON_EXE}" 1>&2
    exec "${PYTHON_EXE}" "$0" "$@"
elif which python >/dev/null 2>&1; then
     PYTHON_EXE=$(which python)
      echo "Using ${PYTHON_EXE}" 1>&2
     exec "${PYTHON_EXE}" "$0" "$@"
elif which python3 >/dev/null 2>&1; then
     PYTHON_EXE=$(which python3)
      echo "Using ${PYTHON_EXE}" 1>&2
     exec "${PYTHON_EXE}" "$0" "$@"
else
     echo 'python not found'
     exit 127
fi
'''


import json
import os
import socket
import time
import traceback
import xml.etree.ElementTree as elementtree
import sys
import subprocess

# DEBUG=True
DEBUG=False

if len(sys.argv) < 4:
    sys.stderr.write("Syntax error: {} <self client_id> <self iface client_id> <target hostname> ...\n".format(sys.argv[0]))
    sys.exit(1)

node_client_id = sys.argv[1]
iface_client_id = sys.argv[2]
targets = sys.argv[3:]

# Finds local interface name

def has_tool(tool_name):
    try:
        tool_loc = subprocess.check_output('which {}'.format(tool_name), shell=True).strip()
        if isinstance(tool_loc, bytes):
            return b'bin' in tool_loc
        else:
            return 'bin' in tool_loc
    except subprocess.CalledProcessError as e:
        return False


has_ifconfig = has_tool('ifconfig')
has_ip = has_tool('ip')
has_ethtool = has_tool('ethtool')
has_ping = has_tool('ping')
has_geni_get = has_tool('geni-get')
has_python2 = has_tool('python2')
has_python = has_tool('python')

if not has_geni_get:
    sys.stderr.write('Missing geni-get. Cannot continue.\n')
    sys.exit(1)

if not has_python2:
    sys.stderr.write('Missing python2 which geni-get requires. Cannot continue.\n')
    sys.exit(1)

if not has_python:
    sys.stderr.write('Missing python which geni-get requires to point to python2. Cannot continue.\n')
    sys.exit(1)

# TODO patch geni-get if it starts with
#     #!/usr/bin/env python
# Forcing it to use:
#     #!/usr/bin/env python2

if not has_ifconfig and not has_ip:
    sys.stderr.write('Missing both ifconfig and ip tool. Cannot continue.\n')
    sys.exit(1)

def fullmac(shortmac):
    res = ''
    help = 0
    for c in shortmac:
        if help in [2,4,6,8,10]:
            res += ':'
        res += c
        help += 1
    return res

def lookupdev(mac):
    if not has_ifconfig and not has_ip:
        return 'unknown'
    try:
        if has_ip:
            devname = subprocess.check_output("ip -o link show | grep -i 'link/ether "+mac+"'", shell=True).strip().split(' ', 2)[1][:-1].split('@',1)[0]
        else:
            devname = subprocess.check_output("ifconfig -a | grep -i 'HWaddr "+mac+"'", shell=True).strip().split(' ', 1)[0]
    except subprocess.CalledProcessError as e:
        devname = 'unknown'
    return devname

def measure_thoughput(target_host):
    port = 8105
    pack_len = 1500

    try:
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.connect((target_host, port))

        header = node_client_id + '\n'
        msg = header + ('A' * int(pack_len - len(header)))

        start = time.time()
        now = time.time()
        while now - start < 0.5:
            s.send(msg.encode("utf-8"))
            now = time.time()
        s.send('**END**')

        bw_reply = s.recv(100).decode()

        if DEBUG:
            print('measure_thoughput rcv: "{}"'.format(bw_reply))

        s.close()

        # print("Finished testing {}.".format(target_host))
        return float(bw_reply)
    except:
        traceback.print_exc(file=sys.stderr)
        return None

manifest = subprocess.check_output("geni-get manifest", shell=True)

namespaces = {'ns': 'http://www.geni.net/resources/rspec/3', 'emulab': 'http://www.protogeni.net/resources/rspec/ext/emulab/1'}

root = elementtree.fromstring(manifest)

devname = None

for iface in root.findall('.//ns:node[@client_id="' + node_client_id + '"]/ns:interface[@client_id="' + iface_client_id + '"]', namespaces):
    mac = iface.get('mac_address')
    fmac = fullmac(mac)
    devname = lookupdev(fmac)

if not devname:
    sys.stderr.write('Could not find iface for node={} iface={}. Cannot continue.\n'
                     .format(node_client_id, iface_client_id))
    sys.exit(1)

report_list = []

# Fetch link bitrate (once per iface)

# ~ $ ethtool eno1 | grep Speed
# Cannot get wake-on-lan settings: Operation not permitted
# 	Speed: 100Mb/s
# ~ $ cat /sys/class/net/eno1/speed
# 100
speed = None
# if has_ethtool:
#     speed = subprocess.check_output("ethtool {}", shell=True)
#     todo: process ethtool reply
# else:
# for now, we assume this method always works:
speed_filename = '/sys/class/net/{}/speed'.format(devname)
if os.path.isfile(speed_filename):
    with open(speed_filename, 'r') as s:
        speed = int(s.read().strip())


for target in targets:
    report = {
        'node_client_id': node_client_id,
        'iface_client_id': iface_client_id,
        'target': target,
        'iface_dev': devname,
        'iface_speed': speed
    }

    # Test connectivity
    ping_result = None
    try:
        if has_ping:
            ping_reply = subprocess.check_output('ping -c 1 -n -q -W 1 {}'
                                    .format(target), shell=True, stderr=subprocess.STDOUT).decode()
            ping_result = '0% packet loss' in ping_reply
    except:
        ping_result = False
        traceback.print_exc(file=sys.stderr)
    report['ping'] = ping_result

    # Measure throughput
    try:
        bw = measure_thoughput(target)
    except Exception as e:
        bw = None
        traceback.print_exc(file=sys.stderr)
    report['measured_bw'] = bw

    # TODO: measure packet loss
    report['loss'] = 0.0

    report_list.append(report)

# report all as json
print(json.dumps(report_list))
sys.exit(0)
