/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.util.jsonld.impl;

import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithUri;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PrimaryIdObject<IdType>
implements JsonLdObjectWithId<IdType>,
JsonLdObjectWithUri {
    private static final Logger LOG = LoggerFactory.getLogger(PrimaryIdObject.class);
    protected final IdType id;
    protected final URI uri;
    protected final boolean serializeInfo_SerializeAsEmbeddedObject;
    private static ObjectMapper mapper = null;

    public PrimaryIdObject(IdType id, URI uri, boolean serializeInfo_SerializeAsEmbeddedObject) {
        this.id = id;
        this.uri = uri;
        this.serializeInfo_SerializeAsEmbeddedObject = serializeInfo_SerializeAsEmbeddedObject;
    }

    public PrimaryIdObject(IdType id, URI uri) {
        this(id, uri, JsonLdObjectsMetaData.mustSerializeAsEmbeddedObjectForJacksonConstructor());
    }

    @Override
    @JsonProperty(value="id")
    public IdType getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="@id")
    public URI getUri() {
        return this.uri;
    }

    @Override
    @JsonProperty(value="@type")
    public String getClassName() {
        return this.getClass().getSimpleName();
    }

    @JsonProperty(value="@type")
    private void setClassName(String className) {
        if (!this.getClass().getSimpleName().equals(className)) {
            throw new IllegalArgumentException("@type must be " + this.getClass().getSimpleName());
        }
    }

    @Override
    @JsonIgnore
    public boolean getSerializeAsEmbeddedObject() {
        return this.serializeInfo_SerializeAsEmbeddedObject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrimaryIdObject)) {
            return false;
        }
        PrimaryIdObject that = (PrimaryIdObject)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return this.uri != null ? this.uri.equals(that.uri) : that.uri == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        return result;
    }

    public String toString() {
        if (mapper == null) {
            mapper = new ObjectMapper();
        }
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting " + this.getClass().getSimpleName() + " to JSON", (Throwable)e);
            return "Exception converting " + this.getClass().getSimpleName() + " to JSON: " + e.getMessage();
        }
    }
}

