/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api;

import be.iminds.ilabt.jfed.lowlevel.connection.ApiCallReply;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaApiCallReply;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.UnknownResponseCodeException;
import be.iminds.ilabt.jfed.lowlevel.connection.XMLRPCCallDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.XMLRPCCallDetailsWithCodeValueError;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.SfaCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.AbstractApi;
import be.iminds.ilabt.jfed.lowlevel.lib.BadReplyGeniException;
import be.iminds.ilabt.jfed.lowlevel.lib.CredentialException;
import be.iminds.ilabt.jfed.lowlevel.lib.GeniUniformFederationApiResponseCode;
import be.iminds.ilabt.jfed.lowlevel.lib.ReplyConverter;
import be.iminds.ilabt.jfed.lowlevel.lib.RetrySettings;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import com.google.common.collect.ForwardingList;
import com.google.common.collect.ForwardingMap;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFederationApi
extends AbstractApi {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFederationApi.class);
    protected boolean handleMalformedReplies = true;

    protected <T> FederationApiReply<T> executeAndLogXmlRpcCommandGeni(@Nullable Map<String, Object> methodParams, @Nonnull SfaConnection con, @Nonnull String methodJavaName, @Nonnull String methodGeniName, @Nonnull List<Object> args, @Nonnull ReplyConverter<T> replyConverter) throws JFedException {
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, methodJavaName, methodGeniName, args, replyConverter, null);
    }

    protected <T> FederationApiReply<T> executeAndLogXmlRpcCommandGeni(@Nullable Map<String, Object> methodParams, @Nonnull SfaConnection con, @Nonnull String methodJavaName, @Nonnull String methodGeniName, @Nonnull List<Object> args, @Nonnull ReplyConverter<T> replyConverter, @Nullable T defaultValue) throws JFedException {
        FederationApiReply<T> r;
        XMLRPCCallDetailsWithCodeValueError res = this.executeXmlRpcCommandGeni(con, methodGeniName, args, methodParams == null ? Collections.emptyMap() : methodParams);
        Object resultValueObject = res.getResultValueObject();
        if (resultValueObject != null && !Objects.equals(resultValueObject, 0)) {
            try {
                r = new FederationApiReply<T>(res, replyConverter.convertXMLRPCCall(resultValueObject));
            }
            catch (AssertionError | Exception t) {
                this.handleErrorProcessingArguments(res, methodJavaName, methodGeniName, con, (Throwable)t);
                r = null;
            }
        } else {
            r = null;
        }
        if (r == null) {
            r = new FederationApiReply<T>(res, defaultValue);
        }
        this.log((XMLRPCCallDetails)res, (ApiCallReply)r, methodJavaName, methodGeniName, con, methodParams);
        return r;
    }

    protected void handleErrorProcessingArguments(XMLRPCCallDetailsWithCodeValueError res, String methodJavaName, String methodGeniName, SfaConnection con, Throwable t) throws JFedException {
        if (!this.handleMalformedReplies && this.isCallSuccess(res)) {
            this.log((XMLRPCCallDetails)res, null, methodJavaName, methodGeniName, con, null);
            throw new JFedException("Error parsing " + methodGeniName + " reply: " + (t == null ? "null" : t.getMessage()), t, (XMLRPCCallDetails)res);
        }
        LOG.error("Error parsing {} reply: {}", new Object[]{methodGeniName, t.getMessage(), t});
    }

    private boolean isCallSuccess(XMLRPCCallDetailsWithCodeValueError res) {
        Object resultCode = res.getResultCode();
        if (resultCode == null) {
            return false;
        }
        if (!(resultCode instanceof Integer)) {
            return false;
        }
        try {
            GeniUniformFederationApiResponseCode genicode = GeniUniformFederationApiResponseCode.getByCode((Integer)resultCode);
            return genicode.isSuccess();
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @Override
    protected boolean isPossibleTemporaryErrorReply(@Nullable XMLRPCCallDetails res) {
        if (res instanceof XMLRPCCallDetailsWithCodeValueError) {
            XMLRPCCallDetailsWithCodeValueError geniDetails = (XMLRPCCallDetailsWithCodeValueError)res;
            if (!(geniDetails.getResultCode() instanceof Map)) {
                return false;
            }
            Map codeStruct = (Map)geniDetails.getResultCode();
            if (codeStruct == null || !codeStruct.containsKey("geni_code")) {
                return false;
            }
            int code = (Integer)codeStruct.get("geni_code");
            if (code == 3 && Objects.equals(geniDetails.getResultOutput().trim(), "Credential owner does not match speaksfor target")) {
                LOG.warn("Received \"Credential owner does not match speaksfor target\" error. Will handle this as \"possible temporary error\" and try again.");
                return true;
            }
        }
        return false;
    }

    public static boolean isBusyApiReply(@Nullable XMLRPCCallDetails res) {
        if (res == null) {
            return false;
        }
        if (res instanceof XMLRPCCallDetailsWithCodeValueError) {
            XMLRPCCallDetailsWithCodeValueError geniDetails = (XMLRPCCallDetailsWithCodeValueError)res;
            if (geniDetails.getResultCode() == null) {
                return false;
            }
            int code = GeniUniformFederationApiResponseCode.NONE.getCode();
            if (geniDetails.getResultCode() instanceof Map) {
                Map codeStruct = (Map)geniDetails.getResultCode();
                code = (Integer)codeStruct.get("geni_code");
            }
            if (geniDetails.getResultCode() instanceof Integer) {
                code = (Integer)geniDetails.getResultCode();
            }
            try {
                return GeniUniformFederationApiResponseCode.getByCode(code).isBusy();
            }
            catch (UnknownResponseCodeException e) {
                LOG.warn("Unknown response code {} encountered while checking for busy", (Object)code, (Object)e);
            }
        }
        return false;
    }

    @Override
    protected boolean isBusyReply(@Nullable XMLRPCCallDetails res) {
        return AbstractFederationApi.isBusyApiReply(res);
    }

    public AbstractFederationApi(be.iminds.ilabt.jfed.log.Logger logger, RetrySettings retrySettings, ApiInfo.Api serverType, JFedPreferences jFedPreferences) {
        super(logger, retrySettings, serverType, jFedPreferences);
    }

    public static List<AnyCredential> apiSpecifiesListOfCredentials(String credentialBaseName, Object o) throws BadReplyGeniException {
        List<Map> vectOfDicts = AbstractApi.apiSpecifiesListOfT(Map.class, o);
        int i = 0;
        ArrayList<AnyCredential> res = new ArrayList<AnyCredential>();
        for (Map ht : vectOfDicts) {
            AnyCredential cred;
            Object credName = credentialBaseName;
            if (vectOfDicts.size() > 1) {
                credName = (String)credName + " " + i;
            }
            try {
                GeniUrn targetUrn;
                SfaCredential sfaCred;
                cred = AnyCredential.createFromV3Map((String)credName, ht);
                String type = cred.getType();
                Object targetName = null;
                if (cred instanceof SfaCredential && (sfaCred = (SfaCredential)cred).getTargetUrn() != null && (targetUrn = GeniUrn.parse((String)sfaCred.getTargetUrn())) != null) {
                    targetName = targetUrn.getResourceType() + "+" + targetUrn.getResourceName();
                }
                Object fullName = cred.getName();
                if (type != null && !type.trim().isEmpty()) {
                    fullName = (String)fullName + " [" + type + "]";
                }
                if (targetName != null && !((String)targetName).trim().isEmpty()) {
                    fullName = (String)fullName + " " + (String)targetName;
                }
                cred.setName((String)fullName);
            }
            catch (CredentialException e) {
                throw new BadReplyGeniException("Response contains an invalid credential", e);
            }
            res.add(cred);
            ++i;
        }
        return res;
    }

    @Nonnull
    public abstract List<GetVersionResult.FieldInfo> getMinimumFields(String var1);

    @Nonnull
    public List<String> getMinimumFieldNames(@Nonnull String objectName) {
        return this.getMinimumFields(objectName).stream().map(GetVersionResult.FieldInfo::getName).collect(Collectors.toList());
    }

    @Nonnull
    public Map<String, String> getMinimumFieldsMap(@Nonnull String objectName) {
        return this.getMinimumFieldNames(objectName).stream().collect(Collectors.toMap(key -> key, key -> key + " value"));
    }

    public abstract List<String> getApiObjects();

    public abstract List<String> getOptionalApiServices();

    public abstract List<String> getRequiredApiServices();

    public void setHandleMalformedReplies(boolean handleErrors) {
        this.handleMalformedReplies = handleErrors;
    }

    public static class FederationApiReply<T>
    implements SfaApiCallReply<T> {
        @Nonnull
        private final GeniUniformFederationApiResponseCode genicode;
        private final T val;
        private final String output;
        private final Map rawResult;
        private final XMLRPCCallDetailsWithCodeValueError xmlRpcCallDetailsWithCodeValueError;

        public int getCode() {
            return this.genicode.getCode();
        }

        @Nonnull
        public GeniUniformFederationApiResponseCode getGeniResponseCode() {
            return this.genicode;
        }

        @Nullable
        public T getValue() {
            return this.val;
        }

        @Nullable
        public String getOutput() {
            return this.output;
        }

        @Nullable
        public XMLRPCCallDetailsWithCodeValueError getXmlRpcCallDetailsWithCodeValueError() {
            return this.xmlRpcCallDetailsWithCodeValueError;
        }

        public static boolean isSuccess(XMLRPCCallDetails res) {
            if (res instanceof XMLRPCCallDetailsWithCodeValueError) {
                GeniUniformFederationApiResponseCode genicode;
                XMLRPCCallDetailsWithCodeValueError geniDetails = (XMLRPCCallDetailsWithCodeValueError)res;
                if (!(geniDetails.getResultCode() instanceof Integer)) {
                    return false;
                }
                int code = (Integer)geniDetails.getResultCode();
                try {
                    genicode = GeniUniformFederationApiResponseCode.getByCode(code);
                }
                catch (UnknownResponseCodeException e) {
                    LOG.error("UnknownResponseCodeException: \"" + e.getMessage() + "\" -> will be treated as unsuccessful", (Throwable)e);
                    genicode = GeniUniformFederationApiResponseCode.SERVER_REPLY_ERROR;
                }
                return genicode.isSuccess();
            }
            return false;
        }

        public FederationApiReply(XMLRPCCallDetailsWithCodeValueError res, T val) {
            GeniUniformFederationApiResponseCode c;
            int code;
            this.xmlRpcCallDetailsWithCodeValueError = res;
            this.rawResult = res.getResult();
            this.val = val;
            Object codeObject = res.getResultCode();
            if (codeObject != null) {
                if (codeObject instanceof Integer) {
                    code = (Integer)codeObject;
                } else {
                    LOG.error("Reply parse error: codeObject is not Integer but " + codeObject.getClass().getName());
                    code = GeniUniformFederationApiResponseCode.SERVER_REPLY_ERROR.getCode();
                }
            } else {
                LOG.error("Reply parse error: codeObject=null");
                code = GeniUniformFederationApiResponseCode.SERVER_REPLY_ERROR.getCode();
            }
            try {
                c = GeniUniformFederationApiResponseCode.getByCode(code);
            }
            catch (UnknownResponseCodeException e) {
                LOG.error("UnknowResponseCodeException: \"" + e.getMessage() + "\"  codeObject=" + codeObject, (Throwable)e);
                c = GeniUniformFederationApiResponseCode.SERVER_REPLY_ERROR;
            }
            this.genicode = c;
            String o = null;
            Map r = res.getResult();
            if (r != null && r.get("output") != null) {
                o = r.get("output").toString();
                if (r.get("output") instanceof Map && ((Map)r.get("output")).isEmpty()) {
                    o = "";
                }
                if (r.get("output") instanceof Object[] && ((Object[])r.get("output")).length == 0) {
                    o = "";
                }
            }
            this.output = o;
        }

        @Nullable
        public Map getRawResult() {
            return this.rawResult;
        }

        @Nullable
        public Object getRawValue() {
            if (this.rawResult == null) {
                return null;
            }
            return this.rawResult.get("value");
        }

        @Nullable
        public XMLRPCCallDetailsWithCodeValueError getXMLRPCCallDetailsWithCodeValueError() {
            return this.xmlRpcCallDetailsWithCodeValueError;
        }

        @Nullable
        public XMLRPCCallDetails getXMLRPCCallDetails() {
            return this.xmlRpcCallDetailsWithCodeValueError;
        }
    }

    public static class MemberKeyInfoList
    extends LookupResult<MemberKeyInfo> {
        public MemberKeyInfoList(@Nonnull Object res) throws BadReplyGeniException {
            super(res, MemberKeyInfo::new);
        }
    }

    public static class MemberKeyInfo {
        private final String keyId;
        private final GeniUrn keyMember;
        private final String publicKey;
        private final String privateKey;
        private final String keyDescription;

        public MemberKeyInfo(@Nonnull Object resultObjectValue) throws BadReplyGeniException {
            this(AbstractApi.apiSpecifiesMapStringToObject(resultObjectValue));
        }

        public MemberKeyInfo(Map<String, Object> raw) throws BadReplyGeniException {
            this.keyId = AbstractApi.apiSpecifiesStringInMap(raw, "KEY_ID");
            this.keyMember = AbstractApi.apiSpecifiesGeniUrnInMap(raw, "KEY_MEMBER");
            this.publicKey = AbstractApi.apiSpecifiesStringInMap(raw, "KEY_PUBLIC");
            this.privateKey = raw.containsKey("KEY_PRIVATE") ? AbstractApi.apiSpecifiesStringInMap(raw, "KEY_PRIVATE") : null;
            this.keyDescription = AbstractApi.apiSpecifiesStringInMap(raw, "KEY_DESCRIPTION");
        }

        public String getKeyId() {
            return this.keyId;
        }

        public String getPublicKey() {
            return this.publicKey;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public String getKeyDescription() {
            return this.keyDescription;
        }

        public GeniUrn getKeyMember() {
            return this.keyMember;
        }

        public String toString() {
            return "MemberKeyInfo{keyId='" + this.keyId + "', keyMember=" + this.keyMember + ", publicKey='" + this.publicKey + "', privateKey='" + this.privateKey + "', keyDescription='" + this.keyDescription + "'}";
        }
    }

    public static class MemberInfoList
    extends LookupResult<MemberInfo> {
        public MemberInfoList(@Nonnull Object res) throws BadReplyGeniException {
            super(res, MemberInfo::new);
        }
    }

    public static class MemberInfo {
        private final GeniUrn memberUrn;
        private final String memberUid;
        private final String firstname;
        private final String lastname;
        private final String username;
        private final String email;
        private final List<X509Certificate> x509pemCerts;

        public MemberInfo(Map<String, Object> raw) throws BadReplyGeniException {
            this.memberUrn = raw.containsKey("MEMBER_URN") ? AbstractApi.apiSpecifiesGeniUrnInMap(raw, "MEMBER_URN") : null;
            this.memberUid = raw.containsKey("MEMBER_UID") ? AbstractApi.apiSpecifiesStringInMap(raw, "MEMBER_UID") : null;
            this.firstname = raw.containsKey("MEMBER_FIRSTNAME") ? AbstractApi.apiSpecifiesStringInMap(raw, "MEMBER_FIRSTNAME") : null;
            this.lastname = raw.containsKey("MEMBER_LASTNAME") ? AbstractApi.apiSpecifiesStringInMap(raw, "MEMBER_LASTNAME") : null;
            this.username = raw.containsKey("MEMBER_USERNAME") ? AbstractApi.apiSpecifiesStringInMap(raw, "MEMBER_USERNAME") : null;
            this.email = raw.containsKey("MEMBER_EMAIL") ? AbstractApi.apiSpecifiesStringInMap(raw, "MEMBER_EMAIL") : null;
            String x509pemCertsString = null;
            if (raw.get("_GENI_MEMBER_SSL_CERTIFICATE") != null) {
                x509pemCertsString = (String)raw.get("_GENI_MEMBER_SSL_CERTIFICATE");
            } else if (raw.get("_EMULAB_MEMBER_SSL_CERTIFICATE") != null) {
                x509pemCertsString = (String)raw.get("_EMULAB_MEMBER_SSL_CERTIFICATE");
            }
            if (x509pemCertsString != null) {
                this.x509pemCerts = KeyUtil.pemToX509CertificateChain((String)x509pemCertsString);
                if (this.x509pemCerts == null) {
                    throw new BadReplyGeniException("Received an invalid x509 certificate chain");
                }
            } else {
                this.x509pemCerts = null;
            }
        }

        public GeniUrn getMemberUrn() {
            return this.memberUrn;
        }

        public String getMemberUid() {
            return this.memberUid;
        }

        public String getFirstname() {
            return this.firstname;
        }

        public String getLastname() {
            return this.lastname;
        }

        public String getUsername() {
            return this.username;
        }

        public String getEmail() {
            return this.email;
        }

        public List<X509Certificate> getX509pemCerts() {
            return this.x509pemCerts;
        }

        public String toString() {
            return "MemberInfo{memberUrn=" + this.memberUrn + ", memberUid='" + this.memberUid + "', firstname='" + this.firstname + "', lastname='" + this.lastname + "', username='" + this.username + "', email='" + this.email + "', x509pemCerts=" + this.x509pemCerts + "}";
        }
    }

    public static class ProjectInfoListFromListOrMap
    extends ProjectInfoList {
        @Nonnull
        private static Object valueAutoConvertor(@Nonnull Object res) {
            if (res instanceof Map) {
                return new ArrayList(((Map)res).values()).toArray();
            }
            return res;
        }

        public ProjectInfoListFromListOrMap(@Nonnull Object res) throws BadReplyGeniException {
            super(ProjectInfoListFromListOrMap.valueAutoConvertor(res));
        }
    }

    public static class ProjectInfoList
    extends LookupListResult<ProjectInfo> {
        public ProjectInfoList(@Nonnull Object res) throws BadReplyGeniException {
            super(res, ProjectInfo::new);
        }
    }

    public static class ProjectInfoMap
    extends LookupResult<ProjectInfo> {
        public ProjectInfoMap(@Nonnull Object res) throws BadReplyGeniException {
            super(res, ProjectInfo::new);
        }
    }

    public static class ProjectInfo {
        private final GeniUrn projectUrn;
        private final String projectUid;
        private final Date creationDate;
        private final Date expirationDate;
        private final Boolean expired;
        private final String name;
        private final String description;

        public ProjectInfo(@Nonnull Object resultObjectValue) throws BadReplyGeniException {
            this(AbstractApi.apiSpecifiesMapStringToObject(resultObjectValue));
        }

        public ProjectInfo(@Nonnull Map<String, Object> raw) throws BadReplyGeniException {
            this.projectUrn = AbstractApi.apiSpecifiesGeniUrnInMap(raw, "PROJECT_URN");
            this.projectUid = AbstractApi.apiSpecifiesOptionalStringInMap(raw, "PROJECT_UID");
            this.creationDate = AbstractApi.apiSpecifiesOptionalDateInMap(raw, "PROJECT_CREATION");
            this.expirationDate = AbstractApi.apiSpecifiesOptionalDateInMap(raw, "PROJECT_EXPIRATION");
            this.expired = raw.containsKey("PROJECT_EXPIRED") ? TextUtil.objectToBoolean((Object)raw.get("PROJECT_EXPIRED")) : (raw.containsKey("EXPIRED") ? TextUtil.objectToBoolean((Object)raw.get("EXPIRED")) : null);
            this.name = AbstractApi.apiSpecifiesOptionalStringInMap(raw, "PROJECT_NAME");
            this.description = AbstractApi.apiSpecifiesOptionalStringInMap(raw, "PROJECT_DESCRIPTION");
        }

        public GeniUrn getProjectUrn() {
            return this.projectUrn;
        }

        public String getProjectUid() {
            return this.projectUid;
        }

        public Date getCreationDate() {
            return this.creationDate;
        }

        public Date getExpirationDate() {
            return this.expirationDate;
        }

        public Boolean getExpired() {
            return this.expired;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return "ProjectInfo{projectUrn=" + this.projectUrn + ", projectUid='" + this.projectUid + "', creationDate=" + this.creationDate + ", expirationDate=" + this.expirationDate + ", expired=" + this.expired + ", name='" + this.name + "', description='" + this.description + "'}";
        }
    }

    public static class SliceRspecList
    extends LookupResult<SliceRspec> {
        public SliceRspecList(@Nonnull Object res) throws BadReplyGeniException {
            super(res, SliceRspec::new);
        }
    }

    public static class SliverInfoList
    extends LookupResult<SliverInfo> {
        public SliverInfoList(@Nonnull Object res) throws BadReplyGeniException {
            super(res, SliverInfo::new);
        }
    }

    public static class SliceRspec {
        public static final String SLICE_RSPEC_ID = "SLICE_RSPEC_ID";
        public static final String SLICE_RSPEC_SLICE_URN = "SLICE_RSPEC_SLICE_URN";
        public static final String SLICE_RSPEC_AGGREGATE_URN = "SLICE_RSPEC_AGGREGATE_URN";
        public static final String SLICE_RSPEC_CREATOR_URN = "SLICE_RSPEC_CREATOR_URN";
        public static final String SLICE_RSPEC_TYPE = "SLICE_RSPEC_TYPE";
        public static final String SLICE_RSPEC_DELETION = "SLICE_RSPEC_DELETION";
        public static final String SLICE_RSPEC_PROVISION = "SLICE_RSPEC_PROVISION";
        public static final String SLICE_RSPEC_RSPEC = "SLICE_RSPEC_RSPEC";
        public static final String SLICE_RSPEC_METADATA = "SLICE_RSPEC_METADATA";
        private final String id;
        private final SliceRspecType type;
        private final String rspec;
        private final String metadata;
        private final GeniUrn aggregateUrn;
        private final GeniUrn sliceUrn;
        private final Date provisionDate;
        private final Date deleteDate;
        private final GeniUrn creatorUrn;

        public SliceRspec(Object resultValueObject) throws BadReplyGeniException {
            this(AbstractApi.apiSpecifiesMapStringToObject(resultValueObject));
        }

        public SliceRspec(Map<String, Object> raw) throws BadReplyGeniException {
            this.id = AbstractApi.apiSpecifiesOptionalStringInMap(raw, SLICE_RSPEC_ID);
            this.type = SliceRspecType.valueOf(AbstractApi.apiSpecifiesStringInMap(raw, SLICE_RSPEC_TYPE));
            this.rspec = AbstractApi.apiSpecifiesStringInMap(raw, SLICE_RSPEC_RSPEC);
            this.metadata = AbstractApi.apiSpecifiesOptionalStringInMap(raw, SLICE_RSPEC_METADATA);
            if (raw.containsKey(SLICE_RSPEC_AGGREGATE_URN) && raw.get(SLICE_RSPEC_AGGREGATE_URN) != null) {
                this.aggregateUrn = AbstractApi.apiSpecifiesGeniUrnInMap(raw, SLICE_RSPEC_AGGREGATE_URN);
            } else {
                this.aggregateUrn = null;
                LOG.info("The API specified SLICE_RSPEC_AGGREGATE_URN to be an URN, but is is </nil>. We'll ignore that.");
            }
            this.sliceUrn = AbstractApi.apiSpecifiesGeniUrnInMap(raw, SLICE_RSPEC_SLICE_URN);
            this.creatorUrn = AbstractApi.apiSpecifiesGeniUrnInMap(raw, SLICE_RSPEC_CREATOR_URN);
            this.provisionDate = AbstractApi.apiSpecifiesOptionalDateInMap(raw, SLICE_RSPEC_PROVISION);
            this.deleteDate = AbstractApi.apiSpecifiesOptionalDateInMap(raw, SLICE_RSPEC_DELETION);
        }

        public String getId() {
            return this.id;
        }

        public SliceRspecType getType() {
            return this.type;
        }

        public String getRspec() {
            return this.rspec;
        }

        public String getMetadata() {
            return this.metadata;
        }

        public GeniUrn getAggregateUrn() {
            return this.aggregateUrn;
        }

        public GeniUrn getSliceUrn() {
            return this.sliceUrn;
        }

        public Date getProvisionDate() {
            return this.provisionDate;
        }

        public Date getDeleteDate() {
            return this.deleteDate;
        }

        public GeniUrn getCreatorUrn() {
            return this.creatorUrn;
        }

        public String toString() {
            return "SliverInfo{id=" + this.id + ", type=" + this.type + ", rspec=" + this.rspec + ", metadata=" + this.metadata + ", aggregateUrn=" + this.aggregateUrn + ", sliceUrn=" + this.sliceUrn + ", creatorUrn=" + this.creatorUrn + ", provisionDate=" + this.provisionDate + ", deleteDate=" + this.deleteDate + "}";
        }
    }

    public static enum SliceRspecType {
        REQUEST,
        MANIFEST,
        COMBINED_MANIFEST;

    }

    public static class SliverInfo {
        public static final String SLIVER_INFO_SLICE_URN = "SLIVER_INFO_SLICE_URN";
        private final GeniUrn sliverUrn;
        private final GeniUrn aggregateUrn;
        private final GeniUrn sliceUrn;
        private final Date expirationDate;
        private final GeniUrn creatorUrn;
        private final String creation;

        public SliverInfo(Object resultValueObject) throws BadReplyGeniException {
            this(AbstractApi.apiSpecifiesMapStringToObject(resultValueObject));
        }

        public SliverInfo(Map<String, Object> raw) throws BadReplyGeniException {
            this.sliverUrn = AbstractApi.apiSpecifiesGeniUrnInMap(raw, "SLIVER_INFO_URN");
            this.aggregateUrn = AbstractApi.apiSpecifiesGeniUrnInMap(raw, "SLIVER_INFO_AGGREGATE_URN");
            this.sliceUrn = AbstractApi.apiSpecifiesGeniUrnInMap(raw, SLIVER_INFO_SLICE_URN);
            this.expirationDate = AbstractApi.apiSpecifiesDateInMap(raw, "SLIVER_INFO_EXPIRATION");
            this.creatorUrn = AbstractApi.apiSpecifiesGeniUrnInMap(raw, "SLIVER_INFO_CREATOR_URN");
            this.creation = AbstractApi.apiSpecifiesNullableString(raw.get("SLIVER_INFO_CREATION"));
        }

        public GeniUrn getAggregateUrn() {
            return this.aggregateUrn;
        }

        public GeniUrn getSliceUrn() {
            return this.sliceUrn;
        }

        public Date getExpirationDate() {
            return this.expirationDate;
        }

        public GeniUrn getCreatorUrn() {
            return this.creatorUrn;
        }

        public String getCreation() {
            return this.creation;
        }

        public GeniUrn getSliverUrn() {
            return this.sliverUrn;
        }

        public String toString() {
            return "SliverInfo{sliverUrn=" + this.sliverUrn + ", aggregateUrn=" + this.aggregateUrn + ", sliceUrn=" + this.sliceUrn + ", expirationDate=" + this.expirationDate + ", creatorUrn=" + this.creatorUrn + ", creation='" + this.creation + "'}";
        }
    }

    public static class SliceInfoList
    extends LookupResult<SliceInfo> {
        public SliceInfoList(@Nonnull Object resultValueObject) throws BadReplyGeniException {
            super(resultValueObject, SliceInfo::new);
        }
    }

    public static class SliceInfo {
        private static final String SLICE_UID = "SLICE_UID";
        private static final String SLICE_CREATION = "SLICE_CREATION";
        private static final String SLICE_EXPIRATION = "SLICE_EXPIRATION";
        private static final String EMULAB_SLICE_HAS_SLIVERS = "_EMULAB_SLICE_HAS_SLIVERS";
        private static final String SLICE_URN = "SLICE_URN";
        @Nonnull
        private final GeniUrn sliceUrn;
        private final Date expirationDate;
        private final Date creationDate;
        private final Boolean emulabHasSlivers;
        private final String uuid;

        public SliceInfo(Object resultValueObject) throws BadReplyGeniException {
            this(AbstractApi.apiSpecifiesMapStringToObject(resultValueObject));
        }

        public SliceInfo(Map<String, Object> raw) throws BadReplyGeniException {
            this.sliceUrn = AbstractApi.apiSpecifiesGeniUrnInMap(raw, SLICE_URN);
            this.expirationDate = AbstractApi.apiSpecifiesDateInMap(raw, SLICE_EXPIRATION);
            this.creationDate = raw.containsKey(SLICE_CREATION) ? AbstractApi.apiSpecifiesDateInMap(raw, SLICE_CREATION) : null;
            this.emulabHasSlivers = TextUtil.objectToBoolean((Object)raw.get(EMULAB_SLICE_HAS_SLIVERS));
            this.uuid = AbstractApi.apiSpecifiesNullableString(raw.get(SLICE_UID));
        }

        @Nonnull
        public GeniUrn getSliceUrn() {
            return this.sliceUrn;
        }

        @Nullable
        public Date getExpirationDate() {
            return this.expirationDate;
        }

        @Nullable
        public Boolean getEmulabHasSlivers() {
            return this.emulabHasSlivers;
        }

        @Nullable
        public Date getCreationDate() {
            return this.creationDate;
        }

        @Nullable
        public String getUuid() {
            return this.uuid;
        }

        public String toString() {
            return "SliceInfo{sliceUrn=" + this.sliceUrn + ", expirationDate=" + this.expirationDate + ", creationDate=" + this.creationDate + ", emulabHasSlivers=" + this.emulabHasSlivers + ", uuid='" + this.uuid + "'}";
        }
    }

    @FunctionalInterface
    public static interface LookupResultConverter<T> {
        public T convert(Map<String, Object> var1) throws BadReplyGeniException;
    }

    public static class LookupListResult<T>
    extends ForwardingList<T> {
        private final List<T> list = new ArrayList<T>();

        public LookupListResult(@Nonnull Object res, @Nonnull LookupResultConverter<T> converter) throws BadReplyGeniException {
            List<Map> l = AbstractApi.apiSpecifiesListOfT(Map.class, res);
            for (Map m : l) {
                Map<String, Object> rawValue = AbstractApi.apiSpecifiesMapStringToObject(m);
                this.list.add(converter.convert(rawValue));
            }
        }

        public String toString() {
            return "LookupListResult{" + this.list + "}";
        }

        protected List<T> delegate() {
            return this.list;
        }
    }

    public static class LookupResult<T>
    extends ForwardingMap<GeniUrn, T> {
        private final Map<GeniUrn, T> map = new HashMap<GeniUrn, T>();

        public LookupResult(@Nonnull Object res, @Nonnull LookupResultConverter<T> converter) throws BadReplyGeniException {
            Map<String, Object> ht = AbstractApi.apiSpecifiesMapStringToObject(res);
            for (Map.Entry<String, Object> entry : ht.entrySet()) {
                GeniUrn key;
                try {
                    key = new GeniUrn(entry.getKey());
                }
                catch (GeniUrn.GeniUrnParseException e) {
                    throw new BadReplyGeniException("Expecting result to lookup to be a mapping of URNs to Dicts. However, key '" + entry.getKey() + "' is not a valid URN", (Exception)((Object)e));
                }
                if (entry.getValue() == null) {
                    throw new BadReplyGeniException("expecting result to lookup to be a mapping of URN to Dictionaries of field/value pairs. However, instead of a dictionary, a null was found for key \"" + entry.getKey() + "\"!");
                }
                if (entry.getValue() instanceof Object[]) {
                    throw new BadReplyGeniException("expecting result to lookup to be a mapping of URN to Dictionaries of field/value pairs. However, instead of a dictionary, a List was found for key \"" + entry.getKey() + "\"!");
                }
                if (!(entry.getValue() instanceof Map)) {
                    throw new BadReplyGeniException("expecting result to lookup to be a mapping of URN to Dictionaries of field/value pairs. However, instead of a dictionary, a " + entry.getValue().getClass().getName() + " was found for key \"" + entry.getKey() + "\"!");
                }
                Map<String, Object> rawValue = AbstractApi.apiSpecifiesMapStringToObject(entry.getValue());
                this.map.put(key, converter.convert(rawValue));
            }
        }

        public String toString() {
            return "ConvertibleLookupResult{" + this.map + "}";
        }

        protected Map<GeniUrn, T> delegate() {
            return this.map;
        }
    }

    public static class HTLookupResult
    extends LookupResult<Map<String, Object>> {
        public HTLookupResult(@Nonnull Object res) throws BadReplyGeniException {
            super(res, o -> o);
        }

        public HTLookupResult(@Nonnull Map<String, Object> res) throws BadReplyGeniException {
            super(res, o -> o);
        }

        public Map<String, Object> get(GeniUrn urn) {
            return (Map)this.get(urn.getValue());
        }

        public boolean containsKey(GeniUrn urn) {
            return this.containsKey(urn.getValue());
        }
    }

    public static class GetVersionResult {
        protected String version;
        protected List<CredentialType> supportedCredentialTypes;
        protected Map<String, FieldInfo> fieldInfos;

        public GetVersionResult(Object resultValueObject, boolean v2) throws BadReplyGeniException {
            Map<String, Object> versionInfo = AbstractApi.apiSpecifiesMapStringToObject(resultValueObject);
            this.version = AbstractApi.apiSpecifiesNonNullString(versionInfo.get("VERSION"));
            if (versionInfo.containsKey("CREDENTIAL_TYPES")) {
                if (!v2) {
                    List<String> strings = AbstractApi.apiSpecifiesListOfString(versionInfo.get("CREDENTIAL_TYPES"));
                    this.supportedCredentialTypes = strings.stream().map(s -> new CredentialType((String)s, "unknown")).collect(Collectors.toList());
                } else {
                    List<Map> credType = AbstractApi.apiSpecifiesListOfT(Map.class, versionInfo.get("CREDENTIAL_TYPES"));
                    this.supportedCredentialTypes = new ArrayList<CredentialType>();
                    for (Map map : credType) {
                        CredentialType credentialType = new CredentialType(AbstractApi.apiSpecifiesNonNullString(map.get("type")), AbstractApi.apiSpecifiesNonNullString(map.get("version")));
                        this.supportedCredentialTypes.add(credentialType);
                    }
                }
            }
            this.fieldInfos = new HashMap<String, FieldInfo>();
            if (versionInfo.containsKey("FIELDS")) {
                Map<String, Object> fields = AbstractApi.apiSpecifiesMapStringToObject(versionInfo.get("FIELDS"));
                for (Map.Entry entry : fields.entrySet()) {
                    FieldInfo fieldInfo = new FieldInfo((String)entry.getKey(), AbstractApi.apiSpecifiesMapStringToObject(entry.getValue()));
                    this.fieldInfos.put((String)entry.getKey(), fieldInfo);
                }
            }
        }

        public String getVersion() {
            return this.version;
        }

        public List<CredentialType> getSupportedCredentialTypes() {
            return this.supportedCredentialTypes;
        }

        public Map<String, FieldInfo> getFields() {
            return this.fieldInfos;
        }

        public Map<String, FieldInfo> getFieldsForObject(String objectName) {
            if (this.fieldInfos == null) {
                return null;
            }
            HashMap<String, FieldInfo> objectFields = new HashMap<String, FieldInfo>();
            for (Map.Entry<String, FieldInfo> e : this.fieldInfos.entrySet()) {
                String fieldName = e.getKey();
                FieldInfo fieldInfo = e.getValue();
                if (fieldInfo.getObject() == null || objectName == null || !Objects.equals(fieldInfo.getObject(), objectName)) continue;
                objectFields.put(fieldName, fieldInfo);
            }
            return objectFields;
        }

        public String toString() {
            return "GetVersionResult{version='" + this.version + "', supportedCredentialTypes=" + this.supportedCredentialTypes + ", fieldInfos=" + this.fieldInfos + "}";
        }

        public static class CredentialType {
            private final String typeName;
            private final String version;

            public CredentialType(String typeName, String version) {
                this.typeName = typeName;
                this.version = version;
            }

            public String getTypeName() {
                return this.typeName;
            }

            public String getVersion() {
                return this.version;
            }
        }

        public static class FieldInfo {
            private Map<String, Object> attributes;
            private Map<String, Object> extraAttributes;
            private final String name;
            private FieldType fieldType;
            private CreationAllowed creationAllowed = CreationAllowed.NOT_ALLOWED;
            private boolean match = true;
            private boolean updateable = false;
            private Protect protect = Protect.PUBLIC;
            private String object = null;

            public String toString() {
                return "FieldInfo{name=" + this.name + ", fieldType=" + this.fieldType + ", creationAllowed=" + this.creationAllowed + ", match=" + this.match + ", updateable=" + this.updateable + ", protect=" + this.protect + ", object='" + this.object + "'}";
            }

            public FieldInfo(String name, FieldType fieldType) {
                this.name = name;
                this.fieldType = fieldType;
            }

            public FieldInfo(String object, String name, FieldType fieldType, CreationAllowed creationAllowed, boolean match, boolean updateable) {
                this.name = name;
                this.fieldType = fieldType;
                this.creationAllowed = creationAllowed;
                this.match = match;
                this.updateable = updateable;
                this.object = object;
            }

            public FieldInfo(String object, String name, FieldType fieldType, boolean match, Protect protect) {
                this.name = name;
                this.fieldType = fieldType;
                this.match = match;
                this.protect = protect;
                this.object = object;
            }

            public FieldInfo(String object, String name, FieldType fieldType, CreationAllowed creationAllowed, boolean match, boolean updateable, Protect protect) {
                this.name = name;
                this.fieldType = fieldType;
                this.creationAllowed = creationAllowed;
                this.match = match;
                this.updateable = updateable;
                this.protect = protect;
                this.object = object;
            }

            public FieldInfo(String name, Map<String, Object> attributesTable) throws BadReplyGeniException {
                this.attributes = new HashMap<String, Object>();
                this.extraAttributes = new HashMap<String, Object>();
                this.name = name;
                for (Map.Entry<String, Object> entry : attributesTable.entrySet()) {
                    boolean known = false;
                    assert (entry != null);
                    assert (entry.getKey() != null);
                    assert (entry.getValue() != null);
                    if (Objects.equals(entry.getKey(), "TYPE")) {
                        try {
                            this.fieldType = FieldType.valueOf((String)entry.getValue());
                        }
                        catch (IllegalArgumentException e) {
                            throw new BadReplyGeniException("field TYPE with value \"" + entry.getValue() + "\" is unknown");
                        }
                        known = true;
                    }
                    if (Objects.equals(entry.getKey(), "CREATE")) {
                        try {
                            this.creationAllowed = CreationAllowed.valueOf(((String)entry.getValue()).replace(' ', '_'));
                        }
                        catch (IllegalArgumentException e) {
                            throw new BadReplyGeniException("field CREATE with value \"" + entry.getValue() + "\" is unknown");
                        }
                        known = true;
                    }
                    if (Objects.equals(entry.getKey(), "UPDATE")) {
                        if (entry.getValue() instanceof String && ((String)entry.getValue()).equalsIgnoreCase("true")) {
                            this.updateable = true;
                            known = true;
                        }
                        if (entry.getValue() instanceof Boolean) {
                            this.updateable = (Boolean)entry.getValue();
                            known = true;
                        }
                        if (entry.getValue() instanceof String && ((String)entry.getValue()).equalsIgnoreCase("false")) {
                            this.updateable = false;
                            known = true;
                        }
                        if (!known) {
                            throw new BadReplyGeniException("field UPDATE with value \"" + entry.getValue() + "\" is unknown");
                        }
                    }
                    if (Objects.equals(entry.getKey(), "MATCH")) {
                        if (entry.getValue() instanceof String && ((String)entry.getValue()).equalsIgnoreCase("true")) {
                            this.match = true;
                            known = true;
                        }
                        if (entry.getValue() instanceof Boolean) {
                            this.match = (Boolean)entry.getValue();
                            known = true;
                        }
                        if (entry.getValue() instanceof String && ((String)entry.getValue()).equalsIgnoreCase("false")) {
                            this.match = false;
                            known = true;
                        }
                        if (!known) {
                            throw new BadReplyGeniException("field MATCH with value \"" + entry.getValue() + "\" is unknown");
                        }
                    }
                    if (Objects.equals(entry.getKey(), "PROTECT")) {
                        try {
                            this.protect = Protect.valueOf((String)entry.getValue());
                        }
                        catch (IllegalArgumentException e) {
                            throw new BadReplyGeniException("field PROTECT with value \"" + entry.getValue() + "\" is unknown");
                        }
                        known = true;
                    }
                    if (Objects.equals(entry.getKey(), "OBJECT")) {
                        this.object = (String)entry.getValue();
                        known = true;
                    }
                    if (!known) {
                        this.extraAttributes.put(entry.getKey(), entry.getValue());
                    }
                    this.attributes.put(entry.getKey(), entry.getValue());
                }
            }

            public Object getAttribute(String name) {
                return this.attributes.get(name);
            }

            public Object getExtraAttribute(String name) {
                return this.extraAttributes.get(name);
            }

            public FieldType getType() {
                return this.fieldType;
            }

            public CreationAllowed getCreationAllowed() {
                return this.creationAllowed;
            }

            public boolean isUpdateable() {
                return this.updateable;
            }

            public Protect getProtect() {
                return this.protect;
            }

            public String getName() {
                return this.name;
            }

            public boolean isMatchable() {
                return this.match;
            }

            public String getObject() {
                return this.object;
            }

            public static enum FieldType {
                URN,
                URL,
                UID,
                STRING,
                DATETIME,
                EMAIL,
                KEY,
                BOOLEAN,
                CERTIFICATE,
                CREDENTIALS,
                INTEGER,
                PEERS;

            }

            public static enum CreationAllowed {
                REQUIRED,
                ALLOWED,
                NOT_ALLOWED;

            }

            public static enum Protect {
                PUBLIC,
                PRIVATE,
                IDENTIFYING;

            }
        }
    }
}

