/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api;

import be.iminds.ilabt.jfed.lowlevel.connection.ApiCallReply;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniAMResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.XMLRPCCallDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.XmlRpcApiCallReply;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.SfaCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.AbstractApi;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethod;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameter;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameterType;
import be.iminds.ilabt.jfed.lowlevel.lib.RetrySettings;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanetlabSfaRegistryInterface
extends AbstractApi {
    private static final Logger LOG = LoggerFactory.getLogger(PlanetlabSfaRegistryInterface.class);

    public static GeniUrn sfaHrnToUrn(String sfaHrn, String type) {
        if (sfaHrn == null) {
            return null;
        }
        int lastDot = sfaHrn.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        String name = sfaHrn.substring(lastDot + 1);
        String tld = sfaHrn.substring(0, lastDot).replace('.', ':');
        return GeniUrn.createGeniUrnFromEncodedParts((String)tld, (String)type, (String)name);
    }

    public static GeniUrn sfaHrnToUserUrn(String sfaHrn) {
        return PlanetlabSfaRegistryInterface.sfaHrnToUrn(sfaHrn, "user");
    }

    public static String urnToSfaHrn(GeniUrn urn) {
        if (urn == null) {
            return null;
        }
        String first = urn.getEncodedTopLevelAuthority().replace(":", ".");
        String last = urn.getEncodedResourceName();
        return first + "." + last;
    }

    public PlanetlabSfaRegistryInterface(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, RetrySettings retrySettings, @Nonnull JFedPreferences jFedPreferences) {
        super(logger, retrySettings, new ApiInfo.Api(ApiInfo.ApiName.PLANETLAB_SLICE_REGISTRY, 1), jFedPreferences);
    }

    public PlanetlabSfaRegistryInterface(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull JFedPreferences jFedPreferences) {
        this(logger, jFedPreferences.getRetrySettings(), jFedPreferences);
    }

    public static String getApiName() {
        return "PlanetLab SFA Registry Interface";
    }

    @Override
    @Nonnull
    public String getName() {
        return PlanetlabSfaRegistryInterface.getApiName();
    }

    @Override
    protected boolean isBusyReply(XMLRPCCallDetails res) {
        return false;
    }

    private void improveCredentialName(AnyCredential cred) {
        if (!(cred instanceof SfaCredential)) {
            return;
        }
        SfaCredential sfaCred = (SfaCredential)cred;
        GeniUrn target = GeniUrn.parse((String)sfaCred.getTargetUrn());
        if (target == null) {
            return;
        }
        String origname = cred.getName();
        if (Objects.equals(target.getEncodedResourceType(), "user")) {
            cred.setName(origname + " for user " + target.getEncodedResourceName());
            return;
        }
        if (Objects.equals(target.getEncodedResourceType(), "slice")) {
            cred.setName(origname + " for slice " + target.getEncodedResourceName());
            return;
        }
        if (target.getEncodedResourceType().startsWith("auth")) {
            cred.setName(origname + " for PI user (allows creating slices)");
            return;
        }
        cred.setName(origname + " target=" + target);
    }

    @ApiMethod(order=1, hint="GetVersion call: Get info about the version of the API supported at the server.")
    public SimpleApiCallReply<GetVersionReply> getVersion(SfaConnection con) throws JFedException {
        GetVersionReply r;
        Map<String, Object> methodParams = PlanetlabSfaRegistryInterface.makeMethodParameters(new Object[0]);
        XMLRPCCallDetails res = this.executeXmlRpcCommand(con, "GetVersion", Collections.emptyList(), methodParams, false);
        try {
            r = new GetVersionReply(res);
        }
        catch (Exception t) {
            LOG.error("Error parsing GetVersion reply", (Throwable)t);
            r = null;
        }
        SimpleApiCallReply<GetVersionReply> wrappedres = new SimpleApiCallReply<GetVersionReply>(res, r);
        this.log(res, (ApiCallReply)wrappedres, "getVersion", "GetVersion", con, methodParams);
        return wrappedres;
    }

    @ApiMethod(order=2, hint="GetSelfCredential call: Get the credential of the current user.")
    public SimpleApiCallReply<AnyCredential> getSelfCredential(SfaConnection con, @ApiMethodParameter(name="certificate", hint="The client's certificate.", multiLineString=true) String certificate, @ApiMethodParameter(name="xrn", hint="The client's URN or HRN.") String xrn, @ApiMethodParameter(name="type", hint="The client's type (if HRN is specified).", required=false) String type) throws JFedException {
        SimpleApiCallReply<AnyCredential> r;
        Map<String, Object> methodParams = PlanetlabSfaRegistryInterface.makeMethodParameters("certificate", certificate, "xrn", xrn, "type", type);
        ArrayList<String> args = new ArrayList<String>(3);
        args.add(certificate);
        args.add(xrn);
        if (type != null) {
            args.add(type);
        } else {
            args.add("");
        }
        XMLRPCCallDetails res = this.executeXmlRpcCommand(con, "GetSelfCredential", args, methodParams, false);
        try {
            AnyCredential signedCredential = AnyCredential.createSfa2("PlanetlabSfaReg GetSelfCredential", res.getResultValueObject().toString());
            this.improveCredentialName(signedCredential);
            r = new SimpleApiCallReply<AnyCredential>(res, signedCredential);
        }
        catch (Exception e) {
            this.log(res, null, "getSelfCredential", "GetSelfCredential", con, methodParams);
            throw new JFedException("Exception retrieving Credential for GetSelfCredential call.", (Throwable)e, res, null);
        }
        this.log(res, (ApiCallReply)r, "getSelfCredential", "GetSelfCredential", con, methodParams);
        return r;
    }

    @ApiMethod(order=3, hint="GetSelfCredential call, with automatic argument: Get the credential of the current user.", convenienceMethodFor="getSelfCredential")
    public SimpleApiCallReply<AnyCredential> getSelfCredential_AutomaticArguments(SfaConnection con, GeniUser geniUser) throws JFedException {
        SimpleApiCallReply<AnyCredential> r;
        Map<String, Object> methodParams = PlanetlabSfaRegistryInterface.makeMethodParameters("geniUserString", (Object)geniUser.getUserUrnString());
        List<X509Certificate> certChain = geniUser.getClientCertificateChain();
        Object certificate = "";
        for (X509Certificate c : certChain) {
            certificate = (String)certificate + KeyUtil.x509certificateToPem((X509Certificate)c);
        }
        String xrn = geniUser.getUserUrnString();
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(certificate);
        args.add(xrn);
        args.add("");
        XMLRPCCallDetails res = this.executeXmlRpcCommand(con, "GetSelfCredential", args, methodParams, false);
        try {
            AnyCredential signedCredential = AnyCredential.createSfa2("PlanetlabSfaRegistry GetSelfCredential", res.getResultValueObject().toString());
            this.improveCredentialName(signedCredential);
            r = new SimpleApiCallReply<AnyCredential>(res, signedCredential);
        }
        catch (Exception e) {
            this.log(res, null, "getSelfCredential_AutomaticArguments", "GetSelfCredential", con, methodParams);
            throw new JFedException("Exception retrieving Credential for GetSelfCredential call.", (Throwable)e, res, null);
        }
        this.log(res, (ApiCallReply)r, "getSelfCredential_AutomaticArguments", "GetSelfCredential", con, methodParams);
        return r;
    }

    @ApiMethod(order=4, hint="GetCredential call, without arguments: Get the credential of the current user.")
    public SimpleApiCallReply<AnyCredential> getCredential(SfaConnection con, @ApiMethodParameter(name="credential", hint="A single credential string or an array of credentials (jFed currently only supports a single credential here)") AnyCredential credential, @ApiMethodParameter(name="xrn", hint="The objects URN or HRN.") String xrn, @ApiMethodParameter(name="type", hint="The objects type (if HRN is specified).", required=false) String type) throws JFedException {
        SimpleApiCallReply<AnyCredential> r;
        Map<String, Object> methodParams = PlanetlabSfaRegistryInterface.makeMethodParameters("credential", credential, "xrn", xrn, "type", type);
        ArrayList<String> args = new ArrayList<String>(3);
        args.add(credential.getCredentialXml());
        args.add(xrn);
        if (type != null) {
            args.add(type);
        } else {
            args.add("");
        }
        XMLRPCCallDetails res = this.executeXmlRpcCommand(con, "GetCredential", args, methodParams, false);
        try {
            AnyCredential signedCredential = AnyCredential.createSfa2("PlanetlabSfaRegistry GetCredential", res.getResultValueObject().toString());
            this.improveCredentialName(signedCredential);
            r = new SimpleApiCallReply<AnyCredential>(res, signedCredential);
        }
        catch (Exception e) {
            this.log(res, null, "getCredential", "GetCredential", con, methodParams);
            throw new JFedException("Exception retrieving Credential for GetCredential call.", (Throwable)e, res, null);
        }
        this.log(res, (ApiCallReply)r, "getCredential", "GetCredential", con, methodParams);
        return r;
    }

    @ApiMethod(order=5, hint="GetCredential call, without arguments: Get the credential of the current user.")
    public SimpleApiCallReply<Map> resolve(SfaConnection con, @ApiMethodParameter(name="credential", hint="A single credential string or an array of credentials (jFed currently only supports a single credential here)") AnyCredential credential, @ApiMethodParameter(name="xrn", hint="A single object URN or HRN or an array of URNs/HRNs. (jFed currently only supports a single object here)") String xrn) throws JFedException {
        SimpleApiCallReply<Map> r;
        Map<String, Object> methodParams = PlanetlabSfaRegistryInterface.makeMethodParameters("credential", credential, "xrn", xrn);
        ArrayList<String> args = new ArrayList<String>(2);
        args.add(xrn);
        args.add(credential.getCredentialXml());
        XMLRPCCallDetails res = this.executeXmlRpcCommand(con, "Resolve", args, methodParams, false);
        try {
            Object resVal = res.getResultValueObject();
            if (resVal instanceof Object[]) {
                Object[] wrappingList = (Object[])resVal;
                if (wrappingList.length == 1) {
                    resVal = wrappingList[0];
                } else {
                    throw new JFedException("Exception in Resolve call: returned array with " + wrappingList.length + " elements instead of struct or array with single struct inside", res, null);
                }
            }
            Map table = (Map)resVal;
            r = new SimpleApiCallReply<Map>(res, table);
        }
        catch (Exception e) {
            this.log(res, null, "resolve", "Resolve", con, methodParams);
            throw new JFedException("Exception in Resolve call.", (Throwable)e, res, null);
        }
        this.log(res, (ApiCallReply)r, "resolve", "Resolve", con, methodParams);
        return r;
    }

    @ApiMethod(order=6, hint="GetCredential call, without arguments: Get the credential of the current user.")
    public SimpleApiCallReply<List> list(SfaConnection con, @ApiMethodParameter(name="credential", hint="A single credential string or an array of credentials (jFed currently only supports a single credential here)") AnyCredential credential, @ApiMethodParameter(name="xrn", hint="A single object URN or HRN or an array of URNs/HRNs. (jFed currently only supports a single object here)") String xrn) throws JFedException {
        SimpleApiCallReply<List> r;
        Map<String, Object> methodParams = PlanetlabSfaRegistryInterface.makeMethodParameters("credential", credential, "xrn", xrn);
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(xrn);
        List<String> creds = Collections.singletonList(credential.getCredentialXml());
        args.add(creds);
        XMLRPCCallDetails res = this.executeXmlRpcCommand(con, "List", args, methodParams, false);
        try {
            List list = (List)res.getResultValueObject();
            r = new SimpleApiCallReply<List>(res, list);
        }
        catch (Exception e) {
            this.log(res, null, "list", "List", con, methodParams);
            throw new JFedException("Exception in List call.", (Throwable)e, res, null);
        }
        this.log(res, (ApiCallReply)r, "list", "List", con, methodParams);
        return r;
    }

    @ApiMethod(order=7, hint="Register call, without Slice record as argument: Create a slice")
    public SimpleApiCallReply<String> registerSlice(SfaConnection con, @ApiMethodParameter(name="credential", hint="A single credential string or an array of credentials (jFed currently only supports a single credential here)") AnyCredential credential, @ApiMethodParameter(name="hrn", hint="hrn") String hrn, @ApiMethodParameter(name="sliceUrl", hint="sliceUrl", required=false, parameterType=ApiMethodParameterType.URL) String sliceUrl, @ApiMethodParameter(name="expiresRRC3339", hint="expires String in RFC3339 format", required=false, parameterType=ApiMethodParameterType.STRING_DATE_RFC3339) String expiresRRC3339, @ApiMethodParameter(name="researchers", hint="researchers", required=false, parameterType=ApiMethodParameterType.LIST_OF_STRING) List<String> researchers, @ApiMethodParameter(name="pis", hint="principle investigators", required=false, parameterType=ApiMethodParameterType.LIST_OF_STRING) List<String> pis, @ApiMethodParameter(name="description", hint="description", required=false, parameterType=ApiMethodParameterType.LIST_OF_STRING) List<String> description) throws JFedException {
        SimpleApiCallReply<String> r;
        Map<String, Object> methodParams = PlanetlabSfaRegistryInterface.makeMethodParameters("credential", credential, "hrn", hrn, "sliceUrl", sliceUrl, "expiresRRC3339", expiresRRC3339, "researchers", researchers, "pis", pis, "description", description);
        HashMap<String, Object> sliceRecord = new HashMap<String, Object>();
        sliceRecord.put("hrn", hrn);
        sliceRecord.put("type", "slice");
        if (sliceUrl != null) {
            sliceRecord.put("url", sliceUrl);
        }
        if (expiresRRC3339 != null) {
            sliceRecord.put("expires", expiresRRC3339);
        }
        if (researchers != null) {
            ArrayList<String> researchersList = new ArrayList<String>(researchers);
            sliceRecord.put("researchers", researchersList);
        }
        if (pis != null) {
            ArrayList<String> pisList = new ArrayList<String>(pis);
            sliceRecord.put("pis", pisList);
        }
        if (description != null) {
            ArrayList<String> descriptionList = new ArrayList<String>(description);
            sliceRecord.put("description", descriptionList);
        }
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(sliceRecord);
        List<String> creds = Collections.singletonList(credential.getCredentialXml());
        args.add(creds);
        XMLRPCCallDetails res = this.executeXmlRpcCommand(con, "Register", args, methodParams, false);
        try {
            String gid = (String)res.getResultValueObject();
            r = new SimpleApiCallReply<String>(res, gid);
        }
        catch (Exception e) {
            this.log(res, null, "registerSlice", "Register", con, methodParams);
            throw new JFedException("Exception in Register call.", (Throwable)e, res, null);
        }
        this.log(res, (ApiCallReply)r, "registerSlice", "Register", con, methodParams);
        return r;
    }

    public SimpleApiCallReply<String> registerSlice(SfaConnection con, AnyCredential credential, String hrn, String sliceUrl, Date expires, List<String> researchers, List<String> pis, List<String> description) throws JFedException {
        return this.registerSlice(con, credential, hrn, sliceUrl, RFC3339Util.dateToRFC3339String((Date)expires, (boolean)true, (boolean)true, (boolean)true), researchers, pis, description);
    }

    class GetVersionReply {
        private int geniApi;
        private int sfa;
        private String codeUrl;
        private String codeTag;
        private String hrn;
        private String urn;
        private Map<String, String> peers;

        private Integer handleInteger(Map h, String key) {
            if (h == null) {
                return null;
            }
            Object o = h.get(key);
            if (o == null) {
                return null;
            }
            if (!(o instanceof Integer)) {
                return null;
            }
            return (Integer)o;
        }

        private int handleInt(Map h, String key) {
            Integer res = this.handleInteger(h, key);
            if (res == null) {
                return -1;
            }
            return res;
        }

        private String handleString(Map h, String key) {
            if (h == null) {
                return null;
            }
            Object o = h.get(key);
            if (o == null) {
                return null;
            }
            return "" + o;
        }

        private Map handleMap(Map h, String key) {
            if (h == null) {
                return null;
            }
            Object o = h.get(key);
            if (o == null) {
                return null;
            }
            if (!(o instanceof Map)) {
                return null;
            }
            return (Map)o;
        }

        public GetVersionReply(XMLRPCCallDetails reply) {
            Map replyTable = (Map)reply.getResult();
            this.geniApi = this.handleInt(replyTable, "geni_api");
            this.sfa = this.handleInt(replyTable, "sfa");
            this.codeUrl = this.handleString(replyTable, "code_url");
            this.codeTag = this.handleString(replyTable, "code_tag");
            this.hrn = this.handleString(replyTable, "hrn");
            this.urn = this.handleString(replyTable, "urn");
            Map peersTable = this.handleMap(replyTable, "peers");
            this.peers = new HashMap<String, String>();
            for (Object p : peersTable.keySet()) {
                String peer = (String)p;
                String peerUrl = this.handleString(peersTable, peer);
                this.peers.put(peer, peerUrl);
            }
        }

        public int getGeniApi() {
            return this.geniApi;
        }

        public int getSfa() {
            return this.sfa;
        }

        public String getCodeUrl() {
            return this.codeUrl;
        }

        public String getCodeTag() {
            return this.codeTag;
        }

        public String getHrn() {
            return this.hrn;
        }

        public String getUrn() {
            return this.urn;
        }

        public Map<String, String> getPeers() {
            return this.peers;
        }

        public String toString() {
            return "GetVersionReply{geniApi=" + this.geniApi + ", sfa=" + this.sfa + ", codeUrl='" + this.codeUrl + "', codeTag='" + this.codeTag + "', hrn='" + this.hrn + "', urn='" + this.urn + "', peers=" + this.peers + "}";
        }
    }

    public static class SimpleApiCallReply<T>
    implements XmlRpcApiCallReply<T> {
        private final T val;
        private final Object rawResult;
        private final XMLRPCCallDetails xmlRpcDetails;

        public SimpleApiCallReply(XMLRPCCallDetails res, T val) {
            this.xmlRpcDetails = res;
            this.rawResult = res.getResult();
            this.val = val;
        }

        @Nullable
        public Object getRawResult() {
            return this.rawResult;
        }

        @Nullable
        public T getValue() {
            return this.val;
        }

        @Nonnull
        public GeniAMResponseCode getGeniResponseCode() {
            return GeniAMResponseCode.GENIRESPONSE_SUCCESS;
        }

        @Nullable
        public String getOutput() {
            return "";
        }

        @Nullable
        public XMLRPCCallDetails getXMLRPCCallDetails() {
            return this.xmlRpcDetails;
        }

        @Nullable
        public Object getRawValue() {
            return this.getValue();
        }
    }
}

