/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.PlanetlabRegistryUserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.ProtoGeniSAUserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.UniformFederationApi1UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.UniformFederationApi2UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AbacCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethod;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameter;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameterType;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserWithSpeaksFor;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomaticUserAndSliceApiWrapper
extends UserAndSliceApiWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(AutomaticUserAndSliceApiWrapper.class);
    protected ApiInfo.Api api;
    protected UserAndSliceApiWrapper impl;
    private GeniUser userChoosenFor;
    private static final long CREDENTIAL_MINIMUM_LIFE_MINUTES = 5L;

    private AutomaticUserAndSliceApiWrapper(be.iminds.ilabt.jfed.log.Logger logger, GeniUserProvider geniUserProvider, JFedConnectionProvider connectionProvider, JFedPreferences jFedPreferences) {
        super(logger, geniUserProvider, connectionProvider, jFedPreferences);
        this.choose();
    }

    protected void reChooseIfNeeded() {
        assert (this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer() != null);
        if (!(this.userChoosenFor == this.geniUserProvider.getLoggedInGeniUser() || this.userChoosenFor != null && this.userChoosenFor.getUserAuthorityServer() != null && Objects.equals(this.userChoosenFor.getUserAuthorityServer().getId(), this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer().getId()))) {
            LOG.info("New login detected: will re-choose authority servers");
            this.choose();
        }
    }

    protected void choose() {
        if (!this.geniUserProvider.isUserLoggedIn()) {
            LOG.warn("Cannot choose implementation when user is not logged in");
            this.api = null;
            this.impl = null;
            this.userChoosenFor = null;
            return;
        }
        this.userChoosenFor = this.geniUserProvider.getLoggedInGeniUser();
        Server userServer = this.getLoggedInUserAuthorityServer();
        if (userServer == null) {
            LOG.warn("Cannot choose implementation when userServer is unknown");
            this.api = null;
            this.impl = null;
            return;
        }
        if (userServer.getServices() == null) {
            throw new RuntimeException("Cannot initialize AutomaticUserAndSliceApiWrapper: userAuth.getServices() = null (userAuth.urn=" + userServer.getDefaultComponentManagerUrn() + ")");
        }
        if (ApiInfo.hasService(userServer, ApiInfo.ApiName.GENI_CH_SA, 2) && ApiInfo.hasService(userServer, ApiInfo.ApiName.GENI_CH_MA, 2)) {
            this.api = null;
            this.impl = new UniformFederationApi2UserAndSliceApiWrapper(this.logger, this.geniUserProvider, this.connectionProvider, this.jFedPreferences);
        } else if (ApiInfo.hasService(userServer, ApiInfo.ApiName.PROTOGENI_SA, 1)) {
            this.api = new ApiInfo.Api(ApiInfo.ApiName.PROTOGENI_SA, 1);
            this.impl = new ProtoGeniSAUserAndSliceApiWrapper(this.logger, this.geniUserProvider, this.connectionProvider, this.jFedPreferences);
        } else if (ApiInfo.hasService(userServer, ApiInfo.ApiName.GENI_CH_SA, 1) && ApiInfo.hasService(userServer, ApiInfo.ApiName.GENI_CH_MA, 1)) {
            this.api = null;
            this.impl = new UniformFederationApi1UserAndSliceApiWrapper(this.logger, this.geniUserProvider, this.connectionProvider, this.jFedPreferences);
        } else if (ApiInfo.hasService(userServer, ApiInfo.ApiName.PLANETLAB_SLICE_REGISTRY, 1)) {
            this.impl = new PlanetlabRegistryUserAndSliceApiWrapper(this.logger, this.geniUserProvider, this.connectionProvider, this.jFedPreferences);
        } else {
            throw new RuntimeException("There is no server known at the users authority that can be used to retrieve user and slice credentials and create slices. user authority: " + userServer.getDefaultComponentManagerUrn());
        }
    }

    protected UserAndSliceApiWrapper getImpl() {
        this.reChooseIfNeeded();
        if (this.impl == null) {
            this.choose();
        }
        if (this.impl == null) {
            LOG.warn("No user logged in, so using DO NOTHING implementation of UserAndSliceApiWrapper");
            return new UserAndSliceApiWrapper(this.logger, this.geniUserProvider, this.connectionProvider, this.jFedPreferences){

                @Override
                public boolean hasUserCredentials() {
                    return true;
                }

                @Override
                public boolean hasSpeaksForSupport() {
                    return false;
                }

                @Override
                public List<AnyCredential> getCachedUserCredentialsForAM() {
                    return Collections.emptyList();
                }

                @Override
                public List<AnyCredential> getUserCredentials(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn userUrn) throws JFedException {
                    return Collections.emptyList();
                }

                @Override
                public List<AnyCredential> getSliceCredentials(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn) throws JFedException {
                    return Collections.emptyList();
                }

                @Override
                public List<GeniUrn> getSlicesForUser(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn userUrn) throws JFedException {
                    return Collections.emptyList();
                }

                @Override
                public List<GeniUrn> getAggregatesForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn sliceUrn) throws JFedException {
                    return Collections.emptyList();
                }

                @Override
                public Date getSliceExpiration(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn sliceUrn) throws JFedException {
                    return new Date();
                }

                @Override
                public boolean isRegisterAggregatesForSliceSupported() {
                    return false;
                }

                @Override
                public void registerAggregatesForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn sliceUrn, @Nonnull GeniUrn aggregateUrn, @Nonnull Collection<GeniUrn> sliverUrns, @Nonnull Date sliverExpirationDate, Date sliverCreationDate) throws JFedException {
                }

                @Override
                public void updateSliverExpirationDateInfoForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn sliceUrn, @Nonnull GeniUrn aggregateUrn, @Nonnull Collection<GeniUrn> sliverUrns, @Nonnull Date sliverExpirationDate) throws JFedException {
                }

                @Override
                public void unregisterAggregatesForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn sliceUrn, @Nonnull GeniUrn aggregateUrn, @Nullable Collection<GeniUrn> sliverUrns) throws JFedException {
                }

                @Override
                public boolean isSliceRspecSupported() {
                    return false;
                }

                @Override
                public UserAndSliceApiWrapper.SliceInfo createSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull String sliceName, Date expirationDate, String subAuthName) throws JFedException {
                    return null;
                }

                @Override
                public List<AnyCredential> renewSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull Date newExpirationDate) throws JFedException {
                    return Collections.emptyList();
                }

                @Override
                public List<String> getSshKeysForUser(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn userUrn) throws JFedException {
                    return Collections.emptyList();
                }

                @Override
                public UserAndSliceApiWrapper.SubAuthoritySupport getSubAuthoritySupport(@Nonnull be.iminds.ilabt.jfed.log.Logger logger) throws JFedException {
                    return UserAndSliceApiWrapper.SubAuthoritySupport.SUB_AUTHORITY_OPTIONAL;
                }

                @Override
                public List<String> getSubAuthorityNames(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn user) throws JFedException {
                    return Collections.emptyList();
                }

                @Override
                public void shareSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn userUrn) throws JFedException {
                }

                @Override
                public void unshareSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn userUrn) throws JFedException {
                }

                @Override
                public List<GeniUrn> getUsersForSubAuthority(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull String projectName) throws JFedException {
                    return null;
                }

                @Override
                public List<GeniUrn> getUsersForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
                    return null;
                }

                @Override
                public boolean hasSubAuthDetailsSupport() {
                    return false;
                }

                @Override
                public void getSubAuthorityDetails(@NotNull be.iminds.ilabt.jfed.log.Logger logger, @NotNull String projectName) throws JFedException {
                }

                @Override
                public void shareSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull List<GeniUrn> userUrns, @Nonnull String role) throws JFedException {
                }
            };
        }
        return this.impl;
    }

    @Override
    @ApiMethod(order=0, hint="getLoggedinUserCredentials")
    public List<AnyCredential> getLocalUserCredentials(@Nonnull be.iminds.ilabt.jfed.log.Logger logger) throws JFedException {
        return super.getLocalUserCredentials(logger);
    }

    @Override
    @ApiMethod(order=1, hint="getUserCredentials")
    public List<AnyCredential> getUserCredentials(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull @ApiMethodParameter(name="userUrn", hint="The urn of the user to request credentials for", parameterType=ApiMethodParameterType.USER_URN) GeniUrn userUrn) throws JFedException {
        return this.getImpl().getUserCredentials(logger, userUrn);
    }

    @Nullable
    @Contract(value="null -> null")
    public static Date getEarliestExpireDate(@Nullable List<AnyCredential> credentials) {
        if (credentials == null || credentials.isEmpty()) {
            return null;
        }
        Date res = null;
        for (AnyCredential cred : credentials) {
            Date expireDate = cred.getExpiresDate();
            if (expireDate == null || res != null && !expireDate.before(res)) continue;
            res = expireDate;
        }
        return res;
    }

    public static boolean hasUsableCredentials(@Nullable List<AnyCredential> credentials) {
        if (credentials == null || credentials.isEmpty()) {
            return false;
        }
        Date now = new Date();
        Date minimum = new Date(now.getTime() + 300000L);
        Date expireDate = AutomaticUserAndSliceApiWrapper.getEarliestExpireDate(credentials);
        if (expireDate == null) {
            LOG.warn("No expire date found in credentials. Assuming valid long enough.");
            return true;
        }
        return expireDate.after(minimum);
    }

    public List<AnyCredential> getUserCredentialsWithRetry(be.iminds.ilabt.jfed.log.Logger logger, GeniUrn userUrn) throws InterruptedException, JFedException {
        List<AnyCredential> res = null;
        boolean tryGetCredentials = true;
        int attempts = 0;
        while (tryGetCredentials) {
            ++attempts;
            res = this.getImpl().getUserCredentials(logger, userUrn);
            if (!AutomaticUserAndSliceApiWrapper.hasUsableCredentials(res)) {
                long expireSeconds;
                if (attempts >= 5) {
                    LOG.warn("Too many attempts (" + attempts + ") to get usable credentials, will give up without usable credentials.");
                    tryGetCredentials = false;
                    continue;
                }
                Date expireDate = AutomaticUserAndSliceApiWrapper.getEarliestExpireDate(res);
                long l = expireSeconds = expireDate == null ? -1L : (expireDate.getTime() - System.currentTimeMillis()) / 1000L;
                if (attempts == 2 && expireDate != null) {
                    long waitSeconds = expireSeconds > 0L ? expireSeconds + 2L : 1L;
                    LOG.warn("Got NON usable credentials (expires in " + expireSeconds + " s), will wait until after credential expires (= " + waitSeconds + " s) and try again.");
                    tryGetCredentials = true;
                    Thread.sleep(waitSeconds * 1000L);
                    continue;
                }
                LOG.warn("Got NON usable credentials (expires in " + expireSeconds + " s), will wait 5 seconds and try again.");
                tryGetCredentials = true;
                Thread.sleep(5000L);
                continue;
            }
            LOG.debug("Got usable credentials");
            tryGetCredentials = false;
        }
        return res;
    }

    @Override
    public boolean hasUserCredentials() {
        return this.getImpl().hasUserCredentials();
    }

    @Override
    public boolean hasSpeaksForSupport() {
        return this.getImpl().hasSpeaksForSupport();
    }

    @Override
    public void setSpeaksFor(List<AnyCredential> speaksForCredentials, @Nullable GeniUrn speakingForUrn) {
        super.setSpeaksFor(speaksForCredentials, speakingForUrn);
        this.getImpl().setSpeaksFor(speaksForCredentials, speakingForUrn);
    }

    @Override
    public List<AnyCredential> getCachedUserCredentialsForAM() {
        return this.getImpl().getCachedUserCredentialsForAM();
    }

    @Override
    @ApiMethod(order=2, hint="getSliceCredentials")
    public List<AnyCredential> getSliceCredentials(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull @ApiMethodParameter(name="sliceUrn", parameterType=ApiMethodParameterType.SLICE_URN) GeniUrn sliceUrn) throws JFedException {
        return this.getImpl().getSliceCredentials(logger, sliceUrn);
    }

    @Override
    @ApiMethod(order=3, hint="getSlicesForUser")
    public List<GeniUrn> getSlicesForUser(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull @ApiMethodParameter(name="userUrn", parameterType=ApiMethodParameterType.USER_URN) GeniUrn userUrn) throws JFedException {
        return this.getImpl().getSlicesForUser(logger, userUrn);
    }

    @Override
    @ApiMethod(order=4, hint="getAggregatesForSlice")
    public List<GeniUrn> getAggregatesForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull @ApiMethodParameter(name="sliceCredentials", hint="slice credentials (only used if needed to get slice aggregate info)", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) List<AnyCredential> sliceCredentials, @Nonnull @ApiMethodParameter(name="sliceUrn", parameterType=ApiMethodParameterType.SLICE_URN) GeniUrn sliceUrn) throws JFedException {
        return this.getImpl().getAggregatesForSlice(logger, sliceCredentials, sliceUrn);
    }

    @Override
    @ApiMethod(order=4, hint="getSliceExpiration")
    public Date getSliceExpiration(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull @ApiMethodParameter(name="sliceCredentials", hint="slice credentials (only used if needed to get slice expiration info)", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) List<AnyCredential> sliceCredentials, @Nonnull @ApiMethodParameter(name="sliceUrn", parameterType=ApiMethodParameterType.SLICE_URN) GeniUrn sliceUrn) throws JFedException {
        Date res = this.getImpl().getSliceExpiration(logger, sliceCredentials, sliceUrn);
        if (res != null) {
            return res;
        }
        for (AnyCredential c : sliceCredentials) {
            if (c.isSpeaksFor() || c.getExpiresDate() == null || res != null && c instanceof AbacCredential) continue;
            res = c.getExpiresDate();
        }
        return res;
    }

    @Override
    public boolean isRegisterAggregatesForSliceSupported() {
        return this.getImpl().isRegisterAggregatesForSliceSupported();
    }

    @Override
    public void registerAggregatesForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn sliceUrn, @Nonnull GeniUrn aggregateUrn, @Nonnull Collection<GeniUrn> sliverUrns, @Nonnull Date sliverExpirationDate, @Nullable Date sliverCreationDate) throws JFedException {
        try {
            this.getImpl().registerAggregatesForSlice(logger, sliceCredentials, sliceUrn, aggregateUrn, sliverUrns, sliverExpirationDate, sliverCreationDate);
        }
        catch (UnsupportedOperationException e) {
            LOG.debug("API does not support registerAggregatesForSlice. This can be ignored.", (Throwable)e);
        }
    }

    @Override
    public void updateSliverExpirationDateInfoForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn sliceUrn, @Nonnull GeniUrn aggregateUrn, @Nonnull Collection<GeniUrn> sliverUrns, @Nonnull Date sliverExpirationDate) throws JFedException {
        try {
            this.getImpl().updateSliverExpirationDateInfoForSlice(logger, sliceCredentials, sliceUrn, aggregateUrn, sliverUrns, sliverExpirationDate);
        }
        catch (UnsupportedOperationException e) {
            LOG.debug("API does not support updateSliverExpirationDateInfoForSlice. This can be ignored.", (Throwable)e);
        }
    }

    @Override
    public void unregisterAggregatesForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn sliceUrn, @Nonnull GeniUrn aggregateUrn, @Nullable Collection<GeniUrn> sliverUrns) throws JFedException {
        try {
            this.getImpl().unregisterAggregatesForSlice(logger, sliceCredentials, sliceUrn, aggregateUrn, sliverUrns);
        }
        catch (UnsupportedOperationException e) {
            LOG.debug("API does not support unregisterAggregatesForSlice. This can be ignored.", (Throwable)e);
        }
    }

    @Override
    public boolean isSliceRspecSupported() {
        return this.getImpl().isSliceRspecSupported();
    }

    @Override
    public void registerRspec(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull AbstractFederationApi.SliceRspecType type, @Nonnull GeniUrn sliceUrn, @Nullable GeniUrn aggregateUrn, @Nonnull String RSpec, @Nonnull Date sliceProvisionDate) throws JFedException {
        try {
            this.getImpl().registerRspec(logger, sliceCredentials, type, sliceUrn, aggregateUrn, RSpec, sliceProvisionDate);
        }
        catch (UnsupportedOperationException e) {
            LOG.debug("API does not support registerRspec. This can be ignored.", (Throwable)e);
        }
    }

    @Override
    @ApiMethod(order=5, hint="createSlice")
    public UserAndSliceApiWrapper.SliceInfo createSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull @ApiMethodParameter(name="sliceName", parameterType=ApiMethodParameterType.STRING) String sliceName, @ApiMethodParameter(name="expirationDate", parameterType=ApiMethodParameterType.DATE, guiDefaultOptional=true, required=false) Date expirationDate, @ApiMethodParameter(name="subAuthName", parameterType=ApiMethodParameterType.STRING, required=false) String subAuthName) throws JFedException {
        return this.getImpl().createSlice(logger, sliceName, expirationDate, subAuthName);
    }

    @Override
    @ApiMethod(order=6, hint="renewSlice")
    public List<AnyCredential> renewSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull @ApiMethodParameter(name="sliceCredentials", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) List<AnyCredential> sliceCredentials, @Nonnull @ApiMethodParameter(name="newExpirationDate", parameterType=ApiMethodParameterType.DATE) Date newExpirationDate) throws JFedException {
        return this.getImpl().renewSlice(logger, sliceCredentials, newExpirationDate);
    }

    @Override
    @ApiMethod(order=7, hint="getSshKeysForUser")
    public List<String> getSshKeysForUser(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull @ApiMethodParameter(name="userUrn", parameterType=ApiMethodParameterType.USER_URN) GeniUrn userUrn) throws JFedException {
        return this.getImpl().getSshKeysForUser(logger, userUrn);
    }

    @Override
    public UserAndSliceApiWrapper.SubAuthoritySupport getSubAuthoritySupport(@Nonnull be.iminds.ilabt.jfed.log.Logger logger) throws JFedException {
        return this.getImpl().getSubAuthoritySupport(logger);
    }

    @Override
    @ApiMethod(order=9, hint="getSubAuthorityNames")
    public List<String> getSubAuthorityNames(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull @ApiMethodParameter(name="user", parameterType=ApiMethodParameterType.USER_URN) GeniUrn user) throws JFedException {
        return this.getImpl().getSubAuthorityNames(logger, user);
    }

    @Override
    public void shareSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn userUrn) throws JFedException {
        this.getImpl().shareSlice(logger, sliceUrn, sliceCredentials, userUrn);
    }

    @Override
    public void unshareSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn userUrn) throws JFedException {
        this.getImpl().unshareSlice(logger, sliceUrn, sliceCredentials, userUrn);
    }

    @Override
    public List<GeniUrn> getUsersForSubAuthority(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull String projectName) throws JFedException {
        return this.getImpl().getUsersForSubAuthority(logger, projectName);
    }

    @Override
    public List<GeniUrn> getUsersForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        return this.getImpl().getUsersForSlice(logger, sliceUrn, sliceCredentials);
    }

    @Override
    public boolean hasSubAuthDetailsSupport() {
        return this.getImpl().hasSubAuthDetailsSupport();
    }

    @Override
    public void getSubAuthorityDetails(@NotNull be.iminds.ilabt.jfed.log.Logger logger, @NotNull String projectName) throws JFedException {
        this.getImpl().getSubAuthorityDetails(logger, projectName);
    }

    @Override
    public void shareSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull List<GeniUrn> userUrns, @Nonnull String role) throws JFedException {
        this.getImpl().shareSlice(logger, sliceUrn, sliceCredentials, userUrns, role);
    }

    @Override
    public void setExtraOptionsForCallsWithCredential(Map<String, ?> extraOptionsForCallsWithCredential) {
        super.setExtraOptionsForCallsWithCredential(extraOptionsForCallsWithCredential);
        this.getImpl().setExtraOptionsForCallsWithCredential(extraOptionsForCallsWithCredential);
    }

    public static class BasicAutomaticUserAndSliceApiWrapperFactory
    implements AutomaticUserAndSliceApiWrapperFactory {
        private final be.iminds.ilabt.jfed.log.Logger logger;
        private final GeniUserProvider geniUserProvider;
        private final JFedConnectionProvider connectionProvider;
        private final JFedPreferences jFedPreferences;

        @Inject
        public BasicAutomaticUserAndSliceApiWrapperFactory(be.iminds.ilabt.jfed.log.Logger logger, GeniUserProvider geniUserProvider, JFedConnectionProvider connectionProvider, JFedPreferences jFedPreferences) {
            this.logger = logger;
            this.geniUserProvider = geniUserProvider;
            this.connectionProvider = connectionProvider;
            this.jFedPreferences = jFedPreferences;
        }

        public BasicAutomaticUserAndSliceApiWrapperFactory(be.iminds.ilabt.jfed.log.Logger logger, final GeniUser geniUser, JFedConnectionProvider connectionProvider, JFedPreferences jFedPreferences) {
            this(logger, new GeniUserProvider(){

                @Override
                @Nonnull
                public GeniUser getLoggedInGeniUser() {
                    return geniUser;
                }

                @Override
                public boolean isUserLoggedIn() {
                    return geniUser != null;
                }
            }, connectionProvider, jFedPreferences);
        }

        @Override
        public AutomaticUserAndSliceApiWrapper create() {
            return this.create(this.logger);
        }

        @Override
        public AutomaticUserAndSliceApiWrapper create(be.iminds.ilabt.jfed.log.Logger altLogger) {
            return this.create(altLogger, this.geniUserProvider);
        }

        @Override
        public AutomaticUserAndSliceApiWrapper create(be.iminds.ilabt.jfed.log.Logger altLogger, final GeniUser altUser) {
            return this.create(altLogger, new GeniUserProvider(){

                @Override
                @Nonnull
                public GeniUser getLoggedInGeniUser() {
                    return altUser;
                }

                @Override
                public boolean isUserLoggedIn() {
                    return altUser != null;
                }
            });
        }

        public AutomaticUserAndSliceApiWrapper create(be.iminds.ilabt.jfed.log.Logger altLogger, GeniUserProvider usedGeniUserProvider) {
            AutomaticUserAndSliceApiWrapper res = new AutomaticUserAndSliceApiWrapper(altLogger, usedGeniUserProvider, this.connectionProvider, this.jFedPreferences);
            if (this.geniUserProvider.isUserLoggedIn() && this.geniUserProvider.getLoggedInGeniUser() instanceof GeniUserWithSpeaksFor) {
                GeniUserWithSpeaksFor geniUserWithSpeaksFor = (GeniUserWithSpeaksFor)this.geniUserProvider.getLoggedInGeniUser();
                res.setSpeaksFor(geniUserWithSpeaksFor.getSpeaksForCredentials(), geniUserWithSpeaksFor.getSpeaksForUrn());
            }
            return res;
        }

        @Override
        public AutomaticUserAndSliceApiWrapper create(GeniUser altUser) {
            return this.create(this.logger, altUser);
        }
    }

    public static interface AutomaticUserAndSliceApiWrapperFactory {
        public AutomaticUserAndSliceApiWrapper create();

        public AutomaticUserAndSliceApiWrapper create(be.iminds.ilabt.jfed.log.Logger var1);

        public AutomaticUserAndSliceApiWrapper create(GeniUser var1);

        public AutomaticUserAndSliceApiWrapper create(be.iminds.ilabt.jfed.log.Logger var1, GeniUser var2);
    }
}

