/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api.FederationMemberAuthorityApi2;
import be.iminds.ilabt.jfed.lowlevel.api.FederationSliceAuthorityApi2;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniformFederationApi2UserAndSliceApiWrapper
extends UserAndSliceApiWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(UniformFederationApi2UserAndSliceApiWrapper.class);
    List<AnyCredential> userCredentials;

    public UniformFederationApi2UserAndSliceApiWrapper(be.iminds.ilabt.jfed.log.Logger logger, GeniUserProvider geniUserProvider, JFedConnectionProvider connectionProvider, JFedPreferences jFedPreferences) {
        super(logger, geniUserProvider, connectionProvider, jFedPreferences);
    }

    private FederationMemberAuthorityApi2 ma(be.iminds.ilabt.jfed.log.Logger logger) {
        return new FederationMemberAuthorityApi2(logger, this.jFedPreferences);
    }

    private FederationSliceAuthorityApi2 sa(be.iminds.ilabt.jfed.log.Logger logger) {
        return new FederationSliceAuthorityApi2(logger, this.jFedPreferences);
    }

    private SfaConnection getSaConnection() throws JFedException {
        return this.getConnection(new ApiInfo.Api(ApiInfo.ApiName.GENI_CH_SA, 2));
    }

    private SfaConnection getMaConnection() throws JFedException {
        return this.getConnection(new ApiInfo.Api(ApiInfo.ApiName.GENI_CH_MA, 2));
    }

    @Nonnull
    public FederationSliceAuthorityApi2.GetVersionSAResult getGetVersionSAResult(be.iminds.ilabt.jfed.log.Logger logger) throws JFedException {
        AbstractFederationApi.FederationApiReply<FederationSliceAuthorityApi2.GetVersionSAResult> reply = this.sa(logger).getVersion(this.getSaConnection());
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("GetVersion call to SA not successful: code=" + reply.getGeniResponseCode() + " output=" + reply.getOutput(), reply);
        }
        return reply.getValue();
    }

    @Override
    public synchronized List<AnyCredential> getUserCredentials(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn user) throws JFedException {
        AbstractFederationApi.FederationApiReply<List<AnyCredential>> reply;
        this.userCredentials = null;
        ArrayList<AnyCredential> reqCredCreds = new ArrayList<AnyCredential>();
        if (this.speaksForCredentials != null && !this.speaksForCredentials.isEmpty()) {
            reqCredCreds.addAll(this.speaksForCredentials);
            assert (this.speaksForUserUrn != null);
            user = this.speaksForUserUrn;
        }
        if (!(reply = this.ma(logger).getCredentials(this.getMaConnection(), reqCredCreds, user, this.addCredentialExtraOptions(null))).getGeniResponseCode().isSuccess()) {
            throw new JFedException("Could not retrieve user credential from server");
        }
        this.userCredentials = new ArrayList<AnyCredential>();
        if (this.speaksForCredentials != null && !this.speaksForCredentials.isEmpty()) {
            this.userCredentials.addAll(this.speaksForCredentials);
        }
        this.userCredentials.addAll((Collection<AnyCredential>)reply.getValue());
        return new ArrayList<AnyCredential>(this.userCredentials);
    }

    @Override
    public boolean hasUserCredentials() {
        return this.hasUserCredentials(this.userCredentials);
    }

    @Override
    public boolean hasSpeaksForSupport() {
        return true;
    }

    @Override
    public List<AnyCredential> getCachedUserCredentialsForAM() {
        if (this.userCredentials == null) {
            return Collections.emptyList();
        }
        return new ArrayList<AnyCredential>(this.userCredentials);
    }

    @Override
    public List<AnyCredential> getSliceCredentials(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn) throws JFedException {
        assert (this.userCredentials != null && !this.userCredentials.isEmpty());
        AbstractFederationApi.FederationApiReply<List<AnyCredential>> reply = this.sa(logger).getSliceCredentials(this.getSaConnection(), this.addSpeaksForCredentials(this.userCredentials), sliceUrn, this.addCredentialExtraOptions(null));
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Could not retrieve slice credential from server", reply);
        }
        ArrayList<AnyCredential> sliceCredentials = new ArrayList<AnyCredential>();
        if (this.speaksForCredentials != null && !this.speaksForCredentials.isEmpty()) {
            sliceCredentials.addAll(this.speaksForCredentials);
        }
        sliceCredentials.addAll((Collection)reply.getValue());
        return sliceCredentials;
    }

    @Override
    public List<GeniUrn> getSlicesForUser(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn user) throws JFedException {
        AbstractFederationApi.FederationApiReply<List<FederationSliceAuthorityApi2.UrnRoleTuple>> reply;
        assert (this.getLoggedInUserAuthorityServer() != null);
        boolean serverSupportsLookupForMemberMatch = this.getLoggedInUserAuthorityServer().hasFlag(Server.Flag.featureFedSaLookupSliceForMemberMatchExpired);
        HashMap<String, Object> extraOptions = null;
        if (serverSupportsLookupForMemberMatch) {
            HashMap<String, Boolean> match = new HashMap<String, Boolean>();
            match.put("SLICE_EXPIRED", false);
            extraOptions = new HashMap<String, Object>();
            extraOptions.put("match", match);
        }
        if (!(reply = this.sa(logger).lookupForMember(this.getSaConnection(), "SLICE", user, this.addSpeaksForCredentials(this.userCredentials), this.addCredentialExtraOptions(extraOptions))).getGeniResponseCode().isSuccess()) {
            throw new JFedException("Could not retrieve slices for user from server", reply);
        }
        ArrayList<GeniUrn> res = new ArrayList<GeniUrn>();
        ArrayList<String> resStrings = new ArrayList<String>();
        List<FederationSliceAuthorityApi2.UrnRoleTuple> urnRoleTuples = reply.getValue();
        boolean sawExpiredSlice = false;
        for (FederationSliceAuthorityApi2.UrnRoleTuple urnRoleTuple : urnRoleTuples) {
            if (!urnRoleTuple.isExpired()) {
                res.add(urnRoleTuple.getUrn());
                resStrings.add(urnRoleTuple.getUrn().toString());
                continue;
            }
            sawExpiredSlice = true;
        }
        if (!resStrings.isEmpty()) {
            HashMap<String, Object> match2 = new HashMap<String, Object>();
            match2.put("SLICE_URN", resStrings);
            if (serverSupportsLookupForMemberMatch || sawExpiredSlice) {
                if (this.getLoggedInUserAuthorityServer().hasFlag(Server.Flag.workaroundFedSaLookupSliceExpiredMatchBoolean)) {
                    match2.put("SLICE_EXPIRED", "false");
                } else {
                    match2.put("SLICE_EXPIRED", false);
                }
            }
            boolean hasSliverActiveInfo = false;
            try {
                AbstractFederationApi.FederationApiReply<AbstractFederationApi.SliceInfoList> sliceInfoLookupRes = this.sa(logger).lookupSlice(this.getSaConnection(), this.addSpeaksForCredentials(this.userCredentials), match2, null, this.addCredentialExtraOptions(null));
                if (sliceInfoLookupRes.getGeniResponseCode().isSuccess()) {
                    hasSliverActiveInfo = sliceInfoLookupRes.getValue().values().stream().anyMatch(sliceInfo -> Objects.equals(sliceInfo.getEmulabHasSlivers(), Boolean.TRUE));
                } else {
                    LOG.warn("The sliceInfo lookup for expired credentials failed. We cannot assure that we don't return expired credentials");
                }
            }
            catch (JFedException ex) {
                LOG.error("Error fetching SLICE info. Will be ignored, because it's not crucial.");
            }
            if (!hasSliverActiveInfo) {
                try {
                    Map match3 = Collections.singletonMap("SLIVER_INFO_SLICE_URN", resStrings);
                    AbstractFederationApi.FederationApiReply<AbstractFederationApi.SliverInfoList> federationApiReply = this.sa(logger).lookupSliverInfo(this.getSaConnection(), this.addSpeaksForCredentials(this.userCredentials), null, match3, null, this.addCredentialExtraOptions(null));
                }
                catch (JFedException e) {
                    LOG.error("Error fetching SLIVER_INFO. Will be ignored, because it's not crucial.");
                }
            }
        } else {
            LOG.debug("Not requesting extra SLICE info, because there are no non expired slices anyway.");
        }
        return res;
    }

    public List<GeniUrn> getUserProjects(be.iminds.ilabt.jfed.log.Logger logger, GeniUrn user) throws JFedException {
        ArrayList<GeniUrn> res;
        block9: {
            AbstractFederationApi.FederationApiReply<List<FederationSliceAuthorityApi2.UrnRoleTuple>> reply = this.sa(logger).lookupForMember(this.getSaConnection(), "PROJECT", user, this.addSpeaksForCredentials(this.userCredentials), this.addCredentialExtraOptions(null));
            if (!reply.getGeniResponseCode().isSuccess()) {
                throw new JFedException("Could not retrieve projects for user from server", reply);
            }
            res = new ArrayList<GeniUrn>();
            List<FederationSliceAuthorityApi2.UrnRoleTuple> urnRoleTuples = reply.getValue();
            boolean hasExpired = false;
            for (FederationSliceAuthorityApi2.UrnRoleTuple urnRoleTuple : urnRoleTuples) {
                if (urnRoleTuple.isExpired()) {
                    hasExpired = true;
                    LOG.debug("skipping expired project: " + urnRoleTuple.getUrn());
                    continue;
                }
                hasExpired |= urnRoleTuple.hasExpiredKey();
                res.add(urnRoleTuple.getUrn());
            }
            if (!hasExpired) {
                LOG.debug("doing second call to check for expired projects");
                assert (this.getLoggedInUserAuthorityServer() != null);
                Map<Object, Object> match = this.getLoggedInUserAuthorityServer().hasFlag(Server.Flag.workaroundFedMaMatchProjectExpired) ? Collections.singletonMap("EXPIRED", Boolean.FALSE) : Collections.emptyMap();
                List<String> filter = Collections.singletonList("PROJECT_URN");
                try {
                    AbstractFederationApi.FederationApiReply<AbstractFederationApi.ProjectInfoList> nonExpiredProj = this.sa(logger).lookupProject(this.getSaConnection(), this.addSpeaksForCredentials(this.userCredentials), match, filter, this.addCredentialExtraOptions(null));
                    if (nonExpiredProj.getGeniResponseCode().isSuccess() && nonExpiredProj.getValue() != null) {
                        LOG.debug("Found " + nonExpiredProj.getValue().size() + " non expired projects on server.");
                        res.removeIf(projUrn -> ((AbstractFederationApi.ProjectInfoList)((Object)((Object)nonExpiredProj.getValue()))).stream().filter(Objects::nonNull).filter(i -> i.getExpired() != Boolean.TRUE).map(AbstractFederationApi.ProjectInfo::getProjectUrn).filter(Objects::nonNull).noneMatch(arg_0 -> ((GeniUrn)projUrn).equals(arg_0)));
                        break block9;
                    }
                    LOG.warn("lookup_projects call failed. Could not check for expired projects. This error will be ignored (possibly leaving expired projects in the list).");
                }
                catch (AssertionError | Exception e) {
                    LOG.warn("lookup_projects call failed. Could not check for expired projects. This error will be ignored (possibly leaving expired projects in the list).", (Throwable)e);
                }
            } else {
                LOG.debug("no second call needed to check for expired projects");
            }
        }
        return res;
    }

    public AbstractFederationApi.MemberInfoList getUserIdentifyingInfo(be.iminds.ilabt.jfed.log.Logger logger, GeniUrn user) throws JFedException {
        Map<String, String> match = Collections.singletonMap("MEMBER_URN", user.getValue());
        AbstractFederationApi.FederationApiReply<AbstractFederationApi.MemberInfoList> reply = this.ma(logger).lookupMember(this.getMaConnection(), this.addSpeaksForCredentials(this.userCredentials), match, null, this.addCredentialExtraOptions(null));
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Problem looking up user info for " + user, reply);
        }
        return reply.getValue();
    }

    @Override
    public List<GeniUrn> getAggregatesForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn sliceUrn) throws JFedException {
        AbstractFederationApi.FederationApiReply<AbstractFederationApi.SliverInfoList> reply = this.sa(logger).lookupSliverInfo(this.getSaConnection(), this.finalizeSliceCredentials(sliceCredentials), sliceUrn, null, null, this.addCredentialExtraOptions(null));
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Problem looking up aggregates for slice '" + sliceUrn + "'", reply);
        }
        if (reply.getValue() == null) {
            throw new JFedException("Got null value when looking up aggregates for slice '" + sliceUrn + "'", reply);
        }
        return reply.getValue().values().stream().map(AbstractFederationApi.SliverInfo::getAggregateUrn).distinct().collect(Collectors.toList());
    }

    @Override
    @Nullable
    public Date getSliceExpiration(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn sliceUrn) throws JFedException {
        Map<String, String> match = Collections.singletonMap("SLICE_URN", sliceUrn.getValue());
        AbstractFederationApi.FederationApiReply<AbstractFederationApi.SliceInfoList> reply = this.sa(logger).lookupSlice(this.getSaConnection(), this.finalizeSliceCredentials(sliceCredentials), match, null, null);
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Could not retrieve slice expiration from server", reply);
        }
        return reply.getValue().values().stream().map(AbstractFederationApi.SliceInfo::getExpirationDate).findAny().orElse(null);
    }

    @Override
    public boolean isRegisterAggregatesForSliceSupported() {
        return true;
    }

    @Override
    public void registerAggregatesForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn sliceUrn, @Nonnull GeniUrn aggregateUrn, @Nonnull Collection<GeniUrn> sliverUrns, @Nonnull Date sliverExpirationDate, @Nonnull Date sliverCreationDate) throws JFedException {
        LOG.debug("UniformFederationApi2UserAndSliceApiWrapper will register: " + sliverUrns.size());
        GeniUrn creatorUrn = this.getRelevantUserUrn();
        assert (creatorUrn != null);
        boolean hasFailures = false;
        for (GeniUrn sliverUrn : sliverUrns) {
            LOG.debug("UniformFederationApi2UserAndSliceApiWrapper is registering: " + sliverUrn);
            try {
                this.sa(logger).createSliverInfo(this.getSaConnection(), this.finalizeSliceCredentials(sliceCredentials), sliceUrn, sliverUrn, aggregateUrn, creatorUrn, sliverExpirationDate, sliverCreationDate, this.addCredentialExtraOptions(null), null);
            }
            catch (JFedException e) {
                LOG.error("Failed to register {} for slice {}", new Object[]{sliverUrn, sliceUrn, e});
                hasFailures = true;
            }
        }
        if (hasFailures) {
            throw new JFedException("One or more slivers failed to register to the SliceRegistery");
        }
    }

    @Override
    public void updateSliverExpirationDateInfoForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn sliceUrn, @Nonnull GeniUrn aggregateUrn, @Nonnull Collection<GeniUrn> sliverUrns, @Nonnull Date newSliverExpirationDate) throws JFedException {
        LOG.debug("UniformFederationApi2UserAndSliceApiWrapper will update SLIVER_INFO expiration: " + sliverUrns.size());
        GeniUrn creatorUrn = this.getRelevantUserUrn();
        assert (creatorUrn != null);
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("SLIVER_INFO_EXPIRATION", RFC3339Util.dateToRFC3339String((Date)newSliverExpirationDate, (boolean)true));
        for (GeniUrn sliverUrn : sliverUrns) {
            try {
                LOG.debug("UniformFederationApi2UserAndSliceApiWrapper is updating SLIVER_INFO: " + sliverUrn);
                AbstractFederationApi.FederationApiReply<String> res = this.sa(logger).updateSliverInfo(this.getSaConnection(), this.finalizeSliceCredentials(sliceCredentials), sliverUrn.toString(), fields, this.addCredentialExtraOptions(null));
                if (res.getGeniResponseCode().isSuccess()) continue;
                LOG.error("Error reply while trying to update SLIVER_INFO for '" + sliverUrn + "' to " + newSliverExpirationDate + " (" + res.getGeniResponseCode().getCode() + " " + res.getGeniResponseCode().getDescription() + " -> " + res.getOutput() + ") -> not critical -> will try to create the SLIVER_INFO as fallback");
                Date creationDate = new Date();
                AbstractFederationApi.FederationApiReply<AbstractFederationApi.SliverInfo> res2 = this.sa(logger).createSliverInfo(this.getSaConnection(), this.finalizeSliceCredentials(sliceCredentials), sliceUrn, sliverUrn, aggregateUrn, creatorUrn, null, creationDate, this.addCredentialExtraOptions(null), fields);
                if (res2.getGeniResponseCode().isSuccess()) continue;
                LOG.error("Error reply while trying to (as a fallback) create SLIVER_INFO for '" + sliverUrn + "' expiring at " + newSliverExpirationDate + " (" + res2.getGeniResponseCode().getCode() + " " + res2.getGeniResponseCode().getDescription() + " -> " + res2.getOutput() + ") -> not critical -> will ignore");
            }
            catch (JFedException e) {
                LOG.error("Exception while trying to update SLIVER_INFO for '" + sliverUrn + "' to " + newSliverExpirationDate + " -> Will be ignored.", (Throwable)e);
            }
        }
    }

    @Override
    public void unregisterAggregatesForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn sliceUrn, @Nonnull GeniUrn aggregateUrn, @Nullable Collection<GeniUrn> sliverUrns) throws JFedException {
        ArrayList<GeniUrn> sliverInfosToDelete;
        block12: {
            Date expiration = null;
            for (AnyCredential c : sliceCredentials) {
                if (c.getExpiresDate() == null || expiration != null && !expiration.after(c.getExpiresDate())) continue;
                expiration = c.getExpiresDate();
            }
            sliverInfosToDelete = new ArrayList<GeniUrn>();
            if (sliverUrns != null) {
                LOG.debug("UniformFederationApi2UserAndSliceApiWrapper will unregister: " + sliverUrns.size());
                try {
                    reply = this.sa(logger).lookupSliverInfo(this.getSaConnection(), this.finalizeSliceCredentials(sliceCredentials), sliceUrn, null, null, this.addCredentialExtraOptions(null));
                    if (reply.getGeniResponseCode().isSuccess()) {
                        reply.getValue().values().stream().map(AbstractFederationApi.SliverInfo::getSliverUrn).filter(sliverUrns::contains).forEach(sliverInfosToDelete::add);
                        break block12;
                    }
                    LOG.warn("lookupSliverInfo call failed for slice {}. Will forcefully try to remove all passed slivers.", (Object)sliceUrn);
                    sliverInfosToDelete.addAll(sliverUrns);
                }
                catch (JFedException t) {
                    LOG.warn("Exception checking registered slivers before deleting them. Will forcefully try to remove all passed slivers", (Throwable)t);
                    sliverInfosToDelete.addAll(sliverUrns);
                }
            } else {
                LOG.debug("UniformFederationApi2UserAndSliceApiWrapper will unregister ALL sliver for " + aggregateUrn);
                reply = this.sa(logger).lookupSliverInfo(this.getSaConnection(), this.finalizeSliceCredentials(sliceCredentials), sliceUrn, null, null, this.addCredentialExtraOptions(null));
                if (!reply.getGeniResponseCode().isSuccess()) {
                    throw new JFedException("Could not retrieve registered slivers for slice '" + sliceUrn + "' from server", reply);
                }
                for (AbstractFederationApi.SliverInfo sliverInfo : reply.getValue().values()) {
                    GeniUrn sliverCmUrn = sliverInfo.getAggregateUrn();
                    if (!Objects.equals(sliverCmUrn, aggregateUrn)) continue;
                    sliverInfosToDelete.add(sliverInfo.getSliverUrn());
                }
            }
        }
        boolean hasFailure = false;
        for (GeniUrn sliverUrn : sliverInfosToDelete) {
            LOG.debug("UniformFederationApi2UserAndSliceApiWrapper is unregistering: " + sliverUrn);
            try {
                this.sa(logger).deleteSliverInfo(this.getSaConnection(), this.finalizeSliceCredentials(sliceCredentials), sliverUrn.toString(), this.addCredentialExtraOptions(null));
            }
            catch (JFedException e) {
                LOG.warn("Error while deleting sliverInfo for {}", (Object)sliverUrn, (Object)e);
                hasFailure = true;
            }
        }
        if (hasFailure) {
            throw new JFedException("One or more deleteSliverInfo calls failed");
        }
    }

    @Override
    public boolean isSliceRspecSupported() {
        return true;
    }

    @Override
    public void registerRspec(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull AbstractFederationApi.SliceRspecType type, @Nonnull GeniUrn sliceUrn, @Nullable GeniUrn aggregateUrn, @Nonnull String rspec, @Nonnull Date sliceProvisionDate) throws JFedException {
        LOG.debug("UniformFederationApi2UserAndSliceApiWrapper will register RSpec of type " + type.name() + " @ " + aggregateUrn);
        GeniUrn creatorUrn = this.getRelevantUserUrn();
        assert (creatorUrn != null);
        try {
            this.sa(logger).createSliceRspec(this.getSaConnection(), this.finalizeSliceCredentials(sliceCredentials), sliceUrn, type.name(), rspec, aggregateUrn, creatorUrn, sliceProvisionDate, this.addCredentialExtraOptions(null), null);
        }
        catch (JFedException e) {
            throw new JFedException("Failed to register SLICE_RSPEC at the SA", e);
        }
    }

    @Override
    public void shareSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn userUrn) throws JFedException {
        List<FederationSliceAuthorityApi2.UrnRoleTuple> membersToAdd = Collections.singletonList(new FederationSliceAuthorityApi2.UrnRoleTuple("SLICE", userUrn, "MEMBER"));
        AbstractFederationApi.FederationApiReply<String> reply = this.sa(logger).modifyMembership(this.getSaConnection(), "SLICE", sliceUrn, membersToAdd, null, null, this.finalizeSliceCredentials(sliceCredentials), this.addCredentialExtraOptions(null));
        if (!reply.getGeniResponseCode().isSuccess()) {
            if (reply.getOutput() != null && reply.getOutput().contains("DUPLICATE")) {
                LOG.warn("Reply to shared slice was \"" + reply.getOutput() + "\". Assuming this means it is successfully shared already.");
                return;
            }
            throw new JFedException("Sharing slice with " + userUrn + " did not succeed: ", reply);
        }
    }

    @Override
    public void shareSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull List<GeniUrn> userUrns, @Nonnull String role) throws JFedException {
        List<FederationSliceAuthorityApi2.UrnRoleTuple> membersToAdd = userUrns.stream().map(userUrn -> new FederationSliceAuthorityApi2.UrnRoleTuple("SLICE", (GeniUrn)userUrn, role)).collect(Collectors.toList());
        AbstractFederationApi.FederationApiReply<String> reply = this.sa(logger).modifyMembership(this.getSaConnection(), "SLICE", sliceUrn, membersToAdd, null, null, this.finalizeSliceCredentials(sliceCredentials), this.addCredentialExtraOptions(null));
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Error adding user to " + sliceUrn, reply);
        }
    }

    @Override
    public void unshareSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn userUrn) throws JFedException {
        List<GeniUrn> membersToRemove = Collections.singletonList(userUrn);
        AbstractFederationApi.FederationApiReply<String> reply = this.sa(logger).modifyMembership(this.getSaConnection(), "SLICE", sliceUrn, null, membersToRemove, null, this.finalizeSliceCredentials(sliceCredentials), this.addCredentialExtraOptions(null));
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Unsharing slice with " + userUrn + " did not succeed: ", reply);
        }
    }

    @Override
    public List<GeniUrn> getUsersForSubAuthority(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull String projectName) throws JFedException {
        assert (this.getLoggedInUserAuthorityServer() != null);
        GeniUrn projectUrn = GeniUrn.createGeniUrnFromEncodedParts((String)this.getLoggedInUserAuthorityServer().getUrnTld(), (String)"project", (String)projectName);
        AbstractFederationApi.FederationApiReply<List<FederationSliceAuthorityApi2.UrnRoleTuple>> reply = this.sa(logger).lookupMembers(this.getSaConnection(), "PROJECT", projectUrn, this.addSpeaksForCredentials(this.userCredentials), this.addCredentialExtraOptions(null));
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Error getting users in project " + projectUrn, reply);
        }
        if (reply.getValue() == null) {
            throw new JFedException("Null reply value getting users in project " + projectUrn, reply);
        }
        return reply.getValue().stream().map(FederationSliceAuthorityApi2.UrnRoleTuple::getUrn).collect(Collectors.toList());
    }

    @Override
    public List<GeniUrn> getUsersForSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        AbstractFederationApi.FederationApiReply<List<FederationSliceAuthorityApi2.UrnRoleTuple>> reply = this.sa(logger).lookupMembers(this.getSaConnection(), "SLICE", sliceUrn, this.finalizeSliceCredentials(sliceCredentials), this.addCredentialExtraOptions(null));
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Error getting users in " + sliceUrn, reply);
        }
        if (reply.getValue() == null) {
            throw new JFedException("Null reply value getting users in " + sliceUrn, reply);
        }
        return reply.getValue().stream().map(FederationSliceAuthorityApi2.UrnRoleTuple::getUrn).collect(Collectors.toList());
    }

    @Override
    public boolean hasSubAuthDetailsSupport() {
        return true;
    }

    @Override
    public void getSubAuthorityDetails(@NotNull be.iminds.ilabt.jfed.log.Logger logger, @NotNull String projectName) throws JFedException {
        if (this.userCredentials == null) {
            throw new IllegalStateException("Cannot fetch SubAuthority Details when userCredentials are unknown");
        }
        assert (this.getLoggedInUserAuthorityServer() != null);
        HashMap<String, String> match = new HashMap<String, String>();
        List<String> filter = null;
        match.put("PROJECT_NAME", projectName);
        AbstractFederationApi.FederationApiReply<AbstractFederationApi.ProjectInfoList> reply = this.sa(logger).lookupProject(this.getSaConnection(), this.addSpeaksForCredentials(this.userCredentials), match, filter, null);
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Error getting project info for " + projectName, reply);
        }
        if (reply.getRawValue() == null) {
            throw new JFedException("Null reply raw value getting project info for \"" + projectName + "\"", reply);
        }
        if (reply.getValue() == null) {
            throw new JFedException("Null reply value getting project info for \"" + projectName + "\"", reply);
        }
    }

    @Override
    public UserAndSliceApiWrapper.SliceInfo createSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull String sliceName, Date expirationDate, @Nullable String subAuthName) throws JFedException {
        LOG.debug("createSlice called");
        FederationSliceAuthorityApi2.GetVersionSAResult gv = this.getGetVersionSAResult(logger);
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("SLICE_DESCRIPTION", "jFed Experimenter GUI slice '" + sliceName + "' for user " + this.getRelevantUserUrnString());
        if (gv.getServices().contains("PROJECT")) {
            if (subAuthName != null) {
                assert (this.getRelevantUserUrn() != null);
                GeniUrn project = GeniUrn.createGeniUrnFromEncodedParts((String)this.getRelevantUserUrn().getEncodedTopLevelAuthority(), (String)"project", (String)subAuthName);
                fields.put("SLICE_PROJECT_URN", project.getValue());
            } else {
                throw new JFedException("A project must be provided to create a slice");
            }
        }
        if (gv.getFieldsForObject("PROJECT").containsKey("_GENI_SLICE_EMAIL")) {
            AbstractFederationApi.MemberInfoList userIdentifyingInfo = this.getUserIdentifyingInfo(logger, this.getRelevantUserUrn());
            if (userIdentifyingInfo != null && ((AbstractFederationApi.MemberInfo)userIdentifyingInfo.get(this.getRelevantUserUrn())).getEmail() != null) {
                String userEmail = ((AbstractFederationApi.MemberInfo)userIdentifyingInfo.get(this.getRelevantUserUrn())).getEmail();
                fields.put("_GENI_SLICE_EMAIL", userEmail);
            } else {
                throw new JFedException("Slice creation requires a user email, but the user email is not known.");
            }
        }
        if (expirationDate != null) {
            fields.put("SLICE_EXPIRATION", RFC3339Util.dateToRFC3339String((Date)expirationDate, (boolean)true, (boolean)true, (boolean)true));
        }
        LOG.debug("createSlice is calling server with sliceName=" + sliceName + " and fields: " + fields);
        AbstractFederationApi.FederationApiReply<AbstractFederationApi.SliceInfo> reply = this.sa(logger).createSlice(this.getSaConnection(), this.addSpeaksForCredentials(this.userCredentials), sliceName, fields, this.addCredentialExtraOptions(null));
        LOG.debug("createSlice got answer from server");
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Error creating slice", reply);
        }
        AbstractFederationApi.SliceInfo sliceInfo = reply.getValue();
        AbstractFederationApi.FederationApiReply<List<AnyCredential>> credReply = this.sa(logger).getSliceCredentials(this.getSaConnection(), this.addSpeaksForCredentials(this.userCredentials), sliceInfo.getSliceUrn(), this.addCredentialExtraOptions(null));
        if (!credReply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Failed to get slice credentials", credReply);
        }
        ArrayList<AnyCredential> sliceCredentials = new ArrayList<AnyCredential>();
        if (this.speaksForCredentials != null && !this.speaksForCredentials.isEmpty()) {
            sliceCredentials.addAll(this.speaksForCredentials);
        }
        sliceCredentials.addAll((Collection)credReply.getValue());
        return new UserAndSliceApiWrapper.SliceInfo(sliceName, sliceInfo.getSliceUrn(), sliceCredentials);
    }

    @Override
    public List<AnyCredential> renewSlice(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull Date newExpirationDate) throws JFedException {
        GeniUrn sliceUrn;
        try {
            sliceUrn = UniformFederationApi2UserAndSliceApiWrapper.findSliceUrn(sliceCredentials);
        }
        catch (IllegalArgumentException e) {
            throw new JFedException("Could not find slice URN in provided slice credential list.");
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("SLICE_EXPIRATION", RFC3339Util.dateToRFC3339String((Date)newExpirationDate, (boolean)true, (boolean)true, (boolean)true));
        AbstractFederationApi.FederationApiReply<String> updateReply = this.sa(logger).updateSlice(this.getSaConnection(), this.finalizeSliceCredentials(sliceCredentials), sliceUrn, fields, this.addCredentialExtraOptions(null));
        if (!updateReply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Failed to update SLICE_EXPIRATION", updateReply);
        }
        AbstractFederationApi.FederationApiReply<List<AnyCredential>> credReply = this.sa(logger).getSliceCredentials(this.getSaConnection(), this.addSpeaksForCredentials(this.userCredentials), sliceUrn, this.addCredentialExtraOptions(null));
        if (!credReply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Failed to get updated slice credentials", credReply);
        }
        ArrayList<AnyCredential> newSliceCredentials = new ArrayList<AnyCredential>();
        if (this.speaksForCredentials != null && !this.speaksForCredentials.isEmpty()) {
            newSliceCredentials.addAll(this.speaksForCredentials);
        }
        newSliceCredentials.addAll((Collection)credReply.getValue());
        return newSliceCredentials;
    }

    @Override
    public List<String> getSshKeysForUser(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn userUrn) throws JFedException {
        AbstractFederationApi.FederationApiReply<AbstractFederationApi.MemberKeyInfoList> reply = this.ma(logger).lookupKeyForMember(this.getMaConnection(), this.addSpeaksForCredentials(this.userCredentials), userUrn, null, null, this.addCredentialExtraOptions(null));
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Failed to get SSH keys", reply);
        }
        AbstractFederationApi.LookupResult lRes = reply.getValue();
        ArrayList<String> res = new ArrayList<String>();
        if (lRes != null) {
            for (AbstractFederationApi.MemberKeyInfo key : lRes.values()) {
                if (key.getPublicKey() == null) continue;
                res.add(key.getPublicKey());
            }
        }
        try {
            HashMap<String, String> matchMember = new HashMap<String, String>();
            matchMember.put("MEMBER_URN", userUrn.toString());
            AbstractFederationApi.FederationApiReply<AbstractFederationApi.MemberInfoList> reply2 = this.ma(logger).lookupMember(this.getMaConnection(), this.addSpeaksForCredentials(this.userCredentials), matchMember, null, this.addCredentialExtraOptions(null));
            if (!reply.getGeniResponseCode().isSuccess()) {
                throw new JFedException("Failed to get SSH keys from user certificate because lookup MEMBER " + userUrn + " call failed", reply);
            }
            AbstractFederationApi.LookupResult lookupResult = reply2.getValue();
            if (lookupResult.size() != 1) {
                throw new JFedException("Failed to get SSH keys from user certificate because lookup MEMBER " + userUrn + " call does not contain a member ssl certificate", reply);
            }
            LOG.debug("Looked up member in order to find public key in ssl certificate");
            AbstractFederationApi.MemberInfo memberInfo = (AbstractFederationApi.MemberInfo)lookupResult.values().iterator().next();
            if (memberInfo.getX509pemCerts() == null) {
                throw new JFedException("Failed to get SSH keys from user certificate because lookup MEMBER " + userUrn + " call does not contain a member ssl certificate.", reply);
            }
            block3: for (X509Certificate cert : memberInfo.getX509pemCerts()) {
                List subjectUrns = KeyUtil.findUrnsInCertAltNames((X509Certificate)cert, (KeyUtil.AltNamesSource)KeyUtil.AltNamesSource.SUBJECT_ALT_NAMES, (boolean)false);
                LOG.debug("subjectUrns in cert: " + subjectUrns);
                for (GeniUrn subjectUrn : subjectUrns) {
                    if (!Objects.equals(subjectUrn.getResourceType(), "user")) continue;
                    String openSshKey = KeyUtil.publicKeyToOpenSshAuthorizedKeysFormat((PublicKey)cert.getPublicKey());
                    res.add(openSshKey);
                    LOG.debug("Got user key from certificate: " + openSshKey);
                    continue block3;
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to get SSH keys from user certificate", (Throwable)e);
        }
        LOG.debug("Keys (" + res.size() + ") seen for " + userUrn + ": " + res);
        ArrayList<String> uniqueRes = new ArrayList<String>();
        HashSet<String> seenKeys = new HashSet<String>();
        for (String key : res) {
            String[] parts = key.split(" ");
            if (parts.length >= 2 && parts[0].startsWith("ssh-")) {
                boolean added = seenKeys.add(parts[1]);
                if (added) {
                    uniqueRes.add(key);
                    continue;
                }
                LOG.debug("Duplicate key removed: " + key);
                continue;
            }
            LOG.warn("Unexpected key format seen: " + key);
            uniqueRes.add(key);
        }
        return uniqueRes;
    }

    @Override
    public UserAndSliceApiWrapper.SubAuthoritySupport getSubAuthoritySupport(@Nonnull be.iminds.ilabt.jfed.log.Logger logger) throws JFedException {
        FederationSliceAuthorityApi2.GetVersionSAResult getSAVersionRes = this.getGetVersionSAResult(logger);
        if (!getSAVersionRes.getServices().contains("PROJECT")) {
            return UserAndSliceApiWrapper.SubAuthoritySupport.SUB_AUTHORITY_FORBIDDEN;
        }
        return UserAndSliceApiWrapper.SubAuthoritySupport.SUB_AUTHORITY_MANDATORY;
    }

    @Override
    public List<String> getSubAuthorityNames(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUrn user) throws JFedException {
        List<String> res = this.getUserProjects(logger, user).stream().map(GeniUrn::getEncodedResourceName).collect(Collectors.toList());
        LOG.debug("returning subauthorities: {}", res);
        return res;
    }

    @Override
    public void setSpeaksFor(List<AnyCredential> speaksForCredentials, @Nullable GeniUrn speakingForUrn) {
        super.setSpeaksFor(speaksForCredentials, speakingForUrn);
        if (speakingForUrn != null) {
            this.setExtraOptionsForCallsWithCredential(Collections.singletonMap("speaking_for", speakingForUrn.getValue()));
        }
    }
}

