/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.lib;

public class RetrySettings {
    public static final int DEFAULT_TIMEOUT_MAX_RETRIES = 3;
    public static final int DEFAULT_TIMEOUT_MS_BEFORE_RETRY = 5000;
    public static final int DEFAULT_BUSY_MAX_RETRIES = 100;
    public static final int DEFAULT_BUSY_MS_BEFORE_RETRY = 5000;
    public static final int DEFAULT_POSSIBLE_TEMPORARY_ERROR_MAX_RETRIES = 1;
    public static final int DEFAULT_POSSIBLE_TEMPORARY_ERROR_MS_BEFORE_RETRY = 1000;
    private final int timeoutMaxRetries;
    private final long timeoutMsBeforeRetry;
    private final int busyMaxRetries;
    private final long busyMsBeforeRetry;
    private final int possibleTemporaryErrorMaxRetries;
    private final long possibleTemporaryErrorMsBeforeRetry;

    public static RetrySettings getNoRetrySettings() {
        return new RetrySettings(0, 0L, 0, 0L, 0, 0L);
    }

    public RetrySettings() {
        this.timeoutMaxRetries = 3;
        this.timeoutMsBeforeRetry = 5000L;
        this.busyMaxRetries = 100;
        this.busyMsBeforeRetry = 5000L;
        this.possibleTemporaryErrorMaxRetries = 1;
        this.possibleTemporaryErrorMsBeforeRetry = 1000L;
    }

    public RetrySettings(int timeoutMaxRetries, long timeoutMsBeforeRetry, int busyMaxRetries, long busyMsBeforeRetry, int possibleTemporaryErrorMaxRetries, long possibleTemporaryErrorMsBeforeRetry) {
        this.timeoutMaxRetries = timeoutMaxRetries;
        this.timeoutMsBeforeRetry = timeoutMsBeforeRetry;
        this.busyMaxRetries = busyMaxRetries;
        this.busyMsBeforeRetry = busyMsBeforeRetry;
        this.possibleTemporaryErrorMaxRetries = possibleTemporaryErrorMaxRetries;
        this.possibleTemporaryErrorMsBeforeRetry = possibleTemporaryErrorMsBeforeRetry;
    }

    public int getTimeoutMaxRetries() {
        return this.timeoutMaxRetries;
    }

    public boolean isAutoRetryOnTimeout() {
        return this.timeoutMaxRetries > 0;
    }

    public int getBusyMaxRetries() {
        return this.busyMaxRetries;
    }

    public long getTimeoutMsBeforeRetry() {
        return this.timeoutMsBeforeRetry;
    }

    public long getBusyMsBeforeRetry() {
        return this.busyMsBeforeRetry;
    }

    public int getPossibleTemporaryErrorMaxRetries() {
        return this.possibleTemporaryErrorMaxRetries;
    }

    public long getPossibleTemporaryErrorMsBeforeRetry() {
        return this.possibleTemporaryErrorMsBeforeRetry;
    }

    public String toString() {
        return "RetrySettings{timeoutMaxRetries=" + this.timeoutMaxRetries + ", timeoutMsBeforeRetry=" + this.timeoutMsBeforeRetry + ", busyMaxRetries=" + this.busyMaxRetries + ", busyMsBeforeRetry=" + this.busyMsBeforeRetry + ", possibleTemporaryErrorMaxRetries=" + this.possibleTemporaryErrorMaxRetries + ", possibleTemporaryErrorMsBeforeRetry=" + this.possibleTemporaryErrorMsBeforeRetry + "}";
    }
}

