/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.stitching;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import javax.annotation.Nonnull;

public class VlanRange
implements Collection<Integer> {
    private List<Range> origRanges = new ArrayList<Range>();

    public VlanRange(VlanRange o) {
        this(o.toString());
    }

    public VlanRange(Collection<Integer> c) {
        TreeSet<Integer> s = new TreeSet<Integer>(c);
        Range curRange = null;
        for (Integer i : s) {
            if (curRange != null && curRange.to + 1 == i) {
                curRange = new Range(curRange.from, i);
                continue;
            }
            if (curRange != null) {
                this.origRanges.add(curRange);
            }
            curRange = new Range(i, i);
        }
        if (curRange != null) {
            this.origRanges.add(curRange);
        }
    }

    public VlanRange(String rangeString) {
        Object[] parts;
        if (rangeString.trim().isEmpty()) {
            return;
        }
        for (String string : parts = rangeString.split(",")) {
            assert (!string.contains(",")) : "part contains comma. part=\"" + string + "\" rangeString=\"" + rangeString + "\" parts=" + Arrays.toString(parts);
            if (string.trim().isEmpty()) continue;
            Range r = new Range(string);
            this.origRanges.add(r);
        }
    }

    public static String rangesToString(List<Range> ranges) {
        Object res = "";
        boolean isFirst = true;
        for (Range r : ranges) {
            if (!isFirst) {
                res = (String)res + ",";
            }
            res = r.to == r.from ? (String)res + r.to : (String)res + r.from + "-" + r.to;
            isFirst = false;
        }
        return res;
    }

    private static List<Range> sortRanges(List<Range> origRanges) {
        ArrayList<Range> res = new ArrayList<Range>(origRanges);
        Collections.sort(res);
        return res;
    }

    @Override
    public int size() {
        int res = 0;
        for (Range r : this.origRanges) {
            res += r.size();
        }
        return res;
    }

    @Override
    public boolean isEmpty() {
        for (Range r : this.origRanges) {
            if (r.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean contains(int i) {
        for (Range r : this.origRanges) {
            if (!r.contains(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Integer)) {
            return false;
        }
        int i = (Integer)o;
        return this.contains(i);
    }

    public Integer getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        Range first = this.origRanges.get(0);
        assert (first != null);
        assert (!first.isEmpty());
        return first.from;
    }

    @Nonnull
    public Iterator iterator() {
        return new Iterator(new ArrayList<Range>(this.origRanges));
    }

    @Nonnull
    public Integer[] toArray() {
        Integer[] res = new Integer[this.size()];
        int j = 0;
        for (Range r : this.origRanges) {
            for (int i = r.from; i <= r.to; ++i) {
                res[j++] = i;
            }
        }
        return res;
    }

    @Override
    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public boolean add(Integer integer) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends Integer> c) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String toString() {
        return VlanRange.rangesToString(this.origRanges);
    }

    public List<Range> getRanges() {
        return new ArrayList<Range>(this.origRanges);
    }

    @Override
    public void clear() {
        this.origRanges.clear();
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> c) {
        TreeSet toBeRemoved = new TreeSet(c);
        boolean changed = false;
        ArrayList<Range> newRanges = new ArrayList<Range>();
        LinkedList<Range> oldRanges = new LinkedList<Range>(VlanRange.sortRanges(this.origRanges));
        while (!oldRanges.isEmpty()) {
            Range oldRange = (Range)oldRanges.removeFirst();
            for (Object r : toBeRemoved) {
                if (!(r instanceof Integer) || oldRange == null || !oldRange.contains((Integer)r)) continue;
                changed = true;
                Range.Pair<Range, Range> splitRanges = oldRange.split((Integer)r);
                if (splitRanges.getFirst() != null) {
                    newRanges.add(splitRanges.getFirst());
                }
                if ((oldRange = splitRanges.getSecond()) != null) continue;
                break;
            }
            if (oldRange == null) continue;
            newRanges.add(oldRange);
        }
        this.origRanges = newRanges;
        return changed;
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        TreeSet<Integer> orig = new TreeSet<Integer>(this);
        boolean changed = orig.retainAll(c);
        this.origRanges = new VlanRange(orig).origRanges;
        return changed;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VlanRange that = (VlanRange)o;
        return Objects.equals(this.toString(), that.toString());
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    public static class Range
    implements Comparable<Range> {
        final int from;
        final int to;

        public Range(String r) {
            if (r == null || r.trim().isEmpty()) {
                throw new RuntimeException("new Range(\"" + r + "\") -> Range constructor called with empty string");
            }
            if (!r.matches("[0-9-]*")) {
                throw new RuntimeException("new Range(\"" + r + "\") -> Range constructor called with invalid string");
            }
            try {
                if (!r.contains("-")) {
                    this.from = this.to = Integer.parseInt(r);
                    return;
                }
                String[] parts = r.split("-");
                assert (parts.length == 2);
                this.from = Integer.parseInt(parts[0]);
                this.to = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Error parsing Range \"" + r + "\": " + e.getMessage(), e);
            }
        }

        public Range(Range o) {
            this.from = o.from;
            this.to = o.to;
        }

        public Range(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public Range(int single) {
            this.from = single;
            this.to = single;
        }

        public boolean isEmpty() {
            return this.to < this.from;
        }

        public boolean contains(int i) {
            return i >= this.from && i <= this.to;
        }

        public Pair<Range, Range> split(int i) {
            if (i < this.from || i > this.to) {
                throw new OutOfBoundsException("Range(" + this.from + "," + this.to + ") cannot be split at " + i);
            }
            if (i == this.from && this.to == this.from) {
                return new Pair<Object, Object>(null, null);
            }
            if (i == this.from) {
                return new Pair<Object, Range>(null, new Range(this.from + 1, this.to));
            }
            if (i == this.to) {
                return new Pair<Range, Object>(new Range(this.from, this.to - 1), null);
            }
            return new Pair<Range, Range>(new Range(this.from, i - 1), new Range(i + 1, this.to));
        }

        @Override
        public int compareTo(@Nonnull Range o) {
            if (this.from < o.from) {
                return -1;
            }
            if (this.from > o.from) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Range range = (Range)o;
            if (this.from != range.from) {
                return false;
            }
            return this.to == range.to;
        }

        public int hashCode() {
            int result = this.from;
            result = 31 * result + this.to;
            return result;
        }

        public String toString() {
            return this.from + "-" + this.to;
        }

        public int size() {
            if (this.isEmpty()) {
                return 0;
            }
            return this.to + 1 - this.from;
        }

        public static class OutOfBoundsException
        extends RuntimeException {
            public OutOfBoundsException() {
            }

            public OutOfBoundsException(String s) {
                super(s);
            }
        }

        public static class Pair<T, U> {
            final T t;
            final U u;

            public Pair(T t, U u) {
                this.t = t;
                this.u = u;
            }

            public T getFirst() {
                return this.t;
            }

            public U getSecond() {
                return this.u;
            }
        }
    }

    public class Iterator
    implements java.util.Iterator<Integer> {
        private final List<Range> itRanges;

        public Iterator(List<Range> itRanges) {
            this.itRanges = itRanges;
        }

        @Override
        public boolean hasNext() {
            if (this.itRanges.isEmpty()) {
                return false;
            }
            Range first = this.itRanges.get(0);
            assert (!first.isEmpty());
            return !first.isEmpty();
        }

        @Override
        public Integer next() {
            if (this.itRanges.isEmpty()) {
                return null;
            }
            Range first = this.itRanges.get(0);
            assert (!first.isEmpty());
            int res = first.from;
            assert (!first.isEmpty());
            first = new Range(first.from + 1, first.to);
            this.itRanges.set(0, first);
            if (first.isEmpty()) {
                this.itRanges.remove(0);
            }
            return res;
        }
    }
}

