/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.user;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserFactory;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserWithSpeaksFor;
import be.iminds.ilabt.jfed.lowlevel.userloginmodel.InvalidLoginException;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.io.File;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleGeniUser
implements GeniUser {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleGeniUser.class);
    protected final List<X509Certificate> certificateChain;
    protected final PrivateKey privateKey;
    protected final PublicKey publicKey;
    protected final Server userAuthorityServer;
    protected final GeniUrn userUrn;
    protected final File privateKeyFile;
    protected final File certificateKeyFile;

    public SimpleGeniUser(@Nullable Server userAuthorityServer, @Nonnull GeniUrn userUrn, @Nonnull String keyCertContent, @Nullable char[] keyPass, @Nullable File certificateKeyFile, @Nullable File privateKeyFile) throws InvalidLoginException {
        PrivateKey privateKey;
        this.userAuthorityServer = userAuthorityServer;
        this.userUrn = userUrn;
        this.certificateKeyFile = certificateKeyFile;
        this.privateKeyFile = privateKeyFile;
        try {
            privateKey = KeyUtil.pemToAnyPrivateKey((String)keyCertContent, (char[])keyPass);
        }
        catch (KeyUtil.PEMDecodingException e) {
            throw new InvalidLoginException("ERROR reading PEM key:" + keyCertContent + " -> " + e.getMessage(), e);
        }
        if (privateKey == null) {
            throw new InvalidLoginException("ERROR: PEM key and certificate does not contain a key:" + keyCertContent);
        }
        this.privateKey = privateKey;
        this.certificateChain = KeyUtil.pemToX509CertificateChain((String)keyCertContent);
        if (this.certificateChain == null || this.certificateChain.isEmpty()) {
            throw new InvalidLoginException("ERROR: PEM key and certificate does not contain a X509 certificate:" + keyCertContent);
        }
        this.publicKey = this.certificateChain.get(0).getPublicKey();
        try {
            assert (Objects.equals(userUrn, GeniUserFactory.deriveUserUrnFromCertificateChain(this.certificateChain))) : "Provided Urn doesn't match the one in the certificate chain";
        }
        catch (CertificateParsingException e) {
            throw new RuntimeException("Could not parse certificate while creating GeniUser", e);
        }
    }

    public SimpleGeniUser(@Nullable Server userAuthorityServer, @Nonnull GeniUrn userUrn, @Nonnull List<X509Certificate> certificateChain, @Nonnull PrivateKey privateKey, @Nullable File certificateKeyFile, @Nullable File privateKeyFile) {
        this.userAuthorityServer = userAuthorityServer;
        this.userUrn = userUrn;
        this.privateKey = privateKey;
        this.certificateChain = certificateChain;
        this.certificateKeyFile = certificateKeyFile;
        this.privateKeyFile = privateKeyFile;
        assert (!certificateChain.isEmpty());
        this.publicKey = certificateChain.get(0).getPublicKey();
        try {
            assert (Objects.equals(userUrn, GeniUserFactory.deriveUserUrnFromCertificateChain(certificateChain))) : "Provided Urn doesn't match the one in the certificate chain";
        }
        catch (CertificateParsingException e) {
            throw new RuntimeException("Could not parse certificate while creating GeniUser", e);
        }
    }

    public SimpleGeniUser(GeniUser geniUser) {
        if (geniUser instanceof GeniUserWithSpeaksFor) {
            LOG.warn("Making a copy of a GeniUserWithSpeaksFor with SimpleGeniUser will DISCARD the speaks_for details.");
        }
        this.userAuthorityServer = geniUser.getUserAuthorityServer();
        this.userUrn = GeniUrn.parse((String)geniUser.getUserUrnString());
        this.publicKey = geniUser.getPublicKey();
        this.privateKey = geniUser.getPrivateKey();
        this.privateKeyFile = geniUser.getPrivateKeyFile();
        this.certificateChain = geniUser.getClientCertificateChain();
        this.certificateKeyFile = geniUser.getCertificateFile();
        assert (!this.certificateChain.isEmpty());
        assert (Objects.equals(this.certificateChain.get(0).getPublicKey(), this.publicKey));
    }

    @Override
    @Nonnull
    public List<X509Certificate> getClientCertificateChain() {
        return this.certificateChain;
    }

    @Override
    @Nonnull
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    @Nonnull
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public Server getUserAuthorityServer() {
        return this.userAuthorityServer;
    }

    @Override
    public Integer getUserAuthorityServerId() {
        return (Integer)this.userAuthorityServer.getId();
    }

    @Override
    @Nonnull
    public GeniUrn getUserUrn() {
        return this.userUrn;
    }

    @Override
    public File getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    @Override
    public File getCertificateFile() {
        return this.certificateKeyFile;
    }

    @Override
    @Nonnull
    public String getUserUrnString() {
        return this.userUrn.toString();
    }
}

