/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.lib;

import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.ssh_terminal_tool.known_hosts.OpenSshKnownHostsFile;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import be.iminds.ilabt.jfed.util.library.OpenSSHKnownHostsInMemory;
import be.iminds.ilabt.jfed.util.library.SshProxySocketImplFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.LocalPortForwarder;
import net.schmizz.sshj.connection.channel.direct.Parameters;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.keyprovider.KeyPairWrapper;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LocalForwardUtil {
    private static final Logger LOG = LoggerFactory.getLogger(LocalForwardUtil.class);
    private final GeniUserProvider geniUserProvider;
    private final OpenSshKnownHostsFile openSshKnownHostsFile;
    private static final int START_FORWARD_PORT = 11111;
    private int nextForwardPort = 11111;
    private Map<ForwardKey, Forward> activeForwards = new ConcurrentHashMap<ForwardKey, Forward>();

    @Inject
    public LocalForwardUtil(GeniUserProvider geniUserProvider, OpenSshKnownHostsFile openSshKnownHostsFile) {
        this.geniUserProvider = geniUserProvider;
        this.openSshKnownHostsFile = openSshKnownHostsFile;
    }

    public int forwardOverSshProxy(@Nonnull JFedConnection.SshProxyInfo sshProxyInfo, @Nonnull String remoteHostName, int remotePort) throws IOException {
        ForwardKey forwardKey = new ForwardKey(sshProxyInfo, remoteHostName, remotePort);
        Forward foundForward = this.activeForwards.get(forwardKey);
        if (foundForward != null) {
            LOG.debug("Found existing LocalForward: " + foundForward);
            return foundForward.getLocalPort();
        }
        int forwardPort = this.nextForwardPort++;
        SSHClient sshClient = new SSHClient((Config)SshProxySocketImplFactory.getDefaultjFedSshConfig());
        if (sshProxyInfo.getHostKey() != null) {
            sshClient.addHostKeyVerifier((HostKeyVerifier)new OpenSSHKnownHostsInMemory(sshProxyInfo.getHostKey()));
        } else {
            LOG.warn("Cannot verify proxy host as no known_hosts-line is specified");
            sshClient.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        }
        sshClient.setTimeout(8000);
        sshClient.setConnectTimeout(10000);
        LOG.debug("Connecting to " + sshProxyInfo.getHostname() + ":" + sshProxyInfo.getPort() + " as user " + sshProxyInfo.getUsername() + " with timeout 10000 ms");
        sshClient.connect(sshProxyInfo.getHostname(), sshProxyInfo.getPort());
        LOG.debug("Connect done. Will now authenticate.");
        try {
            assert (sshProxyInfo.getUsername() != null);
            assert (sshProxyInfo.getSshKeyInfo() != null);
            assert (sshProxyInfo.getSshKeyInfo().getPrivateKey() != null);
            assert (KeyUtil.matchingKeys((PublicKey)sshProxyInfo.getSshKeyInfo().getPublicKey(), (PrivateKey)sshProxyInfo.getSshKeyInfo().getPrivateKey()));
            sshClient.authPublickey(sshProxyInfo.getUsername(), new KeyProvider[]{new KeyPairWrapper(sshProxyInfo.getSshKeyInfo().getPublicKey(), sshProxyInfo.getSshKeyInfo().getPrivateKey())});
            LOG.debug("Connected and authenticated to {}:{}", (Object)sshProxyInfo.getHostname(), (Object)sshProxyInfo.getPort());
        }
        catch (UserAuthException ex) {
            LOG.warn("Connected to {}:{}, but authentication failed", (Object)sshProxyInfo.getHostname(), (Object)sshProxyInfo.getPort());
            throw new IOException("Failed to authenticate user \"" + sshProxyInfo.getUsername() + "\" on server " + sshProxyInfo.getHostname() + ":" + sshProxyInfo.getPort(), ex);
        }
        Parameters params = new Parameters("0.0.0.0", forwardPort, remoteHostName, remotePort);
        ServerSocket ss = new ServerSocket();
        ss.setReuseAddress(true);
        ss.bind(new InetSocketAddress(params.getLocalHost(), params.getLocalPort()));
        LocalPortForwarder localPortForwarder = sshClient.newLocalPortForwarder(params, ss);
        Thread listenThread = new Thread(() -> {
            try {
                localPortForwarder.listen();
            }
            catch (IOException e) {
                LOG.warn("Error while forwarding " + forwardKey, (Throwable)e);
                this.close(forwardKey);
            }
            finally {
                LOG.warn("Closed forwarding " + forwardKey);
                this.close(forwardKey);
            }
        });
        Forward forward = new Forward(sshProxyInfo, localPortForwarder, remoteHostName, remotePort, forwardPort, sshClient, listenThread);
        listenThread.start();
        assert (forward.getKey().equals(forwardKey));
        this.activeForwards.put(forwardKey, forward);
        return forwardPort;
    }

    private void close(@Nullable ForwardKey forwardKey) {
        if (forwardKey == null) {
            return;
        }
        Forward foundForward = this.activeForwards.remove(forwardKey);
        if (foundForward != null) {
            foundForward.close();
        }
    }

    public void close(JFedConnection.SshProxyInfo sshProxyInfo, String remoteHostName, int remotePort) {
        this.close(new ForwardKey(sshProxyInfo, remoteHostName, remotePort));
    }

    public void close(int localPort) {
        throw new RuntimeException("Not yet implemented");
    }

    public void close() {
        HashSet<ForwardKey> allKeys = new HashSet<ForwardKey>(this.activeForwards.keySet());
        for (ForwardKey key : allKeys) {
            this.close(key);
        }
    }

    private static class ForwardKey {
        @Nonnull
        private final JFedConnection.SshProxyInfo sshProxyInfo;
        @Nonnull
        private final String remoteHostName;
        private final int remotePort;

        public ForwardKey(@Nonnull JFedConnection.SshProxyInfo sshProxyInfo, @Nonnull String remoteHostName, int remotePort) {
            this.sshProxyInfo = sshProxyInfo;
            this.remoteHostName = remoteHostName;
            this.remotePort = remotePort;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ForwardKey forward = (ForwardKey)o;
            if (this.remotePort != forward.remotePort) {
                return false;
            }
            if (!this.sshProxyInfo.equals((Object)forward.sshProxyInfo)) {
                return false;
            }
            return this.remoteHostName.equals(forward.remoteHostName);
        }

        public int hashCode() {
            int result = this.sshProxyInfo.hashCode();
            result = 31 * result + this.remoteHostName.hashCode();
            result = 31 * result + this.remotePort;
            return result;
        }
    }

    private static class Forward {
        @Nonnull
        private final JFedConnection.SshProxyInfo sshProxyInfo;
        @Nullable
        private LocalPortForwarder localPortForwarder;
        @Nullable
        private SSHClient sshClient;
        @Nonnull
        private final String remoteHostName;
        private final int remotePort;
        private final int localPort;
        @Nonnull
        private final Thread listenThread;

        public Forward(@Nonnull JFedConnection.SshProxyInfo sshProxyInfo, @Nullable LocalPortForwarder localPortForwarder, @Nonnull String remoteHostName, int remotePort, int localPort, @Nullable SSHClient sshClient, @Nonnull Thread listenThread) {
            this.sshProxyInfo = sshProxyInfo;
            this.localPortForwarder = localPortForwarder;
            this.sshClient = sshClient;
            this.remoteHostName = remoteHostName;
            this.remotePort = remotePort;
            this.localPort = localPort;
            this.listenThread = listenThread;
        }

        public ForwardKey getKey() {
            return new ForwardKey(this.sshProxyInfo, this.remoteHostName, this.remotePort);
        }

        public int getLocalPort() {
            return this.localPort;
        }

        public void close() {
            block10: {
                try {
                    if (this.localPortForwarder != null) {
                        try {
                            this.localPortForwarder.close();
                        }
                        finally {
                            this.localPortForwarder = null;
                        }
                    }
                    if (this.sshClient == null) break block10;
                    try {
                        this.sshClient.close();
                    }
                    finally {
                        this.sshClient = null;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public String toString() {
            return "Forward{sshProxyInfo=" + this.sshProxyInfo + ", localPortForwarder=" + this.localPortForwarder + ", sshClient=" + (this.sshClient != null ? "non-null" : "null") + ", remoteHostName='" + this.remoteHostName + "', remotePort=" + this.remotePort + ", localPort=" + this.localPort + "}";
        }
    }
}

