/*
 * Decompiled with CFR 0.152.
 */
package org.rendersnake.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackedMap
implements Map<String, Object> {
    public static int MAX_STACK_DEPTH = 16;
    public static int INITIAL_MAP_CAPACITY = 7;
    private HashMap<String, Object>[] stack;
    private int depth = -1;

    public StackedMap() {
        this.init();
    }

    public StackedMap(Map<? extends String, ? extends Object> m) {
        this();
        this.putAll(m);
    }

    private void init() {
        this.depth = -1;
        this.stack = new HashMap[MAX_STACK_DEPTH];
        this.push();
    }

    public void push() {
        ++this.depth;
        HashMap<String, Object> existing = this.stack[this.depth];
        if (existing == null) {
            this.stack[this.depth] = new HashMap(INITIAL_MAP_CAPACITY);
        } else {
            existing.clear();
        }
    }

    public void pop() {
        if (this.depth == 0) {
            throw new IllegalStateException("getDepth() == 0");
        }
        --this.depth;
    }

    public int getDepth() {
        return this.depth;
    }

    private HashMap<String, Object> top() {
        return this.stack[this.depth];
    }

    @Override
    public void clear() {
        for (HashMap<String, Object> each : this.stack) {
            if (each == null) continue;
            each.clear();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        for (int level = this.depth; level != -1; --level) {
            HashMap<String, Object> here = this.stack[level];
            if (here == null || !here.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (int level = this.depth; level != -1; --level) {
            HashMap<String, Object> here = this.stack[level];
            if (!here.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> union = new HashSet<Map.Entry<String, Object>>();
        for (int level = this.depth; level != -1; --level) {
            HashMap<String, Object> here = this.stack[level];
            union.addAll(here.entrySet());
        }
        return union;
    }

    @Override
    public boolean isEmpty() {
        for (int level = this.depth; level != -1; --level) {
            HashMap<String, Object> here = this.stack[level];
            if (here.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> union = new HashSet<String>();
        for (int level = this.depth; level != -1; --level) {
            HashMap<String, Object> here = this.stack[level];
            union.addAll(here.keySet());
        }
        return union;
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        for (int level = this.depth; level != -1; --level) {
            HashMap<String, Object> here = this.stack[level];
            if (here == null || !here.containsKey(key)) continue;
            return here.get(key);
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        return this.top().put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        if (m == null) {
            throw new IllegalArgumentException("m == null");
        }
        this.top().putAll(m);
    }

    @Override
    public Object remove(Object key) {
        Object objectToReturn = null;
        for (int level = this.depth; level != -1; --level) {
            HashMap<String, Object> here = this.stack[level];
            Object value = here.remove(key);
            if (objectToReturn != null) continue;
            objectToReturn = value;
        }
        return objectToReturn;
    }

    @Override
    public int size() {
        int total = 0;
        for (int level = this.depth; level != -1; --level) {
            HashMap<String, Object> here = this.stack[level];
            total += here.size();
        }
        return total;
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> union = new ArrayList<Object>();
        for (String each : this.keySet()) {
            union.add(this.get(each));
        }
        return union;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (int level = this.depth; level != -1; --level) {
            HashMap<String, Object> here = this.stack[level];
            hash |= here.hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object otherMap) {
        if (!(otherMap instanceof StackedMap)) {
            return false;
        }
        StackedMap otherStackedMap = (StackedMap)otherMap;
        for (int level = this.depth; level != -1; --level) {
            if (this.stack[level].equals(otherStackedMap.stack[level])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append('[');
        Object[] keys = this.keySet().toArray();
        Arrays.sort(keys);
        for (Object each : keys) {
            sb.append(each).append('=').append(this.get(each)).append('\n');
        }
        sb.append(']');
        return sb.toString();
    }
}

