/*
 * Decompiled with CFR 0.152.
 */
package org.rendersnake.tools;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.rendersnake.HtmlCanvas;
import org.rendersnake.Renderable;

public class PrettyWriter
extends Writer {
    public Writer writer;
    public int indentLevel = 0;
    private boolean inString = false;
    private boolean lastCharWasSlash = false;

    public PrettyWriter() {
        this.writer = new StringWriter(1024);
    }

    public PrettyWriter(Writer wrapped) {
        this.writer = wrapped;
    }

    public static String toString(Renderable component) {
        HtmlCanvas html = new HtmlCanvas(new PrettyWriter());
        try {
            component.renderOn(html);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error writing HTML for component:" + component);
        }
        return html.toHtml();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (len < 2) {
            if (this.lastCharWasSlash && cbuf[0] == '>') {
                --this.indentLevel;
            }
            this.lastCharWasSlash = cbuf[0] == '/';
            this.writer.write(cbuf, off, len);
            return;
        }
        if (cbuf[off] == '<') {
            if (cbuf[off + 1] == '/') {
                --this.indentLevel;
                this.doIndent(this.indentLevel);
                this.writer.write(cbuf, off, len);
                this.writer.write(10);
                return;
            }
            if (cbuf[off + len - 2] == '/') {
                this.doIndent(this.indentLevel);
                this.writer.write(cbuf, off, len);
                this.writer.write(10);
                return;
            }
            if (cbuf[off + len - 1] == '>') {
                this.doIndent(this.indentLevel);
                ++this.indentLevel;
                this.writer.write(cbuf, off, len);
                this.checkQuotes(cbuf, off, len);
                this.doNewLine();
                return;
            }
            this.doIndent(this.indentLevel);
            ++this.indentLevel;
            this.writer.write(cbuf, off, len);
            return;
        }
        if (cbuf[off + len - 2] == '/') {
            this.writer.write(cbuf, off, len);
            --this.indentLevel;
            this.doIndent(this.indentLevel);
            return;
        }
        this.checkQuotes(cbuf, off, len);
        this.writer.write(cbuf, off, len);
    }

    private void doIndent(int level) throws IOException {
        if (this.inString || level == 0) {
            return;
        }
        this.doNewLine();
        for (int i = 0; i < level; ++i) {
            this.writer.write(9);
        }
    }

    private void doNewLine() throws IOException {
        if (!this.inString) {
            this.writer.write(10);
        }
    }

    private void checkQuotes(char[] cbuf, int off, int len) {
        int quotes = 0;
        for (int i = 0; i < len; ++i) {
            quotes += cbuf[i + off] == '\"' ? 1 : 0;
        }
        this.inString = this.inString ? quotes % 2 == 0 : quotes % 2 == 1;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public String toString() {
        return this.writer.toString();
    }
}

