/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.io.IOException;
import org.rrd4j.core.RrdByteArrayBackend;
import org.rrd4j.core.RrdMongoDBBackendFactory;

public class RrdMongoDBBackend
extends RrdByteArrayBackend {
    private final RrdMongoDBBackendFactory.MongoWrapper wrapper;
    private volatile boolean dirty = false;

    public RrdMongoDBBackend(String path, RrdMongoDBBackendFactory.MongoWrapper wrapper) {
        super(path);
        this.wrapper = wrapper;
        BasicDBObject query = new BasicDBObject("path", (Object)path);
        DBObject rrdObject = wrapper.get(query);
        if (rrdObject != null) {
            this.buffer = (byte[])rrdObject.get("rrd");
        }
    }

    @Override
    protected synchronized void write(long offset, byte[] bytes) throws IOException {
        super.write(offset, bytes);
        this.dirty = true;
    }

    @Override
    public void close() throws IOException {
        if (this.dirty) {
            BasicDBObject query = new BasicDBObject("path", (Object)this.getPath());
            this.wrapper.save(query, this.buffer);
        }
    }
}

