/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.convert;

import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.RspecFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.parser.ExtraXml;
import be.iminds.ilabt.jfed.rspec.parser.RspecXmlConstants;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RspecConverter {
    private static final Logger LOG = LoggerFactory.getLogger(RspecConverter.class);

    public ModelRspec convertManifestToRequest(ModelRspec source, boolean keepNodeBindings, RspecFactory rspecFactory) {
        if (Objects.equals(source.getType(), "request")) {
            LOG.warn("convertManifestToRequest was asked to convert a request rspec. This will be ignored, and we will act as if it was a manifest.");
        }
        if (Objects.equals(source.getType(), "advertisement")) {
            LOG.warn("convertManifestToRequest was asked to convert an advertisement rspec. This will be ignored, and we will act as if it was a manifest.");
        }
        ModelRspec res = rspecFactory.copyModelRspec(source, "request");
        for (RspecNode rspecNode : res.getNodes()) {
            rspecNode.setComponentName(null);
            if (!keepNodeBindings) {
                rspecNode.setComponentId((String)null);
            }
            rspecNode.setLoginServices(Collections.emptyList());
            rspecNode.setSliverId((String)null);
            ListIterator<ExtraXml> it = rspecNode.getExtraXml().listIterator();
            while (it.hasNext()) {
                ExtraXml extraXml = it.next();
                if (Objects.equals(RspecXmlConstants.Q_NODE_HOST, extraXml.getStartElementName())) {
                    it.remove();
                }
                if (!Objects.equals(RspecXmlConstants.Q_NODE_VNODE, extraXml.getStartElementName())) continue;
                it.remove();
            }
            for (RspecInterface rspecInterface : rspecNode.getInterfaces()) {
                rspecInterface.setSliverId((String)null);
                rspecInterface.setMacAddress(null);
                rspecInterface.setComponentId(null);
            }
        }
        for (RspecLink rspecLink : res.getLinks()) {
            rspecLink.setSliverId((String)null);
            rspecLink.setVlanTag(null);
            for (RspecInterface rspecInterface : rspecLink.getInterfaces()) {
                rspecInterface.setSliverId((String)null);
                rspecInterface.setComponentId(null);
                rspecInterface.setMacAddress(null);
            }
        }
        ListIterator<ExtraXml> it = res.getExtraXml().listIterator();
        while (it.hasNext()) {
            ExtraXml extraXml = it.next();
            if (!Objects.equals(extraXml.getStartElementName(), RspecXmlConstants.Q_STITCHING)) continue;
            it.remove();
        }
        return res;
    }

    public ModelRspec removeComponentManagerBindings(ModelRspec source, RspecFactory rspecFactory) {
        ModelRspec res = rspecFactory.copyModelRspec(source, null);
        for (RspecNode rspecNode : res.getNodes()) {
            rspecNode.setComponentName(null);
            rspecNode.setComponentId((String)null);
            rspecNode.setComponentManagerId((String)null);
            for (RspecInterface rspecInterface : rspecNode.getInterfaces()) {
                rspecInterface.setComponentId(null);
            }
        }
        for (RspecLink rspecLink : res.getLinks()) {
            rspecLink.getComponentManagerUrns().clear();
            for (RspecInterface rspecInterface : rspecLink.getInterfaces()) {
                rspecInterface.setComponentId(null);
            }
        }
        return res;
    }

    public ModelRspec forceComponentManagerBindings(ModelRspec source, RspecFactory rspecFactory, GeniUrn componentManagerUrn) {
        GeniUrn ifaceCompIdUrn;
        ModelRspec res = rspecFactory.copyModelRspec(source, null);
        for (RspecNode rspecNode : res.getNodes()) {
            rspecNode.setComponentManagerId(componentManagerUrn);
            if (rspecNode.getComponentId() != null && !Objects.equals(rspecNode.getComponentId().getTopLevelAuthority(), componentManagerUrn.getTopLevelAuthority())) {
                rspecNode.setComponentId((String)null);
                rspecNode.setComponentName(null);
            }
            for (RspecInterface rspecInterface : rspecNode.getInterfaces()) {
                if (rspecInterface.getComponentId() == null) continue;
                ifaceCompIdUrn = GeniUrn.parse((String)rspecInterface.getComponentId());
                if (ifaceCompIdUrn == null) {
                    rspecInterface.setComponentId(null);
                    continue;
                }
                if (Objects.equals(ifaceCompIdUrn.getTopLevelAuthority(), componentManagerUrn.getTopLevelAuthority())) continue;
                rspecInterface.setComponentId(null);
            }
        }
        for (RspecLink rspecLink : res.getLinks()) {
            rspecLink.getComponentManagerUrns().clear();
            rspecLink.getComponentManagerUrns().add(componentManagerUrn);
            for (RspecInterface rspecInterface : rspecLink.getInterfaces()) {
                if (rspecInterface.getComponentId() == null) continue;
                ifaceCompIdUrn = GeniUrn.parse((String)rspecInterface.getComponentId());
                if (ifaceCompIdUrn == null) {
                    rspecInterface.setComponentId(null);
                    continue;
                }
                if (Objects.equals(ifaceCompIdUrn.getTopLevelAuthority(), componentManagerUrn.getTopLevelAuthority())) continue;
                rspecInterface.setComponentId(null);
            }
        }
        return res;
    }
}

