/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.model.impl;

import be.iminds.ilabt.jfed.rspec.model.AddressPool;
import be.iminds.ilabt.jfed.rspec.model.IPv4;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicIPv4;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.List;

public class BasicAddressPool
implements AddressPool {
    private String clientId;
    private GeniUrn componentManagerId;
    private Integer count;
    private String type;
    private final List<BasicIPv4> iPv4s = new ArrayList<BasicIPv4>();
    private double editorX = -1.0;
    private double editorY = -1.0;

    public BasicAddressPool() {
    }

    public BasicAddressPool(AddressPool addressPool) {
        this.clientId = addressPool.getClientId();
        this.componentManagerId = addressPool.getComponentManagerId();
        this.count = addressPool.getCount();
        this.type = addressPool.getType();
        for (IPv4 iPv4 : addressPool.getIPv4s()) {
            this.addIPv4(new BasicIPv4(iPv4));
        }
        this.editorX = addressPool.getEditorX();
        this.editorY = addressPool.getEditorY();
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public GeniUrn getComponentManagerId() {
        return this.componentManagerId;
    }

    @Override
    public void setComponentManagerId(GeniUrn componentManagerId) {
        this.componentManagerId = componentManagerId;
    }

    @Override
    public Integer getCount() {
        return this.count;
    }

    @Override
    public void setCount(Integer count) {
        this.count = count;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void addIPv4(IPv4 iPv4) {
        if (iPv4 instanceof BasicIPv4) {
            this.iPv4s.add((BasicIPv4)iPv4);
        } else {
            this.iPv4s.add(new BasicIPv4(iPv4));
        }
    }

    @Override
    public boolean deleteIPv4(IPv4 iPv4) {
        return this.iPv4s.remove(iPv4);
    }

    public List<BasicIPv4> getIPv4s() {
        return this.iPv4s;
    }

    @Override
    public double getEditorX() {
        return this.editorX;
    }

    @Override
    public double getEditorY() {
        return this.editorY;
    }

    @Override
    public void setEditorX(double x) {
        this.editorX = x;
    }

    @Override
    public void setEditorY(double y) {
        this.editorY = y;
    }
}

