/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.model.impl;

import be.iminds.ilabt.jfed.rspec.model.Lease;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import java.text.ParseException;
import java.util.Date;

public class BasicLease
implements Lease {
    private final String leaseId;
    private final String clientId;
    private final String validFromString;
    private final String validUntilString;
    private final Date validFromDate;
    private final Date validUntilDate;

    public BasicLease(Lease orig) {
        this.leaseId = orig.getLeaseId();
        this.clientId = orig.getClientId();
        this.validFromDate = orig.getValidFromDate();
        this.validUntilDate = orig.getValidUntilDate();
        this.validFromString = orig.getValidFromString();
        this.validUntilString = orig.getValidUntilString();
    }

    public BasicLease(String leaseId, String clientId, Date validFromDate, Date validUntilDate) {
        this(leaseId, clientId, validFromDate, validUntilDate, RFC3339Util.dateToRFC3339String((Date)validFromDate, (boolean)true, (boolean)true, (boolean)true), RFC3339Util.dateToRFC3339String((Date)validUntilDate, (boolean)true, (boolean)true, (boolean)true));
    }

    public BasicLease(String leaseId, String clientId, Date validFromDate, Date validUntilDate, String validFromString, String validUntilString) {
        block4: {
            this.leaseId = leaseId;
            this.clientId = clientId;
            this.validFromDate = validFromDate;
            this.validUntilDate = validUntilDate;
            this.validFromString = validFromString;
            this.validUntilString = validUntilString;
            try {
                assert (RFC3339Util.rfc3339StringToDate((String)validFromString) != null);
                assert (RFC3339Util.rfc3339StringToDate((String)validUntilString) != null);
            }
            catch (ParseException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)"There was a parse exception ");
            }
        }
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getLeaseId() {
        return this.leaseId;
    }

    @Override
    public Date getValidFromDate() {
        return this.validFromDate;
    }

    @Override
    public Date getValidUntilDate() {
        return this.validUntilDate;
    }

    @Override
    public String getValidFromString() {
        return this.validFromString;
    }

    @Override
    public String getValidUntilString() {
        return this.validUntilString;
    }
}

