/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.model.impl;

import be.iminds.ilabt.jfed.rspec.model.LinkSetting;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicRspecInterface;
import java.util.Objects;

public class BasicLinkSetting
implements LinkSetting {
    private final BasicRspecInterface from;
    private final BasicRspecInterface to;
    private Long capacity_kbps;
    private Integer latency_ms;
    private Double packetLoss;
    private boolean shownIfNotActive;

    public BasicLinkSetting(BasicRspecInterface fromIface, BasicRspecInterface toIface) {
        this.from = fromIface;
        this.to = toIface;
        this.shownIfNotActive = false;
        assert (this.from != null);
        assert (this.to != null);
    }

    @Override
    public BasicRspecInterface getFromIface() {
        return this.from;
    }

    @Override
    public BasicRspecInterface getToIface() {
        return this.to;
    }

    @Override
    public long getCapacity_Kbps() {
        return this.capacity_kbps == null ? -1L : this.capacity_kbps;
    }

    @Override
    public void setCapacity_Kbps(Long value) {
        this.capacity_kbps = value;
    }

    @Override
    public boolean isCapacitySet() {
        return this.capacity_kbps != null && this.capacity_kbps >= 0L;
    }

    @Override
    public int getLatency_ms() {
        return this.latency_ms == null ? -1 : this.latency_ms;
    }

    @Override
    public void setLatency_ms(Integer value) {
        this.latency_ms = value;
    }

    @Override
    public boolean isLatencySet() {
        return this.latency_ms != null && this.latency_ms >= 0;
    }

    @Override
    public double getPacketLoss() {
        return this.packetLoss == null ? -1.0 : this.packetLoss;
    }

    @Override
    public void setPacketLoss(Double value) {
        this.packetLoss = value;
    }

    @Override
    public boolean isPacketLossSet() {
        return this.packetLoss != null && this.packetLoss >= 0.0;
    }

    @Override
    public boolean isActive() {
        return this.isCapacitySet() || this.isPacketLossSet() || this.isLatencySet();
    }

    @Override
    public boolean isShownIfNotActive() {
        return this.shownIfNotActive;
    }

    @Override
    public void setShownIfNotActive(boolean shownIfNotActive) {
        this.shownIfNotActive = shownIfNotActive;
    }

    @Override
    public void setSameAs(LinkSetting o) {
        assert (Objects.equals(o.getFromIface().getClientId(), this.getFromIface().getClientId()));
        assert (Objects.equals(o.getToIface().getClientId(), this.getToIface().getClientId()));
        if (o.isCapacitySet()) {
            this.setCapacity_Kbps(o.getCapacity_Kbps());
        } else {
            this.setCapacity_Kbps(null);
        }
        if (o.isLatencySet()) {
            this.setLatency_ms(o.getLatency_ms());
        } else {
            this.setLatency_ms(null);
        }
        if (o.isPacketLossSet()) {
            this.setPacketLoss(o.getPacketLoss());
        } else {
            this.setPacketLoss(null);
        }
        this.shownIfNotActive = o.isShownIfNotActive();
    }
}

