/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.model.impl;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceUrn;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.LinkSetting;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicLinkSetting;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicModelRspec;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicRspecInterface;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicRspecNode;
import be.iminds.ilabt.jfed.rspec.parser.ExtraXml;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicRspecLink
implements RspecLink {
    private static final Logger LOG = LoggerFactory.getLogger(BasicRspecLink.class);
    protected final List<ExtraXml> extraXml = new ArrayList<ExtraXml>();
    private final List<GeniUrn> componentManagerUrns = new ArrayList<GeniUrn>();
    private final List<String> linkTypes = new ArrayList<String>();
    private final List<BasicRspecInterface> interfaces = new ArrayList<BasicRspecInterface>();
    private final List<BasicLinkSetting> linkSettings = new ArrayList<BasicLinkSetting>();
    private String clientId;
    private GeniUrn sliverId;
    private String sharedLanName;
    @Nonnull
    private final BasicModelRspec modelRspec;
    private final List<String> autoSharedLanNames = new ArrayList<String>();
    private Boolean vlanTagging;
    private Integer vlanTag;
    private Boolean noMacLearning;
    private Boolean linkMultiplexing;
    private Boolean bestEffort;
    private Boolean interswitchDisallow;
    private String noMacLearningValueString;

    BasicRspecLink(@Nonnull BasicModelRspec modelRspec, @Nullable String clientId, @Nullable String addDefaultLinkType) {
        this.modelRspec = modelRspec;
        this.clientId = clientId;
        if (addDefaultLinkType != null) {
            this.linkTypes.add(addDefaultLinkType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicRspecLink(@Nonnull BasicModelRspec newModelRspec, @Nonnull RspecLink other, @Nonnull RspecNode.InterfaceCopyMethod interfaceCopyMethod) {
        this(newModelRspec, other.getClientId(), null);
        this.extraXml.addAll(other.getExtraXml());
        this.setSliverId(other.getSliverId());
        this.componentManagerUrns.addAll(other.getComponentManagerUrns());
        this.linkTypes.addAll(other.getLinkTypes());
        this.sharedLanName = other.getSharedLan();
        this.autoSharedLanNames.clear();
        this.autoSharedLanNames.addAll(other.getAutoShareLanNames());
        this.vlanTagging = other.hasVlanTaggingTag() ? Boolean.valueOf(other.isVlanTaggingEnabled()) : null;
        this.vlanTag = other.getVlanTag();
        this.noMacLearning = other.hasNoMacLearningTag() ? Boolean.valueOf(other.isNoMacLearning()) : null;
        this.noMacLearningValueString = other.hasNoMacLearningTag() ? other.getNoMacLeaningValueString() : null;
        this.bestEffort = other.hasBestEffortTag() ? Boolean.valueOf(other.isBestEffortEnabled()) : null;
        this.linkMultiplexing = other.hasLinkMultiplexingTag() ? Boolean.valueOf(other.isLinkMultiplexingEnabled()) : null;
        Boolean bl = this.interswitchDisallow = other.hasInterswitchDisallowTag() ? Boolean.valueOf(other.isInterswitchDisallowed()) : null;
        if (Objects.equals((Object)interfaceCopyMethod, (Object)RspecNode.InterfaceCopyMethod.CREATE_NEW_INTERFACE)) {
            this.copyInterfaces(other);
        }
        if (Objects.equals((Object)interfaceCopyMethod, (Object)RspecNode.InterfaceCopyMethod.STEAL_INTERFACE)) {
            this.stealInterfaces(other);
        }
        if (interfaceCopyMethod.equals((Object)RspecNode.InterfaceCopyMethod.CREATE_NEW_INTERFACE) || interfaceCopyMethod.equals((Object)RspecNode.InterfaceCopyMethod.STEAL_INTERFACE)) {
            List<BasicLinkSetting> list = this.linkSettings;
            synchronized (list) {
                List<BasicLinkSetting> updatedLinkSetting = this.updateLinkSettings();
                this.linkSettings.clear();
                this.linkSettings.addAll(updatedLinkSetting);
                for (LinkSetting linkSetting : other.getLinkSettings()) {
                    BasicLinkSetting linkSetting2 = this.getLinkSettingByClientIds(linkSetting.getFromIface().getClientId(), linkSetting.getToIface().getClientId());
                    assert (linkSetting2 != null) : "no linksetting for from=" + linkSetting.getFromIface().getClientId() + " to=" + linkSetting.getToIface().getClientId();
                    if (linkSetting2 == null) continue;
                    linkSetting2.setSameAs(linkSetting);
                }
            }
        }
    }

    public void copyInterfaces(@Nonnull RspecLink rspecLink) {
        for (RspecInterface rspecInterface : rspecLink.getInterfaces()) {
            BasicRspecInterface res = rspecLink.getRspec() == this.getRspec() ? new BasicRspecInterface((BasicRspecNode)rspecInterface.getNode(), this, BasicRspecNode.generateNewInterfaceId(rspecInterface)) : new BasicRspecInterface(this, rspecInterface.getClientId());
            res.overwritePropertiesWith(rspecInterface, true);
        }
    }

    public void stealInterfaces(@Nonnull RspecLink rspecLink) {
        ArrayList<? extends RspecInterface> origIfaces = new ArrayList<RspecInterface>(rspecLink.getInterfaces());
        for (RspecInterface rspecInterface : origIfaces) {
            rspecInterface.moveToLink(this);
        }
    }

    @Override
    public void overwritePropertiesWith(@Nonnull RspecLink other, boolean overwriteWithNull) {
        assert (Objects.equals(this.clientId, other.getClientId()));
        if (overwriteWithNull) {
            this.sliverId = other.getSliverId();
            this.componentManagerUrns.clear();
            this.componentManagerUrns.addAll(other.getComponentManagerUrns());
            this.linkTypes.clear();
            this.linkTypes.addAll(other.getLinkTypes());
            for (LinkSetting linkSetting : other.getLinkSettings()) {
                BasicLinkSetting thisls = this.getLinkSettingByClientIds(linkSetting.getFromIface().getClientId(), linkSetting.getToIface().getClientId());
                if (thisls == null) continue;
                thisls.setSameAs(linkSetting);
            }
            this.extraXml.clear();
            this.extraXml.addAll(other.getExtraXml());
        } else {
            if (other.getSliverId() != null) {
                this.sliverId = other.getSliverId();
            }
            other.getLinkSettings().stream().filter(LinkSetting::isActive).forEach(ls -> {
                BasicLinkSetting ols = this.getLinkSettingByClientIds(ls.getFromIface().getClientId(), ls.getToIface().getClientId());
                if (ols != null) {
                    ols.setSameAs((LinkSetting)ls);
                } else {
                    BasicRspecInterface fromIface = this.getInterfaceByClientId(ls.getFromIface().getUniqueId());
                    BasicRspecInterface toIface = this.getInterfaceByUniqueId(ls.getToIface().getUniqueId());
                    if (fromIface != null && toIface != null) {
                        BasicLinkSetting newLs = this.getLinkSetting(fromIface, toIface);
                        assert (newLs != null) : "link settings not found for " + ls.getFromIface().getClientId() + " " + ls.getToIface().getClientId();
                        if (newLs != null) {
                            newLs.setSameAs((LinkSetting)ls);
                        }
                    }
                }
            });
            BasicRspecLink.addMissing(this.componentManagerUrns, other.getComponentManagerUrns());
            BasicRspecLink.addMissing(this.linkTypes, other.getLinkTypes());
            BasicRspecLink.addMissing(this.extraXml, other.getExtraXml());
        }
    }

    private static <T> void addMissing(@Nonnull List<T> target, @Nonnull List<T> other) {
        other.stream().filter(o -> !target.contains(o)).forEach(target::add);
    }

    @Override
    @Nonnull
    public BasicModelRspec getRspec() {
        return this.modelRspec;
    }

    @Override
    @Nonnull
    public String getUniqueId() {
        return BasicStringRspec.makeUniqueLinkId((String)this.clientId, null, this.getComponentManagerUrnStrings());
    }

    @Nonnull
    public List<String> getComponentManagerUrnStrings() {
        return this.componentManagerUrns.stream().map(ResourceUrn::getValue).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public void setClientId(@Nullable String value) {
        this.clientId = value;
    }

    @Override
    @Nonnull
    public List<GeniUrn> getComponentManagerUrns() {
        return this.componentManagerUrns;
    }

    @Override
    @Nonnull
    public List<String> getLinkTypes() {
        return this.linkTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public List<? extends LinkSetting> getLinkSettings() {
        List<BasicLinkSetting> list = this.linkSettings;
        synchronized (list) {
            List<BasicLinkSetting> updatedLinkSetting = this.updateLinkSettings();
            this.linkSettings.clear();
            this.linkSettings.addAll(updatedLinkSetting);
            return new ArrayList<BasicLinkSetting>(updatedLinkSetting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public BasicLinkSetting getLinkSetting(@Nonnull RspecInterface fromIface, @Nonnull RspecInterface toIface) {
        assert (fromIface != null);
        assert (fromIface instanceof BasicRspecInterface);
        assert (toIface != null);
        assert (toIface instanceof BasicRspecInterface);
        assert (fromIface.getRspec() == this.getRspec());
        assert (toIface.getRspec() == this.getRspec());
        List<BasicLinkSetting> list = this.linkSettings;
        synchronized (list) {
            List<BasicLinkSetting> updatedLinkSetting = this.updateLinkSettings();
            this.linkSettings.clear();
            this.linkSettings.addAll(updatedLinkSetting);
            assert (this.interfaces.contains(fromIface));
            assert (this.interfaces.contains(toIface));
            for (BasicLinkSetting ls : this.linkSettings) {
                if (ls.getFromIface() != fromIface || ls.getToIface() != toIface) continue;
                return ls;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public BasicLinkSetting getLinkSettingByClientIds(@Nonnull String fromIfaceName, @Nonnull String toIfaceName) {
        List<BasicLinkSetting> list = this.linkSettings;
        synchronized (list) {
            List<BasicLinkSetting> updatedLinkSetting = this.updateLinkSettings();
            this.linkSettings.clear();
            this.linkSettings.addAll(updatedLinkSetting);
            for (BasicLinkSetting ls : this.linkSettings) {
                if (!Objects.equals(ls.getFromIface().getClientId(), fromIfaceName) || !Objects.equals(ls.getToIface().getClientId(), toIfaceName)) continue;
                return ls;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public BasicLinkSetting getLinkSettingByUniqueIds(@Nonnull String fromIfaceName, @Nonnull String toIfaceName) {
        List<BasicLinkSetting> list = this.linkSettings;
        synchronized (list) {
            List<BasicLinkSetting> updatedLinkSetting = this.updateLinkSettings();
            this.linkSettings.clear();
            this.linkSettings.addAll(updatedLinkSetting);
            for (BasicLinkSetting ls : this.linkSettings) {
                if (!Objects.equals(ls.getFromIface().getUniqueId(), fromIfaceName) || !Objects.equals(ls.getToIface().getUniqueId(), toIfaceName)) continue;
                return ls;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BasicLinkSetting> updateLinkSettings() {
        List<BasicLinkSetting> list = this.linkSettings;
        synchronized (list) {
            ArrayList<BasicLinkSetting> res = new ArrayList<BasicLinkSetting>(this.linkSettings);
            Iterator it = res.iterator();
            while (it.hasNext()) {
                BasicLinkSetting ls = (BasicLinkSetting)it.next();
                if (!this.interfaces.contains(ls.getFromIface()) || !this.interfaces.contains(ls.getToIface())) {
                    it.remove();
                }
                if (ls.getFromIface() != ls.getToIface()) continue;
                it.remove();
            }
            for (BasicRspecInterface fromIface : this.interfaces) {
                for (BasicRspecInterface toIface : this.interfaces) {
                    if (fromIface == toIface) continue;
                    boolean missing = true;
                    for (BasicLinkSetting ls : res) {
                        if (ls.getFromIface() != fromIface || ls.getToIface() != toIface) continue;
                        missing = false;
                        break;
                    }
                    if (!missing) continue;
                    BasicLinkSetting newLinkSetting = new BasicLinkSetting(fromIface, toIface);
                    res.add(newLinkSetting);
                }
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isImpaired() {
        List<BasicLinkSetting> list = this.linkSettings;
        synchronized (list) {
            for (BasicLinkSetting ls : this.linkSettings) {
                if (!ls.isActive()) continue;
                return true;
            }
            return false;
        }
    }

    protected boolean addInterface(@Nonnull RspecInterface iface) {
        assert (iface instanceof BasicRspecInterface);
        return this.interfaces.add((BasicRspecInterface)iface);
    }

    protected boolean removeInterface(@Nonnull RspecInterface iface) {
        assert (iface instanceof BasicRspecInterface);
        return this.interfaces.remove(iface);
    }

    @Nonnull
    public List<BasicRspecInterface> getInterfaces() {
        return this.interfaces;
    }

    @Override
    @Nullable
    public BasicRspecInterface getInterfaceForNode(@Nonnull RspecNode node) {
        assert (node instanceof BasicRspecNode);
        for (BasicRspecInterface iface : this.interfaces) {
            if (iface.getNode() != node) continue;
            return iface;
        }
        return null;
    }

    @Override
    @Nullable
    public BasicRspecInterface getInterfaceByClientId(@Nonnull String clientId) {
        for (BasicRspecInterface iface : this.interfaces) {
            if (!Objects.equals(iface.getClientId(), clientId)) continue;
            return iface;
        }
        return null;
    }

    @Override
    @Nullable
    public BasicRspecInterface getInterfaceByUniqueId(@Nonnull String uniqueId) {
        for (BasicRspecInterface iface : this.interfaces) {
            if (!Objects.equals(iface.getUniqueId(), uniqueId)) continue;
            return iface;
        }
        return null;
    }

    @Override
    @Nullable
    public GeniUrn getSliverId() {
        return this.sliverId;
    }

    @Override
    public void setSliverId(@Nullable GeniUrn sliverId) {
        this.sliverId = sliverId;
    }

    @Override
    public void setSliverId(@Nullable String sliverId) {
        if (sliverId == null) {
            this.sliverId = null;
            return;
        }
        GeniUrn geniUrn = GeniUrn.parse((String)sliverId);
        if (geniUrn != null) {
            this.sliverId = geniUrn;
        } else {
            LOG.warn("Could not set sliverId to {} as it is not a valid URN!", (Object)sliverId);
            this.sliverId = null;
        }
    }

    @Override
    public boolean isStitched(@Nullable TestbedInfoSource testbedInfoSource) {
        if (this.getComponentManagerUrns().size() < 2) {
            return false;
        }
        if (this.getLinkTypes().size() > 1 || this.getLinkTypes().size() == 1 && !this.getLinkTypes().get(0).equalsIgnoreCase("lan") && !this.getLinkTypes().get(0).equalsIgnoreCase("vlan")) {
            return false;
        }
        if (testbedInfoSource == null) {
            return true;
        }
        Server firstServer = null;
        for (GeniUrn urn : this.getComponentManagerUrns()) {
            Server server = testbedInfoSource.getByUrn(urn, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_TOPLEVEL, TestbedInfoSource.SubAuthMatchPreference.PREFER_TOPLEVEL);
            if (server == null) {
                LOG.warn("Authority not found for " + urn + " during stitch check -> falling back to assuming link is stitched");
                return true;
            }
            if (firstServer == null) {
                firstServer = server;
                continue;
            }
            if (Objects.equals(firstServer.getDefaultComponentManagerUrn(), server.getDefaultComponentManagerUrn())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public List<ExtraXml> getExtraXml() {
        return this.extraXml;
    }

    @Override
    @Nullable
    public String getSharedLan() {
        return this.sharedLanName;
    }

    @Override
    public void setSharedLan(@Nullable String sharedLanName) {
        this.sharedLanName = sharedLanName;
    }

    @Override
    public boolean isVlanTaggingEnabled() {
        return this.vlanTagging != null && this.vlanTagging != false;
    }

    @Override
    public boolean hasVlanTaggingTag() {
        return this.vlanTagging != null;
    }

    @Override
    public void setVlanTagging(@Nullable Boolean value) {
        this.vlanTagging = value;
    }

    @Override
    @Nullable
    public Integer getVlanTag() {
        return this.vlanTag;
    }

    @Override
    public void setVlanTag(@Nullable Integer vlanTag) {
        this.vlanTag = vlanTag;
    }

    @Override
    public boolean isNoMacLearning() {
        return this.noMacLearning != null && this.noMacLearning != false;
    }

    @Override
    public boolean hasNoMacLearningTag() {
        return this.noMacLearning != null;
    }

    @Override
    public void setNoMacLearning(@Nullable Boolean value) {
        this.noMacLearning = value;
        this.noMacLearningValueString = value == null ? null : "" + value;
    }

    @Override
    @Nullable
    public String getNoMacLeaningValueString() {
        if (this.noMacLearning == null) {
            return null;
        }
        return this.noMacLearningValueString;
    }

    @Override
    public void setNoMacLearning(@Nullable String value) {
        this.noMacLearningValueString = value;
        this.noMacLearning = TextUtil.stringToBoolean((String)value);
    }

    @Override
    public boolean isBestEffortEnabled() {
        return this.bestEffort != null && this.bestEffort != false;
    }

    @Override
    public boolean hasBestEffortTag() {
        return this.bestEffort != null;
    }

    @Override
    public void setBestEffort(@Nullable Boolean value) {
        this.bestEffort = value;
    }

    @Override
    public boolean isLinkMultiplexingEnabled() {
        return this.linkMultiplexing != null && this.linkMultiplexing != false;
    }

    @Override
    public boolean hasLinkMultiplexingTag() {
        return this.linkMultiplexing != null;
    }

    @Override
    public void setLinkMultiplexing(@Nullable Boolean value) {
        this.linkMultiplexing = value;
    }

    @Override
    public boolean hasAutoShareLan() {
        return !this.autoSharedLanNames.isEmpty();
    }

    @Override
    @Nonnull
    public List<String> getAutoShareLanNames() {
        return this.autoSharedLanNames;
    }

    @Override
    public boolean isInterswitchDisallowed() {
        return this.interswitchDisallow != null && this.interswitchDisallow != false;
    }

    @Override
    public boolean hasInterswitchDisallowTag() {
        return this.interswitchDisallow != null;
    }

    @Override
    public void setInterswitchDisallow(@Nullable Boolean value) {
        this.interswitchDisallow = value;
    }
}

