/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.model.impl;

import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.AnsibleService;
import be.iminds.ilabt.jfed.rspec.model.DiskImage;
import be.iminds.ilabt.jfed.rspec.model.ExecuteService;
import be.iminds.ilabt.jfed.rspec.model.HardwareType;
import be.iminds.ilabt.jfed.rspec.model.InstallService;
import be.iminds.ilabt.jfed.rspec.model.LoginService;
import be.iminds.ilabt.jfed.rspec.model.NodeLocation;
import be.iminds.ilabt.jfed.rspec.model.ProxyService;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.SliverType;
import be.iminds.ilabt.jfed.rspec.model.SliverTypeBuilder;
import be.iminds.ilabt.jfed.rspec.model.WebVncService;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicAnsibleService;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicExecuteService;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicInstallService;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicModelRspec;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicRspecInterface;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicRspecLink;
import be.iminds.ilabt.jfed.rspec.parser.ExtraXml;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicRspecNode
implements RspecNode {
    private static final Logger LOG = LoggerFactory.getLogger(BasicRspecNode.class);
    private final BasicModelRspec modelRspec;
    protected final List<SliverType> sliverTypes = new ArrayList<SliverType>();
    final List<BasicRspecInterface> interfaces = new ArrayList<BasicRspecInterface>();
    private String clientId;
    private double editorPosX = -1.0;
    private double editorPosY = -1.0;
    private double flackEditorPosX = -1.0;
    private double flackEditorPosY = -1.0;
    private final List<HardwareType> hardwareTypes = new ArrayList<HardwareType>();
    private Boolean exclusive;
    private Boolean available;
    private NodeLocation nodeLocation;
    private GeniUrn componentManagerId;
    private GeniUrn componentId;
    private String componentName;
    private GeniUrn sliverId;
    private String hostname;
    private boolean hasRoutableControlIp;
    private final List<String> leaseIdRefs = new ArrayList<String>();
    private List<BasicExecuteService> executeServices = new ArrayList<BasicExecuteService>();
    private List<BasicInstallService> installServices = new ArrayList<BasicInstallService>();
    private List<LoginService> loginServices = new ArrayList<LoginService>();
    private List<ProxyService> proxyServices = new ArrayList<ProxyService>();
    private List<WebVncService> webVncServices = new ArrayList<WebVncService>();
    private List<BasicAnsibleService> ansibleServices = new ArrayList<BasicAnsibleService>();
    private final List<String> ansibleGroups = new ArrayList<String>();
    private final List<ExtraXml> extraServicesXmls = new ArrayList<ExtraXml>();
    private final List<ExtraXml> extraXmls = new ArrayList<ExtraXml>();
    private final Set<RspecNode.EmptyTag> emptyTags = new HashSet<RspecNode.EmptyTag>();

    @Override
    public BasicModelRspec getRspec() {
        return this.modelRspec;
    }

    private BasicRspecNode() {
        this.modelRspec = null;
    }

    BasicRspecNode(BasicModelRspec modelRspec, String clientId) {
        this.clientId = clientId;
        this.modelRspec = modelRspec;
    }

    BasicRspecNode(BasicModelRspec newModelRspec, RspecNode rspecNode, RspecNode.InterfaceCopyMethod interfaceCopyMethod) {
        this.modelRspec = newModelRspec;
        this.clientId = rspecNode.getClientId();
        this.editorPosX = rspecNode.getEditorX();
        this.editorPosY = rspecNode.getEditorY();
        this.flackEditorPosX = rspecNode.getFlackEditorX();
        this.flackEditorPosY = rspecNode.getFlackEditorY();
        this.componentId = rspecNode.getComponentId();
        this.componentManagerId = rspecNode.getComponentManagerId();
        this.componentName = rspecNode.getComponentName();
        this.sliverId = rspecNode.getSliverId();
        this.exclusive = rspecNode.getExclusive();
        this.available = rspecNode.getAvailable();
        this.hostname = rspecNode.getHostName();
        this.nodeLocation = rspecNode.getLocation();
        this.leaseIdRefs.clear();
        this.leaseIdRefs.addAll(rspecNode.getLeaseIdRefs());
        this.setExecuteServices(rspecNode.getExecuteServices());
        this.hardwareTypes.addAll(rspecNode.getHardwareTypes());
        this.setInstallServices(rspecNode.getInstallServices());
        this.loginServices.addAll(rspecNode.getLoginServices());
        this.proxyServices.addAll(rspecNode.getProxyServices());
        this.webVncServices.addAll(rspecNode.getWebVncServices());
        this.setAnsibleServices(rspecNode.getAnsibleServices());
        this.ansibleGroups.addAll(rspecNode.getAnsibleGroups());
        this.sliverTypes.addAll(rspecNode.getSliverTypes());
        this.hasRoutableControlIp = rspecNode.getRoutableControlIp();
        this.emptyTags.addAll(rspecNode.getEmptyTags());
        this.extraXmls.addAll(rspecNode.getExtraXml());
        this.extraServicesXmls.addAll(rspecNode.getExtraServicesXml());
        if (Objects.equals((Object)interfaceCopyMethod, (Object)RspecNode.InterfaceCopyMethod.CREATE_NEW_INTERFACE)) {
            this.copyInterfaces(rspecNode);
        }
        if (Objects.equals((Object)interfaceCopyMethod, (Object)RspecNode.InterfaceCopyMethod.STEAL_INTERFACE)) {
            assert (rspecNode instanceof BasicRspecNode);
            this.stealInterfaces((BasicRspecNode)rspecNode);
        }
    }

    public static String generateNewInterfaceId(RspecInterface rspecInterface) {
        Object id = rspecInterface.getClientId();
        Object preDigitName = (String)(rspecInterface.getNode() == null ? "" : (rspecInterface.getNode().getClientId() != null ? rspecInterface.getNode().getClientId() + ":" : "")) + "if";
        int number = -1;
        if (id != null) {
            int digitsCount = 0;
            while (Character.isDigit(((String)id).charAt(((String)id).length() - digitsCount - 1))) {
                ++digitsCount;
            }
            int digitsStartLoc = ((String)id).length() - digitsCount;
            number = -1;
            if (digitsCount > 0) {
                number = Integer.parseInt(((String)id).substring(digitsStartLoc));
            }
            preDigitName = ((String)id).substring(0, digitsStartLoc);
        }
        boolean duplicate = true;
        while (duplicate) {
            id = (String)preDigitName + ++number;
            duplicate = rspecInterface.getRspec().getInterfaceByClientId((String)id) != null;
        }
        return id;
    }

    public void copyInterfaces(RspecNode rspecNode) {
        for (RspecInterface rspecInterface : rspecNode.getInterfaces()) {
            BasicRspecInterface res = rspecNode.getRspec() == this.getRspec() ? new BasicRspecInterface(this, rspecInterface.isLinkBound() ? (BasicRspecLink)rspecInterface.getLink() : null, BasicRspecNode.generateNewInterfaceId(rspecInterface)) : new BasicRspecInterface(this, rspecInterface.getClientId());
            res.overwritePropertiesWith(rspecInterface, true);
        }
    }

    public void stealInterfaces(BasicRspecNode rspecNode) {
        ArrayList<BasicRspecInterface> origIfaces = new ArrayList<BasicRspecInterface>(rspecNode.getInterfaces());
        for (BasicRspecInterface rspecInterface : origIfaces) {
            rspecInterface.moveToNode(this);
        }
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public void setClientId(String value) {
        this.clientId = value;
    }

    @Override
    @Nonnull
    public String getUniqueId() {
        return BasicStringRspec.makeUniqueNodeId((String)this.clientId, (String)(this.componentId != null ? this.componentId.getValue() : null), this.componentManagerId != null ? this.componentManagerId.getValue() : null);
    }

    @Override
    public double getEditorX() {
        return this.editorPosX;
    }

    @Override
    public void setEditorX(double value) {
        this.editorPosX = value;
    }

    @Override
    public double getEditorY() {
        return this.editorPosY;
    }

    @Override
    public void setEditorY(double value) {
        this.editorPosY = value;
    }

    @Override
    public double getFlackEditorX() {
        return this.flackEditorPosX;
    }

    @Override
    public void setFlackEditorX(double value) {
        this.flackEditorPosX = value;
    }

    @Override
    public double getFlackEditorY() {
        return this.flackEditorPosY;
    }

    @Override
    public void setFlackEditorY(double value) {
        this.flackEditorPosX = value;
    }

    @Override
    public List<HardwareType> getHardwareTypes() {
        return this.hardwareTypes;
    }

    @Override
    public Boolean getExclusive() {
        return this.exclusive;
    }

    @Override
    public void setExclusive(Boolean value) {
        this.exclusive = value;
    }

    @Override
    public Boolean getAvailable() {
        return this.available;
    }

    @Override
    public void setAvailable(Boolean available) {
        this.available = available;
    }

    @Override
    public void setSliverTypeDiskImage(String diskImageName) {
        if (this.sliverTypes.size() > 1) {
            throw new RuntimeException("The caller did expected this RSpec to have exactly one sliver types. (probably because expected this to be a request rspec). But this has " + this.sliverTypes.size() + " sliver types.");
        }
        assert (this.sliverTypes.size() == 1);
        SliverTypeBuilder builder = new SliverTypeBuilder(this.sliverTypes.get(0));
        ArrayList<DiskImage> diskImageList = new ArrayList<DiskImage>();
        if (diskImageName != null) {
            diskImageList.add(new DiskImage(diskImageName));
        }
        builder.setDiskImages(diskImageList);
        this.sliverTypes.clear();
        this.sliverTypes.add(builder.build());
    }

    @Override
    public void setSliverTypeFlavor(@Nullable String flavor) {
        if (this.sliverTypes.size() > 1) {
            throw new RuntimeException("The caller did expected this RSpec to have exactly one sliver types. (probably because expected this to be a request rspec). But this has " + this.sliverTypes.size() + " sliver types.");
        }
        assert (this.sliverTypes.size() == 1);
        SliverTypeBuilder builder = new SliverTypeBuilder(this.sliverTypes.get(0));
        ArrayList<String> flavors = new ArrayList<String>();
        if (flavor != null) {
            flavors.add(flavor);
        }
        builder.setFlavors(flavors);
        this.sliverTypes.clear();
        this.sliverTypes.add(builder.build());
    }

    @Override
    public String getSliverTypeName() {
        if (this.sliverTypes.size() > 1) {
            throw new RuntimeException("The caller did not expect this RSpec to have multiple sliver types. (it probably expected this to be a request rspec, which does indeed not have multiple sliver_type's)");
        }
        if (this.sliverTypes.isEmpty()) {
            return null;
        }
        return this.sliverTypes.get(0).getName();
    }

    @Override
    public void setSliverTypeName(String name) {
        assert (this.sliverTypes.size() <= 1);
        SliverTypeBuilder builder = this.sliverTypes.size() == 1 ? new SliverTypeBuilder(this.sliverTypes.get(0)).name(name) : new SliverTypeBuilder(name);
        this.sliverTypes.clear();
        this.sliverTypes.add(builder.build());
    }

    @Override
    public SliverType getSliverType() {
        if (this.sliverTypes.isEmpty()) {
            return null;
        }
        if (this.sliverTypes.size() > 1) {
            throw new RuntimeException("The caller did not expect this RSpec to have multiple sliver types. (it probably expected this to be a request rspec, which does indeed not have multiple sliver_type's)");
        }
        return this.sliverTypes.get(0);
    }

    @Override
    public void setSliverType(SliverType singleType) {
        this.sliverTypes.clear();
        if (singleType != null) {
            this.sliverTypes.add(singleType);
        }
    }

    @Override
    public String getOsImageUrn() {
        if (this.sliverTypes.size() > 1) {
            throw new RuntimeException("The getOsImageUrn convenience method does not support multiple sliver_types");
        }
        if (this.sliverTypes.isEmpty()) {
            return null;
        }
        SliverType sliverType = this.sliverTypes.get(0);
        if (sliverType.getDiskImages().size() > 1) {
            throw new RuntimeException("The getOsImageUrn convenience method does not support multiple disk_images in the sliver_type");
        }
        if (sliverType.getDiskImages().isEmpty()) {
            return null;
        }
        return sliverType.getDiskImages().get(0).getName();
    }

    @Override
    public List<SliverType> getSliverTypes() {
        return this.sliverTypes;
    }

    @Override
    public NodeLocation getLocation() {
        return this.nodeLocation;
    }

    @Override
    public void setLocation(NodeLocation value) {
        this.nodeLocation = value;
    }

    @Override
    public GeniUrn getComponentManagerId() {
        return this.componentManagerId;
    }

    @Override
    public void setComponentManagerId(String value) {
        if (value == null) {
            this.componentManagerId = null;
            return;
        }
        GeniUrn geniUrn = GeniUrn.parse((String)value);
        if (geniUrn != null) {
            this.componentManagerId = geniUrn;
        } else {
            LOG.warn("Could not set componentManagerId to {} as it is not a valid URN!", (Object)value);
            this.componentManagerId = null;
        }
    }

    @Override
    public void setComponentManagerId(GeniUrn value) {
        this.componentManagerId = value;
    }

    @Override
    public GeniUrn getComponentId() {
        return this.componentId;
    }

    @Override
    public void setComponentId(String value) {
        if (value == null) {
            this.componentId = null;
            return;
        }
        GeniUrn geniUrn = GeniUrn.parse((String)value);
        if (geniUrn != null) {
            this.componentId = geniUrn;
        } else {
            LOG.warn("Could not set componentId to {} as it is not a valid URN!", (Object)value);
            this.componentId = null;
        }
    }

    @Override
    public void setComponentId(GeniUrn value) {
        this.componentId = value;
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public void setComponentName(String value) {
        this.componentName = value;
    }

    @Override
    public GeniUrn getSliverId() {
        return this.sliverId;
    }

    @Override
    public void setSliverId(GeniUrn sliverId) {
        this.sliverId = sliverId;
    }

    @Override
    public void setSliverId(String sliverId) {
        if (sliverId == null) {
            this.sliverId = null;
            return;
        }
        GeniUrn geniUrn = GeniUrn.parse((String)sliverId);
        if (geniUrn != null) {
            this.sliverId = geniUrn;
        } else {
            LOG.warn("Could not set sliverId to {} as it is not a valid URN!", (Object)sliverId);
            this.sliverId = null;
        }
    }

    @Override
    public String getHostName() {
        return this.hostname;
    }

    @Override
    public void setHostName(String value) {
        this.hostname = value;
    }

    @Override
    public boolean getRoutableControlIp() {
        return this.hasRoutableControlIp;
    }

    @Override
    public void setRoutableControlIp(boolean hasRoutableControlIp) {
        this.hasRoutableControlIp = hasRoutableControlIp;
    }

    public List<BasicExecuteService> getExecuteServices() {
        return this.executeServices;
    }

    @Override
    public void setExecuteServices(List<? extends ExecuteService> value) {
        this.executeServices = value.stream().map(BasicExecuteService::new).collect(Collectors.toList());
    }

    public List<BasicInstallService> getInstallServices() {
        return this.installServices;
    }

    @Override
    public void setInstallServices(List<? extends InstallService> value) {
        this.installServices = value.stream().map(BasicInstallService::new).collect(Collectors.toList());
    }

    @Override
    public void addExecuteService(ExecuteService executeService) {
        if (executeService instanceof BasicExecuteService) {
            this.executeServices.add((BasicExecuteService)executeService);
        } else {
            this.executeServices.add(new BasicExecuteService(executeService));
        }
    }

    @Override
    public void addInstallService(InstallService installService) {
        if (installService instanceof BasicInstallService) {
            this.installServices.add((BasicInstallService)installService);
        } else {
            this.installServices.add(new BasicInstallService(installService));
        }
    }

    @Override
    public List<LoginService> getLoginServices() {
        return this.loginServices;
    }

    @Override
    public void setLoginServices(List<LoginService> value) {
        this.loginServices = value;
    }

    @Override
    public List<ProxyService> getProxyServices() {
        return this.proxyServices;
    }

    @Override
    public void setProxyServices(List<ProxyService> value) {
        this.proxyServices = value;
    }

    @Override
    public List<WebVncService> getWebVncServices() {
        return this.webVncServices;
    }

    @Override
    public void setWebVncServices(List<WebVncService> value) {
        this.webVncServices = value;
    }

    public List<BasicAnsibleService> getAnsibleServices() {
        return this.ansibleServices;
    }

    @Override
    public void setAnsibleServices(List<? extends AnsibleService> value) {
        this.ansibleServices = value.stream().map(BasicAnsibleService::new).collect(Collectors.toList());
    }

    @Override
    public void addAnsibleService(AnsibleService as) {
        if (as instanceof BasicAnsibleService) {
            this.ansibleServices.add((BasicAnsibleService)as);
        } else {
            this.ansibleServices.add(new BasicAnsibleService(as));
        }
    }

    public List<BasicRspecInterface> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public BasicRspecInterface getInterfaceByClientId(String clientId) {
        for (BasicRspecInterface iface : this.interfaces) {
            if (!Objects.equals(iface.getClientId(), clientId)) continue;
            return iface;
        }
        return null;
    }

    @Override
    public BasicRspecInterface getInterfaceByUniqueId(String uniqueId) {
        for (BasicRspecInterface iface : this.interfaces) {
            if (!Objects.equals(iface.getUniqueId(), uniqueId)) continue;
            return iface;
        }
        return null;
    }

    protected boolean addInterface(RspecInterface iface) {
        assert (iface instanceof BasicRspecInterface);
        return this.interfaces.add((BasicRspecInterface)iface);
    }

    protected boolean removeInterface(RspecInterface iface) {
        assert (iface instanceof BasicRspecInterface);
        return this.interfaces.remove(iface);
    }

    public List<BasicRspecLink> getLinks() {
        return Collections.unmodifiableList(this.interfaces.stream().filter(BasicRspecInterface::isLinkBound).map(BasicRspecInterface::getLink).collect(Collectors.toList()));
    }

    @Override
    public List<String> getLeaseIdRefs() {
        return this.leaseIdRefs;
    }

    @Override
    public void addLeaseIdRef(String leaseIdRef) {
        this.leaseIdRefs.add(leaseIdRef);
    }

    @Override
    public List<String> getAnsibleGroups() {
        return this.ansibleGroups;
    }

    @Override
    @Nonnull
    public List<ExtraXml> getExtraXml() {
        return this.extraXmls;
    }

    @Override
    @Nonnull
    public List<ExtraXml> getExtraServicesXml() {
        return this.extraServicesXmls;
    }

    @Override
    public void addEmptyTag(RspecNode.EmptyTag e) {
        this.emptyTags.add(e);
    }

    @Override
    public boolean hasEmptyTag(RspecNode.EmptyTag e) {
        return this.emptyTags.contains((Object)e);
    }

    @Override
    public Collection<RspecNode.EmptyTag> getEmptyTags() {
        return this.emptyTags;
    }

    @Override
    public void overwritePropertiesWith(RspecNode otherNode, boolean overwriteWithNull) {
        assert (Objects.equals(this.getUniqueId(), otherNode.getUniqueId()));
        if (overwriteWithNull) {
            this.componentId = otherNode.getComponentId();
            this.componentManagerId = otherNode.getComponentManagerId();
            this.editorPosX = otherNode.getEditorX();
            this.editorPosY = otherNode.getEditorY();
            this.flackEditorPosX = otherNode.getFlackEditorX();
            this.flackEditorPosY = otherNode.getFlackEditorY();
            this.componentName = otherNode.getComponentName();
            this.sliverId = otherNode.getSliverId();
            this.exclusive = otherNode.getExclusive();
            this.available = otherNode.getAvailable();
            this.hostname = otherNode.getHostName();
            this.nodeLocation = otherNode.getLocation();
            this.leaseIdRefs.clear();
            this.leaseIdRefs.addAll(otherNode.getLeaseIdRefs());
            this.executeServices.clear();
            this.setExecuteServices(otherNode.getExecuteServices());
            this.hardwareTypes.clear();
            this.hardwareTypes.addAll(otherNode.getHardwareTypes());
            this.installServices.clear();
            this.setInstallServices(otherNode.getInstallServices());
            this.ansibleServices.clear();
            this.setAnsibleServices(otherNode.getAnsibleServices());
            this.loginServices.clear();
            this.loginServices.addAll(otherNode.getLoginServices());
            this.proxyServices.clear();
            this.proxyServices.addAll(otherNode.getProxyServices());
            this.webVncServices.clear();
            this.webVncServices.addAll(otherNode.getWebVncServices());
            this.sliverTypes.clear();
            this.sliverTypes.addAll(otherNode.getSliverTypes());
            this.ansibleGroups.clear();
            this.ansibleGroups.addAll(otherNode.getAnsibleGroups());
            this.extraXmls.clear();
            this.extraXmls.addAll(otherNode.getExtraXml());
            this.extraServicesXmls.clear();
            this.extraServicesXmls.addAll(otherNode.getExtraServicesXml());
        } else {
            if (otherNode.getComponentId() != null) {
                this.componentId = otherNode.getComponentId();
            }
            if (otherNode.getComponentManagerId() != null) {
                this.componentManagerId = otherNode.getComponentManagerId();
            }
            if (otherNode.getEditorX() >= 0.0) {
                this.editorPosX = otherNode.getEditorX();
            }
            if (otherNode.getEditorY() >= 0.0) {
                this.editorPosY = otherNode.getEditorY();
            }
            if (otherNode.getFlackEditorX() >= 0.0) {
                this.flackEditorPosX = otherNode.getFlackEditorX();
            }
            if (otherNode.getFlackEditorY() >= 0.0) {
                this.flackEditorPosY = otherNode.getFlackEditorY();
            }
            if (otherNode.getComponentName() != null) {
                this.componentName = otherNode.getComponentName();
            }
            if (otherNode.getSliverId() != null) {
                this.sliverId = otherNode.getSliverId();
            }
            if (otherNode.getExclusive() != null) {
                this.exclusive = otherNode.getExclusive();
            }
            if (otherNode.getAvailable() != null) {
                this.available = otherNode.getAvailable();
            }
            if (otherNode.getHostName() != null) {
                this.hostname = otherNode.getHostName();
            }
            if (otherNode.getLocation() != null) {
                this.nodeLocation = otherNode.getLocation();
            }
            BasicRspecNode.addMissingExecuteServices(this.executeServices, otherNode.getExecuteServices());
            BasicRspecNode.addMissing(this.hardwareTypes, otherNode.getHardwareTypes());
            BasicRspecNode.addMissingInstallServices(this.installServices, otherNode.getInstallServices());
            BasicRspecNode.addMissing(this.loginServices, otherNode.getLoginServices());
            BasicRspecNode.addMissing(this.proxyServices, otherNode.getProxyServices());
            BasicRspecNode.addMissing(this.webVncServices, otherNode.getWebVncServices());
            BasicRspecNode.addMissing(this.sliverTypes, otherNode.getSliverTypes());
            BasicRspecNode.addMissing(this.extraXmls, otherNode.getExtraXml());
            BasicRspecNode.addMissing(this.extraServicesXmls, otherNode.getExtraServicesXml());
        }
    }

    private static <T> void addMissing(List<T> target, List<T> other) {
        other.stream().filter(o -> !target.contains(o)).forEach(target::add);
    }

    private static void addMissingExecuteServices(List<BasicExecuteService> target, List<? extends ExecuteService> other) {
        for (ExecuteService executeService : other) {
            if (executeService instanceof BasicExecuteService) {
                if (target.contains(executeService)) continue;
                target.add((BasicExecuteService)executeService);
                continue;
            }
            target.add(new BasicExecuteService(executeService));
        }
    }

    private static void addMissingInstallServices(List<BasicInstallService> target, List<? extends InstallService> other) {
        for (InstallService installService : other) {
            if (installService instanceof BasicInstallService) {
                if (target.contains(installService)) continue;
                target.add((BasicInstallService)installService);
                continue;
            }
            target.add(new BasicInstallService(installService));
        }
    }
}

